/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.GraalPythonModuleBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.GraalPythonModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.EconomicMapStorage;
import com.oracle.graal.python.builtins.objects.common.EmptyStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.set.PSet;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PConstructAndRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.bytecode.PBytecodeRootNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.BuiltinFunctionRootNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.exception.PythonExitException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CallTarget;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeUtil;
import com.oracle.truffle.api.nodes.RootNode;
import com.oracle.truffle.api.source.Source;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.llvm.api.Toolchain;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.graalvm.home.Version;
import org.graalvm.nativeimage.ImageInfo;

@CoreFunctions(defineModule="__graalpython__", isEager=true)
public final class GraalPythonModuleBuiltins
extends PythonBuiltins {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(GraalPythonModuleBuiltins.class);
    private static final TruffleString T_PATH_HOOKS = PythonUtils.tsLiteral("path_hooks");
    private static final TruffleString T_PATH_IMPORTER_CACHE = PythonUtils.tsLiteral("path_importer_cache");
    private static final TruffleString T__RUN_MODULE_AS_MAIN = PythonUtils.tsLiteral("_run_module_as_main");
    private static final TruffleString T_STDIO_ENCODING = PythonUtils.tsLiteral("stdio_encoding");
    private static final TruffleString T_STDIO_ERROR = PythonUtils.tsLiteral("stdio_error");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GraalPythonModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        TruffleString[] parts;
        super.initialize(core);
        this.addBuiltinConstant("is_native", (Object)ImageInfo.inImageCode());
        PythonContext ctx = core.getContext();
        TruffleString encodingOpt = ctx.getLanguage().getEngineOption(PythonOptions.StandardStreamEncoding);
        TruffleString standardStreamEncoding = null;
        TruffleString standardStreamError = null;
        if (encodingOpt != null && !encodingOpt.isEmpty() && (parts = StringUtils.split(encodingOpt, StringLiterals.T_COLON, TruffleString.CodePointLengthNode.getUncached(), TruffleString.IndexOfStringNode.getUncached(), TruffleString.SubstringNode.getUncached(), TruffleString.EqualNode.getUncached())).length > 0) {
            standardStreamEncoding = parts[0].isEmpty() ? StringLiterals.T_UTF8 : parts[0];
            TruffleString truffleString = standardStreamError = parts.length > 1 && !parts[1].isEmpty() ? parts[1] : StringLiterals.T_STRICT;
        }
        if (standardStreamEncoding == null) {
            standardStreamEncoding = StringLiterals.T_UTF8;
            standardStreamError = StringLiterals.T_SURROGATEESCAPE;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Setting default stdio encoding to %s:%s", standardStreamEncoding, standardStreamError));
        }
        this.addBuiltinConstant(T_STDIO_ENCODING, (Object)standardStreamEncoding);
        this.addBuiltinConstant(T_STDIO_ERROR, (Object)standardStreamError);
        this.addBuiltinConstant("startup_wall_clock_ts", (Object)-1L);
        this.addBuiltinConstant("startup_nano", (Object)-1L);
        this.postInitialize(core);
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        PythonContext context = core.getContext();
        PythonModule mod = core.lookupBuiltinModule(BuiltinNames.T___GRAALPYTHON__);
        PythonLanguage language = context.getLanguage();
        if (!ImageInfo.inImageBuildtimeCode()) {
            mod.setAttribute(PythonUtils.tsLiteral("home"), context.getLanguageHome());
        }
        mod.setAttribute(PythonUtils.tsLiteral("in_image_buildtime"), ImageInfo.inImageBuildtimeCode());
        mod.setAttribute(PythonUtils.tsLiteral("in_image"), ImageInfo.inImageCode());
        TruffleString coreHome = context.getCoreHome();
        TruffleString stdlibHome = context.getStdlibHome();
        TruffleString capiHome = context.getCAPIHome();
        TruffleLanguage.Env env = context.getEnv();
        LanguageInfo llvmInfo = (LanguageInfo)env.getInternalLanguages().get("llvm");
        mod.setAttribute(PythonUtils.tsLiteral("jython_emulation_enabled"), language.getEngineOption(PythonOptions.EmulateJython));
        mod.setAttribute(PythonUtils.tsLiteral("host_import_enabled"), context.getEnv().isHostLookupAllowed());
        mod.setAttribute(PythonUtils.tsLiteral("core_home"), coreHome);
        mod.setAttribute(PythonUtils.tsLiteral("stdlib_home"), stdlibHome);
        mod.setAttribute(PythonUtils.tsLiteral("capi_home"), capiHome);
        mod.setAttribute(PythonUtils.tsLiteral("jni_home"), context.getJNIHome());
        Object[] arr = GraalPythonModuleBuiltins.convertToObjectArray(PythonOptions.getExecutableList(context));
        PList executableList = PythonObjectFactory.getUncached().createList(arr);
        mod.setAttribute(PythonUtils.tsLiteral("executable_list"), executableList);
        mod.setAttribute(PythonUtils.tsLiteral("ForeignType"), core.lookupType(PythonBuiltinClassType.ForeignObject));
        mod.setAttribute(PythonUtils.tsLiteral("use_system_toolchain"), context.getOption(PythonOptions.UseSystemToolchain));
        mod.setAttribute(PythonUtils.tsLiteral("ext_mode"), context.getOption(PythonOptions.NativeModules) != false ? StringLiterals.T_NATIVE : StringLiterals.T_LLVM_LANGUAGE);
        if (!context.getOption(PythonOptions.EnableDebuggingBuiltins).booleanValue()) {
            mod.setAttribute(PythonUtils.tsLiteral("dump_truffle_ast"), PNone.NO_VALUE);
            mod.setAttribute(PythonUtils.tsLiteral("tdebug"), PNone.NO_VALUE);
            mod.setAttribute(PythonUtils.tsLiteral("set_storage_strategy"), PNone.NO_VALUE);
            mod.setAttribute(PythonUtils.tsLiteral("storage_to_native"), PNone.NO_VALUE);
            mod.setAttribute(PythonUtils.tsLiteral("dump_heap"), PNone.NO_VALUE);
            mod.setAttribute(PythonUtils.tsLiteral("is_native_object"), PNone.NO_VALUE);
        }
        if (PythonOptions.WITHOUT_PLATFORM_ACCESS || !context.getOption(PythonOptions.RunViaLauncher).booleanValue()) {
            mod.setAttribute(PythonUtils.tsLiteral("list_files"), PNone.NO_VALUE);
        }
    }

    @CompilerDirectives.TruffleBoundary
    TruffleString getStdIOEncoding() {
        return (TruffleString)this.getBuiltinConstant(T_STDIO_ENCODING);
    }

    @CompilerDirectives.TruffleBoundary
    TruffleString getStdIOError() {
        return (TruffleString)this.getBuiltinConstant(T_STDIO_ERROR);
    }

    private static Object[] convertToObjectArray(TruffleString[] arr) {
        Object[] objectArr = new Object[arr.length];
        System.arraycopy(arr, 0, objectArr, 0, arr.length);
        return objectArr;
    }

    @Builtin(name="get_jdk_version", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetJdkVersion
    extends PythonBuiltinNode {
        GetJdkVersion() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        TruffleString get() {
            return TruffleString.fromJavaStringUncached((String)System.getProperty("java.version"), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="get_graalvm_version", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetGraalVmVersion
    extends PythonBuiltinNode {
        GetGraalVmVersion() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        TruffleString get() {
            Version current = Version.getCurrent();
            return TruffleString.fromJavaStringUncached((String)current.toString(), (TruffleString.Encoding)PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="list_files", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ListFiles
    extends PythonBinaryBuiltinNode {
        ListFiles() {
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object list(TruffleString dirPath, TruffleString filesListPath) {
            if (PythonOptions.WITHOUT_PLATFORM_ACCESS) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            this.print(this.getContext().getStandardOut(), String.format("listing files from '%s' to '%s'\n", dirPath, filesListPath));
            TruffleFile dir = this.getContext().getPublicTruffleFileRelaxed(dirPath, new TruffleString[0]);
            if (!dir.exists(new LinkOption[0]) || !dir.isDirectory(new LinkOption[0])) {
                this.print(this.getContext().getStandardErr(), String.format("'%s' has to exist and be a directory.\n", dirPath));
            }
            try (BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(filesListPath.toJavaStringUncached())));){
                TruffleFile p = this.getContext().getPublicTruffleFileRelaxed(filesListPath, new TruffleString[0]).getParent();
                if (!p.exists(new LinkOption[0])) {
                    this.getContext().getPublicTruffleFileRelaxed(filesListPath, new TruffleString[0]).getParent().createDirectories(new FileAttribute[0]);
                }
                Set<String> ret = ListFiles.list(dir, null);
                Object[] a = ret.toArray(new String[ret.size()]);
                Arrays.sort(a);
                for (Object f : a) {
                    if (((String)f).charAt(0) == '\\') {
                        f = ((String)f).replace("\\", "/");
                    }
                    bw.write((String)f);
                    bw.write("\n");
                }
            }
            catch (IOException e) {
                String msg = String.format("error while creating '%s': %s \n", filesListPath, e);
                this.print(this.getContext().getStandardErr(), msg);
            }
            return PNone.NONE;
        }

        private static Set<String> list(TruffleFile dir, TruffleFile rd) throws IOException {
            HashSet<String> ret = new HashSet<String>();
            Collection files = dir.list();
            String dirPath = ListFiles.makeDirPath(dir.getAbsoluteFile().getPath());
            TruffleFile rootDir = rd == null ? dir : rd;
            String rootPath = ListFiles.makeDirPath(rootDir.getAbsoluteFile().getPath());
            int rootEndIdx = rootPath.lastIndexOf(File.separator, rootPath.lastIndexOf(File.separator) - 1);
            ret.add(dirPath.substring(rootEndIdx));
            TruffleFile parent = dir;
            while (!parent.equals((Object)rootDir)) {
                String p = ListFiles.makeDirPath(parent.getAbsoluteFile().getPath());
                p = p.substring(rootEndIdx);
                ret.add(p);
                parent = parent.getParent();
            }
            if (files != null) {
                for (TruffleFile f : files) {
                    if (f.isRegularFile(new LinkOption[0])) {
                        ret.add(f.getAbsoluteFile().getPath().substring(rootEndIdx));
                        continue;
                    }
                    ret.addAll(ListFiles.list(f, rootDir));
                }
            }
            return ret;
        }

        private static String makeDirPath(String p) {
            if (!((String)p).endsWith(File.separator)) {
                p = (String)p + File.separator;
            }
            return p;
        }

        private void print(OutputStream out, String msg) {
            try {
                out.write(String.format("%s: %s", this.getContext().getOption(PythonOptions.Executable), msg).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Builtin(name="PyTruffle_CreateType", minNumOfPositionalArgs=4)
    @GenerateNodeFactory
    static abstract class PyTruffle_CreateType
    extends PythonQuaternaryBuiltinNode {
        PyTruffle_CreateType() {
        }

        @Specialization
        static PythonClass createType(VirtualFrame frame, TruffleString name, PTuple bases, PDict namespaceOrig, Object metaclass, @Cached TypeNodes.CreateTypeNode createType) {
            return createType.execute(frame, namespaceOrig, name, bases, metaclass, PKeyword.EMPTY_KEYWORDS);
        }
    }

    @Builtin(name="is_native_object", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IsNativeObject
    extends PythonUnaryBuiltinNode {
        IsNativeObject() {
        }

        @Specialization
        boolean isNative(PythonAbstractNativeObject obj) {
            return true;
        }

        @Fallback
        boolean isNative(Object obj) {
            return false;
        }
    }

    @Builtin(name="java_assert", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class JavaAssertNode
    extends PythonBuiltinNode {
        JavaAssertNode() {
        }

        @Specialization
        Object doit() {
            boolean assertOn = false;
            if (!$assertionsDisabled) {
                assertOn = true;
                if (!true) {
                    throw new AssertionError();
                }
            }
            return assertOn;
        }
    }

    @Builtin(name="dump_heap", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class DumpHeapNode
    extends PythonBuiltinNode {
        DumpHeapNode() {
        }

        @Specialization
        TruffleString doit(VirtualFrame frame, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            TruffleFile tempFile;
            try {
                PythonContext context = this.getContext();
                tempFile = context.getEnv().createTempFile(context.getEnv().getCurrentWorkingDirectory(), "graalpy", ".hprof", new FileAttribute[0]);
                tempFile.delete();
            }
            catch (IOException e) {
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError((Frame)frame, e, eqNode);
            }
            PythonUtils.dumpHeap(tempFile.getPath());
            return fromJavaStringNode.execute(tempFile.getPath(), PythonUtils.TS_ENCODING);
        }
    }

    @Builtin(name="which", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WhichNode
    extends PythonUnaryBuiltinNode {
        WhichNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object which(PBuiltinFunction object) {
            RootCallTarget callTarget = object.getCallTarget();
            return PythonUtils.toTruffleStringUncached(String.format("%s(%s)", object.getClass().getName(), WhichNode.whichCallTarget(callTarget)));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object which(PBuiltinMethod object) {
            return PythonUtils.toTruffleStringUncached(String.format("%s(%s)", object.getClass().getName(), WhichNode.whichCallTarget(object.getBuiltinFunction().getCallTarget())));
        }

        private static String whichCallTarget(RootCallTarget callTarget) {
            String rootStr;
            RootNode rootNode = callTarget.getRootNode();
            if (rootNode instanceof BuiltinFunctionRootNode) {
                BuiltinFunctionRootNode builtinFunctionRootNode = (BuiltinFunctionRootNode)rootNode;
                rootStr = String.format("nodeClass=%s", builtinFunctionRootNode.getFactory().getNodeClass().getName());
            } else {
                rootStr = String.format("root=%s", rootNode.getClass().getName());
            }
            return rootStr;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object which(Object object) {
            return PythonUtils.toTruffleStringUncached(object.getClass().getName());
        }
    }

    @Builtin(name="super", minNumOfPositionalArgs=1, doc="Returns HostAdapter instance of the object or None")
    @GenerateNodeFactory
    public static abstract class JavaSuperNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doIt(Object value) {
            try {
                return InteropLibrary.getUncached().readMember(value, "super");
            }
            catch (UnknownIdentifierException | UnsupportedMessageException e) {
                return PNone.NONE;
            }
        }
    }

    @Builtin(name="dis", minNumOfPositionalArgs=1, parameterNames={"obj", "quickened"}, doc="Helper to disassemble code objects")
    @ArgumentClinic(name="quickened", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")
    @GenerateNodeFactory
    static abstract class DisNode
    extends PythonBinaryClinicBuiltinNode {
        DisNode() {
        }

        @Specialization
        Object doMethod(PMethod method, boolean quickened) {
            Object function = method.getFunction();
            if (function instanceof PFunction) {
                return this.doFunction((PFunction)function, quickened);
            }
            return PNone.NONE;
        }

        @Specialization
        Object doFunction(PFunction function, boolean quickened) {
            return this.doCode(function.getCode(), quickened);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object doCode(PCode code, boolean quickened) {
            return PythonUtils.toTruffleStringUncached(code.toDisassembledString(quickened));
        }

        @Fallback
        Object doObject(Object value, Object quickened) {
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return GraalPythonModuleBuiltinsClinicProviders.DisNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=1, doc="Extends Java class and return HostAdapterCLass")
    @GenerateNodeFactory
    public static abstract class JavaExtendNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object doIt(Object value, @CachedLibrary(limit="3") InteropLibrary lib) {
            if (ImageInfo.inImageBuildtimeCode()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new UnsupportedOperationException(ErrorMessages.CANT_EXTEND_JAVA_CLASS_NOT_JVM.toJavaStringUncached());
            }
            if (ImageInfo.inImageRuntimeCode()) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw this.raise(PythonErrorType.SystemError, ErrorMessages.CANT_EXTEND_JAVA_CLASS_NOT_JVM);
            }
            TruffleLanguage.Env env = this.getContext().getEnv();
            if (!JavaExtendNode.isType(value, env, lib)) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.CANT_EXTEND_JAVA_CLASS_NOT_TYPE, value);
            }
            try {
                return env.createHostAdapter(new Object[]{value});
            }
            catch (Exception ex) {
                throw this.raise(PythonErrorType.TypeError, PythonUtils.getMessage(ex), ex);
            }
        }

        protected static boolean isType(Object obj, TruffleLanguage.Env env, InteropLibrary lib) {
            return env.isHostObject(obj) && (env.isHostSymbol(obj) || lib.isMetaObject(obj));
        }
    }

    @Builtin(name="storage_to_native", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StorageToNative
    extends PythonUnaryBuiltinNode {
        StorageToNative() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object toNative(PBytesLike bytes) {
            this.ensureCapi();
            NativeSequenceStorage newStorage = PySequenceArrayWrapper.ToNativeStorageNode.getUncached().execute(bytes.getSequenceStorage(), true);
            bytes.setSequenceStorage(newStorage);
            return bytes;
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        Object toNative(PSequence sequence) {
            this.ensureCapi();
            NativeSequenceStorage newStorage = PySequenceArrayWrapper.ToNativeStorageNode.getUncached().execute(sequence.getSequenceStorage(), false);
            sequence.setSequenceStorage(newStorage);
            return sequence;
        }

        private void ensureCapi() {
            try {
                CApiContext.ensureCapiWasLoaded(null, this.getContext(), StringLiterals.T_EMPTY_STRING, StringLiterals.T_EMPTY_STRING);
            }
            catch (Exception e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @Builtin(name="set_storage_strategy", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStorageStrategyNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object doSet(PSet set, TruffleString strategyName) {
            this.validate(set.getDictStorage());
            set.setDictStorage(this.getStrategy(strategyName, this.getLanguage()));
            return set;
        }

        @Specialization
        Object doDict(PDict dict, TruffleString strategyName) {
            this.validate(dict.getDictStorage());
            dict.setDictStorage(this.getStrategy(strategyName, this.getLanguage()));
            return dict;
        }

        private HashingStorage getStrategy(TruffleString tname, PythonLanguage lang) {
            String name;
            switch (name = tname.toJavaStringUncached()) {
                case "empty": {
                    return EmptyStorage.INSTANCE;
                }
                case "dynamicobject": {
                    return new DynamicObjectStorage(lang);
                }
                case "economicmap": {
                    return EconomicMapStorage.create();
                }
            }
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.UNKNOWN_STORAGE_STRATEGY);
        }

        private void validate(HashingStorage dictStorage) {
            if (HashingStorageNodes.HashingStorageLen.executeUncached(dictStorage) != 0) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.SHOULD_BE_USED_ONLY_NEW_SETS);
            }
        }
    }

    @Builtin(name="time_millis", minNumOfPositionalArgs=0, maxNumOfPositionalArgs=1, doc="Like time.time() but in milliseconds resolution.")
    @GenerateNodeFactory
    public static abstract class TimeMillis
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static long doIt(Object dummy) {
            return System.currentTimeMillis();
        }
    }

    @Builtin(name="posix_module_backend", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class PosixModuleBackendNode
    extends PythonBuiltinNode {
        @Specialization
        TruffleString posixModuleBackend(@CachedLibrary(value="getPosixSupport()") PosixSupportLibrary posixLib) {
            return posixLib.getBackend(this.getPosixSupport());
        }
    }

    @Builtin(name="determine_system_toolchain", maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DetermineSystemToolchain
    extends PythonUnaryBuiltinNode {
        private static final String[] C_COMPILER_PRECEDENCE = new String[]{"gcc", "clang"};
        private static final String[] CXX_COMPILER_PRECEDENCE = new String[]{"g++", "clang++"};
        private static final PKeyword[] GENERIC_TOOLCHAIN = new PKeyword[]{new PKeyword(PythonUtils.tsLiteral("CC"), PythonUtils.tsLiteral("cc")), new PKeyword(PythonUtils.tsLiteral("CXX"), PythonUtils.tsLiteral("c++")), new PKeyword(PythonUtils.tsLiteral("AR"), PythonUtils.tsLiteral("ar")), new PKeyword(PythonUtils.tsLiteral("RANLIB"), PythonUtils.tsLiteral("ranlib")), new PKeyword(PythonUtils.tsLiteral("LD"), PythonUtils.tsLiteral("ld")), new PKeyword(PythonUtils.tsLiteral("NM"), PythonUtils.tsLiteral("nm"))};

        @Specialization
        PDict doGeneric(Object unused) {
            return this.factory().createDict(DetermineSystemToolchain.fromToolchain());
        }

        @CompilerDirectives.TruffleBoundary
        private static PKeyword[] fromToolchain() {
            PKeyword[] result = GENERIC_TOOLCHAIN;
            int id = DetermineSystemToolchain.which();
            if (id >= 0) {
                assert (id < C_COMPILER_PRECEDENCE.length);
                result = Arrays.copyOf(GENERIC_TOOLCHAIN, GENERIC_TOOLCHAIN.length);
                result[0] = new PKeyword(PythonUtils.tsLiteral("CC"), PythonUtils.tsLiteral(C_COMPILER_PRECEDENCE[id]));
                result[1] = new PKeyword(PythonUtils.tsLiteral("CXX"), PythonUtils.tsLiteral(CXX_COMPILER_PRECEDENCE[id]));
            }
            return result;
        }

        private static int which() {
            CompilerAsserts.neverPartOfCompilation();
            String path = System.getenv("PATH");
            if (path != null) {
                for (int i = 0; i < C_COMPILER_PRECEDENCE.length; ++i) {
                    int last = 0;
                    int j = path.indexOf(File.pathSeparatorChar);
                    while (j != -1) {
                        Path resolvedProgramName = Paths.get(path.substring(last, j), new String[0]).resolve(C_COMPILER_PRECEDENCE[i]);
                        if (Files.isExecutable(resolvedProgramName)) {
                            return i;
                        }
                        last = j + 1;
                        j = path.indexOf(File.pathSeparatorChar, last);
                    }
                }
            }
            return -1;
        }
    }

    @Builtin(name="get_toolchain_paths", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class GetToolchainPathsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object getToolPath(TruffleString tool) {
            LanguageInfo llvmInfo;
            TruffleLanguage.Env env = this.getContext().getEnv();
            Toolchain toolchain = (Toolchain)env.lookup(llvmInfo = (LanguageInfo)env.getInternalLanguages().get("llvm"), Toolchain.class);
            List toolPaths = toolchain.getPaths(tool.toJavaStringUncached());
            if (toolPaths == null) {
                return PNone.NONE;
            }
            Object[] pathNames = new Object[toolPaths.size()];
            for (int i = 0; i < pathNames.length; ++i) {
                pathNames[i] = PythonUtils.toTruffleStringUncached(((TruffleFile)toolPaths.get(i)).toString().replace("\\", "/"));
            }
            return PythonObjectFactory.getUncached().createList(pathNames);
        }
    }

    @Builtin(name="get_platform_id", minNumOfPositionalArgs=0)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class GetPlatformId
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected TruffleString getPlatformId() {
            return this.getContext().getPlatformId();
        }
    }

    @Builtin(name="get_toolchain_tool_path", minNumOfPositionalArgs=1)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class GetToolPathNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object getToolPath(TruffleString tool) {
            LanguageInfo llvmInfo;
            TruffleLanguage.Env env = this.getContext().getEnv();
            Toolchain toolchain = (Toolchain)env.lookup(llvmInfo = (LanguageInfo)env.getInternalLanguages().get("llvm"), Toolchain.class);
            TruffleFile toolPath = toolchain.getToolPath(tool.toJavaStringUncached());
            if (toolPath == null) {
                return PNone.NONE;
            }
            return PythonUtils.toTruffleStringUncached(toolPath.toString().replace("\\", "/"));
        }
    }

    @Builtin(name="is_managed_launcher")
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class IsManagedLauncher
    extends PythonBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected boolean isManaged() {
            return !this.getContext().getEnv().isNativeAccessAllowed() && this.getContext().getOption(PythonOptions.RunViaLauncher) != false;
        }
    }

    @Builtin(name="get_toolchain_tools_for_venv")
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class GetToolchainToolsForVenv
    extends PythonBuiltinNode {
        static final Tool[] tools = new Tool[]{Tool.forVariable("AR", PythonUtils.tsLiteral("ar")), Tool.forVariable("RANLIB", PythonUtils.tsLiteral("ranlib")), Tool.forVariable("NM", PythonUtils.tsLiteral("nm")), Tool.forVariable("LD", PythonUtils.tsLiteral("ld.lld"), PythonUtils.tsLiteral("ld"), PythonUtils.tsLiteral("lld")), Tool.forVariable("CC", PythonUtils.tsLiteral("clang"), PythonUtils.tsLiteral("cc")), Tool.forVariable("CXX", PythonUtils.tsLiteral("clang++"), PythonUtils.tsLiteral("c++")), Tool.forVariable("FC", PythonUtils.tsLiteral("graalvm-flang"), PythonUtils.tsLiteral("flang-new"), PythonUtils.tsLiteral("flang")), Tool.forBinary("llvm-as", PythonUtils.tsLiteral("as")), Tool.forBinary("clang-cl", PythonUtils.tsLiteral("cl")), Tool.forBinary("clang-cpp", PythonUtils.tsLiteral("cpp"))};

        @Specialization
        @CompilerDirectives.TruffleBoundary
        protected Object getToolPath() {
            TruffleLanguage.Env env = this.getContext().getEnv();
            LanguageInfo llvmInfo = (LanguageInfo)env.getInternalLanguages().get("llvm");
            Toolchain toolchain = (Toolchain)env.lookup(llvmInfo, Toolchain.class);
            List toolchainPaths = toolchain.getPaths("PATH");
            EconomicMapStorage storage = EconomicMapStorage.create(tools.length);
            for (Tool tool : tools) {
                String path;
                block4: {
                    block3: {
                        path = null;
                        if (!tool.isVariableName) break block3;
                        TruffleFile toolPath = toolchain.getToolPath(tool.name);
                        if (toolPath == null) break block4;
                        path = toolPath.getAbsoluteFile().getPath();
                        break block4;
                    }
                    for (TruffleFile toolchainPath : toolchainPaths) {
                        LOGGER.finest(() -> " Testing path " + toolchainPath.getPath() + " for tool " + tool.name);
                        TruffleFile pathToTest = toolchainPath.resolve(tool.name);
                        if (!pathToTest.exists(new LinkOption[0])) continue;
                        path = pathToTest.getAbsoluteFile().getPath();
                        break;
                    }
                }
                if (path != null) {
                    storage.putUncached(PythonUtils.toTruffleStringUncached(path), (Object)this.factory().createTuple(tool.targets));
                    continue;
                }
                LOGGER.fine("Could not locate tool " + tool.name);
            }
            return this.factory().createDict(storage);
        }

        private static final class Tool {
            final String name;
            final boolean isVariableName;
            final Object[] targets;

            public Tool(String name, boolean isVariableName, Object[] targets) {
                this.name = name;
                this.isVariableName = isVariableName;
                this.targets = targets;
            }

            static Tool forVariable(String name, Object ... targets) {
                return new Tool(name, true, targets);
            }

            static Tool forBinary(String name, Object ... targets) {
                return new Tool(name, true, targets);
            }
        }
    }

    @Builtin(name="force_split_direct_calls", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ForceSplitDirectCallsNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doIt(PFunction func) {
            func.setForceSplitDirectCalls(true);
            return func;
        }
    }

    @Builtin(name="builtin_method", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class BuiltinMethodNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doIt(PFunction func, @Bind(value="this") Node inliningTarget, @Cached CodeNodes.GetCodeRootNode getRootNode) {
            RootNode rootNode = getRootNode.execute(inliningTarget, func.getCode());
            if (rootNode instanceof PBytecodeRootNode) {
                ((PBytecodeRootNode)rootNode).setPythonInternal(true);
            }
            return func;
        }
    }

    @Builtin(name="builtin", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class BuiltinNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        public Object doIt(VirtualFrame frame, PFunction func, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItem) {
            PythonModule builtinModule;
            PFunction builtinFunc = this.convertToBuiltin(func);
            PythonObject globals = func.getGlobals();
            if (globals instanceof PythonModule) {
                builtinModule = (PythonModule)globals;
            } else {
                TruffleString moduleName = (TruffleString)getItem.execute((Frame)frame, inliningTarget, globals, SpecialAttributeNames.T___NAME__);
                builtinModule = this.getContext().lookupBuiltinModule(moduleName);
                assert (builtinModule != null);
            }
            return this.factory().createBuiltinMethod((Object)builtinModule, builtinFunc);
        }

        @CompilerDirectives.TruffleBoundary
        public synchronized PFunction convertToBuiltin(PFunction func) {
            RootNode rootNode = CodeNodes.GetCodeRootNode.executeUncached(func.getCode());
            if (rootNode instanceof PBytecodeRootNode) {
                ((PBytecodeRootNode)rootNode).setPythonInternal(true);
            }
            func.setBuiltin(true);
            return func;
        }
    }

    @Builtin(name="tdebug", takesVarArgs=true)
    @GenerateNodeFactory
    public static abstract class DebugNode
    extends PythonBuiltinNode {
        public abstract Object execute(Object[] var1);

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public Object doIt(Object[] args) {
            PrintWriter stdout = new PrintWriter(this.getContext().getStandardOut());
            for (int i = 0; i < args.length; ++i) {
                stdout.println(args[i]);
            }
            stdout.flush();
            return PNone.NONE;
        }

        @NeverDefault
        public static DebugNode create() {
            return GraalPythonModuleBuiltinsFactory.DebugNodeFactory.create(null);
        }
    }

    @Builtin(name="current_import", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    public static abstract class CurrentImport
    extends PythonBuiltinNode {
        @Specialization
        TruffleString doIt() {
            return this.getContext().getCurrentImport();
        }
    }

    @Builtin(name="dump_truffle_ast", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class DumpTruffleAstNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        public TruffleString doIt(PFunction func) {
            return PythonUtils.toTruffleStringUncached(NodeUtil.printTreeToString((Node)FunctionNodes.GetCallTargetNode.getUncached().execute(func).getRootNode()));
        }

        @Specialization(guards={"isFunction(method.getFunction())"})
        @CompilerDirectives.TruffleBoundary
        public TruffleString doIt(PMethod method) {
            return PythonUtils.toTruffleStringUncached(NodeUtil.printTreeToString((Node)FunctionNodes.GetCallTargetNode.getUncached().execute(method).getRootNode()));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public TruffleString doIt(PGenerator gen) {
            return PythonUtils.toTruffleStringUncached(NodeUtil.printTreeToString((Node)gen.getCurrentCallTarget().getRootNode()));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public TruffleString doIt(PCode code) {
            return PythonUtils.toTruffleStringUncached(NodeUtil.printTreeToString((Node)CodeNodes.GetCodeRootNode.executeUncached(code)));
        }

        @CompilerDirectives.TruffleBoundary
        @Fallback
        public TruffleString doit(Object object) {
            return PythonUtils.toTruffleStringUncached("truffle ast dump not supported for " + object.toString());
        }

        protected static boolean isFunction(Object callee) {
            return callee instanceof PFunction;
        }
    }

    @Builtin(name="read_file", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReadFileNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PBytes doString(VirtualFrame frame, Object filenameObj, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.EqualNode eqNode, @Cached PConstructAndRaiseNode.Lazy constructAndRaiseNode) {
            try {
                TruffleString filename = castToTruffleStringNode.execute(inliningTarget, filenameObj);
                TruffleFile file = this.getContext().getPublicTruffleFileRelaxed(filename, PythonLanguage.T_DEFAULT_PYTHON_EXTENSIONS);
                byte[] bytes = file.readAllBytes();
                return this.factory().createBytes(bytes);
            }
            catch (Exception ex) {
                OSErrorEnum.ErrorAndMessagePair errAndMsg = OSErrorEnum.fromException(ex, eqNode);
                throw constructAndRaiseNode.get(inliningTarget).raiseOSError(frame, errAndMsg.oserror.getNumber(), errAndMsg.message);
            }
        }
    }

    @Builtin(name="run_path")
    @GenerateNodeFactory
    static abstract class RunPathNode
    extends PythonBuiltinNode {
        public static final TruffleString T_RUNPY = PythonUtils.tsLiteral("runpy");

        RunPathNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PNone run() {
            boolean needsMainImporter;
            assert (!ImageInfo.inImageBuildtimeCode());
            PythonContext context = this.getContext();
            TruffleString inputFilePath = context.getOption(PythonOptions.InputFilePath);
            PythonModule sysModule = context.getSysModule();
            boolean bl = needsMainImporter = !inputFilePath.isEmpty() && RunPathNode.getImporter(sysModule, inputFilePath);
            if (needsMainImporter) {
                Object sysPath = sysModule.getAttribute(StringLiterals.T_PATH);
                PyObjectCallMethodObjArgs.getUncached().execute(null, null, sysPath, SpecialMethodNames.T_INSERT, 0, inputFilePath);
            } else {
                context.addSysPath0();
            }
            if (needsMainImporter) {
                RunPathNode.runModule(BuiltinNames.T___MAIN__, false);
            } else {
                this.runFile(context, inputFilePath);
            }
            return PNone.NONE;
        }

        private void runFile(PythonContext context, TruffleString inputFilePath) {
            Source source;
            try {
                Source.SourceBuilder builder;
                if (inputFilePath.isEmpty()) {
                    builder = Source.newBuilder((String)"python", (Reader)new InputStreamReader(context.getStandardIn()), (String)"<stdin>");
                } else {
                    TruffleFile file = context.getPublicTruffleFileRelaxed(inputFilePath, new TruffleString[0]);
                    builder = Source.newBuilder((String)"python", (TruffleFile)file);
                }
                source = builder.mimeType("text/x-python").build();
            }
            catch (IOException e) {
                OSErrorEnum.ErrorAndMessagePair error = OSErrorEnum.fromException(e, TruffleString.EqualNode.getUncached());
                String msg = String.format("%s: can't open file '%s': [Errno %d] %s\n", context.getOption(PythonOptions.Executable), inputFilePath, error.oserror.getNumber(), error.message);
                try {
                    context.getStandardErr().write(msg.getBytes(StandardCharsets.UTF_8));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw new PythonExitException(this, 2);
            }
            CallTarget callTarget = context.getEnv().parsePublic(source, new String[0]);
            callTarget.call(PythonUtils.EMPTY_OBJECT_ARRAY);
        }

        private static void runModule(TruffleString module, boolean setArgv0) {
            Object runpy = AbstractImportNode.importModule(T_RUNPY);
            PyObjectCallMethodObjArgs.executeUncached(runpy, T__RUN_MODULE_AS_MAIN, module, setArgv0);
        }

        private static boolean getImporter(PythonModule sysModule, TruffleString inputFilePath) {
            PDict pathImporterCacheDict;
            Object importer = null;
            Object pathHooks = sysModule.getAttribute(T_PATH_HOOKS);
            Object pathImporterCache = sysModule.getAttribute(T_PATH_IMPORTER_CACHE);
            if (pathHooks instanceof PList && pathImporterCache instanceof PDict && (importer = (pathImporterCacheDict = (PDict)pathImporterCache).getItem(inputFilePath)) == null) {
                pathImporterCacheDict.setItem(inputFilePath, PNone.NONE);
                SequenceStorage storage = ((PList)pathHooks).getSequenceStorage();
                Object[] hooks = storage.getInternalArray();
                int numHooks = storage.length();
                for (int i = 0; i < numHooks; ++i) {
                    try {
                        importer = CallNode.getUncached().execute(hooks[i], inputFilePath);
                        break;
                    }
                    catch (PException e) {
                        if (IsSubtypeNode.getUncached().execute(GetClassNode.executeUncached(e.getUnreifiedException()), (Object)PythonErrorType.ImportError)) continue;
                        throw e;
                    }
                }
                if (importer != null) {
                    pathImporterCacheDict.setItem(inputFilePath, importer);
                }
            }
            return importer != null && importer != PNone.NONE;
        }
    }
}

