/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.BufferedIONodes;
import com.oracle.graal.python.builtins.modules.io.FileIOBuiltins;
import com.oracle.graal.python.builtins.modules.io.PBuffered;
import com.oracle.graal.python.builtins.modules.io.PFileIO;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.exception.OsErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

abstract class AbstractBufferedIOBuiltins
extends PythonBuiltins {
    public static final int DEFAULT_BUFFER_SIZE = 8192;

    AbstractBufferedIOBuiltins() {
    }

    protected static boolean isFileIO(PBuffered self, Object raw, PythonBuiltinClassType type, Node inliningTarget, GetClassNode.GetPythonObjectClassNode getSelfClass, GetClassNode getRawClass) {
        return raw instanceof PFileIO && getSelfClass.execute(inliningTarget, self) == type && getRawClass.execute(inliningTarget, raw) == PythonBuiltinClassType.PFileIO;
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class LazyRaiseBlockingIOError
    extends Node {
        public final RaiseBlockingIOError get(Node inliningTarget) {
            return this.execute(inliningTarget);
        }

        protected abstract RaiseBlockingIOError execute(Node var1);

        @Specialization
        static RaiseBlockingIOError doIt(@Cached(inline=false) RaiseBlockingIOError node) {
            return node;
        }
    }

    @GenerateInline(value=false)
    public static abstract class RaiseBlockingIOError
    extends Node {
        protected abstract PException execute(Node var1, Object var2, TruffleString var3, int var4);

        public final PException raise(Object errno, TruffleString message, int written) {
            return this.execute(this, errno, message, written);
        }

        public final PException raiseEWOULDBLOCK(TruffleString message, int written) {
            return this.raise(OSErrorEnum.EWOULDBLOCK.getNumber(), message, written);
        }

        public final PException raiseEAGAIN(TruffleString message, int written) {
            return this.raise(OSErrorEnum.EAGAIN.getNumber(), message, written);
        }

        @Specialization
        static PException raise(Node node, Object errno, TruffleString message, int written, @Cached PythonObjectFactory factory) {
            Object[] args = new Object[]{errno, message, written};
            PBaseException exception = factory.createBaseException((Object)PythonBuiltinClassType.BlockingIOError, factory.createTuple(args));
            Object[] attrs = OsErrorBuiltins.OS_ERROR_ATTR_FACTORY.create();
            attrs[0] = errno;
            attrs[1] = message;
            attrs[5] = written;
            exception.setExceptionAttributes(attrs);
            return PRaiseNode.raiseExceptionObject(node, exception);
        }
    }

    static abstract class PythonUnaryWithInitErrorBuiltinNode
    extends PythonUnaryBuiltinNode {
        PythonUnaryWithInitErrorBuiltinNode() {
        }

        @Specialization(guards={"!self.isOK()"})
        Object initError(PBuffered self) {
            if (self.isDetached()) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_STREAM_DETACHED);
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    static abstract class PythonBinaryWithInitErrorBuiltinNode
    extends PythonBinaryBuiltinNode {
        PythonBinaryWithInitErrorBuiltinNode() {
        }

        @Specialization(guards={"!self.isOK()"})
        Object initError(PBuffered self, Object buffer) {
            if (self.isDetached()) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_STREAM_DETACHED);
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    static abstract class PythonBinaryWithInitErrorClinicBuiltinNode
    extends PythonBinaryClinicBuiltinNode {
        PythonBinaryWithInitErrorClinicBuiltinNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            throw CompilerDirectives.shouldNotReachHere((String)"abstract");
        }

        @Specialization(guards={"!self.isOK()"})
        Object initError(PBuffered self, Object o) {
            if (self.isDetached()) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_STREAM_DETACHED);
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class InitBufferSizeNode
    extends Node {
        public abstract int execute(VirtualFrame var1, Node var2, Object var3);

        @Specialization
        static int doInit(PNone bufferSize) {
            return 8192;
        }

        @Specialization
        static int doInt(int bufferSize) {
            return bufferSize;
        }

        @Fallback
        static int doOther(VirtualFrame frame, Node inliningTarget, Object bufferSizeObj, @Cached PyNumberAsSizeNode asSizeNode) {
            return asSizeNode.executeExact((Frame)frame, inliningTarget, bufferSizeObj, PythonErrorType.ValueError);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class BufferedInitNode
    extends PNodeWithContext {
        public abstract void execute(VirtualFrame var1, Node var2, PBuffered var3, int var4, PythonObjectFactory var5);

        @Specialization(guards={"bufferSize > 0"})
        static void bufferedInit(VirtualFrame frame, Node inliningTarget, PBuffered self, int bufferSize, PythonObjectFactory factory, @Cached BufferedIONodes.RawTellIgnoreErrorNode rawTellNode) {
            BufferedInitNode.init(self, bufferSize, factory);
            rawTellNode.execute(frame, inliningTarget, self);
        }

        @Specialization(guards={"bufferSize <= 0"})
        static void bufferSizeError(PBuffered self, int bufferSize, PythonObjectFactory factory, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.BUF_SIZE_POS);
        }

        private static void init(PBuffered self, int bufferSize, PythonObjectFactory factory) {
            self.initBuffer(bufferSize);
            self.setLock(factory.createLock());
            self.setOwner(0L);
            int n = bufferSize - 1;
            while ((n & 1) != 0) {
                n >>= 1;
            }
            int mask = n == 0 ? bufferSize - 1 : 0;
            self.setBufferMask(mask);
        }

        public static void internalInit(PBuffered self, int bufferSize, PythonObjectFactory factory, Object posixSupport, PosixSupportLibrary posixLib) {
            BufferedInitNode.init(self, bufferSize, factory);
            try {
                FileIOBuiltins.TellNode.internalTell(self.getFileIORaw(), posixSupport, posixLib);
            }
            catch (PosixSupportLibrary.PosixException posixException) {
                // empty catch block
            }
        }
    }
}

