/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodes;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.NFILZMASupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(defineModule="_lzma")
public final class LZMAModuleBuiltins
extends PythonBuiltins {
    public static final String J__LZMA = "_lzma";
    public static final TruffleString T__LZMA = PythonUtils.tsLiteral("_lzma");
    public static final TruffleString T_LZMA_JAVA_ERROR = PythonUtils.tsLiteral("This feature is only supported with native library being loaded. Please install 'lzma' library in your system.");
    public static final int INITIAL_BUFFER_SIZE = 8192;
    @CompilerDirectives.CompilationFinal
    public static int CHECK_NONE = 0;
    @CompilerDirectives.CompilationFinal
    public static int CHECK_CRC32 = 1;
    @CompilerDirectives.CompilationFinal
    public static int CHECK_CRC64 = 4;
    @CompilerDirectives.CompilationFinal
    public static int CHECK_SHA256 = 10;
    @CompilerDirectives.CompilationFinal
    public static int CHECK_ID_MAX = 15;
    @CompilerDirectives.CompilationFinal
    public static int CHECK_UNKNOWN = CHECK_ID_MAX + 1;
    public static final int LZMA_FILTERS_MAX = 4;
    public static final int LZMA_TELL_NO_CHECK = 1;
    public static final int LZMA_TELL_ANY_CHECK = 4;
    public static final int LZMA_IGNORE_CHECK = 16;
    @CompilerDirectives.CompilationFinal
    public static long PRESET_DEFAULT = 6L;
    @CompilerDirectives.CompilationFinal
    public static long PRESET_EXTREME = 9L;
    @CompilerDirectives.CompilationFinal
    public static int MODE_FAST = 1;
    @CompilerDirectives.CompilationFinal
    public static int MODE_NORMAL = 2;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final long[] FILTERS = new long[]{32L, 33L, 3L, 4L, 5L, 6L, 7L, 8L, 9L};
    @CompilerDirectives.CompilationFinal
    public static int MF_HC3 = 3;
    @CompilerDirectives.CompilationFinal
    public static int MF_HC4 = 4;
    @CompilerDirectives.CompilationFinal
    public static int MF_BT2 = 18;
    @CompilerDirectives.CompilationFinal
    public static int MF_BT3 = 19;
    @CompilerDirectives.CompilationFinal
    public static int MF_BT4 = 20;
    @CompilerDirectives.CompilationFinal
    public static int FORMAT_AUTO = 0;
    @CompilerDirectives.CompilationFinal
    public static int FORMAT_XZ = 1;
    @CompilerDirectives.CompilationFinal
    public static int FORMAT_ALONE = 2;
    @CompilerDirectives.CompilationFinal
    public static int FORMAT_RAW = 3;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return LZMAModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        super.initialize(core);
    }

    private static Object as(Python3Core core, int[] a) {
        return core.getContext().getEnv().asGuestValue((Object)a);
    }

    private static Object as(Python3Core core, long[] a) {
        return core.getContext().getEnv().asGuestValue((Object)a);
    }

    @Override
    public void postInitialize(Python3Core c) {
        super.postInitialize(c);
        NFILZMASupport lzmaSupport = c.getContext().getNFILZMASupport();
        PythonModule lzmaModule = c.lookupBuiltinModule(T__LZMA);
        int[] formats = new int[4];
        int[] checks = new int[6];
        int[] mfs = new int[5];
        int[] modes = new int[2];
        long[] preset = new long[2];
        if (lzmaSupport.isAvailable()) {
            try {
                lzmaSupport.getMacros(LZMAModuleBuiltins.as(c, formats), LZMAModuleBuiltins.as(c, checks), LZMAModuleBuiltins.as(c, FILTERS), LZMAModuleBuiltins.as(c, mfs), LZMAModuleBuiltins.as(c, modes), LZMAModuleBuiltins.as(c, preset));
                FORMAT_AUTO = formats[0];
                FORMAT_XZ = formats[1];
                FORMAT_ALONE = formats[2];
                FORMAT_RAW = formats[3];
                CHECK_NONE = checks[0];
                CHECK_CRC32 = checks[1];
                CHECK_CRC64 = checks[2];
                CHECK_SHA256 = checks[3];
                CHECK_ID_MAX = checks[4];
                CHECK_UNKNOWN = checks[5];
                MF_HC3 = mfs[0];
                MF_HC4 = mfs[1];
                MF_BT2 = mfs[2];
                MF_BT3 = mfs[3];
                MF_BT4 = mfs[4];
                MODE_FAST = modes[0];
                MODE_NORMAL = modes[1];
                PRESET_DEFAULT = preset[0];
                PRESET_EXTREME = preset[1];
            }
            catch (NativeLibrary.NativeLibraryCannotBeLoaded e) {
                lzmaSupport.notAvailable();
            }
        }
        lzmaModule.setAttribute(PythonUtils.tsLiteral("CHECK_NONE"), CHECK_NONE);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("CHECK_CRC32"), CHECK_CRC32);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("CHECK_CRC64"), CHECK_CRC64);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("CHECK_SHA256"), CHECK_SHA256);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("CHECK_ID_MAX"), CHECK_ID_MAX);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("CHECK_UNKNOWN"), CHECK_UNKNOWN);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_LZMA1"), FILTERS[0]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_LZMA2"), FILTERS[1]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_DELTA"), FILTERS[2]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_X86"), FILTERS[3]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_POWERPC"), FILTERS[4]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_IA64"), FILTERS[5]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_ARM"), FILTERS[6]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_ARMTHUMB"), FILTERS[7]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FILTER_SPARC"), FILTERS[8]);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FORMAT_AUTO"), FORMAT_AUTO);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FORMAT_XZ"), FORMAT_XZ);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FORMAT_ALONE"), FORMAT_ALONE);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("FORMAT_RAW"), FORMAT_RAW);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("PRESET_DEFAULT"), PRESET_DEFAULT);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("PRESET_EXTREME"), PRESET_EXTREME);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MODE_FAST"), MODE_FAST);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MODE_NORMAL"), MODE_NORMAL);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MF_BT2"), MF_BT2);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MF_BT3"), MF_BT3);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MF_BT4"), MF_BT4);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MF_HC3"), MF_HC3);
        lzmaModule.setAttribute(PythonUtils.tsLiteral("MF_HC4"), MF_HC4);
    }

    @Builtin(name="_decode_filter_properties", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class DecodeFilterPropertiesNode
    extends PythonBinaryBuiltinNode {
        DecodeFilterPropertiesNode() {
        }

        @Specialization
        PDict encode(VirtualFrame frame, Object id, Object encodedProps, @Bind(value="this") Node inliningTarget, @Cached CastToJavaLongLossyNode toLong, @Cached BytesNodes.ToBytesNode toBytes, @Cached LZMANodes.DecodeFilterProperties decodeFilterProperties) {
            byte[] bytes = toBytes.execute(frame, encodedProps);
            PDict dict = this.factory().createDict();
            decodeFilterProperties.execute(frame, toLong.execute(inliningTarget, id), bytes, dict);
            return dict;
        }
    }

    @Builtin(name="_encode_filter_properties", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class EncodeFilterPropertiesNode
    extends PythonUnaryBuiltinNode {
        EncodeFilterPropertiesNode() {
        }

        @Specialization
        PBytes encode(VirtualFrame frame, Object filter, @Cached LZMANodes.EncodeFilterProperties encodeFilterProperties) {
            return this.factory().createBytes(encodeFilterProperties.execute(frame, filter));
        }
    }

    @Builtin(name="is_check_supported", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class IsCheckSupportedNode
    extends PythonUnaryBuiltinNode {
        IsCheckSupportedNode() {
        }

        @Specialization
        static boolean doInt(VirtualFrame frame, Object checkID, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached LZMANodes.IsCheckSupported isCheckSupported) {
            return isCheckSupported.execute(asSizeNode.executeExact((Frame)frame, inliningTarget, checkID, PythonBuiltinClassType.ValueError));
        }
    }

    @Builtin(name="LZMADecompressor", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PLZMADecompressor)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class LZMADecompressorNode
    extends PythonBuiltinNode {
        LZMADecompressorNode() {
        }

        @Specialization
        LZMAObject doNew(Object cls, Object arg) {
            return this.factory().createLZMADecompressor(cls, this.getContext().getNFILZMASupport().isAvailable());
        }
    }

    @Builtin(name="LZMACompressor", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true, constructsClass=PythonBuiltinClassType.PLZMACompressor)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class LZMACompressorNode
    extends PythonBuiltinNode {
        LZMACompressorNode() {
        }

        @Specialization
        LZMAObject doNew(Object cls, Object arg) {
            return this.factory().createLZMACompressor(cls, this.getContext().getNFILZMASupport().isAvailable());
        }
    }
}

