/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.lzma;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.lzma.LZMAModuleBuiltins;
import com.oracle.graal.python.builtins.modules.lzma.LZMANodesFactory;
import com.oracle.graal.python.builtins.modules.lzma.LZMAObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesUtils;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PNodeWithRaise;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongLossyNode;
import com.oracle.graal.python.runtime.NFILZMASupport;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NonIdempotent;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Arrays;
import org.tukaani.xz.ARMOptions;
import org.tukaani.xz.ARMThumbOptions;
import org.tukaani.xz.CorruptedInputException;
import org.tukaani.xz.DeltaOptions;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.IA64Options;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.MemoryLimitException;
import org.tukaani.xz.PowerPCOptions;
import org.tukaani.xz.SPARCOptions;
import org.tukaani.xz.UnsupportedOptionsException;
import org.tukaani.xz.X86Options;
import org.tukaani.xz.XZFormatException;
import org.tukaani.xz.check.Check;

public class LZMANodes {
    public static final long MAX_UINT32 = 0x100000000L;
    protected static final int LZMA_RUN = 0;
    protected static final int LZMA_FINISH = 3;
    private static final int LZMA_OK = 0;
    private static final int LZMA_STREAM_END = 1;
    private static final int LZMA_NO_CHECK = 2;
    private static final int LZMA_UNSUPPORTED_CHECK = 3;
    private static final int LZMA_GET_CHECK = 4;
    private static final int LZMA_MEM_ERROR = 5;
    private static final int LZMA_MEMLIMIT_ERROR = 6;
    private static final int LZMA_FORMAT_ERROR = 7;
    private static final int LZMA_OPTIONS_ERROR = 8;
    private static final int LZMA_DATA_ERROR = 9;
    private static final int LZMA_BUF_ERROR = 10;
    private static final int LZMA_PROG_ERROR = 11;

    @CompilerDirectives.TruffleBoundary
    protected static LZMA2Options parseLZMAOptions(long preset) {
        LZMA2Options lzmaOptions = null;
        try {
            lzmaOptions = new LZMA2Options();
            lzmaOptions.setPreset((int)preset);
        }
        catch (UnsupportedOptionsException e) {
            try {
                lzmaOptions.setPreset(9);
            }
            catch (UnsupportedOptionsException e1) {
                throw new IllegalStateException("should not be reached");
            }
        }
        return lzmaOptions;
    }

    protected static int errorHandling(int lzret, PRaiseNode raise) {
        switch (lzret) {
            case 0: 
            case 1: 
            case 2: 
            case 4: {
                return 0;
            }
            case 3: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.UNSUPPORTED_INTEGRITY_CHECK);
            }
            case 5: {
                throw raise.raise(PythonBuiltinClassType.MemoryError);
            }
            case 6: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.MEM_USAGE_LIMIT_EXCEEDED);
            }
            case 7: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INPUT_FMT_NOT_SUPPORTED_BY_DECODER);
            }
            case 8: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_UNSUPPORTED_OPTIONS);
            }
            case 9: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.CORRUPT_INPUT_DATA);
            }
            case 10: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INSUFFICIENT_BUFFER_SPACE);
            }
            case 11: {
                throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INTERNAL_ERROR);
            }
        }
        throw raise.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.UNRECOGNIZED_ERROR_FROM_LIBLZMA, lzret);
    }

    protected static class LZMAByteInputStream
    extends ByteArrayInputStream {
        public LZMAByteInputStream(byte[] buf, int offset, int length) {
            super(buf, offset, length);
        }

        public void setBuffer(byte[] bytes, int off) {
            this.buf = bytes;
            this.pos = off;
            this.mark = off;
            this.count = bytes.length;
        }

        public int getNextInIndex() {
            return this.pos;
        }

        public int getAvailIn() {
            return this.available();
        }
    }

    public static abstract class DecodeFilterProperties
    extends PNodeWithRaise {
        public abstract void execute(VirtualFrame var1, long var2, byte[] var4, PDict var5);

        @NonIdempotent
        protected boolean useNativeContext() {
            return PythonContext.get(this).getNFILZMASupport().isAvailable();
        }

        @Specialization(guards={"useNativeContext()"})
        void decodeNative(VirtualFrame frame, long id, byte[] encoded, PDict dict, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction decodeFilter, @Cached HashingStorageNodes.HashingStorageSetItem setItem, @Cached InlinedConditionProfile errProfile) {
            Object filter;
            PythonContext ctxt = PythonContext.get(this);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            long[] opts = new long[10];
            int len = encoded.length;
            Object encodedProps = ctxt.getEnv().asGuestValue((Object)encoded);
            int lzret = lzmaSupport.decodeFilter(id, encodedProps, len, filter = ctxt.getEnv().asGuestValue((Object)opts), decodeFilter);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                if (lzret == 98) {
                    throw this.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_FILTER, opts[LZMAOption.id.ordinal()]);
                }
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
            this.buildFilterSpec(frame, inliningTarget, opts, dict, setItem);
        }

        @Specialization(guards={"!useNativeContext()"})
        void decodeJava(long id, byte[] encoded, PDict dict) {
            throw this.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }

        void buildFilterSpec(VirtualFrame frame, Node inliningTarget, long[] opts, PDict dict, HashingStorageNodes.HashingStorageSetItem setItem) {
            long id = opts[LZMAOption.id.ordinal()];
            this.addField(frame, inliningTarget, setItem, dict, LZMAOption.id.OptName(), id);
            switch (LZMAFilter.from(id)) {
                case LZMA_FILTER_LZMA1: {
                    this.addField(frame, inliningTarget, setItem, dict, LZMAOption.lc.OptName(), opts[LZMAOption.lc.ordinal()]);
                    this.addField(frame, inliningTarget, setItem, dict, LZMAOption.lp.OptName(), opts[LZMAOption.lp.ordinal()]);
                    this.addField(frame, inliningTarget, setItem, dict, LZMAOption.pb.OptName(), opts[LZMAOption.pb.ordinal()]);
                    this.addField(frame, inliningTarget, setItem, dict, LZMAOption.dict_size.OptName(), opts[LZMAOption.dict_size.ordinal()]);
                    break;
                }
                case LZMA_FILTER_LZMA2: {
                    this.addField(frame, inliningTarget, setItem, dict, LZMAOption.dict_size.OptName(), opts[LZMAOption.dict_size.ordinal()]);
                    break;
                }
                case LZMA_FILTER_DELTA: {
                    this.addField(frame, inliningTarget, setItem, dict, DeltaOption.dist.OptName(), opts[DeltaOption.dist.ordinal()]);
                    break;
                }
                case LZMA_FILTER_X86: 
                case LZMA_FILTER_POWERPC: 
                case LZMA_FILTER_IA64: 
                case LZMA_FILTER_ARM: 
                case LZMA_FILTER_ARMTHUMB: 
                case LZMA_FILTER_SPARC: {
                    this.addField(frame, inliningTarget, setItem, dict, BCJOption.start_offset.OptName(), opts[BCJOption.start_offset.ordinal()]);
                }
            }
        }

        void addField(VirtualFrame frame, Node inliningTarget, HashingStorageNodes.HashingStorageSetItem setItem, PDict dict, TruffleString key, long val) {
            dict.setDictStorage(setItem.execute((Frame)frame, inliningTarget, dict.getDictStorage(), key, val));
        }
    }

    public static abstract class EncodeFilterProperties
    extends PNodeWithRaise {
        public abstract byte[] execute(VirtualFrame var1, Object var2);

        @NonIdempotent
        protected boolean useNativeContext() {
            return PythonContext.get(this).getNFILZMASupport().isAvailable();
        }

        @Specialization(guards={"useNativeContext()"})
        byte[] encodeNative(VirtualFrame frame, Object filter, @Bind(value="this") Node inliningTarget, @Cached LZMAFilterConverter filterConverter, @Cached GetOutputNativeBufferNode getBuffer, @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached NativeLibrary.InvokeNativeFunction encodeFilter, @Cached NativeLibrary.InvokeNativeFunction deallocateStream, @Cached InlinedConditionProfile errProfile) {
            PythonContext ctxt = PythonContext.get(this);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            long[] opts = filterConverter.execute(frame, filter);
            int lzret = lzmaSupport.encodeFilter(lzmast, ctxt.getEnv().asGuestValue((Object)opts), encodeFilter);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                lzmaSupport.deallocateStream(lzmast, deallocateStream);
                if (lzret == 99) {
                    throw this.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_COMPRESSION_PRESET, opts[LZMAOption.preset.ordinal()]);
                }
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
            byte[] encoded = getBuffer.execute(lzmast, ctxt);
            lzmaSupport.deallocateStream(lzmast, deallocateStream);
            return encoded;
        }

        @Specialization(guards={"!useNativeContext()"})
        byte[] encodeJava(Object filter) {
            throw this.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }
    }

    public static abstract class IsCheckSupported
    extends PNodeWithRaise {
        public abstract boolean execute(int var1);

        @NonIdempotent
        protected boolean useNativeContext() {
            return PythonContext.get(this).getNFILZMASupport().isAvailable();
        }

        @Specialization(guards={"useNativeContext()"})
        boolean checkNative(int checkId, @Cached NativeLibrary.InvokeNativeFunction checkIsSupported) {
            return PythonContext.get(this).getNFILZMASupport().checkIsSupported(checkId, checkIsSupported) == 1;
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization(guards={"!useNativeContext()"})
        boolean checkJava(int checkId) {
            try {
                Check.getInstance((int)checkId);
                return true;
            }
            catch (UnsupportedOptionsException e) {
                return false;
            }
        }
    }

    public static abstract class GetOutputNativeBufferNode
    extends PNodeWithRaise {
        public abstract byte[] execute(Object var1, PythonContext var2);

        @Specialization
        byte[] getBuffer(Object lzmast, PythonContext context, @Cached NativeLibrary.InvokeNativeFunction getBufferSize, @Cached NativeLibrary.InvokeNativeFunction getBuffer) {
            int size;
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            try {
                size = PInt.intValueExact(lzmaSupport.getOutputBufferSize(lzmast, getBufferSize));
            }
            catch (OverflowException of) {
                throw this.raise(PythonBuiltinClassType.SystemError, ErrorMessages.VALUE_TOO_LARGE_TO_FIT_INTO_INDEX);
            }
            if (size == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            byte[] resultArray = new byte[size];
            Object out = context.getEnv().asGuestValue((Object)resultArray);
            lzmaSupport.getOutputBuffer(lzmast, out, getBuffer);
            return resultArray;
        }
    }

    @GenerateCached(value=false)
    @GenerateInline
    public static abstract class InternalDecompressNode
    extends PNodeWithContext {
        public abstract byte[] execute(Node var1, LZMAObject.LZMADecompressor var2, int var3);

        @Specialization
        static byte[] nativeInternalDecompress(Node inliningTarget, LZMAObject.LZMADecompressor.Native self, int maxLength, @Cached(inline=false) NativeLibrary.InvokeNativeFunction decompress, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getLzsAvailIn, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getLzsAvailOut, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getNextInIndex, @Cached(inline=false) NativeLibrary.InvokeNativeFunction getLzsCheck, @Cached(inline=false) GetOutputNativeBufferNode getBuffer, @Cached.Exclusive @Cached PRaiseNode.Lazy lazyRaiseNode, @Cached InlinedConditionProfile errProfile) {
            PythonContext context = PythonContext.get(inliningTarget);
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object inGuest = context.getEnv().asGuestValue((Object)self.getNextIn());
            int offset = self.getNextInIndex();
            int err = lzmaSupport.decompress(self.getLzs(), inGuest, offset, maxLength, 8192L, self.getLzsAvailIn(), decompress);
            long nextInIdx = lzmaSupport.getNextInIndex(self.getLzs(), getNextInIndex);
            long lzsAvailIn = lzmaSupport.getLzsAvailIn(self.getLzs(), getLzsAvailIn);
            long lzsAvailOut = lzmaSupport.getLzsAvailOut(self.getLzs(), getLzsAvailOut);
            self.setCheck(lzmaSupport.getLzsCheck(self.getLzs(), getLzsCheck));
            try {
                self.setNextInIndex(nextInIdx);
                self.setLzsAvailIn(lzsAvailIn);
                self.setLzsAvailOut(lzsAvailOut);
            }
            catch (OverflowException of) {
                throw lazyRaiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.VALUE_TOO_LARGE_TO_FIT_INTO_INDEX);
            }
            if (err == 1) {
                self.setEOF();
            } else if (errProfile.profile(inliningTarget, err != 0)) {
                LZMANodes.errorHandling(err, lazyRaiseNode.get(inliningTarget));
            }
            return getBuffer.execute(self.getLzs(), context);
        }

        @CompilerDirectives.TruffleBoundary
        @Specialization
        static byte[] javaInternalDecompress(Node inliningTarget, LZMAObject.LZMADecompressor.Java self, int maxLength, @Cached.Exclusive @Cached PRaiseNode.Lazy lazyRaiseNode) {
            if (maxLength == 0) {
                return PythonUtils.EMPTY_BYTE_ARRAY;
            }
            self.setInput();
            int maxLen = maxLength == -1 ? Integer.MAX_VALUE : maxLength;
            byte[] result = new byte[Math.min(maxLen, 8192)];
            ByteArrayOutputStream baos = BytesUtils.createOutputStream(result.length);
            int dataSize = -1;
            boolean isInitialized = self.isInitialized();
            try {
                while (true) {
                    try {
                        if (!isInitialized) {
                            self.initialize();
                        }
                        InternalDecompressNode.doDecompression(self, baos, result, maxLen);
                    }
                    catch (IOException ioe) {
                        isInitialized = true;
                        if (self.isFormatAuto()) {
                            if (dataSize != baos.size()) {
                                dataSize = baos.size();
                                self.switchStream();
                                continue;
                            }
                            break;
                        }
                        throw ioe;
                    }
                    break;
                }
            }
            catch (UnsupportedOptionsException o) {
                LZMANodes.errorHandling(8, lazyRaiseNode.get(inliningTarget));
            }
            catch (CorruptedInputException c) {
                if (self.isFormatAuto() && baos.size() > 0) {
                    self.setEOF();
                } else {
                    LZMANodes.errorHandling(9, lazyRaiseNode.get(inliningTarget));
                }
            }
            catch (MemoryLimitException m) {
                LZMANodes.errorHandling(6, lazyRaiseNode.get(inliningTarget));
            }
            catch (XZFormatException f) {
                LZMANodes.errorHandling(7, lazyRaiseNode.get(inliningTarget));
            }
            catch (EOFException eof) {
                self.setEOF();
            }
            catch (IOException e) {
                PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.OSError, e);
            }
            byte[] ret = BytesUtils.toByteArray(baos);
            self.decompressedData(ret.length);
            self.update(maxLen - ret.length);
            return ret;
        }

        @CompilerDirectives.TruffleBoundary
        private static void doDecompression(LZMAObject.LZMADecompressor.Java self, ByteArrayOutputStream baos, byte[] result, int maxLen) throws IOException {
            while (baos.size() < maxLen) {
                int read;
                try {
                    read = self.read(result);
                }
                catch (EOFException eof) {
                    if (!self.sameData()) break;
                    self.setEOF();
                    break;
                }
                if (read == -1) {
                    self.setEOF();
                    break;
                }
                BytesUtils.append(baos, result, 0, read);
            }
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class DecompressNode
    extends Node {
        public abstract byte[] execute(Node var1, LZMAObject.LZMADecompressor var2, byte[] var3, int var4, int var5);

        @Specialization
        static byte[] nativeDecompress(Node inliningTarget, LZMAObject.LZMADecompressor self, byte[] bytes, int len, int maxLength, @Cached InternalDecompressNode decompress) {
            boolean inputBufferInUse;
            if (self.getNextIn() != null) {
                int availNow = self.getInputBufferSize() - (self.getNextInIndex() + self.getLzsAvailIn());
                int availTotal = self.getInputBufferSize() - self.getLzsAvailIn();
                if (availTotal < len) {
                    int newSize = self.getInputBufferSize() + len - availNow;
                    self.resizeInputBuffer(newSize);
                    self.setNextIn(self.getInputBuffer());
                } else if (availNow < len) {
                    PythonUtils.arraycopy(self.getNextIn(), self.getNextInIndex(), self.getInputBuffer(), 0, self.getLzsAvailIn());
                    self.setNextIn(self.getInputBuffer());
                    self.setNextInIndex(0);
                }
                PythonUtils.arraycopy(bytes, 0, self.getNextIn(), self.getNextInIndex() + self.getLzsAvailIn(), len);
                self.incLzsAvailIn(len);
                inputBufferInUse = true;
            } else {
                self.setNextIn(bytes);
                self.setLzsAvailIn(len);
                inputBufferInUse = false;
            }
            byte[] result = decompress.execute(inliningTarget, self, maxLength);
            if (self.isEOF()) {
                self.setNeedsInput(false);
                if (self.getLzsAvailIn() > 0) {
                    self.setUnusedData();
                }
            } else if (self.getLzsAvailIn() == 0) {
                self.clearNextIn();
                self.setNextInIndex(0);
                self.setNeedsInput(self.getLzsAvailOut() != 0);
            } else {
                self.setNeedsInput(false);
                if (!inputBufferInUse) {
                    if (self.getInputBuffer() != null && self.getInputBufferSize() < self.getLzsAvailIn()) {
                        self.discardInputBuffer();
                    }
                    if (self.getInputBuffer() == null) {
                        self.createInputBuffer(self.getLzsAvailIn());
                    }
                    PythonUtils.arraycopy(self.getNextIn(), self.getNextInIndex(), self.getInputBuffer(), 0, self.getLzsAvailIn());
                    self.setNextIn(self.getInputBuffer());
                    self.setNextInIndex(0);
                }
            }
            return result;
        }
    }

    @ImportStatic(value={LZMAModuleBuiltins.class})
    public static abstract class LZMARawDecompressInit
    extends PNodeWithRaise {
        public abstract void execute(VirtualFrame var1, LZMAObject.LZMADecompressor var2, Object var3);

        @Specialization
        void rawJava(VirtualFrame frame, LZMAObject.LZMADecompressor.Java self, Object filters) {
            throw this.raise(PythonBuiltinClassType.SystemError, LZMAModuleBuiltins.T_LZMA_JAVA_ERROR);
        }

        @Specialization
        void rawNative(VirtualFrame frame, LZMAObject.LZMADecompressor.Native self, Object filters, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached NativeLibrary.InvokeNativeFunction lzmaRawDecoder, @Cached NativeFilterChain filterChain, @Cached InlinedConditionProfile errProfile) {
            PythonContext context = PythonContext.get(this);
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, context, filters);
            int lzret = lzmaSupport.lzmaRawDecoder(lzmast, lzmaRawDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }
    }

    @ImportStatic(value={LZMAModuleBuiltins.class})
    public static abstract class LZMADecompressInit
    extends PNodeWithRaise {
        public abstract void execute(VirtualFrame var1, LZMAObject.LZMADecompressor var2, int var3, Object var4);

        @Specialization
        void init(LZMAObject.LZMADecompressor.Java self, int format, int memlimit) {
        }

        @Specialization(guards={"format == FORMAT_AUTO"})
        void auto(LZMAObject.LZMADecompressor.Native self, int format, int memlimit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAutoDecoder, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            NFILZMASupport lzmaSupport = PythonContext.get(this).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int decoderFlags = 5;
            int lzret = lzmaSupport.lzmaAutoDecoder(lzmast, memlimit, decoderFlags, lzmaAutoDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_XZ"})
        void xz(LZMAObject.LZMADecompressor.Native self, int format, int memlimit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaStreamDecoder, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            NFILZMASupport lzmaSupport = PythonContext.get(this).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int decoderFlags = 5;
            int lzret = lzmaSupport.lzmaStreamDecoder(lzmast, memlimit, decoderFlags, lzmaStreamDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        void alone(LZMAObject.LZMADecompressor.Native self, int format, int memlimit, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAloneDecoder, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            NFILZMASupport lzmaSupport = PythonContext.get(this).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int lzret = lzmaSupport.lzmaAloneDecoder(lzmast, memlimit, lzmaAloneDecoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }
    }

    @ImportStatic(value={LZMANodes.class})
    public static abstract class CompressNode
    extends PNodeWithRaise {
        public abstract byte[] execute(LZMAObject.LZMACompressor var1, PythonContext var2, byte[] var3, int var4, int var5);

        public byte[] compress(LZMAObject.LZMACompressor self, PythonContext context, byte[] bytes, int len) {
            return this.execute(self, context, bytes, len, 0);
        }

        public byte[] flush(LZMAObject.LZMACompressor self, PythonContext context) {
            return this.execute(self, context, PythonUtils.EMPTY_BYTE_ARRAY, 0, 3);
        }

        @Specialization
        byte[] nativeCompress(LZMAObject.LZMACompressor.Native self, PythonContext context, byte[] bytes, int len, int action, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction compress, @Cached GetOutputNativeBufferNode getBuffer, @Cached InlinedConditionProfile errProfile) {
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object inGuest = context.getEnv().asGuestValue((Object)bytes);
            int err = lzmaSupport.compress(self.getLzs(), inGuest, len, action, 8192L, compress);
            if (errProfile.profile(inliningTarget, err != 0)) {
                LZMANodes.errorHandling(err, this.getRaiseNode());
            }
            return getBuffer.execute(self.getLzs(), context);
        }

        @Specialization(guards={"action == LZMA_RUN"})
        byte[] javaCompress(LZMAObject.LZMACompressor.Java self, PythonContext context, byte[] bytes, int len, int action) {
            try {
                self.write(bytes);
                byte[] result = self.getByteArray();
                self.resetBuffer();
                return result;
            }
            catch (IOException e) {
                throw this.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"action == LZMA_FINISH"})
        byte[] javaFlush(LZMAObject.LZMACompressor.Java self, PythonContext context, byte[] bytes, int len, int action) {
            try {
                self.finish();
                return self.getByteArray();
            }
            catch (IOException e) {
                throw this.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.M, e);
            }
        }
    }

    @ImportStatic(value={LZMAModuleBuiltins.class})
    public static abstract class LZMACompressInit
    extends PNodeWithRaise {
        public abstract void execute(VirtualFrame var1, LZMAObject.LZMACompressor var2, int var3, long var4, Object var6);

        @Specialization(guards={"format == FORMAT_XZ"})
        void xz(LZMAObject.LZMACompressor.Native self, int format, long preset, PNone filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaEasyEncoder, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            NFILZMASupport lzmaSupport = PythonContext.get(this).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int lzret = lzmaSupport.lzmaEasyEncoder(lzmast, preset, self.getCheck(), lzmaEasyEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_XZ"})
        void xz(VirtualFrame frame, LZMAObject.LZMACompressor.Native self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaStreamEncoder, @Cached.Exclusive @Cached NativeFilterChain filterChain, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            PythonContext ctxt = PythonContext.get(this);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, ctxt, filters);
            int lzret = lzmaSupport.lzmaStreamEncoder(lzmast, self.getCheck(), lzmaStreamEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        void alone(LZMAObject.LZMACompressor.Native self, int format, long preset, PNone filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAloneEncoderPreset, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            NFILZMASupport lzmaSupport = PythonContext.get(this).getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            int lzret = lzmaSupport.lzmaAloneEncoderPreset(lzmast, preset, lzmaAloneEncoderPreset);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        void alone(VirtualFrame frame, LZMAObject.LZMACompressor.Native self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaAloneEncoder, @Cached.Exclusive @Cached NativeFilterChain filterChain, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            PythonContext ctxt = PythonContext.get(this);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, ctxt, filters);
            int lzret = lzmaSupport.lzmaAloneEncoder(lzmast, lzmaAloneEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_RAW"})
        void raw(VirtualFrame frame, LZMAObject.LZMACompressor.Native self, int format, long preset, Object filters, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="cs") @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached.Exclusive @Cached NativeLibrary.InvokeNativeFunction lzmaRawEncoder, @Cached.Exclusive @Cached NativeFilterChain filterChain, @Cached.Shared @Cached InlinedConditionProfile errProfile) {
            PythonContext ctxt = PythonContext.get(this);
            NFILZMASupport lzmaSupport = ctxt.getNFILZMASupport();
            Object lzmast = lzmaSupport.createStream(createStream);
            self.init(lzmast, lzmaSupport);
            filterChain.execute(frame, lzmast, ctxt, filters);
            int lzret = lzmaSupport.lzmaRawEncoder(lzmast, lzmaRawEncoder);
            if (errProfile.profile(inliningTarget, lzret != 0)) {
                LZMANodes.errorHandling(lzret, this.getRaiseNode());
            }
        }

        @Specialization(guards={"format == FORMAT_XZ"})
        void xz(LZMAObject.LZMACompressor.Java self, int format, long preset, PNone filters) {
            try {
                self.lzmaEasyEncoder(LZMANodes.parseLZMAOptions(preset));
            }
            catch (IOException e) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_XZ"})
        void xz(VirtualFrame frame, LZMAObject.LZMACompressor.Java self, int format, long preset, Object filters, @Cached.Exclusive @Cached JavaFilterChain filterChain) {
            try {
                self.lzmaStreamEncoder(filterChain.execute(frame, filters));
            }
            catch (IOException e) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        void alone(LZMAObject.LZMACompressor.Java self, int format, long preset, PNone filters) {
            try {
                self.lzmaAloneEncoder(LZMANodes.parseLZMAOptions(preset));
            }
            catch (IOException e) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_ALONE"})
        void alone(VirtualFrame frame, LZMAObject.LZMACompressor.Java self, int format, long preset, Object filters, @Cached.Exclusive @Cached JavaFilterChain filterChain) {
            FilterOptions[] optionsChain = filterChain.execute(frame, filters);
            if (optionsChain.length != 1 && !(optionsChain[0] instanceof LZMA2Options)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER_CHAIN_FOR_FORMAT);
            }
            try {
                self.lzmaAloneEncoder((LZMA2Options)optionsChain[0]);
            }
            catch (IOException e) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Specialization(guards={"format == FORMAT_RAW"})
        void raw(VirtualFrame frame, LZMAObject.LZMACompressor.Java self, int format, long preset, Object filters, @Cached.Exclusive @Cached JavaFilterChain filterChain) {
            FilterOptions[] optionsChain = filterChain.execute(frame, filters);
            if (optionsChain.length != 1 && !(optionsChain[0] instanceof LZMA2Options)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER_CHAIN_FOR_FORMAT);
            }
            try {
                self.lzmaRawEncoder(optionsChain);
            }
            catch (IOException e) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, e);
            }
        }

        @Fallback
        void error(VirtualFrame frame, LZMAObject.LZMACompressor self, int format, long preset, Object filters) {
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_CONTAINER_FORMAT, format);
        }
    }

    protected static abstract class JavaFilterChain
    extends PNodeWithRaise {
        protected JavaFilterChain() {
        }

        public abstract FilterOptions[] execute(VirtualFrame var1, Object var2);

        @Specialization
        FilterOptions[] parseFilterChainSpec(VirtualFrame frame, Object filterSpecs, @Cached LZMAParseFilterChain parseFilterChain) {
            long[][] filters = parseFilterChain.execute(frame, filterSpecs);
            FilterOptions[] optionsChain = new FilterOptions[filters.length];
            for (int i = 0; i < filters.length; ++i) {
                try {
                    optionsChain[i] = this.getFilterOptions(filters[i]);
                    continue;
                }
                catch (UnsupportedOptionsException e) {
                    throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.M, new Object[]{e});
                }
            }
            return optionsChain;
        }

        @CompilerDirectives.TruffleBoundary
        private static String getMessage(UnsupportedOptionsException e) {
            return e.getMessage();
        }

        @CompilerDirectives.TruffleBoundary
        private FilterOptions getFilterOptions(long[] longFilter) throws UnsupportedOptionsException {
            int[] filter = new int[longFilter.length];
            for (int i = 0; i < longFilter.length; ++i) {
                filter[i] = (int)longFilter[i];
            }
            switch (LZMAFilter.from(longFilter[0])) {
                case LZMA_FILTER_LZMA1: 
                case LZMA_FILTER_LZMA2: {
                    LZMA2Options lzma2Options;
                    try {
                        lzma2Options = new LZMA2Options(filter[1]);
                    }
                    catch (UnsupportedOptionsException e) {
                        throw this.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_COMPRESSION_PRESET, filter[LZMAOption.preset.ordinal()]);
                    }
                    for (int j = 2; j < filter.length; ++j) {
                        JavaFilterChain.setLZMAOption(lzma2Options, j, filter[j]);
                    }
                    return lzma2Options;
                }
                case LZMA_FILTER_DELTA: {
                    DeltaOptions deltaOptions = filter[DeltaOption.dist.ordinal()] != -1 ? new DeltaOptions(filter[DeltaOption.dist.ordinal()]) : new DeltaOptions();
                    return deltaOptions;
                }
                case LZMA_FILTER_X86: {
                    X86Options x86Options = new X86Options();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        x86Options.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return x86Options;
                }
                case LZMA_FILTER_POWERPC: {
                    PowerPCOptions powerPCOptions = new PowerPCOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        powerPCOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return powerPCOptions;
                }
                case LZMA_FILTER_IA64: {
                    IA64Options ia64Options = new IA64Options();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        ia64Options.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return ia64Options;
                }
                case LZMA_FILTER_ARM: {
                    ARMOptions armOptions = new ARMOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        armOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return armOptions;
                }
                case LZMA_FILTER_ARMTHUMB: {
                    ARMThumbOptions armThumbOptions = new ARMThumbOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        armThumbOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return armThumbOptions;
                }
                case LZMA_FILTER_SPARC: {
                    SPARCOptions sparcOptions = new SPARCOptions();
                    if (filter[BCJOption.start_offset.ordinal()] != -1) {
                        sparcOptions.setStartOffset(filter[BCJOption.start_offset.ordinal()]);
                    }
                    return sparcOptions;
                }
            }
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER, longFilter[0]);
        }

        @CompilerDirectives.TruffleBoundary
        private static void setLZMAOption(LZMA2Options lzma2Options, int idx, int value) throws UnsupportedOptionsException {
            if (value == -1) {
                return;
            }
            switch (LZMAOption.values()[idx]) {
                case dict_size: {
                    lzma2Options.setDictSize(value);
                    break;
                }
                case lc: {
                    lzma2Options.setLc(value);
                    break;
                }
                case lp: {
                    lzma2Options.setLp(value);
                    break;
                }
                case pb: {
                    lzma2Options.setPb(value);
                    break;
                }
                case mode: {
                    lzma2Options.setMode(value);
                    break;
                }
                case nice_len: {
                    lzma2Options.setNiceLen(value);
                    break;
                }
                case mf: {
                    lzma2Options.setMatchFinder(value);
                    break;
                }
                case depth: {
                    lzma2Options.setDepthLimit(value);
                }
            }
        }
    }

    protected static abstract class NativeFilterChain
    extends PNodeWithRaise {
        protected NativeFilterChain() {
        }

        public abstract void execute(VirtualFrame var1, Object var2, PythonContext var3, Object var4);

        @Specialization
        void parseFilterChainSpec(VirtualFrame frame, Object lzmast, PythonContext context, Object filterSpecs, @Cached NativeLibrary.InvokeNativeFunction setFilterSpecLZMA, @Cached NativeLibrary.InvokeNativeFunction setFilterSpecDelta, @Cached NativeLibrary.InvokeNativeFunction setFilterSpecBCJ, @Cached LZMAParseFilterChain parseFilterChain) {
            long[][] filters = parseFilterChain.execute(frame, filterSpecs);
            for (int i = 0; i < filters.length; ++i) {
                this.setFilterOptions(lzmast, filters[i], i, context, setFilterSpecLZMA, setFilterSpecDelta, setFilterSpecBCJ);
            }
        }

        private void setFilterOptions(Object lzmast, long[] filter, int fidx, PythonContext context, NativeLibrary.InvokeNativeFunction setFilterSpecLZMA, NativeLibrary.InvokeNativeFunction setFilterSpecDelta, NativeLibrary.InvokeNativeFunction setFilterSpecBCJ) {
            NFILZMASupport lzmaSupport = context.getNFILZMASupport();
            Object opts = context.getEnv().asGuestValue((Object)filter);
            long id = filter[0];
            switch (LZMAFilter.from(id)) {
                case LZMA_FILTER_LZMA1: 
                case LZMA_FILTER_LZMA2: {
                    assert (filter.length == 10);
                    int err = lzmaSupport.setFilterSpecLZMA(lzmast, fidx, opts, setFilterSpecLZMA);
                    if (err != 0) {
                        if (err == 99) {
                            throw this.raise(PythonBuiltinClassType.LZMAError, ErrorMessages.INVALID_COMPRESSION_PRESET, filter[LZMAOption.preset.ordinal()]);
                        }
                        LZMANodes.errorHandling(err, this.getRaiseNode());
                    }
                    return;
                }
                case LZMA_FILTER_DELTA: {
                    assert (filter.length == 2);
                    int err = lzmaSupport.setFilterSpecDelta(lzmast, fidx, opts, setFilterSpecDelta);
                    if (err != 0) {
                        LZMANodes.errorHandling(err, this.getRaiseNode());
                    }
                    return;
                }
                case LZMA_FILTER_X86: 
                case LZMA_FILTER_POWERPC: 
                case LZMA_FILTER_IA64: 
                case LZMA_FILTER_ARM: 
                case LZMA_FILTER_ARMTHUMB: 
                case LZMA_FILTER_SPARC: {
                    assert (filter.length == 2);
                    int err = lzmaSupport.setFilterSpecBCJ(lzmast, fidx, opts, setFilterSpecBCJ);
                    if (err != 0) {
                        LZMANodes.errorHandling(err, this.getRaiseNode());
                    }
                    return;
                }
            }
            throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER, id);
        }
    }

    public static abstract class LZMAParseFilterChain
    extends PNodeWithRaise {
        public abstract long[][] execute(VirtualFrame var1, Object var2);

        @Specialization
        long[][] parseFilter(VirtualFrame frame, Object filterSpecs, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItemNode, @Cached LZMAFilterConverter converter, @Cached SequenceNodes.CheckIsSequenceNode checkIsSequenceNode, @Cached PyObjectSizeNode sizeNode) {
            checkIsSequenceNode.execute(filterSpecs);
            int numFilters = sizeNode.execute((Frame)frame, inliningTarget, filterSpecs);
            if (numFilters > 4) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.TOO_MAMNY_FILTERS_LZMA_SUPPORTS_MAX_S, 4);
            }
            long[][] filters = new long[numFilters][0];
            for (int i = 0; i < numFilters; ++i) {
                filters[i] = converter.execute(frame, getItemNode.execute((Frame)frame, inliningTarget, filterSpecs, i));
            }
            return filters;
        }
    }

    public static abstract class LZMAFilterConverter
    extends PNodeWithRaise {
        public abstract long[] execute(VirtualFrame var1, Object var2);

        @Specialization
        long[] converter(VirtualFrame frame, Object spec, @Bind(value="this") Node inliningTarget, @Cached ForEachOption getOptions, @Cached CastToJavaLongLossyNode toLong, @Cached GetOptionsDict getOptionsDict, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached HashingStorageNodes.HashingStorageForEach forEachNode) {
            long[] options;
            HashingStorage dict = getOptionsDict.execute(frame, spec);
            Object idObj = getItem.execute(inliningTarget, dict, StringLiterals.T_ID);
            long id = toLong.execute(inliningTarget, idObj);
            OptionsState state = switch (LZMAFilter.from(id)) {
                case LZMAFilter.LZMA_FILTER_LZMA1, LZMAFilter.LZMA_FILTER_LZMA2 -> {
                    options = new long[LZMAOption.values().length];
                    Arrays.fill(options, -1L);
                    options[LZMAOption.preset.ordinal()] = LZMAModuleBuiltins.PRESET_DEFAULT;
                    yield new OptionsState("LZMA", LZMAOption.values(), options, dict);
                }
                case LZMAFilter.LZMA_FILTER_DELTA -> {
                    options = new long[DeltaOption.values().length];
                    Arrays.fill(options, -1L);
                    yield new OptionsState("delta", DeltaOption.values(), options, dict);
                }
                case LZMAFilter.LZMA_FILTER_X86, LZMAFilter.LZMA_FILTER_POWERPC, LZMAFilter.LZMA_FILTER_IA64, LZMAFilter.LZMA_FILTER_ARM, LZMAFilter.LZMA_FILTER_ARMTHUMB, LZMAFilter.LZMA_FILTER_SPARC -> {
                    options = new long[BCJOption.values().length];
                    Arrays.fill(options, -1L);
                    yield new OptionsState("BCJ", BCJOption.values(), options, dict);
                }
                default -> throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER, id);
            };
            options[0] = id;
            forEachNode.execute((Frame)frame, inliningTarget, dict, getOptions, state);
            return options;
        }
    }

    static enum BCJOption implements Option
    {
        id("id"),
        start_offset("start_offset");

        private final TruffleString optname;

        private BCJOption(String name) {
            this.optname = PythonUtils.tsLiteral(name);
        }

        @Override
        public TruffleString OptName() {
            return this.optname;
        }
    }

    static enum DeltaOption implements Option
    {
        id("id"),
        dist("dist");

        private final TruffleString optname;

        private DeltaOption(String name) {
            this.optname = PythonUtils.tsLiteral(name);
        }

        @Override
        public TruffleString OptName() {
            return this.optname;
        }
    }

    static enum LZMAOption implements Option
    {
        id("id"),
        preset("preset"),
        dict_size("dict_size"),
        lc("lc"),
        lp("lp"),
        pb("pb"),
        mode("mode"),
        nice_len("nice_len"),
        mf("mf"),
        depth("depth");

        private final TruffleString optname;

        private LZMAOption(String name) {
            this.optname = PythonUtils.tsLiteral(name);
        }

        @Override
        public TruffleString OptName() {
            return this.optname;
        }
    }

    static enum LZMAFilter {
        LZMA_FILTER_LZMA1,
        LZMA_FILTER_LZMA2,
        LZMA_FILTER_DELTA,
        LZMA_FILTER_X86,
        LZMA_FILTER_POWERPC,
        LZMA_FILTER_IA64,
        LZMA_FILTER_ARM,
        LZMA_FILTER_ARMTHUMB,
        LZMA_FILTER_SPARC,
        UNKNOWN;


        public long v() {
            return LZMAModuleBuiltins.FILTERS[this.ordinal()];
        }

        @ExplodeLoop
        public static LZMAFilter from(long v) {
            for (int i = 0; i < LZMAModuleBuiltins.FILTERS.length; ++i) {
                if (LZMAModuleBuiltins.FILTERS[i] != v) continue;
                return LZMAFilter.values()[i];
            }
            return UNKNOWN;
        }
    }

    static interface Option {
        public TruffleString OptName();

        public int ordinal();
    }

    @GenerateInline
    @GenerateCached(value=false)
    protected static abstract class ForEachOption
    extends HashingStorageNodes.HashingStorageForEachCallback<OptionsState> {
        protected ForEachOption() {
        }

        private static int getOptionIndex(TruffleString key, OptionsState s, TruffleString.EqualNode equalNode) {
            for (int i = 0; i < s.optnames.length; ++i) {
                if (!equalNode.execute((AbstractTruffleString)key, (AbstractTruffleString)s.optnames[i].OptName(), PythonUtils.TS_ENCODING)) continue;
                return i;
            }
            return -1;
        }

        @Override
        public abstract OptionsState execute(Frame var1, Node var2, HashingStorage var3, HashingStorageNodes.HashingStorageIterator var4, OptionsState var5);

        @Specialization
        static OptionsState doit(Frame frame, Node inliningTarget, HashingStorage storage, HashingStorageNodes.HashingStorageIterator it, OptionsState s, @Cached HashingStorageNodes.HashingStorageIteratorKey itKey, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached CastToJavaLongLossyNode toLong, @Cached InlinedConditionProfile errProfile, @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached PRaiseNode.Lazy raise, @Cached(inline=false) TruffleString.EqualNode equalNode) {
            Object key = itKey.execute(inliningTarget, storage, it);
            TruffleString skey = strNode.execute(frame, inliningTarget, key);
            int idx = ForEachOption.getOptionIndex(skey, s, equalNode);
            if (errProfile.profile(inliningTarget, idx == -1)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_FILTER_SPECIFIED_FOR_FILTER, s.filterType);
            }
            long l = toLong.execute(inliningTarget, getItem.execute(inliningTarget, s.dictStorage, skey));
            if (errProfile.profile(inliningTarget, l < 0L)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANT_CONVERT_NEG_INT_TO_UNSIGNED);
            }
            if (errProfile.profile(inliningTarget, l > 0x100000000L && idx > 0)) {
                throw raise.get(inliningTarget).raise(PythonBuiltinClassType.OverflowError, ErrorMessages.VALUE_TOO_LARGE_FOR_UINT32);
            }
            s.options[idx] = l;
            return s;
        }
    }

    @ImportStatic(value={PGuards.class})
    public static abstract class GetOptionsDict
    extends PNodeWithRaise {
        public abstract HashingStorage execute(VirtualFrame var1, Object var2);

        @Specialization
        HashingStorage fast(VirtualFrame frame, PDict dict, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
            HashingStorage storage = dict.getDictStorage();
            if (!getItem.hasKey((Frame)frame, inliningTarget, storage, StringLiterals.T_ID)) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.FILTER_SPECIFIER_MUST_HAVE);
            }
            return storage;
        }

        @Specialization(guards={"!isDict(object)"})
        HashingStorage slow(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getItem") @Cached HashingStorageNodes.HashingStorageGetItem getItem, @Cached GetDictIfExistsNode getDict) {
            PDict dict = getDict.execute(object);
            if (dict == null) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.FILTER_SPEC_MUST_BE_DICT);
            }
            return this.fast(frame, dict, inliningTarget, getItem);
        }
    }

    @ImportStatic(value={LZMANodes.class})
    public static abstract class ToUINT32Option
    extends PNodeWithRaise {
        private final boolean with32BitLimit;

        public ToUINT32Option(boolean with32BitLimit) {
            this.with32BitLimit = with32BitLimit;
        }

        public abstract long execute(Object var1);

        @Specialization(guards={"i >= 0"})
        long i(int i) {
            return i;
        }

        @Specialization(guards={"l >= 0", "l <= MAX_UINT32"})
        long l(long l) {
            return l;
        }

        @Specialization
        long ll(long l) {
            if (l < 0L) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.CANT_CONVERT_NEG_INT_TO_UNSIGNED);
            }
            if (l > 0x100000000L && this.with32BitLimit) {
                throw this.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.VALUE_TOO_LARGE_FOR_UINT32);
            }
            return l;
        }

        @Specialization
        long o(Object o, @Bind(value="this") Node inliningTarget, @Cached CastToJavaLongExactNode cast) {
            try {
                return this.ll(cast.execute(inliningTarget, o));
            }
            catch (CannotCastException e) {
                throw this.raise(PythonErrorType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
        }

        @NeverDefault
        public static ToUINT32Option create(boolean with32BitLimit) {
            return LZMANodesFactory.ToUINT32OptionNodeGen.create(with32BitLimit);
        }

        @NeverDefault
        public static ToUINT32Option create() {
            return ToUINT32Option.create(true);
        }
    }

    protected static class OptionsState {
        private final String filterType;
        private final Option[] optnames;
        private final long[] options;
        public final HashingStorage dictStorage;

        public OptionsState(String filterType, Option[] optnames, long[] options, HashingStorage dictStorage) {
            this.filterType = filterType;
            this.optnames = optnames;
            this.options = options;
            this.dictStorage = dictStorage;
        }
    }
}

