/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.interop.ArityException;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.nodes.Node;

public abstract class ManagedMethodWrappers {
    public static MethodWrapper createKeywords(Object method) {
        return new MethKeywords(method);
    }

    public static MethodWrapper createVarargs(Object method) {
        return new MethVarargs(method);
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MethKeywords
    extends MethodWrapper {
        public MethKeywords(Object method) {
            super(method);
        }

        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        public Object execute(Object[] arguments, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached.Exclusive @Cached CApiTransitions.PythonToNativeNewRefNode toSulongNode, @Cached.Exclusive @Cached CallNode callNode, @Cached.Exclusive @Cached ExecutePositionalStarargsNode posStarargsNode, @Cached.Exclusive @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached.Exclusive @Cached CExtNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            try {
                if (arguments.length != 3) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)3, (int)3, (int)arguments.length);
                }
                try {
                    Object[] pArgs;
                    Object receiver = toJavaNode.execute(arguments[0]);
                    Object starArgs = toJavaNode.execute(arguments[1]);
                    Object kwArgs = toJavaNode.execute(arguments[2]);
                    if (starArgs != PNone.NO_VALUE) {
                        Object[] starArgsArray = posStarargsNode.executeWith(null, starArgs);
                        pArgs = PythonUtils.prependArgument(receiver, starArgsArray);
                    } else {
                        pArgs = new Object[]{receiver};
                    }
                    PKeyword[] kwArgsArray = expandKwargsNode.execute(inliningTarget, kwArgs);
                    Object object = toSulongNode.execute(callNode.execute((Frame)null, this.getDelegate(), pArgs, kwArgsArray));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SetAttrWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(e);
                        Object object = PythonContext.get(callNode).getNativeNull().getPtr();
                        return object;
                    }
                }
            }
            finally {
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER,POINTER,POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    static final class MethVarargs
    extends MethodWrapper {
        public MethVarargs(Object method) {
            super(method);
        }

        @ExportMessage
        protected boolean isExecutable() {
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @ExportMessage
        public Object execute(Object[] arguments, @Cached.Exclusive @Cached CApiTransitions.NativeToPythonNode toJavaNode, @Cached.Exclusive @Cached CApiTransitions.PythonToNativeNewRefNode toSulongNode, @Cached.Exclusive @Cached PythonAbstractObject.PExecuteNode executeNode2, @Cached.Exclusive @Cached CExtNodes.TransformExceptionToNativeNode transformExceptionToNativeNode, @Cached.Exclusive @Cached GilNode gil) throws ArityException {
            boolean mustRelease = gil.acquire();
            try {
                if (arguments.length != 1) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw ArityException.create((int)1, (int)1, (int)arguments.length);
                }
                try {
                    Object varArgs = toJavaNode.execute(arguments[0]);
                    Object object = toSulongNode.execute(executeNode2.execute(this.getDelegate(), new Object[]{varArgs}));
                    return object;
                }
                catch (Throwable t) {
                    try {
                        throw PythonCextBuiltins.checkThrowableBeforeNative(t, "SetAttrWrapper", this.getDelegate());
                    }
                    catch (PException e) {
                        transformExceptionToNativeNode.execute(e);
                        Object object = PythonContext.get(toJavaNode).getNativeNull().getPtr();
                        return object;
                    }
                }
            }
            finally {
                gil.release(mustRelease);
            }
        }

        @Override
        protected String getSignature() {
            return "(POINTER):POINTER";
        }
    }

    @ExportLibrary(value=InteropLibrary.class)
    public static abstract class MethodWrapper
    extends PythonNativeWrapper {
        public MethodWrapper(Object method) {
            super(method);
        }

        @ExportMessage
        public boolean isPointer() {
            return this.isNative();
        }

        @ExportMessage
        public long asPointer() {
            return this.getNativePointer();
        }

        @ExportMessage
        @CompilerDirectives.TruffleBoundary
        public void toNative() {
            if (!this.isPointer()) {
                this.setNativePointer(PythonContext.get(null).getCApiContext().registerClosure(this.getSignature(), this, this.getDelegate()));
            }
        }

        protected abstract String getSignature();
    }
}

