/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallTernaryNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.BinaryOpNode;
import com.oracle.graal.python.nodes.expression.InplaceArithmetic;
import com.oracle.graal.python.nodes.expression.LookupAndCallInplaceNode;
import com.oracle.graal.python.nodes.expression.TernaryArithmetic;
import com.oracle.graal.python.nodes.expression.UnaryArithmetic;
import com.oracle.graal.python.nodes.expression.UnaryOpNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.NodeCost;

public abstract class GraalHPyArithmeticNode {
    private GraalHPyArithmeticNode() {
    }

    private static final class HPyInplaceArithmeticUncached
    extends HPyInplaceArithmeticNode {
        final InplaceArithmetic operator;
        private static final HPyInplaceArithmeticUncached[] UNCACHEDS;

        public HPyInplaceArithmeticUncached(InplaceArithmetic operator) {
            this.operator = operator;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0, Object arg1, Object arg2) {
            Object[] pythonArguments = PArguments.create(3);
            PArguments.setArgument(pythonArguments, 0, arg0);
            PArguments.setArgument(pythonArguments, 1, arg1);
            PArguments.setArgument(pythonArguments, 2, arg2);
            RootCallTarget callTarget = PythonLanguage.get(null).createCachedCallTarget(this.operator::createRootNode, (Object)this.operator);
            return GenericInvokeNode.invokeUncached(callTarget, pythonArguments);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            InplaceArithmetic[] values = InplaceArithmetic.values();
            UNCACHEDS = new HPyInplaceArithmeticUncached[values.length];
            for (int i = 0; i < values.length; ++i) {
                HPyInplaceArithmeticUncached.UNCACHEDS[i] = new HPyInplaceArithmeticUncached(values[i]);
            }
        }
    }

    private static final class HPyInplaceArithmeticCached
    extends HPyInplaceArithmeticNode {
        @Node.Child
        private LookupAndCallInplaceNode opNode;
        private final boolean isTernary;

        private HPyInplaceArithmeticCached(InplaceArithmetic operator) {
            this.opNode = operator.create();
            this.isTernary = operator.isTernary();
        }

        @Override
        public Object execute(Object arg0, Object arg1, Object arg2) {
            if (this.isTernary) {
                return this.opNode.executeTernary(null, arg0, arg1, arg2);
            }
            return this.opNode.execute(null, arg0, arg1);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    public static abstract class HPyInplaceArithmeticNode
    extends Node {
        public abstract Object execute(Object var1, Object var2, Object var3);

        public final Object execute(Object arg0, Object arg1) {
            return this.execute(arg0, arg1, PNone.NO_VALUE);
        }

        @NeverDefault
        public static HPyInplaceArithmeticNode create(InplaceArithmetic operator) {
            return new HPyInplaceArithmeticCached(operator);
        }

        public static HPyInplaceArithmeticNode getUncached(InplaceArithmetic operator) {
            return HPyInplaceArithmeticUncached.UNCACHEDS[operator.ordinal()];
        }
    }

    private static final class HPyTernaryArithmeticUncached
    extends HPyTernaryArithmeticNode {
        final TernaryArithmetic operator;
        private static final HPyTernaryArithmeticUncached[] UNCACHEDS;

        public HPyTernaryArithmeticUncached(TernaryArithmetic operator) {
            this.operator = operator;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0, Object arg1, Object arg2) {
            Object[] pythonArguments = PArguments.create(3);
            PArguments.setArgument(pythonArguments, 0, arg0);
            PArguments.setArgument(pythonArguments, 1, arg1);
            PArguments.setArgument(pythonArguments, 2, arg2);
            RootCallTarget callTarget = PythonLanguage.get(null).createCachedCallTarget(this.operator::createRootNode, (Object)this.operator);
            return GenericInvokeNode.invokeUncached(callTarget, pythonArguments);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            TernaryArithmetic[] values = TernaryArithmetic.values();
            UNCACHEDS = new HPyTernaryArithmeticUncached[values.length];
            for (int i = 0; i < values.length; ++i) {
                HPyTernaryArithmeticUncached.UNCACHEDS[i] = new HPyTernaryArithmeticUncached(values[i]);
            }
        }
    }

    private static final class HPyTernaryArithmeticCached
    extends HPyTernaryArithmeticNode {
        @Node.Child
        private LookupAndCallTernaryNode opNode;

        private HPyTernaryArithmeticCached(TernaryArithmetic operator) {
            this.opNode = operator.create();
        }

        @Override
        public Object execute(Object arg0, Object arg1, Object arg2) {
            return this.opNode.execute(null, arg0, arg1, arg2);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    public static abstract class HPyTernaryArithmeticNode
    extends Node {
        public abstract Object execute(Object var1, Object var2, Object var3);

        @NeverDefault
        public static HPyTernaryArithmeticNode create(TernaryArithmetic operator) {
            return new HPyTernaryArithmeticCached(operator);
        }

        public static HPyTernaryArithmeticNode getUncached(TernaryArithmetic operator) {
            return HPyTernaryArithmeticUncached.UNCACHEDS[operator.ordinal()];
        }
    }

    private static final class HPyBinaryArithmeticUncached
    extends HPyBinaryArithmeticNode {
        final BinaryArithmetic operator;
        private static final HPyBinaryArithmeticUncached[] UNCACHEDS;

        public HPyBinaryArithmeticUncached(BinaryArithmetic operator) {
            this.operator = operator;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object arg0, Object arg1) {
            Object[] pythonArguments = PArguments.create(2);
            PArguments.setArgument(pythonArguments, 0, arg0);
            PArguments.setArgument(pythonArguments, 1, arg1);
            RootCallTarget callTarget = PythonLanguage.get(null).createCachedCallTarget(this.operator::createRootNode, (Object)this.operator);
            return GenericInvokeNode.invokeUncached(callTarget, pythonArguments);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            BinaryArithmetic[] values = BinaryArithmetic.values();
            UNCACHEDS = new HPyBinaryArithmeticUncached[values.length];
            for (int i = 0; i < values.length; ++i) {
                HPyBinaryArithmeticUncached.UNCACHEDS[i] = new HPyBinaryArithmeticUncached(values[i]);
            }
        }
    }

    private static final class HPyBinaryArithmeticCached
    extends HPyBinaryArithmeticNode {
        @Node.Child
        private BinaryOpNode opNode;

        private HPyBinaryArithmeticCached(BinaryArithmetic operator) {
            this.opNode = operator.create();
        }

        @Override
        public Object execute(Object arg0, Object arg1) {
            return this.opNode.executeObject(null, arg0, arg1);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    public static abstract class HPyBinaryArithmeticNode
    extends Node {
        public abstract Object execute(Object var1, Object var2);

        @NeverDefault
        public static HPyBinaryArithmeticNode create(BinaryArithmetic operator) {
            return new HPyBinaryArithmeticCached(operator);
        }

        public static HPyBinaryArithmeticNode getUncached(BinaryArithmetic operator) {
            return HPyBinaryArithmeticUncached.UNCACHEDS[operator.ordinal()];
        }
    }

    private static final class HPyUnaryArithmeticUncached
    extends HPyUnaryArithmeticNode {
        final UnaryArithmetic operator;
        private static final HPyUnaryArithmeticUncached[] UNCACHEDS;

        public HPyUnaryArithmeticUncached(UnaryArithmetic operator) {
            this.operator = operator;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public Object execute(Object object) {
            Object[] pythonArguments = PArguments.create(1);
            PArguments.setArgument(pythonArguments, 0, object);
            RootCallTarget callTarget = PythonLanguage.get(null).createCachedCallTarget(this.operator::createRootNode, (Object)this.operator);
            return GenericInvokeNode.invokeUncached(callTarget, pythonArguments);
        }

        public NodeCost getCost() {
            return NodeCost.MEGAMORPHIC;
        }

        public boolean isAdoptable() {
            return false;
        }

        static {
            UnaryArithmetic[] values = UnaryArithmetic.values();
            UNCACHEDS = new HPyUnaryArithmeticUncached[values.length];
            for (int i = 0; i < values.length; ++i) {
                HPyUnaryArithmeticUncached.UNCACHEDS[i] = new HPyUnaryArithmeticUncached(values[i]);
            }
        }
    }

    static final class HPyUnaryArithmeticCached
    extends HPyUnaryArithmeticNode {
        @Node.Child
        private UnaryOpNode opNode;

        private HPyUnaryArithmeticCached(UnaryArithmetic operator) {
            this.opNode = operator.create();
        }

        @Override
        public Object execute(Object object) {
            return this.opNode.executeCached(null, object);
        }

        public NodeCost getCost() {
            return NodeCost.NONE;
        }
    }

    public static abstract class HPyUnaryArithmeticNode
    extends Node {
        public abstract Object execute(Object var1);

        @NeverDefault
        public static HPyUnaryArithmeticNode create(UnaryArithmetic operator) {
            return new HPyUnaryArithmeticCached(operator);
        }

        public static HPyUnaryArithmeticNode getUncached(UnaryArithmetic operator) {
            return HPyUnaryArithmeticUncached.UNCACHEDS[operator.ordinal()];
        }
    }
}

