/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.common;

import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

public class KeywordsStorage
extends HashingStorage {
    final PKeyword[] keywords;

    protected KeywordsStorage(PKeyword[] keywords) {
        this.keywords = keywords;
    }

    public PKeyword[] getStore() {
        return this.keywords;
    }

    public int length() {
        return this.keywords.length;
    }

    @ExplodeLoop(kind=ExplodeLoop.LoopExplosionKind.FULL_UNROLL_UNTIL_RETURN)
    protected int findCachedStringKey(TruffleString key, int len, TruffleString.EqualNode equalNode) {
        for (int i = 0; i < len; ++i) {
            if (!equalNode.execute((AbstractTruffleString)this.keywords[i].getName(), (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) continue;
            return i;
        }
        return -1;
    }

    protected int findStringKey(TruffleString key, TruffleString.EqualNode equalNode) {
        return KeywordsStorage.findStringKey(this.keywords, key, equalNode);
    }

    public static int findStringKey(PKeyword[] keywords, TruffleString key, TruffleString.EqualNode equalNode) {
        for (int i = 0; i < keywords.length; ++i) {
            if (!equalNode.execute((AbstractTruffleString)keywords[i].getName(), (AbstractTruffleString)key, PythonUtils.TS_ENCODING)) continue;
            return i;
        }
        return -1;
    }

    void addAllTo(Node inliningTarget, HashingStorage storage, HashingStorageNodes.SpecializedSetStringKey putNode) {
        for (PKeyword entry : this.keywords) {
            putNode.execute(inliningTarget, storage, entry.getName(), entry.getValue());
        }
    }

    public HashingStorage copy() {
        return this;
    }

    public static KeywordsStorage create(PKeyword[] keywords) {
        return new KeywordsStorage(keywords);
    }

    @ImportStatic(value={PGuards.class})
    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetKeywordsStorageItemNode
    extends Node {
        public abstract Object execute(Frame var1, Node var2, KeywordsStorage var3, Object var4, long var5);

        @Specialization(guards={"self.length() == cachedLen", "cachedLen < 6"}, limit="1")
        static Object cached(KeywordsStorage self, TruffleString key, long hash, @Cached.Exclusive @Cached(value="self.length()") int cachedLen, @Cached.Shared(value="tsEqual") @Cached(inline=false) TruffleString.EqualNode equalNode) {
            int idx = self.findCachedStringKey(key, cachedLen, equalNode);
            return idx != -1 ? self.keywords[idx].getValue() : null;
        }

        @Specialization(replaces={"cached"})
        static Object string(KeywordsStorage self, TruffleString key, long hash, @Cached.Shared(value="tsEqual") @Cached(inline=false) TruffleString.EqualNode equalNode) {
            int idx = self.findStringKey(key, equalNode);
            return idx != -1 ? self.keywords[idx].getValue() : null;
        }

        @Specialization(guards={"isBuiltinString(inliningTarget, key, profile)"}, limit="1")
        static Object pstring(Node inliningTarget, KeywordsStorage self, PString key, long hash, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile, @Cached.Shared(value="tsEqual") @Cached(inline=false) TruffleString.EqualNode equalNode) {
            return GetKeywordsStorageItemNode.string(self, castToTruffleStringNode.execute(inliningTarget, key), -1L, equalNode);
        }

        @Specialization(guards={"!isBuiltinString(inliningTarget, key, profile)"}, limit="1")
        static Object notString(Frame frame, Node inliningTarget, KeywordsStorage self, Object key, long hashIn, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile profile, @Cached PyObjectHashNode hashNode, @Cached PyObjectRichCompareBool.EqNode eqNode) {
            long hash = hashIn == -1L ? hashNode.execute(frame, inliningTarget, key) : hashIn;
            for (int i = 0; i < self.keywords.length; ++i) {
                TruffleString currentKey = self.keywords[i].getName();
                long keyHash = hashNode.execute(frame, inliningTarget, currentKey);
                if (keyHash != hash || !eqNode.compare(frame, inliningTarget, key, currentKey)) continue;
                return self.keywords[i].getValue();
            }
            return null;
        }
    }
}

