/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.exception;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.PythonOS;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionBuiltins;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.OSErrorEnum;
import com.oracle.graal.python.builtins.objects.exception.OsErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.lib.PyArgCheckPositionalNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberCheckNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectStrAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.OSError})
public final class OsErrorBuiltins
extends PythonBuiltins {
    static final int ARGS_MIN = 2;
    static final int ARGS_MAX = 5;
    public static final int IDX_ERRNO = 0;
    public static final int IDX_STRERROR = 1;
    public static final int IDX_FILENAME = 2;
    public static final int IDX_WINERROR = 3;
    public static final int IDX_FILENAME2 = 4;
    public static final int IDX_WRITTEN = 5;
    public static final int OS_ERR_NUM_ATTRS = 6;
    public static final BaseExceptionAttrNode.StorageFactory OS_ERROR_ATTR_FACTORY = (args, factory) -> {
        Object[] attrs = new Object[6];
        attrs[5] = -1;
        return attrs;
    };

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return OsErrorBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.registerTypeInBuiltins(PythonUtils.tsLiteral("EnvironmentError"), PythonBuiltinClassType.OSError);
        core.registerTypeInBuiltins(PythonUtils.tsLiteral("IOError"), PythonBuiltinClassType.OSError);
    }

    static boolean osErrorUseInit(VirtualFrame frame, Node inliningTarget, Python3Core core, Object type, PyObjectGetAttr getAttr) {
        PythonBuiltinClass osErrorType = core.lookupType(PythonBuiltinClassType.OSError);
        Object tpInit = getAttr.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___INIT__);
        Object tpNew = getAttr.execute((Frame)frame, inliningTarget, type, SpecialMethodNames.T___NEW__);
        Object osErrInit = getAttr.execute((Frame)frame, inliningTarget, osErrorType, SpecialMethodNames.T___INIT__);
        Object osErrNew = getAttr.execute((Frame)frame, inliningTarget, osErrorType, SpecialMethodNames.T___NEW__);
        return tpInit != osErrInit && tpNew == osErrNew;
    }

    static PythonBuiltinClassType errno2errorType(int errno) {
        OSErrorEnum osErrorEnum = OSErrorEnum.fromNumber(errno);
        if (osErrorEnum == null) {
            return null;
        }
        switch (osErrorEnum) {
            case EISDIR: {
                return PythonBuiltinClassType.IsADirectoryError;
            }
            case EAGAIN: 
            case EWOULDBLOCK: 
            case EALREADY: 
            case EINPROGRESS: {
                return PythonBuiltinClassType.BlockingIOError;
            }
            case EPIPE: 
            case ESHUTDOWN: {
                return PythonBuiltinClassType.BrokenPipeError;
            }
            case ECHILD: {
                return PythonBuiltinClassType.ChildProcessError;
            }
            case ECONNABORTED: {
                return PythonBuiltinClassType.ConnectionAbortedError;
            }
            case ECONNREFUSED: {
                return PythonBuiltinClassType.ConnectionRefusedError;
            }
            case ECONNRESET: {
                return PythonBuiltinClassType.ConnectionResetError;
            }
            case EEXIST: {
                return PythonBuiltinClassType.FileExistsError;
            }
            case ENOENT: {
                return PythonBuiltinClassType.FileNotFoundError;
            }
            case ENOTDIR: {
                return PythonBuiltinClassType.NotADirectoryError;
            }
            case EINTR: {
                return PythonBuiltinClassType.InterruptedError;
            }
            case EACCES: 
            case EPERM: {
                return PythonBuiltinClassType.PermissionError;
            }
            case ESRCH: {
                return PythonBuiltinClassType.ProcessLookupError;
            }
            case ETIMEDOUT: {
                return PythonBuiltinClassType.TimeoutError;
            }
        }
        return null;
    }

    public static OSErrorEnum errorType2errno(PythonBuiltinClassType type) {
        switch (type) {
            case IsADirectoryError: {
                return OSErrorEnum.EISDIR;
            }
            case ChildProcessError: {
                return OSErrorEnum.ECHILD;
            }
            case ConnectionAbortedError: {
                return OSErrorEnum.ECONNABORTED;
            }
            case ConnectionRefusedError: {
                return OSErrorEnum.ECONNREFUSED;
            }
            case ConnectionResetError: {
                return OSErrorEnum.ECONNRESET;
            }
            case FileExistsError: {
                return OSErrorEnum.EEXIST;
            }
            case FileNotFoundError: {
                return OSErrorEnum.ENOENT;
            }
            case NotADirectoryError: {
                return OSErrorEnum.ENOTDIR;
            }
            case InterruptedError: {
                return OSErrorEnum.EINTR;
            }
            case ProcessLookupError: {
                return OSErrorEnum.ESRCH;
            }
            case TimeoutError: {
                return OSErrorEnum.ETIMEDOUT;
            }
        }
        return null;
    }

    static void osErrorInit(Frame frame, Node inliningTarget, PBaseException self, Object type, Object[] args, Object[] parsedArgs, PyNumberCheckNode pyNumberCheckNode, PyNumberAsSizeNode pyNumberAsSizeNode, BaseExceptionBuiltins.BaseExceptionInitNode baseInitNode) {
        Object[] pArgs = args;
        Object filename = parsedArgs[2];
        Object filename2 = parsedArgs[4];
        if (filename != null && filename != PNone.NONE) {
            if (type == PythonBuiltinClassType.BlockingIOError && pyNumberCheckNode.execute(inliningTarget, filename)) {
                parsedArgs[5] = pyNumberAsSizeNode.executeExact(frame, inliningTarget, filename, PythonBuiltinClassType.ValueError);
            } else {
                parsedArgs[2] = filename;
                if (filename2 != null && filename2 != PNone.NONE) {
                    parsedArgs[4] = filename2;
                }
                if (args.length >= 2 && args.length <= 5) {
                    pArgs = PythonUtils.arrayCopyOfRange(args, 0, 2);
                }
            }
        }
        baseInitNode.execute(self, pArgs);
        self.setExceptionAttributes(parsedArgs);
    }

    static Object[] osErrorParseArgs(Object[] args, Node inliningTarget, PyArgCheckPositionalNode checkPositionalNode) {
        Object[] parsed = new Object[6];
        if (args.length >= 2 && args.length <= 5) {
            checkPositionalNode.execute(inliningTarget, PythonBuiltinClassType.OSError.getPrintName(), args, 2, 5);
            PythonUtils.arraycopy(args, 0, parsed, 0, args.length);
        }
        parsed[5] = -1;
        return parsed;
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class OSErrorReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reduce(PBaseException self, @Bind(value="this") Node inliningTarget, @Cached ExceptionNodes.GetArgsNode getArgsNode, @Cached BaseExceptionAttrNode attrNode, @Cached GetClassNode getClassNode, @Cached GetDictIfExistsNode getDictNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode) {
            PTuple args = getArgsNode.execute(inliningTarget, self);
            Object filename = attrNode.get(self, 2, OS_ERROR_ATTR_FACTORY);
            Object filename2 = attrNode.get(self, 4, OS_ERROR_ATTR_FACTORY);
            SequenceStorage argsStorage = args.getSequenceStorage();
            if (argsStorage.length() == 2 && filename != PNone.NONE) {
                Object[] argData = new Object[filename2 != PNone.NONE ? 5 : 3];
                argData[0] = getItemNode.execute(inliningTarget, argsStorage, 0);
                argData[1] = getItemNode.execute(inliningTarget, argsStorage, 1);
                argData[2] = filename;
                if (filename2 != PNone.NONE) {
                    argData[3] = PNone.NONE;
                    argData[4] = filename2;
                }
                args = this.factory().createTuple(argData);
            }
            Object type = getClassNode.execute(inliningTarget, self);
            PDict dict = getDictNode.execute(self);
            if (dict != null) {
                return this.factory().createTuple(new Object[]{type, args, dict});
            }
            return this.factory().createTuple(new Object[]{type, args});
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class OSErrorStrNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object str(VirtualFrame frame, PBaseException self, @Bind(value="this") Node inliningTarget, @Cached BaseExceptionAttrNode attrNode, @Cached BaseExceptionBuiltins.StrNode baseStrNode, @Cached PyObjectStrAsTruffleStringNode strNode, @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object filename = attrNode.get(self, 2, OS_ERROR_ATTR_FACTORY);
            Object filename2 = attrNode.get(self, 4, OS_ERROR_ATTR_FACTORY);
            Object errno = attrNode.get(self, 0, OS_ERROR_ATTR_FACTORY);
            Object strerror = attrNode.get(self, 1, OS_ERROR_ATTR_FACTORY);
            if (filename != PNone.NONE) {
                if (filename2 != PNone.NONE) {
                    return simpleTruffleStringFormatNode.format("[Errno %s] %s: %s -> %s", strNode.execute((Frame)frame, inliningTarget, errno != null ? errno : PNone.NONE), strNode.execute((Frame)frame, inliningTarget, strerror != null ? strerror : PNone.NONE), reprNode.execute((Frame)frame, inliningTarget, filename), reprNode.execute((Frame)frame, inliningTarget, filename2));
                }
                return simpleTruffleStringFormatNode.format("[Errno %s] %s: %s", strNode.execute((Frame)frame, inliningTarget, errno != null ? errno : PNone.NONE), strNode.execute((Frame)frame, inliningTarget, strerror != null ? strerror : PNone.NONE), reprNode.execute((Frame)frame, inliningTarget, filename));
            }
            if (errno != PNone.NONE && strerror != PNone.NONE) {
                return simpleTruffleStringFormatNode.format("[Errno %s] %s", strNode.execute((Frame)frame, inliningTarget, errno), strNode.execute((Frame)frame, inliningTarget, strerror));
            }
            return baseStrNode.execute(frame, self);
        }
    }

    @Builtin(name="characters_written", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception characters written")
    @GenerateNodeFactory
    public static abstract class OSErrorCharsWrittenNode
    extends PythonBuiltinNode {
        protected boolean isInvalid(PBaseException self) {
            Object[] attrs = self.getExceptionAttributes();
            return attrs != null && attrs[5] instanceof Integer && (Integer)attrs[5] == -1;
        }

        @Specialization(guards={"isInvalid(self)"})
        Object generic(PBaseException self, Object value) {
            throw this.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.CHARACTERS_WRITTEN);
        }

        @Specialization(guards={"!isInvalid(self)"})
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            Object retVal = attrNode.execute(self, value, 5, OS_ERROR_ATTR_FACTORY);
            if (PGuards.isDeleteMarker(value)) {
                self.getExceptionAttributes()[5] = -1;
            }
            return retVal;
        }
    }

    @Builtin(name="winerror", os=PythonOS.PLATFORM_WIN32, minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="Win32 exception code")
    @GenerateNodeFactory
    public static abstract class OSErrorWinerrorNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            Object result = attrNode.execute(self, value, 3, OS_ERROR_ATTR_FACTORY);
            if (result instanceof PNone) {
                return attrNode.execute(self, value, 0, OS_ERROR_ATTR_FACTORY);
            }
            return result;
        }
    }

    @Builtin(name="filename2", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception filename2")
    @GenerateNodeFactory
    public static abstract class OSErrorFilename2Node
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 4, OS_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="filename", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception filename")
    @GenerateNodeFactory
    public static abstract class OSErrorFilenameNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 2, OS_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="strerror", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="exception strerror")
    @GenerateNodeFactory
    public static abstract class OSErrorStrerrorNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 1, OS_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="errno", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true, doc="POSIX exception code")
    @GenerateNodeFactory
    public static abstract class OSErrorErrnoNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 0, OS_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class OSErrorInitNode
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PBaseException var2, Object[] var3, PKeyword[] var4);

        @Specialization
        Object initNoArgs(VirtualFrame frame, PBaseException self, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttr getAttr, @Cached PyNumberCheckNode pyNumberCheckNode, @Cached PyNumberAsSizeNode pyNumberAsSizeNode, @Cached PyArgCheckPositionalNode checkPositionalNode, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseInitNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            if (!OsErrorBuiltins.osErrorUseInit(frame, inliningTarget, this.getContext(), type, getAttr)) {
                return PNone.NONE;
            }
            if (kwds.length != 0) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_TAKES_NO_KEYWORD_ARGS, type);
            }
            Object[] parsedArgs = OsErrorBuiltins.osErrorParseArgs(args, inliningTarget, checkPositionalNode);
            OsErrorBuiltins.osErrorInit((Frame)frame, inliningTarget, self, type, args, parsedArgs, pyNumberCheckNode, pyNumberAsSizeNode, baseInitNode);
            return PNone.NONE;
        }

        @NeverDefault
        public static OSErrorInitNode create() {
            return OsErrorBuiltinsFactory.OSErrorInitNodeFactory.create(null);
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class OSErrorNewNode
    extends PythonBuiltinNode {
        protected OSErrorNewNode() {
        }

        @Specialization
        protected Object newCData(VirtualFrame frame, Object subType, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached PyNumberCheckNode pyNumberCheckNode, @Cached PyNumberAsSizeNode pyNumberAsSizeNode, @Cached PyArgCheckPositionalNode checkPositionalNode, @Cached BaseExceptionBuiltins.BaseExceptionInitNode baseInitNode) {
            Object type = subType;
            Object[] parsedArgs = new Object[6];
            PythonContext core = this.getContext();
            if (!OsErrorBuiltins.osErrorUseInit(frame, inliningTarget, core, type, getAttr)) {
                int errno;
                PythonBuiltinClassType newType;
                if (kwds.length != 0) {
                    throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.P_TAKES_NO_KEYWORD_ARGS, type);
                }
                parsedArgs = OsErrorBuiltins.osErrorParseArgs(args, inliningTarget, checkPositionalNode);
                Object errnoVal = parsedArgs[0];
                if (errnoVal != null && PGuards.canBeInteger(errnoVal) && subType == PythonBuiltinClassType.OSError && (newType = OsErrorBuiltins.errno2errorType(errno = pyNumberAsSizeNode.executeExact((Frame)frame, inliningTarget, errnoVal))) != null) {
                    type = newType;
                }
            }
            PBaseException self = this.factory().createBaseException(type);
            if (!OsErrorBuiltins.osErrorUseInit(frame, inliningTarget, core, type, getAttr)) {
                OsErrorBuiltins.osErrorInit((Frame)frame, inliningTarget, self, type, args, parsedArgs, pyNumberCheckNode, pyNumberAsSizeNode, baseInitNode);
            } else {
                self.setArgs(this.factory().createEmptyTuple());
            }
            return self;
        }
    }
}

