/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ints;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.MathGuards;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.common.FormatNodeBase;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.lib.PyNumberFloatNode;
import com.oracle.graal.python.lib.PyObjectHashNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallVarargsNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.formatting.FloatFormatter;
import com.oracle.graal.python.runtime.formatting.IntegerFormatter;
import com.oracle.graal.python.runtime.formatting.InternalFormat;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedIntValueProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PInt})
public final class IntBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return IntBuiltinsFactory.getFactories();
    }

    @Builtin(name="__float__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class FloatNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static double doBoolean(boolean self) {
            return self ? 1.0 : 0.0;
        }

        @Specialization
        static double doInt(int self) {
            return self;
        }

        @Specialization
        static double doLong(long self) {
            return self;
        }

        @Specialization
        double doPInt(PInt self) {
            return self.doubleValueWithOverflow(this.getRaiseNode());
        }

        @Fallback
        static PNotImplemented doGeneric(Object self) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__getnewargs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetNewArgsNode
    extends PythonUnaryBuiltinNode {
        GetNewArgsNode() {
        }

        @Specialization
        Object doI(int self) {
            return this.factory().createTuple(new Object[]{this.factory().createInt(self)});
        }

        @Specialization
        Object doL(long self) {
            return this.factory().createTuple(new Object[]{this.factory().createInt(self)});
        }

        @Specialization
        Object getPI(PInt self) {
            return this.factory().createTuple(new Object[]{this.factory().createInt(self.getValue())});
        }
    }

    @Builtin(name="__index__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IndexNode
    extends IntNode {
        IndexNode() {
        }
    }

    @Builtin(name="__int__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class IntNode
    extends PythonUnaryBuiltinNode {
        IntNode() {
        }

        @Specialization
        static int doB(boolean self) {
            return self ? 1 : 0;
        }

        @Specialization
        static int doI(int self) {
            return self;
        }

        @Specialization
        static long doL(long self) {
            return self;
        }

        @Specialization(guards={"cannotBeOverridden(self, inliningTarget, getClassNode)"})
        static PInt doPInt(PInt self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode) {
            return self;
        }

        @Specialization(guards={"!cannotBeOverridden(self, inliningTarget, getClassNode)"}, rewriteOn={OverflowException.class})
        static int doPIntOverridenNarrowInt(PInt self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode) throws OverflowException {
            return self.intValueExact();
        }

        @Specialization(guards={"!cannotBeOverridden(self, inliningTarget, getClassNode)"}, replaces={"doPIntOverridenNarrowInt"}, rewriteOn={OverflowException.class})
        static long doPIntOverridenNarrowLong(PInt self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode) throws OverflowException {
            return self.longValueExact();
        }

        @Specialization(guards={"!cannotBeOverridden(self, inliningTarget, getClassNode)"}, replaces={"doPIntOverridenNarrowLong"})
        PInt doPIntOverriden(PInt self, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode) {
            return this.factory().createInt(self.getValue());
        }

        @Specialization
        static PythonNativeVoidPtr doL(PythonNativeVoidPtr self) {
            return self;
        }
    }

    @Builtin(name="__trunc__", minNumOfPositionalArgs=1, doc="Truncating an Integral returns itself.")
    @GenerateNodeFactory
    static abstract class TruncNode
    extends IntNode {
        TruncNode() {
        }
    }

    @Builtin(name="as_integer_ratio", minNumOfPositionalArgs=1, doc="Return integer ratio.")
    @GenerateNodeFactory
    static abstract class AsIntegerRatioNode
    extends PythonBuiltinNode {
        AsIntegerRatioNode() {
        }

        @Specialization
        Object get(VirtualFrame frame, Object self, @Cached IntNode intNode) {
            return this.factory().createTuple(new Object[]{intNode.execute(frame, self), 1});
        }
    }

    @Builtin(name="denominator", minNumOfPositionalArgs=1, isGetter=true, doc="the denominator of a rational number in lowest terms")
    @GenerateNodeFactory
    static abstract class DenominatorNode
    extends PythonBuiltinNode {
        DenominatorNode() {
        }

        @Specialization
        static int get(Object self) {
            return 1;
        }
    }

    @Builtin(name="conjugate", minNumOfPositionalArgs=1, doc="Returns self, the complex conjugate of any int.")
    @GenerateNodeFactory
    static abstract class ConjugateNode
    extends IntNode {
        ConjugateNode() {
        }
    }

    @Builtin(name="numerator", minNumOfPositionalArgs=1, isGetter=true, doc="the numerator of a rational number in lowest terms")
    @GenerateNodeFactory
    static abstract class NumeratorNode
    extends IntNode {
        NumeratorNode() {
        }
    }

    @Builtin(name="imag", minNumOfPositionalArgs=1, isGetter=true, doc="the imaginary part of a complex number")
    @GenerateNodeFactory
    static abstract class ImagNode
    extends PythonBuiltinNode {
        ImagNode() {
        }

        @Specialization
        static int get(Object self) {
            return 0;
        }
    }

    @Builtin(name="real", minNumOfPositionalArgs=1, isGetter=true, doc="the real part of a complex number")
    @GenerateNodeFactory
    static abstract class RealNode
    extends IntNode {
        RealNode() {
        }
    }

    @Builtin(name="bit_length", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class BitLengthNode
    extends PythonBuiltinNode {
        BitLengthNode() {
        }

        @Specialization
        static int bitLength(int argument2) {
            return 32 - Integer.numberOfLeadingZeros(Math.abs(argument2));
        }

        @Specialization
        static int bitLength(long argument2) {
            return 64 - Long.numberOfLeadingZeros(Math.abs(argument2));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int bitLength(PInt argument2) {
            return argument2.getValue().abs().bitLength();
        }
    }

    @Builtin(name="bit_count", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class BitCountNode
    extends PythonBuiltinNode {
        BitCountNode() {
        }

        @Specialization
        static int bitCount(int i) {
            return Integer.bitCount(Math.abs(i));
        }

        @Specialization
        static int bitCount(long l) {
            return Long.bitCount(Math.abs(l));
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int bitCount(PInt i) {
            return i.getValue().abs().bitCount();
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long hash(int self) {
            return PyObjectHashNode.hash(self);
        }

        @Specialization
        static long hash(long self) {
            return PyObjectHashNode.hash(self);
        }

        @Specialization
        static long hash(PInt self) {
            return self.hash();
        }

        @Specialization(limit="1")
        static long hash(PythonNativeVoidPtr self, @CachedLibrary(value="self.getPointerObject()") InteropLibrary lib) {
            Object object = self.getPointerObject();
            if (lib.hasIdentity(object)) {
                try {
                    return lib.identityHashCode(object);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return HashNode.hashCodeBoundary(object);
        }

        @CompilerDirectives.TruffleBoundary
        private static long hashCodeBoundary(Object object) {
            return object.hashCode();
        }
    }

    @Builtin(name="__format__", minNumOfPositionalArgs=2, parameterNames={"$self", "format_spec"})
    @ArgumentClinic(name="format_spec", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class FormatNode
    extends FormatNodeBase {
        FormatNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IntBuiltinsClinicProviders.FormatNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        TruffleString formatB(boolean self, TruffleString formatString) {
            return this.formatI(self ? 1 : 0, formatString);
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        TruffleString formatI(int self, TruffleString formatString) {
            PRaiseNode raiseNode = this.getRaiseNode();
            InternalFormat.Spec spec = FormatNode.getSpec(formatString, raiseNode);
            if (FormatNode.isDoubleSpec(spec)) {
                return FormatNode.formatDouble(raiseNode, spec, self);
            }
            FormatNode.validateIntegerSpec(raiseNode, spec);
            return FormatNode.formatInt(self, raiseNode, spec);
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        TruffleString formatL(VirtualFrame frame, long self, TruffleString formatString, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberFloatNode floatNode) {
            return this.formatPI(frame, this.factory().createInt(self), formatString, inliningTarget, floatNode);
        }

        @Specialization(guards={"!formatString.isEmpty()"})
        TruffleString formatPI(VirtualFrame frame, PInt self, TruffleString formatString, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached PyNumberFloatNode floatNode) {
            PRaiseNode raiseNode = this.getRaiseNode();
            InternalFormat.Spec spec = FormatNode.getSpec(formatString, raiseNode);
            if (FormatNode.isDoubleSpec(spec)) {
                double doubleVal = this.asDouble(frame, inliningTarget, floatNode, self);
                return FormatNode.formatDouble(raiseNode, spec, doubleVal);
            }
            FormatNode.validateIntegerSpec(raiseNode, spec);
            return FormatNode.formatPInt(self, raiseNode, spec);
        }

        private double asDouble(VirtualFrame frame, Node inliningTarget, PyNumberFloatNode floatNode, Object self) {
            return floatNode.execute((Frame)frame, inliningTarget, self);
        }

        private static InternalFormat.Spec getSpec(TruffleString formatString, PRaiseNode raiseNode) {
            return InternalFormat.fromText(raiseNode, formatString, 'd', '>');
        }

        private static boolean isDoubleSpec(InternalFormat.Spec spec) {
            return spec.type == 'e' || spec.type == 'E' || spec.type == 'f' || spec.type == 'F' || spec.type == 'g' || spec.type == 'G' || spec.type == '%';
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatDouble(PRaiseNode raiseNode, InternalFormat.Spec spec, double value) {
            FloatFormatter formatter = new FloatFormatter(raiseNode, spec);
            formatter.format(value);
            return formatter.pad().getResult();
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatInt(int self, PRaiseNode raiseNode, InternalFormat.Spec spec) {
            IntegerFormatter formatter = new IntegerFormatter(raiseNode, spec);
            formatter.format(self);
            return formatter.pad().getResult();
        }

        @CompilerDirectives.TruffleBoundary
        private static TruffleString formatPInt(PInt self, PRaiseNode raiseNode, InternalFormat.Spec spec) {
            IntegerFormatter formatter = new IntegerFormatter(raiseNode, spec);
            formatter.format(self.getValue());
            return formatter.pad().getResult();
        }

        private static void validateIntegerSpec(PRaiseNode raiseNode, InternalFormat.Spec spec) {
            if (InternalFormat.Spec.specified(spec.precision)) {
                throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.PRECISION_NOT_ALLOWED_FOR_INT);
            }
            if (spec.type == 'c') {
                if (InternalFormat.Spec.specified(spec.sign)) {
                    throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.SIGN_NOT_ALLOWED_WITH_C_FOR_INT);
                }
                if (spec.alternate) {
                    throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.ALTERNATE_NOT_ALLOWED_WITH_C_FOR_INT);
                }
            }
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends StrNode {
        ReprNode() {
        }
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class StrNode
    extends PythonBuiltinNode {
        StrNode() {
        }

        @Specialization
        static TruffleString doL(long self, @Cached.Shared(value="fromLong") @Cached TruffleString.FromLongNode fromLongNode) {
            return fromLongNode.execute(self, PythonUtils.TS_ENCODING, false);
        }

        @Specialization
        TruffleString doPInt(PInt self, @Bind(value="this") Node inliningTarget, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached InlinedIntValueProfile maxDigitsProfile, @Cached InlinedIntValueProfile maxDigitsBitLengthProfile) {
            int bitLength;
            PythonContext context = PythonContext.get(this);
            int intMaxStrDigits = maxDigitsProfile.profile(inliningTarget, context.getIntMaxStrDigits());
            if (intMaxStrDigits > 0 && (bitLength = StrNode.positiveBitLength(self)) >= maxDigitsBitLengthProfile.profile(inliningTarget, context.getMinIntBitLengthOverLimit())) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.EXCEEDS_THE_LIMIT_FOR_INTEGER_STRING_CONVERSION, intMaxStrDigits);
            }
            String value = self.toString();
            if (intMaxStrDigits > 0) {
                int digits;
                int n = digits = self.isNegative() ? value.length() - 1 : value.length();
                if (digits > intMaxStrDigits) {
                    throw this.raise(PythonErrorType.ValueError, ErrorMessages.EXCEEDS_THE_LIMIT_FOR_INTEGER_STRING_CONVERSION);
                }
            }
            return fromJavaStringNode.execute(value, PythonUtils.TS_ENCODING);
        }

        @CompilerDirectives.TruffleBoundary
        private static int positiveBitLength(PInt self) {
            return self.abs().bitLength();
        }

        @Specialization
        static TruffleString doNativeVoidPtr(VirtualFrame frame, PythonNativeVoidPtr self, @Bind(value="this") Node inliningTarget, @Cached PyObjectHashNode hashNode, @Cached.Shared(value="fromLong") @Cached TruffleString.FromLongNode fromLongNode) {
            return StrNode.doL(hashNode.execute((Frame)frame, inliningTarget, self), fromLongNode);
        }
    }

    @Builtin(name="__bool__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class BoolNode
    extends PythonBuiltinNode {
        @Specialization
        static boolean toBoolean(boolean self) {
            return self;
        }

        @Specialization
        static boolean toBoolean(int self) {
            return self != 0;
        }

        @Specialization
        static boolean toBoolean(long self) {
            return self != 0L;
        }

        @Specialization
        static boolean toBoolean(PInt self) {
            return !self.isZero();
        }

        @Specialization
        static boolean toBoolean(PythonNativeVoidPtr self, @CachedLibrary(limit="1") InteropLibrary lib) {
            return !lib.isNull(self.getPointerObject());
        }
    }

    @Builtin(name="from_bytes", minNumOfPositionalArgs=3, parameterNames={"cls", "bytes", "byteorder"}, varArgsMarker=true, keywordOnlyNames={"signed"}, isClassmethod=true)
    @ArgumentsClinic(value={@ArgumentClinic(name="byteorder", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="signed", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @ImportStatic(value={SpecialMethodNames.class})
    @GenerateNodeFactory
    public static abstract class FromBytesNode
    extends PythonClinicBuiltinNode {
        @Node.Child
        private LookupAndCallVarargsNode constructNode;

        private static byte[] littleToBig(byte[] bytes) {
            byte[] bigEndianBytes = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                bigEndianBytes[bytes.length - i - 1] = bytes[i];
            }
            return bigEndianBytes;
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger createBigInteger(byte[] bytes, boolean isBigEndian, boolean signed) {
            BigInteger result;
            if (bytes.length == 0) {
                return BigInteger.ZERO;
            }
            if (isBigEndian) {
                result = signed ? new BigInteger(bytes) : new BigInteger(1, bytes);
            } else {
                byte[] converted = FromBytesNode.littleToBig(bytes);
                result = signed ? new BigInteger(converted) : new BigInteger(1, converted);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private boolean isBigEndian(TruffleString order) {
            if (order.equalsUncached((AbstractTruffleString)StringLiterals.T_BIG, PythonUtils.TS_ENCODING)) {
                return true;
            }
            if (order.equalsUncached((AbstractTruffleString)StringLiterals.T_LITTLE, PythonUtils.TS_ENCODING)) {
                return false;
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.BYTEORDER_MUST_BE_LITTLE_OR_BIG);
        }

        private Object createIntObject(Object cl, BigInteger number) {
            PythonBuiltinClassType type = null;
            if (cl instanceof PythonBuiltinClass) {
                type = ((PythonBuiltinClass)cl).getType();
            } else if (cl instanceof PythonBuiltinClassType) {
                type = (PythonBuiltinClassType)((Object)cl);
            }
            if (type == PythonBuiltinClassType.PInt) {
                return this.factory().createInt(number);
            }
            if (this.constructNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.constructNode = (LookupAndCallVarargsNode)this.insert(LookupAndCallVarargsNode.create(SpecialMethodNames.T___CALL__));
            }
            return this.constructNode.execute(null, cl, new Object[]{cl, this.factory().createInt(number)});
        }

        private Object compute(Object cl, byte[] bytes, TruffleString byteorder, boolean signed) {
            BigInteger bi = FromBytesNode.createBigInteger(bytes, this.isBigEndian(byteorder), signed);
            return this.createIntObject(cl, bi);
        }

        @Specialization
        Object fromObject(VirtualFrame frame, Object cl, Object object, TruffleString byteorder, boolean signed, @Cached(value="create(Bytes)") LookupAndCallUnaryNode callBytes, @CachedLibrary(limit="1") PythonBufferAccessLibrary bufferLib, @Cached BytesNodes.BytesFromObject bytesFromObject) {
            byte[] bytes;
            Object bytesObj = callBytes.executeObject(frame, object);
            if (bytesObj != PNone.NO_VALUE) {
                if (!(bytesObj instanceof PBytes)) {
                    throw this.raise(PythonErrorType.TypeError, ErrorMessages.RETURNED_NONBYTES, SpecialMethodNames.T___BYTES__);
                }
                bytes = bufferLib.getCopiedByteArray(bytesObj);
            } else {
                bytes = bytesFromObject.execute(frame, object);
            }
            return this.compute(cl, bytes, byteorder, signed);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IntBuiltinsClinicProviders.FromBytesNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="to_bytes", minNumOfPositionalArgs=3, parameterNames={"$self", "length", "byteorder"}, keywordOnlyNames={"signed"})
    @ArgumentsClinic(value={@ArgumentClinic(name="length", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="byteorder", conversion=ArgumentClinic.ClinicConversion.TString), @ArgumentClinic(name="signed", conversion=ArgumentClinic.ClinicConversion.Boolean, defaultValue="false")})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class ToBytesNode
    extends PythonClinicBuiltinNode {
        @CompilerDirectives.TruffleBoundary
        private boolean isBigEndian(TruffleString order) {
            if (order.equalsUncached((AbstractTruffleString)StringLiterals.T_BIG, PythonUtils.TS_ENCODING)) {
                return true;
            }
            if (order.equalsUncached((AbstractTruffleString)StringLiterals.T_LITTLE, PythonUtils.TS_ENCODING)) {
                return false;
            }
            throw this.raise(PythonErrorType.ValueError, ErrorMessages.BYTEORDER_MUST_BE_LITTLE_OR_BIG);
        }

        @Specialization
        PBytes fromLong(long self, int byteCount, TruffleString byteorder, boolean signed, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile negativeByteCountProfile, @Cached.Exclusive @Cached InlinedConditionProfile negativeNumberProfile, @Cached.Exclusive @Cached InlinedConditionProfile overflowProfile) {
            if (negativeByteCountProfile.profile(inliningTarget, byteCount < 0)) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.MESSAGE_LENGTH_ARGUMENT);
            }
            if (self < 0L && negativeNumberProfile.profile(inliningTarget, !signed)) {
                throw this.raise(PythonErrorType.OverflowError, ErrorMessages.MESSAGE_CONVERT_NEGATIVE);
            }
            return this.factory().createBytes(ToBytesNode.fromLong(self, byteCount, this.isBigEndian(byteorder), signed, inliningTarget, overflowProfile, this.getRaiseNode()));
        }

        public static byte[] fromLong(long self, int byteCount, boolean isBigEndian, boolean signed, Node inliningTarget, InlinedConditionProfile overflowProfile, PRaiseNode raise) {
            long number;
            int delta;
            int index;
            int signByte = 0;
            if (self < 0L) {
                assert (signed) : ErrorMessages.MESSAGE_CONVERT_NEGATIVE;
                signByte = -1;
            }
            if (isBigEndian) {
                index = byteCount - 1;
                delta = -1;
            } else {
                index = 0;
                delta = 1;
            }
            byte[] bytes = new byte[byteCount];
            for (number = self; number != 0L && 0 <= index && index <= byteCount - 1; number >>= 8, index += delta) {
                bytes[index] = (byte)(number & 0xFFL);
                if (number != (long)signByte) continue;
                number = 0L;
            }
            if (overflowProfile.profile(inliningTarget, !signed && number != 0L || signed && bytes.length == 1 && (long)bytes[0] != self || byteCount == 0 && self != 0L)) {
                throw raise.raise(PythonErrorType.OverflowError, ErrorMessages.MESSAGE_INT_TO_BIG);
            }
            if (signed) {
                while (0 <= index && index <= byteCount - 1) {
                    bytes[index] = signByte;
                    index += delta;
                }
            }
            return bytes;
        }

        @CompilerDirectives.TruffleBoundary
        private static byte getSingByte(BigInteger value, boolean signed, PRaiseNode raise) {
            if (value.compareTo(BigInteger.ZERO) < 0) {
                if (!signed) {
                    throw raise.raise(PythonErrorType.OverflowError, ErrorMessages.MESSAGE_CONVERT_NEGATIVE);
                }
                return -1;
            }
            return 0;
        }

        @CompilerDirectives.TruffleBoundary
        private static byte[] getBytes(BigInteger value) {
            return value.toByteArray();
        }

        @Specialization
        public PBytes fromPIntInt(PInt self, int byteCount, TruffleString byteorder, boolean signed, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile negativeByteCountProfile, @Cached.Exclusive @Cached InlinedConditionProfile overflowProfile) {
            if (negativeByteCountProfile.profile(inliningTarget, byteCount < 0)) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.MESSAGE_LENGTH_ARGUMENT);
            }
            return this.factory().createBytes(ToBytesNode.fromBigInteger(self, byteCount, this.isBigEndian(byteorder), signed, inliningTarget, overflowProfile, this.getRaiseNode()));
        }

        public static byte[] fromBigInteger(PInt self, int byteCount, boolean isBigEndian, boolean signed, Node inliningTarget, InlinedConditionProfile overflowProfile, PRaiseNode raise) {
            int i;
            BigInteger value = self.getValue();
            byte signByte = ToBytesNode.getSingByte(value, signed, raise);
            byte[] bytes = ToBytesNode.getBytes(value);
            if (bytes.length > byteCount) {
                int len = bytes.length;
                int startIndex = 0;
                if (!signed) {
                    for (startIndex = 0; startIndex < bytes.length && bytes[startIndex] == 0; ++startIndex) {
                    }
                    len = Math.max(bytes.length - startIndex, byteCount);
                }
                if (overflowProfile.profile(inliningTarget, len > byteCount)) {
                    throw raise.raise(PythonErrorType.OverflowError, ErrorMessages.MESSAGE_INT_TO_BIG);
                }
                byte[] tmp = bytes;
                bytes = new byte[len];
                PythonUtils.arraycopy(tmp, startIndex, bytes, 0, len);
            }
            if (isBigEndian) {
                if (byteCount > bytes.length) {
                    byte[] resultBytes = new byte[byteCount];
                    PythonUtils.arraycopy(bytes, 0, resultBytes, resultBytes.length - bytes.length, bytes.length);
                    if (signByte == -1) {
                        for (i = 0; i < resultBytes.length - bytes.length; ++i) {
                            resultBytes[i] = signByte;
                        }
                    }
                    return resultBytes;
                }
                return bytes;
            }
            byte[] resultBytes = new byte[byteCount];
            for (i = 0; i < bytes.length; ++i) {
                resultBytes[i] = bytes[bytes.length - 1 - i];
            }
            if (byteCount > bytes.length && signByte == -1) {
                for (i = bytes.length; i < resultBytes.length; ++i) {
                    resultBytes[i] = signByte;
                }
            }
            return resultBytes;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return IntBuiltinsClinicProviders.ToBytesNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }

        @Specialization
        static boolean doII(int left, int right) {
            return left >= right;
        }

        @Specialization
        static boolean doLL(long left, long right) {
            return left >= right;
        }

        @Specialization
        static boolean doLP(long left, PInt right) {
            try {
                return left >= right.longValueExact();
            }
            catch (OverflowException e) {
                return right.doubleValue() < 0.0;
            }
        }

        @Specialization
        static boolean doPL(PInt left, long right) {
            try {
                return left.longValueExact() >= right;
            }
            catch (OverflowException e) {
                return left.doubleValue() > 0.0;
            }
        }

        @Specialization
        static boolean doPP(PInt left, PInt right) {
            return left.compareTo(right) >= 0;
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static boolean doII(int left, int right) {
            return left > right;
        }

        @Specialization
        static boolean doLL(long left, long right) {
            return left > right;
        }

        @Specialization
        static boolean doLP(long left, PInt right) {
            try {
                return left > right.longValueExact();
            }
            catch (OverflowException e) {
                return right.doubleValue() < 0.0;
            }
        }

        @Specialization
        static boolean doPL(PInt left, long right) {
            try {
                return left.longValueExact() > right;
            }
            catch (OverflowException e) {
                return left.doubleValue() > 0.0;
            }
        }

        @Specialization
        static boolean doPP(PInt left, PInt right) {
            return left.compareTo(right) > 0;
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }

        @Specialization
        static boolean doII(int left, int right) {
            return left <= right;
        }

        @Specialization
        static boolean doLL(long left, long right) {
            return left <= right;
        }

        @Specialization
        static boolean doLP(long left, PInt right) {
            try {
                return left <= right.longValueExact();
            }
            catch (OverflowException e) {
                return right.doubleValue() > 0.0;
            }
        }

        @Specialization
        static boolean doPL(PInt left, long right) {
            try {
                return left.longValueExact() <= right;
            }
            catch (OverflowException e) {
                return left.doubleValue() < 0.0;
            }
        }

        @Specialization
        static boolean doPP(PInt left, PInt right) {
            return left.compareTo(right) <= 0;
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={CExtNodes.FromNativeSubclassNode.class})
    public static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static boolean doII(int left, int right) {
            return left < right;
        }

        @Specialization
        static boolean doLL(long left, long right) {
            return left < right;
        }

        @Specialization
        static boolean doLP(long left, PInt right) {
            try {
                return left < right.longValueExact();
            }
            catch (OverflowException e) {
                return right.doubleValue() > 0.0;
            }
        }

        @Specialization
        static boolean doPL(PInt left, long right) {
            try {
                return left.longValueExact() < right;
            }
            catch (OverflowException e) {
                return left.doubleValue() < 0.0;
            }
        }

        @Specialization
        static boolean doPP(PInt left, PInt right) {
            return left.compareTo(right) < 0;
        }

        @Specialization(guards={"isFloatSubtype(frame, inliningTarget, y, getClass, isSubtype)"})
        static boolean doDN(VirtualFrame frame, long x, PythonAbstractNativeObject y, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached.Shared @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeRight) {
            return (double)x < nativeRight.execute(frame, y);
        }

        @Specialization(guards={"isFloatSubtype(frame, inliningTarget, x, getClass, isSubtype)", "isFloatSubtype(frame, inliningTarget, y, getClass, isSubtype)"})
        static boolean doDN(VirtualFrame frame, PythonAbstractNativeObject x, PythonAbstractNativeObject y, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached.Shared @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeLeft, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeRight) {
            return nativeLeft.execute(frame, x) < nativeRight.execute(frame, y);
        }

        @Specialization(guards={"isFloatSubtype(frame, inliningTarget, x, getClass, isSubtype)"})
        static boolean doDN(VirtualFrame frame, PythonAbstractNativeObject x, double y, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode.GetPythonObjectClassNode getClass, @Cached.Shared @Cached IsSubtypeNode isSubtype, @Cached.Shared @Cached CExtNodes.FromNativeSubclassNode nativeLeft) {
            return nativeLeft.execute(frame, x) < y;
        }

        @Specialization
        static boolean doVoidPtr(PythonNativeVoidPtr x, long y, @Cached CExtNodes.PointerCompareNode ltNode) {
            return ltNode.execute(SpecialMethodNames.T___LT__, x, y);
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }

        @Specialization
        static boolean eqLL(long a, long b) {
            return a != b;
        }

        @Specialization(rewriteOn={OverflowException.class})
        static boolean eqPiL(PInt a, long b) throws OverflowException {
            return a.longValueExact() != b;
        }

        @Specialization(replaces={"eqPiL"})
        static boolean eqPiLOvf(PInt a, long b) {
            try {
                return a.longValueExact() != b;
            }
            catch (OverflowException e) {
                return true;
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static boolean eqLPi(long b, PInt a) throws OverflowException {
            return a.longValueExact() != b;
        }

        @Specialization(replaces={"eqLPi"})
        static boolean eqLPiOvf(long b, PInt a) {
            try {
                return a.longValueExact() != b;
            }
            catch (OverflowException e) {
                return true;
            }
        }

        @Specialization
        static boolean eqPiPi(PInt a, PInt b) {
            return a.compareTo(b) != 0;
        }

        @Fallback
        static PNotImplemented eq(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static boolean eqLL(long a, long b) {
            return a == b;
        }

        @Specialization
        static boolean eqPIntBoolean(PInt a, boolean b) {
            return b ? a.isOne() : a.isZero();
        }

        @Specialization
        static boolean eqBooleanPInt(boolean a, PInt b) {
            return a ? b.isOne() : b.isZero();
        }

        @Specialization(rewriteOn={OverflowException.class})
        static boolean eqPiL(PInt a, long b) throws OverflowException {
            return a.longValueExact() == b;
        }

        @Specialization
        static boolean eqPiLOvf(PInt a, long b) {
            try {
                return a.longValueExact() == b;
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        static boolean eqLPi(long b, PInt a) throws OverflowException {
            return a.longValueExact() == b;
        }

        @Specialization
        static boolean eqPiLOvf(long b, PInt a) {
            try {
                return a.longValueExact() == b;
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Specialization
        static boolean eqPiPi(PInt a, PInt b) {
            return a.compareTo(b) == 0;
        }

        @Specialization
        static boolean eqLongVoidPtr(VirtualFrame frame, long a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            return EqNode.eqVoidPtrLong(frame, b, a, inliningTarget, hashNode);
        }

        @Specialization
        static boolean eqPIntVoidPtr(PInt a, PythonNativeVoidPtr b) {
            return EqNode.eqVoidPtrPInt(b, a);
        }

        @Specialization
        static boolean eqVoidPtrLong(VirtualFrame frame, PythonNativeVoidPtr a, long b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            if (a.isNativePointer()) {
                long ptrVal = a.getNativePointer();
                return ptrVal == b;
            }
            return hashNode.execute((Frame)frame, inliningTarget, a) == b;
        }

        @Specialization(guards={"a.isNativePointer()", "b.isNativePointer()"})
        static boolean voidPtrsNative(PythonNativeVoidPtr a, PythonNativeVoidPtr b) {
            long ptrVal = a.getNativePointer();
            return ptrVal == b.getNativePointer();
        }

        @Specialization(guards={"a.isNativePointer()", "!b.isNativePointer()"})
        static boolean voidPtrsANative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            long ptrVal = a.getNativePointer();
            return ptrVal == hashNode.execute((Frame)frame, inliningTarget, b);
        }

        @Specialization(guards={"!a.isNativePointer()", "b.isNativePointer()"})
        static boolean voidPtrsBNative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            long ptrVal = b.getNativePointer();
            return ptrVal == hashNode.execute((Frame)frame, inliningTarget, a);
        }

        @Specialization(guards={"!a.isNativePointer()", "!b.isNativePointer()"})
        static boolean voidPtrsManaged(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            return hashNode.execute((Frame)frame, inliningTarget, a) == hashNode.execute((Frame)frame, inliningTarget, b);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static boolean eqVoidPtrPInt(PythonNativeVoidPtr a, PInt b) {
            if (a.isNativePointer()) {
                long ptrVal = a.getNativePointer();
                if (ptrVal < 0L) {
                    BigInteger bi = PInt.longToBigInteger(ptrVal).add(BigInteger.ONE.shiftLeft(64));
                    return bi.equals(b.getValue());
                }
                return PInt.longToBigInteger(ptrVal).equals(b.getValue());
            }
            try {
                return PyObjectHashNode.executeUncached(a) == b.longValueExact();
            }
            catch (OverflowException e) {
                return false;
            }
        }

        @Fallback
        static PNotImplemented eq(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rxor__", minNumOfPositionalArgs=2), @Builtin(name="__xor__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class XorNode
    extends BinaryBitwiseNode {
        @Override
        protected int op(int left, int right) {
            return left ^ right;
        }

        @Override
        protected long op(long left, long right) {
            return left ^ right;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public BigInteger op(BigInteger left, BigInteger right) {
            return left.xor(right);
        }

        @NeverDefault
        public static XorNode create() {
            return IntBuiltinsFactory.XorNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__ror__", minNumOfPositionalArgs=2), @Builtin(name="__or__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class OrNode
    extends BinaryBitwiseNode {
        @Override
        protected int op(int left, int right) {
            return left | right;
        }

        @Override
        protected long op(long left, long right) {
            return left | right;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        public final BigInteger op(BigInteger left, BigInteger right) {
            return left.or(right);
        }

        @NeverDefault
        public static OrNode create() {
            return IntBuiltinsFactory.OrNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rand__", minNumOfPositionalArgs=2), @Builtin(name="__and__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class AndNode
    extends BinaryBitwiseNode {
        @Override
        protected int op(int left, int right) {
            return left & right;
        }

        @Override
        protected long op(long left, long right) {
            return left & right;
        }

        @Override
        @CompilerDirectives.TruffleBoundary
        protected final BigInteger op(BigInteger left, BigInteger right) {
            return left.and(right);
        }

        @NeverDefault
        public static AndNode create() {
            return IntBuiltinsFactory.AndNodeFactory.create();
        }
    }

    static abstract class BinaryBitwiseNode
    extends PythonBinaryBuiltinNode {
        BinaryBitwiseNode() {
        }

        protected int op(int left, int right) {
            throw CompilerDirectives.shouldNotReachHere((String)"should not reach here");
        }

        protected long op(long left, long right) {
            throw CompilerDirectives.shouldNotReachHere((String)"should not reach here");
        }

        protected BigInteger op(BigInteger left, BigInteger right) {
            throw CompilerDirectives.shouldNotReachHere((String)"should not reach here");
        }

        @Specialization
        int doInteger(int left, int right) {
            return this.op(left, right);
        }

        @Specialization
        long doInteger(long left, long right) {
            return this.op(left, right);
        }

        @Specialization(guards={"a.isNativePointer()"})
        Object opVoidNativePtrLong(PythonNativeVoidPtr a, long b) {
            if (a.isNativePointer()) {
                return this.op(a.getNativePointer(), b);
            }
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"!a.isNativePointer()"})
        Object opVoidPtrLong(VirtualFrame frame, PythonNativeVoidPtr a, long b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            return this.op(hashNode.execute((Frame)frame, inliningTarget, a), b);
        }

        @Specialization(guards={"a.isNativePointer()", "b.isNativePointer()"})
        long voidPtrsNative(PythonNativeVoidPtr a, PythonNativeVoidPtr b) {
            long ptrVal = a.getNativePointer();
            return this.op(ptrVal, b.getNativePointer());
        }

        @Specialization(guards={"a.isNativePointer()", "!b.isNativePointer()"})
        long voidPtrsANative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            long ptrVal = a.getNativePointer();
            return this.op(ptrVal, hashNode.execute((Frame)frame, inliningTarget, b));
        }

        @Specialization(guards={"!a.isNativePointer()", "b.isNativePointer()"})
        long voidPtrsBNative(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            long ptrVal = b.getNativePointer();
            return this.op(ptrVal, hashNode.execute((Frame)frame, inliningTarget, a));
        }

        @Specialization(guards={"!a.isNativePointer()", "!b.isNativePointer()"})
        long voidPtrsManaged(VirtualFrame frame, PythonNativeVoidPtr a, PythonNativeVoidPtr b, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="h") @Cached PyObjectHashNode hashNode) {
            return this.op(hashNode.execute((Frame)frame, inliningTarget, a), hashNode.execute((Frame)frame, inliningTarget, b));
        }

        @Specialization
        PInt doPInt(long left, PInt right) {
            return this.factory().createInt(this.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization
        PInt doPInt(PInt left, long right) {
            return this.factory().createInt(this.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization
        PInt doPInt(PInt left, PInt right) {
            return this.factory().createInt(this.op(left.getValue(), right.getValue()));
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }
    }

    @Builtins(value={@Builtin(name="__rshift__", minNumOfPositionalArgs=2), @Builtin(name="__rrshift__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class RShiftNode
    extends PythonBinaryBuiltinNode {
        public abstract int executeInt(int var1, int var2) throws UnexpectedResultException;

        public abstract Object execute(int var1, int var2);

        @Specialization(guards={"right < 32"})
        int doIISmall(int left, int right) {
            this.raiseNegativeShiftCount(right < 0);
            return left >> right;
        }

        @Specialization(replaces={"doIISmall"})
        int doII(int left, int right) {
            this.raiseNegativeShiftCount(right < 0);
            return left >> (right >= 32 ? 31 : right);
        }

        @Specialization(guards={"right < 64"})
        long doLLSmall(long left, long right) {
            this.raiseNegativeShiftCount(right < 0L);
            return left >> (int)right;
        }

        @Specialization(replaces={"doLLSmall"})
        long doLL(long left, long right) {
            this.raiseNegativeShiftCount(right < 0L);
            return left >> (int)(right >= 64L ? 63L : right);
        }

        @Specialization
        Object doIPi(int left, PInt right) {
            return this.doHugeShift(PInt.longToBigInteger(left), right);
        }

        @Specialization
        Object doLPi(long left, PInt right) {
            return this.doHugeShift(PInt.longToBigInteger(left), right);
        }

        @Specialization
        PInt doPiI(PInt left, int right) {
            this.raiseNegativeShiftCount(right < 0);
            return this.factory().createInt(RShiftNode.op(left.getValue(), right));
        }

        @Specialization
        Object doPiL(PInt left, long right) {
            this.raiseNegativeShiftCount(right < 0L);
            int rightI = (int)right;
            if ((long)rightI == right) {
                return this.factory().createInt(RShiftNode.op(left.getValue(), rightI));
            }
            return left.isNegative() ? -1 : 0;
        }

        @Specialization
        Object doPInt(PInt left, PInt right) {
            return this.doHugeShift(left.getValue(), right);
        }

        private void raiseNegativeShiftCount(boolean cond) {
            if (cond) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SHIFT_COUNT);
            }
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        private Object doHugeShift(BigInteger left, PInt right) {
            this.raiseNegativeShiftCount(!right.isZeroOrPositive());
            try {
                return this.factory().createInt(RShiftNode.op(left, right.intValueExact()));
            }
            catch (OverflowException e) {
                return left.signum() < 0 ? -1 : 0;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(BigInteger left, int right) {
            return left.shiftRight(right);
        }

        @NeverDefault
        public static RShiftNode create() {
            return IntBuiltinsFactory.RShiftNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__lshift__", minNumOfPositionalArgs=2), @Builtin(name="__rlshift__", minNumOfPositionalArgs=2, reverseOperation=true)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class LShiftNode
    extends PythonBinaryBuiltinNode {
        public abstract int executeInt(int var1, int var2) throws UnexpectedResultException;

        public abstract Object execute(int var1, int var2);

        private long leftShiftExact(long left, long right) throws OverflowException {
            long result;
            if (right >= 64L || right < 0L) {
                this.shiftError(right);
            }
            if (left != (result = left << (int)right) >> (int)right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        private int leftShiftExact(int left, int right) throws OverflowException {
            int result;
            if (right >= 32 || right < 0) {
                this.shiftError(right);
            }
            if (left != (result = left << right) >> right) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        private void shiftError(long shiftCount) throws OverflowException {
            if (shiftCount >= 32L) {
                throw OverflowException.INSTANCE;
            }
            if (shiftCount < 0L) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SHIFT_COUNT);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        int doII(int left, int right) throws OverflowException {
            this.raiseNegativeShiftCount(right < 0);
            return this.leftShiftExact(left, right);
        }

        @Specialization
        Object doIIOvf(int left, int right) {
            this.raiseNegativeShiftCount(right < 0);
            try {
                return this.leftShiftExact(left, right);
            }
            catch (OverflowException e) {
                return this.doGuardedBiI(PInt.longToBigInteger(left), right);
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        long doLL(long left, long right) throws OverflowException {
            this.raiseNegativeShiftCount(right < 0L);
            return this.leftShiftExact(left, right);
        }

        @Specialization
        Object doILOvf(int left, long right) {
            return this.doLLOvf(left, right);
        }

        @Specialization
        Object doLIOvf(long left, int right) {
            return this.doLLOvf(left, right);
        }

        @Specialization
        Object doLLOvf(long left, long right) {
            this.raiseNegativeShiftCount(right < 0L);
            try {
                return this.leftShiftExact(left, right);
            }
            catch (OverflowException e) {
                int rightI = (int)right;
                if ((long)rightI == right) {
                    try {
                        return this.factory().createInt(LShiftNode.op(PInt.longToBigInteger(left), rightI));
                    }
                    catch (OverflowException overflowException) {
                        // empty catch block
                    }
                }
                throw this.raise(PythonErrorType.OverflowError);
            }
        }

        @Specialization(guards={"left == 0", "right.isZeroOrPositive()"})
        static int doIPiZero(int left, PInt right) {
            return 0;
        }

        @Specialization(replaces={"doIPiZero"})
        PInt doIPi(int left, PInt right) {
            this.raiseNegativeShiftCount(!right.isZeroOrPositive());
            if (left == 0) {
                return this.factory().createInt(BigInteger.ZERO);
            }
            try {
                int iright = right.intValueExact();
                return this.factory().createInt(LShiftNode.op(PInt.longToBigInteger(left), iright));
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError);
            }
        }

        @Specialization(guards={"left == 0", "right.isZeroOrPositive()"})
        static int doLPiZero(long left, PInt right) {
            return 0;
        }

        @Specialization(replaces={"doLPiZero"})
        PInt doLPi(long left, PInt right) {
            this.raiseNegativeShiftCount(!right.isZeroOrPositive());
            if (left == 0L) {
                return this.factory().createInt(BigInteger.ZERO);
            }
            try {
                int iright = right.intValueExact();
                return this.factory().createInt(LShiftNode.op(PInt.longToBigInteger(left), iright));
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError);
            }
        }

        @Specialization
        PInt doPiI(PInt left, int right) {
            this.raiseNegativeShiftCount(right < 0);
            return this.doGuardedBiI(left.getValue(), right);
        }

        protected PInt doGuardedBiI(BigInteger left, int right) {
            try {
                return this.factory().createInt(LShiftNode.op(left, right));
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError);
            }
        }

        @Specialization
        PInt doPiL(PInt left, long right) {
            int rightI = (int)right;
            if ((long)rightI == right) {
                return this.doPiI(left, rightI);
            }
            throw this.raise(PythonErrorType.OverflowError);
        }

        @Specialization(guards={"left.isZero()", "right.isZeroOrPositive()"})
        static int doPiPiZero(PInt left, PInt right) {
            return 0;
        }

        @Specialization(replaces={"doPiPiZero"})
        PInt doPiPi(PInt left, PInt right) {
            this.raiseNegativeShiftCount(!right.isZeroOrPositive());
            if (left.isZero()) {
                return this.factory().createInt(BigInteger.ZERO);
            }
            try {
                return this.factory().createInt(LShiftNode.op(left.getValue(), right.intValueExact()));
            }
            catch (OverflowException e) {
                throw this.raise(PythonErrorType.OverflowError);
            }
        }

        @Fallback
        static PNotImplemented doGeneric(Object a, Object b) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @CompilerDirectives.TruffleBoundary
        public static BigInteger op(BigInteger left, int right) throws OverflowException {
            try {
                return left.shiftLeft(right);
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        private void raiseNegativeShiftCount(boolean cond) {
            if (cond) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SHIFT_COUNT);
            }
        }

        @NeverDefault
        public static LShiftNode create() {
            return IntBuiltinsFactory.LShiftNodeFactory.create();
        }
    }

    @Builtin(name="__invert__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class InvertNode
    extends PythonUnaryBuiltinNode {
        InvertNode() {
        }

        @Specialization
        static int neg(boolean arg) {
            return ~(arg ? 1 : 0);
        }

        @Specialization
        static int neg(int arg) {
            return ~arg;
        }

        @Specialization
        static long neg(long arg) {
            return arg ^ 0xFFFFFFFFFFFFFFFFL;
        }

        @Specialization
        PInt doPInt(PInt operand) {
            return this.factory().createInt(InvertNode.not(operand.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger not(BigInteger value) {
            return value.not();
        }
    }

    @Builtin(name="__neg__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class NegNode
    extends PythonUnaryBuiltinNode {
        public abstract Object execute(int var1);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int neg(int arg) {
            return Math.negateExact(arg);
        }

        @Specialization
        static long negOvf(int arg) {
            return -((long)arg);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long neg(long arg) {
            return Math.negateExact(arg);
        }

        @Specialization
        PInt negOvf(long arg) {
            BigInteger value = arg == Long.MIN_VALUE ? NegNode.negate(PInt.longToBigInteger(arg)) : PInt.longToBigInteger(-arg);
            return this.factory().createInt(value);
        }

        @Specialization
        PInt doPInt(PInt operand) {
            return this.factory().createInt(NegNode.negate(operand.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger negate(BigInteger value) {
            return value.negate();
        }

        @NeverDefault
        public static NegNode create() {
            return IntBuiltinsFactory.NegNodeFactory.create();
        }
    }

    @Builtin(name="__pos__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class PosNode
    extends PythonUnaryBuiltinNode {
        PosNode() {
        }

        @Specialization
        static int pos(int arg) {
            return arg;
        }

        @Specialization
        static long pos(long arg) {
            return arg;
        }

        @Specialization
        PInt pos(PInt arg) {
            return this.factory().createInt(arg.getValue());
        }
    }

    @Builtin(name="__floor__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class FloorNode
    extends PythonUnaryBuiltinNode {
        FloorNode() {
        }

        @Specialization
        static int floor(int arg) {
            return arg;
        }

        @Specialization
        static long floor(long arg) {
            return arg;
        }

        @Specialization
        PInt floor(PInt arg) {
            return this.factory().createInt(arg.getValue());
        }
    }

    @Builtin(name="__ceil__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class CeilNode
    extends PythonUnaryBuiltinNode {
        CeilNode() {
        }

        @Specialization
        static int ceil(int arg) {
            return arg;
        }

        @Specialization
        static long ceil(long arg) {
            return arg;
        }

        @Specialization
        static PInt ceil(PInt arg) {
            return arg;
        }
    }

    @Builtin(name="__abs__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class AbsNode
    extends PythonUnaryBuiltinNode {
        AbsNode() {
        }

        @Specialization
        static int absBoolean(boolean arg) {
            return arg ? 1 : 0;
        }

        @Specialization(rewriteOn={ArithmeticException.class, OverflowException.class})
        static int absInt(int arg) throws OverflowException {
            int result = Math.abs(arg);
            if (result < 0) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        @Specialization(replaces={"absInt"})
        static long absIntOvf(int arg) {
            return Math.abs((long)arg);
        }

        @Specialization(rewriteOn={ArithmeticException.class, OverflowException.class})
        static long absLong(long arg) throws OverflowException {
            long result = Math.abs(arg);
            if (result < 0L) {
                throw OverflowException.INSTANCE;
            }
            return result;
        }

        @Specialization(replaces={"absLong"})
        PInt absLongOvf(long arg) {
            long result = Math.abs(arg);
            if (result < 0L) {
                return this.factory().createInt(AbsNode.absBigInteger(PInt.longToBigInteger(arg)));
            }
            return this.factory().createInt(PInt.longToBigInteger(arg));
        }

        @Specialization
        PInt absPInt(PInt arg) {
            return this.factory().createInt(AbsNode.absBigInteger(arg.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger absBigInteger(BigInteger value) {
            return value.abs();
        }
    }

    @Builtins(value={@Builtin(name="__rpow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3, reverseOperation=true), @Builtin(name="__pow__", minNumOfPositionalArgs=2, maxNumOfPositionalArgs=3)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @ImportStatic(value={MathGuards.class})
    @ReportPolymorphism
    public static abstract class PowNode
    extends PythonTernaryBuiltinNode {
        protected abstract int executeInt(int var1, int var2, PNone var3) throws UnexpectedResultException;

        protected abstract Object execute(int var1, int var2, PNone var3);

        public final int executeInt(int left, int right) throws UnexpectedResultException {
            return this.executeInt(left, right, PNone.NO_VALUE);
        }

        public final Object execute(int left, int right) {
            return this.execute(left, right, PNone.NO_VALUE);
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={ArithmeticException.class})
        static int doIIFast(int left, int right, PNone none) {
            int result = 1;
            int exponent = right;
            int base = left;
            while (exponent != 0) {
                if ((exponent & 1) != 0) {
                    result = Math.multiplyExact(result, base);
                }
                if ((exponent >>= 1) == 0) continue;
                base = Math.multiplyExact(base, base);
            }
            return result;
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={ArithmeticException.class})
        static long doLLFast(long left, long right, PNone none) {
            long result = 1L;
            long exponent = right;
            long base = left;
            while (exponent != 0L) {
                if ((exponent & 1L) != 0L) {
                    result = Math.multiplyExact(result, base);
                }
                if ((exponent >>= 1) == 0L) continue;
                base = Math.multiplyExact(base, base);
            }
            return result;
        }

        @Specialization(guards={"right >= 0"}, replaces={"doLLFast"})
        PInt doLLPos(long left, long right, PNone none) {
            return this.factory().createInt(this.op(PInt.longToBigInteger(left), right));
        }

        @Specialization(guards={"right < 0"})
        double doLLNeg(long left, long right, PNone none, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="leftIsZero") @Cached InlinedConditionProfile leftIsZero) {
            if (leftIsZero.profile(inliningTarget, left == 0L)) {
                throw this.raise(PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return Math.pow(left, right);
        }

        @Specialization(rewriteOn={OverflowException.class, ArithmeticException.class})
        Object doLPNarrow(long left, PInt right, PNone none, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="leftIsZero") @Cached InlinedConditionProfile leftIsZero) throws OverflowException {
            long lright = right.longValueExact();
            if (lright >= 0L) {
                return PowNode.doLLFast(left, lright, none);
            }
            return this.doLLNeg(left, lright, none, inliningTarget, leftIsZero);
        }

        @Specialization(replaces={"doLPNarrow"})
        Object doLP(long left, PInt right, PNone none) {
            Object result = this.op(PInt.longToBigInteger(left), right.getValue());
            if (result instanceof BigInteger) {
                return this.factory().createInt((BigInteger)result);
            }
            return result;
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={OverflowException.class})
        long doPLNarrow(PInt left, long right, PNone none) throws OverflowException {
            return PInt.longValueExact(this.op(left.getValue(), right));
        }

        @Specialization(guards={"right >= 0"}, replaces={"doPLNarrow"})
        PInt doPLPos(PInt left, long right, PNone none) {
            return this.factory().createInt(this.op(left.getValue(), right));
        }

        @Specialization(guards={"right < 0"})
        double doPLNeg(PInt left, long right, PNone none, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="leftIsZero") @Cached InlinedConditionProfile leftIsZero) {
            if (leftIsZero.profile(inliningTarget, left.isZero())) {
                throw this.raise(PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            return TrueDivNode.op(BigInteger.ONE, this.op(left.getValue(), -right), this.getRaiseNode());
        }

        @Specialization
        Object doPP(PInt left, PInt right, PNone none) {
            Object result = this.op(left.getValue(), right.getValue());
            if (result instanceof BigInteger) {
                return this.factory().createInt((BigInteger)result);
            }
            return result;
        }

        @Specialization(guards={"right >= 0", "mod > 0"})
        static long doLLPosLPos(long left, long right, long mod) {
            try {
                return PInt.longValueExact(PowNode.op(left, right, mod));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }

        @Specialization(guards={"right >= 0"}, replaces={"doLLPosLPos"})
        long doLLPosLGeneric(long left, long right, long mod, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile errorProfile, @Cached.Exclusive @Cached InlinedConditionProfile modNegativeProfile) {
            if (errorProfile.profile(inliningTarget, mod == 0L)) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.POW_THIRD_ARG_CANNOT_BE_ZERO);
            }
            try {
                if (modNegativeProfile.profile(inliningTarget, mod < 0L)) {
                    return PInt.longValueExact(PowNode.opNeg(left, right, mod));
                }
                return PInt.longValueExact(PowNode.op(left, right, mod));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new IllegalStateException();
            }
        }

        @Specialization(replaces={"doPP"})
        Object powModulo(Object x, Object y, Object z) {
            Object result;
            if (!MathGuards.isInteger(x) || !MathGuards.isInteger(y)) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (z instanceof PNone) {
                result = this.objectOp(x, y);
            } else if (MathGuards.isInteger(z)) {
                result = this.objectOp(x, y, z);
            } else {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            if (result instanceof BigInteger) {
                return this.factory().createInt((BigInteger)result);
            }
            return result;
        }

        @CompilerDirectives.TruffleBoundary
        private Object objectOp(Object left, Object right) {
            BigInteger bigLeft = PowNode.integerToBigInteger(left);
            BigInteger bigRight = PowNode.integerToBigInteger(right);
            return this.op(bigLeft, bigRight);
        }

        @CompilerDirectives.TruffleBoundary
        private Object objectOp(Object left, Object right, Object mod) {
            BigInteger bigLeft = PowNode.integerToBigInteger(left);
            BigInteger bigRight = PowNode.integerToBigInteger(right);
            BigInteger bigMod = PowNode.integerToBigInteger(mod);
            if (bigMod.signum() == 0) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.POW_THIRD_ARG_CANNOT_BE_ZERO);
            }
            BigInteger bigModPos = bigMod.signum() < 0 ? bigMod.abs() : bigMod;
            try {
                BigInteger pow = bigLeft.modPow(bigRight, bigModPos);
                if (bigModPos != bigMod && !BigInteger.ZERO.equals(pow)) {
                    return pow.subtract(bigModPos);
                }
                return pow;
            }
            catch (ArithmeticException e) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.POW_BASE_NOT_INVERTIBLE);
            }
        }

        private static BigInteger integerToBigInteger(Object value) {
            if (value instanceof Boolean) {
                return (Boolean)value != false ? BigInteger.ONE : BigInteger.ZERO;
            }
            if (value instanceof Integer) {
                return BigInteger.valueOf(((Integer)value).intValue());
            }
            if (value instanceof Long) {
                return BigInteger.valueOf((Long)value);
            }
            if (value instanceof PInt) {
                return ((PInt)value).getValue();
            }
            throw CompilerDirectives.shouldNotReachHere((String)"never reached");
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(long left, long right, long mod) {
            assert (mod > 0L);
            assert (right >= 0L);
            return BigInteger.valueOf(left).modPow(BigInteger.valueOf(right), BigInteger.valueOf(mod));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger opNeg(long left, long right, long mod) {
            assert (mod < 0L);
            BigInteger modPos = BigInteger.valueOf(-mod);
            BigInteger pow = right == 0L ? BigInteger.ONE : BigInteger.valueOf(left).modPow(BigInteger.valueOf(right), modPos);
            if (!BigInteger.ZERO.equals(pow)) {
                return pow.subtract(modPos);
            }
            return pow;
        }

        @CompilerDirectives.TruffleBoundary
        private Object op(BigInteger left, BigInteger right) {
            if (right.signum() >= 0) {
                try {
                    return this.op(left, right.longValueExact());
                }
                catch (ArithmeticException e) {
                    return this.op(left, Long.MAX_VALUE);
                }
            }
            if (left.signum() == 0) {
                throw this.raise(PythonBuiltinClassType.ZeroDivisionError, ErrorMessages.POW_ZERO_CANNOT_RAISE_TO_NEGATIVE_POWER);
            }
            try {
                return Math.pow(left.longValueExact(), right.longValueExact());
            }
            catch (ArithmeticException e) {
                return Math.pow(left.doubleValue(), right.doubleValue());
            }
        }

        @CompilerDirectives.TruffleBoundary
        private BigInteger op(BigInteger a, long b) {
            assert (b >= 0L);
            try {
                int value = a.intValueExact();
                if (value == 0) {
                    if (b == 0L) {
                        return BigInteger.ONE;
                    }
                    return BigInteger.ZERO;
                }
                if (value == 1) {
                    return BigInteger.ONE;
                }
                if (value == -1) {
                    return (b & 1L) != 0L ? PInt.longToBigInteger(-1L) : BigInteger.ONE;
                }
            }
            catch (ArithmeticException arithmeticException) {
                // empty catch block
            }
            if (b != (long)((int)b)) {
                throw this.raise(PythonErrorType.ArithmeticError, ErrorMessages.EXPONENT_TOO_LARGE);
            }
            return a.pow((int)b);
        }

        @NeverDefault
        public static PowNode create() {
            return IntBuiltinsFactory.PowNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rmul__", minNumOfPositionalArgs=2), @Builtin(name="__mul__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class MulNode
    extends PythonBinaryBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int x, int y) throws ArithmeticException {
            return Math.multiplyExact(x, y);
        }

        @Specialization(replaces={"doII"})
        static long doIIL(int x, int y) {
            return (long)x * (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long doLL(long x, long y) {
            return Math.multiplyExact(x, y);
        }

        @Specialization
        Object doLongWithOverflow(long x, long y) {
            long ay;
            long r = x * y;
            long ax = Math.abs(x);
            if ((ax | (ay = Math.abs(y))) >>> 31 != 0L && (y != 0L && r / y != x || x == Long.MIN_VALUE && y == -1L)) {
                return this.factory().createInt(MulNode.mul(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
            }
            return r;
        }

        @Specialization(guards={"right == 0"})
        static int doPIntLongZero(PInt left, long right) {
            return 0;
        }

        @Specialization(guards={"right == 1"})
        PInt doPIntLongOne(PInt left, long right) {
            return this.factory().createInt(left.getValue());
        }

        @Specialization(guards={"right != 0", "right != 1"})
        PInt doPIntLong(PInt left, long right) {
            return this.factory().createInt(MulNode.mul(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization
        PInt doPIntPInt(PInt left, PInt right) {
            return this.factory().createInt(MulNode.mul(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger mul(BigInteger a, BigInteger b) {
            if (!BigInteger.ZERO.equals(b) && b.and(b.subtract(BigInteger.ONE)).equals(BigInteger.ZERO)) {
                return MulNode.bigIntegerShift(a, b.getLowestSetBit());
            }
            return MulNode.bigIntegerMul(a, b);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger bigIntegerMul(BigInteger a, BigInteger b) {
            return a.multiply(b);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger bigIntegerShift(BigInteger a, int n) {
            return a.shiftLeft(n);
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static MulNode create() {
            return IntBuiltinsFactory.MulNodeFactory.create();
        }
    }

    @Builtin(name="__mod__", minNumOfPositionalArgs=2)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class ModNode
    extends IntBinaryBuiltinNode {
        public abstract int executeInt(int var1, int var2) throws UnexpectedResultException;

        public abstract Object execute(int var1, int var2);

        @Specialization
        int doII(int left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0, divisionByZeroProfile);
            return Math.floorMod(left, right);
        }

        @Specialization
        long doLL(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return Math.floorMod(left, right);
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        long doLPiAndNarrow(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return PInt.longValueExact(ModNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, replaces={"doLPiAndNarrow"})
        PInt doLPi(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return this.factory().createInt(ModNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        long doLPiNegativeAndNarrow(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return PInt.longValueExact(ModNode.opNeg(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, replaces={"doLPiNegativeAndNarrow"})
        PInt doLPiNegative(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return this.factory().createInt(ModNode.opNeg(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(guards={"right >= 0"}, rewriteOn={OverflowException.class})
        long doPiLAndNarrow(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return PInt.longValueExact(ModNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right >= 0"}, replaces={"doPiLAndNarrow"})
        PInt doPiL(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return this.factory().createInt(ModNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right < 0"}, rewriteOn={OverflowException.class})
        long doPiLNegAndNarrow(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return PInt.longValueExact(ModNode.opNeg(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right < 0"}, replaces={"doPiLNegAndNarrow"})
        PInt doPiLNeg(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return this.factory().createInt(ModNode.opNeg(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        long doPiPiAndNarrow(PInt left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return PInt.longValueExact(ModNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(guards={"right.isZeroOrPositive()"}, replaces={"doPiPiAndNarrow"})
        PInt doPiPi(PInt left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return this.factory().createInt(ModNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, rewriteOn={OverflowException.class})
        static long doPiPiNegAndNarrow(PInt left, PInt right) throws OverflowException {
            return PInt.longValueExact(ModNode.opNeg(left.getValue(), right.getValue()));
        }

        @Specialization(guards={"!right.isZeroOrPositive()"}, replaces={"doPiPiNegAndNarrow"})
        PInt doPiPiNeg(PInt left, PInt right) {
            return this.factory().createInt(ModNode.opNeg(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger op(BigInteger a, BigInteger b) {
            return a.mod(b);
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger opNeg(BigInteger a, BigInteger b) {
            if (a.signum() == 0) {
                return BigInteger.ZERO;
            }
            BigInteger mod = a.mod(b.negate());
            if (mod.signum() == 0) {
                return BigInteger.ZERO;
            }
            return a.mod(b.negate()).subtract(b.negate());
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static ModNode create() {
            return IntBuiltinsFactory.ModNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rdivmod__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__divmod__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class DivModNode
    extends IntBinaryBuiltinNode {
        DivModNode() {
        }

        @Specialization
        PTuple doLL(int left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0, divisionByZeroProfile);
            return this.factory().createTuple(new Object[]{Math.floorDiv(left, right), Math.floorMod(left, right)});
        }

        @Specialization
        PTuple doLL(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return this.factory().createTuple(new Object[]{Math.floorDiv(left, right), Math.floorMod(left, right)});
        }

        @Specialization(guards={"accepts(left)", "accepts(right)"})
        PTuple doGenericInt(VirtualFrame frame, Object left, Object right, @Cached FloorDivNode floorDivNode, @Cached ModNode modNode) {
            return this.factory().createTuple(new Object[]{floorDivNode.execute(frame, left, right), modNode.execute(frame, left, right)});
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        protected static boolean accepts(Object obj) {
            return obj instanceof Integer || obj instanceof Long || obj instanceof PInt;
        }
    }

    @Builtins(value={@Builtin(name="__rfloordiv__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__floordiv__", minNumOfPositionalArgs=2)})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    public static abstract class FloorDivNode
    extends IntBinaryBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization
        int doII(int left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0, divisionByZeroProfile);
            return Math.floorDiv(left, right);
        }

        @Specialization(rewriteOn={OverflowException.class})
        long doLL(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            if (left == Long.MIN_VALUE && right == -1L) {
                throw OverflowException.INSTANCE;
            }
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return Math.floorDiv(left, right);
        }

        @Specialization(replaces={"doLL"})
        PInt doLLOverflow(long left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            return this.doPiPi(this.factory().createInt(left), this.factory().createInt(right), inliningTarget, divisionByZeroProfile);
        }

        @Specialization(rewriteOn={OverflowException.class})
        int doIPi(int left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return Math.floorDiv(left, right.intValueExact());
        }

        @Specialization(replaces={"doIPi"})
        int doIPiOvf(int left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            try {
                return Math.floorDiv(left, right.intValueExact());
            }
            catch (OverflowException e) {
                return left < 0 == right.isNegative() ? 0 : -1;
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        long doLPi(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return Math.floorDiv(left, right.longValueExact());
        }

        @Specialization(replaces={"doLPi"})
        long doLPiOvf(long left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            try {
                return Math.floorDiv(left, right.longValueExact());
            }
            catch (OverflowException e) {
                return left < 0L == right.isNegative() ? 0L : -1L;
            }
        }

        @Specialization(rewriteOn={OverflowException.class})
        long doPiIAndNarrow(PInt left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right == 0, divisionByZeroProfile);
            return PInt.longValueExact(FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPiIAndNarrow"})
        PInt doPiI(PInt left, int right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0, divisionByZeroProfile);
            return this.factory().createInt(FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        long doPiLAndNarrow(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return PInt.longValueExact(FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPiLAndNarrow"})
        PInt doPiL(PInt left, long right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right == 0L, divisionByZeroProfile);
            return this.factory().createInt(FloorDivNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        long doPiPiAndNarrow(PInt left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) throws OverflowException {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return PInt.longValueExact(FloorDivNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(replaces={"doPiPiAndNarrow"})
        PInt doPiPi(PInt left, PInt right, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedBranchProfile divisionByZeroProfile) {
            this.raiseDivisionByZero(inliningTarget, right.isZero(), divisionByZeroProfile);
            return this.factory().createInt(FloorDivNode.op(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger op(BigInteger left, BigInteger right) {
            BigInteger r = left.divide(right);
            if (left.xor(right).signum() < 0 && r.multiply(right).compareTo(left) != 0) {
                r = r.subtract(BigInteger.ONE);
            }
            return r;
        }

        @Fallback
        static PNotImplemented doGeneric(Object right, Object left) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static FloorDivNode create() {
            return IntBuiltinsFactory.FloorDivNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rtruediv__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__truediv__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class TrueDivNode
    extends PythonBinaryBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization
        double divII(int x, int y) {
            return this.divDD(x, y);
        }

        @Specialization(guards={"fitsIntoDouble(x)", "fitsIntoDouble(y)"})
        double divLL(long x, long y) {
            return this.divDD(x, y);
        }

        @Specialization(guards={"!fitsIntoDouble(x) || !fitsIntoDouble(y)"})
        double divLLLarge(long x, long y) {
            if (y == 0L) {
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(PInt.longToBigInteger(x), PInt.longToBigInteger(y), this.getRaiseNode());
        }

        double divDD(double x, double y) {
            if (y == 0.0) {
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return x / y;
        }

        @Specialization
        double doPI(long left, PInt right) {
            if (right.isZero()) {
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(PInt.longToBigInteger(left), right.getValue(), this.getRaiseNode());
        }

        @Specialization
        double doPL(PInt left, long right) {
            if (right == 0L) {
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(left.getValue(), PInt.longToBigInteger(right), this.getRaiseNode());
        }

        @Specialization
        double doPP(PInt left, PInt right) {
            if (right.isZero()) {
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.DIVISION_BY_ZERO);
            }
            return TrueDivNode.op(left.getValue(), right.getValue(), this.getRaiseNode());
        }

        @CompilerDirectives.TruffleBoundary
        private static double op(BigInteger a, BigInteger b, PRaiseNode raiseNode) {
            int precisionOfDouble = 17;
            if (TrueDivNode.fitsIntoDouble(a) && TrueDivNode.fitsIntoDouble(b)) {
                return a.doubleValue() / b.doubleValue();
            }
            BigDecimal aDecimal = new BigDecimal(a);
            BigDecimal bDecimal = new BigDecimal(b);
            int aPrec = aDecimal.precision();
            int bPrec = bDecimal.precision();
            BigDecimal result = aDecimal.divide(bDecimal, bPrec - aPrec + 17, RoundingMode.HALF_EVEN);
            double d = result.doubleValue();
            if (Double.isInfinite(d)) {
                throw raiseNode.raise(PythonErrorType.OverflowError, ErrorMessages.INTEGER_DIVISION_RESULT_TOO_LARGE);
            }
            return d;
        }

        protected static boolean fitsIntoDouble(long x) {
            return x < 0x10000000000000L && x > -4503599627370496L;
        }

        private static boolean fitsIntoDouble(BigInteger x) {
            return x.bitLength() < 53;
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static TrueDivNode create() {
            return IntBuiltinsFactory.TrueDivNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__rsub__", minNumOfPositionalArgs=2, reverseOperation=true), @Builtin(name="__sub__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class SubNode
    extends PythonBinaryBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int doII(int x, int y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization
        static long doIIOvf(int x, int y) {
            return (long)x - (long)y;
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long doLL(long x, long y) throws ArithmeticException {
            return Math.subtractExact(x, y);
        }

        @Specialization
        Object doLongWithOverflow(long x, long y) {
            long r = x - y;
            if (((x ^ y) & (x ^ r)) < 0L) {
                return this.factory().createInt(SubNode.op(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
            }
            return r;
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPIntLongAndNarrow(PInt left, long right) throws OverflowException {
            return PInt.longValueExact(SubNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"doPIntLongAndNarrow"})
        PInt doPIntLong(PInt left, long right) {
            return this.factory().createInt(SubNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doLongPIntAndNarrow(long left, PInt right) throws OverflowException {
            return PInt.longValueExact(SubNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(replaces={"doLongPIntAndNarrow"})
        PInt doLongPInt(long left, PInt right) {
            return this.factory().createInt(SubNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static long doPIntPIntAndNarrow(PInt left, PInt right) throws OverflowException {
            return PInt.longValueExact(SubNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(replaces={"doPIntPIntAndNarrow"})
        PInt doPIntPInt(PInt left, PInt right) {
            return this.factory().createInt(SubNode.op(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger op(BigInteger left, BigInteger right) {
            return left.subtract(right);
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static SubNode create() {
            return IntBuiltinsFactory.SubNodeFactory.create();
        }
    }

    @Builtins(value={@Builtin(name="__radd__", minNumOfPositionalArgs=2), @Builtin(name="__add__", minNumOfPositionalArgs=2)})
    @GenerateNodeFactory
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    public static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        public abstract Object execute(int var1, int var2);

        @Specialization(rewriteOn={ArithmeticException.class})
        static int add(int left, int right) {
            return Math.addExact(left, right);
        }

        @Specialization(rewriteOn={ArithmeticException.class})
        static long addLong(long left, long right) {
            return Math.addExact(left, right);
        }

        @Specialization
        Object addLongWithOverflow(long x, long y) {
            long r = x + y;
            if (((x ^ r) & (y ^ r)) < 0L) {
                return this.factory().createInt(AddNode.op(PInt.longToBigInteger(x), PInt.longToBigInteger(y)));
            }
            return r;
        }

        @Specialization(rewriteOn={OverflowException.class})
        static Object addPIntLongAndNarrow(PInt left, long right) throws OverflowException {
            return PInt.longValueExact(AddNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(replaces={"addPIntLongAndNarrow"})
        Object addPIntLong(PInt left, long right) {
            return this.factory().createInt(AddNode.op(left.getValue(), PInt.longToBigInteger(right)));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static Object addLongPIntAndNarrow(long left, PInt right) throws OverflowException {
            return PInt.longValueExact(AddNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(replaces={"addLongPIntAndNarrow"})
        Object addLongPInt(long left, PInt right) {
            return this.factory().createInt(AddNode.op(PInt.longToBigInteger(left), right.getValue()));
        }

        @Specialization(rewriteOn={OverflowException.class})
        static Object addPIntPIntAndNarrow(PInt left, PInt right) throws OverflowException {
            return PInt.longValueExact(AddNode.op(left.getValue(), right.getValue()));
        }

        @Specialization(replaces={"addPIntPIntAndNarrow"})
        Object addPIntPInt(PInt left, PInt right) {
            return this.factory().createInt(AddNode.op(left.getValue(), right.getValue()));
        }

        @CompilerDirectives.TruffleBoundary
        static BigInteger op(BigInteger left, BigInteger right) {
            return left.add(right);
        }

        @Fallback
        static PNotImplemented doGeneric(Object left, Object right) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @NeverDefault
        public static AddNode create() {
            return IntBuiltinsFactory.AddNodeFactory.create();
        }
    }

    @Builtin(name="__round__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    @ImportStatic(value={MathGuards.class})
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    static abstract class RoundNode
    extends PythonBinaryBuiltinNode {
        RoundNode() {
        }

        @Specialization
        static int roundIntNone(int arg, PNone n) {
            return arg;
        }

        @Specialization
        static long roundLongNone(long arg, PNone n) {
            return arg;
        }

        @Specialization
        PInt roundPIntNone(PInt arg, PNone n) {
            return this.factory().createInt(arg.getValue());
        }

        @Specialization
        Object roundLongInt(long arg, int n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow) {
            if (n >= 0) {
                return arg;
            }
            return this.makeInt(inliningTarget, RoundNode.op(arg, n), intOverflow);
        }

        @Specialization
        Object roundPIntInt(PInt arg, int n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow) {
            if (n >= 0) {
                return arg;
            }
            return this.makeInt(inliningTarget, RoundNode.op(arg.getValue(), n), intOverflow);
        }

        @Specialization
        Object roundLongLong(long arg, long n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow) {
            if (n >= 0L) {
                return arg;
            }
            if (n < Integer.MIN_VALUE) {
                return 0;
            }
            return this.makeInt(inliningTarget, RoundNode.op(arg, (int)n), intOverflow);
        }

        @Specialization
        Object roundPIntLong(PInt arg, long n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow) {
            if (n >= 0L) {
                return arg;
            }
            if (n < Integer.MIN_VALUE) {
                return 0;
            }
            return this.makeInt(inliningTarget, RoundNode.op(arg.getValue(), (int)n), intOverflow);
        }

        @Specialization
        Object roundPIntLong(long arg, PInt n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow) {
            if (n.isZeroOrPositive()) {
                return arg;
            }
            try {
                return this.makeInt(inliningTarget, RoundNode.op(arg, n.intValueExact()), intOverflow);
            }
            catch (OverflowException e) {
                return 0;
            }
        }

        @Specialization
        Object roundPIntPInt(PInt arg, PInt n, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="intOvf") @Cached InlinedBranchProfile intOverflow) {
            if (n.isZeroOrPositive()) {
                return arg;
            }
            try {
                return this.makeInt(inliningTarget, RoundNode.op(arg.getValue(), n.intValueExact()), intOverflow);
            }
            catch (OverflowException e) {
                return 0;
            }
        }

        @Specialization(guards={"!isInteger(n)"})
        Object roundPIntPInt(Object arg, Object n) {
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.OBJ_CANNOT_BE_INTERPRETED_AS_INTEGER, n);
        }

        private Object makeInt(Node inliningTarget, BigDecimal d, InlinedBranchProfile intOverflow) {
            try {
                return RoundNode.intValueExact(d);
            }
            catch (OverflowException e2) {
                intOverflow.enter(inliningTarget);
                try {
                    return RoundNode.longValueExact(d);
                }
                catch (OverflowException e2) {
                    try {
                        return this.factory().createInt(RoundNode.toBigIntegerExact(d));
                    }
                    catch (OverflowException e3) {
                        throw CompilerDirectives.shouldNotReachHere((String)"non-integer produced after rounding an integer", (Throwable)e3);
                    }
                }
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger toBigIntegerExact(BigDecimal d) throws OverflowException {
            try {
                return d.toBigIntegerExact();
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static int intValueExact(BigDecimal d) throws OverflowException {
            try {
                return d.intValueExact();
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static long longValueExact(BigDecimal d) throws OverflowException {
            try {
                return d.longValueExact();
            }
            catch (ArithmeticException ex) {
                throw OverflowException.INSTANCE;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigDecimal op(long arg, int n) {
            try {
                return new BigDecimal(arg).setScale(n, RoundingMode.HALF_EVEN);
            }
            catch (ArithmeticException e) {
                return BigDecimal.ZERO;
            }
        }

        @CompilerDirectives.TruffleBoundary
        private static BigDecimal op(BigInteger arg, int n) {
            try {
                return new BigDecimal(arg).setScale(n, RoundingMode.HALF_EVEN);
            }
            catch (ArithmeticException e) {
                return BigDecimal.ZERO;
            }
        }
    }

    private static abstract class IntBinaryBuiltinNode
    extends PythonBinaryBuiltinNode {
        private IntBinaryBuiltinNode() {
        }

        protected void raiseDivisionByZero(Node inliningTarget, boolean cond, InlinedBranchProfile divisionByZeroProfile) {
            if (cond) {
                divisionByZeroProfile.enter(inliningTarget);
                throw this.raise(PythonErrorType.ZeroDivisionError, ErrorMessages.S_DIVISION_OR_MODULO_BY_ZERO, "integer");
            }
        }
    }
}

