/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.itertools.PTee;
import com.oracle.graal.python.builtins.objects.itertools.PTeeDataObject;
import com.oracle.graal.python.builtins.objects.itertools.TeeBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltins;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.tuple.TupleBuiltins;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTee})
public final class TeeBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TeeBuiltinsFactory.getFactories();
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        abstract Object execute(VirtualFrame var1, PythonObject var2, Object var3);

        @Specialization
        Object setState(VirtualFrame frame, PTee self, Object state, @Bind(value="this") Node inliningTarget, @Cached TupleBuiltins.LenNode lenNode, @Cached TupleBuiltins.GetItemNode getItemNode, @Cached CastToJavaIntLossyNode castToIntNode) {
            if (!(state instanceof PTuple) || (Integer)lenNode.execute(frame, state) != 2) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "2-tuple");
            }
            Object dataObject = getItemNode.execute(frame, state, (Object)0);
            if (!(dataObject instanceof PTeeDataObject)) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A, "state", "_tee_dataobject");
            }
            self.setDataObj((PTeeDataObject)dataObject);
            Object secondElement = getItemNode.execute(frame, state, (Object)1);
            int index = 0;
            try {
                index = castToIntNode.execute(inliningTarget, secondElement);
            }
            catch (CannotCastException e) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED_GOT, secondElement);
            }
            if (index < 0 || index > 128) {
                throw this.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INDEX_OUT_OF_RANGE);
            }
            self.setIndex(index);
            return PNone.NONE;
        }
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        abstract Object execute(VirtualFrame var1, PythonObject var2);

        @Specialization
        Object reduce(PTee self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass) {
            Object type = getClass.execute(inliningTarget, self);
            PTuple tuple1 = this.factory().createTuple(new Object[]{this.factory().createEmptyTuple()});
            PTuple tuple2 = this.factory().createTuple(new Object[]{self.getDataobj(), self.getIndex()});
            return this.factory().createTuple(new Object[]{type, tuple1, tuple2});
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @ImportStatic(value={TeeDataObjectBuiltins.class})
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getIndex() < LINKCELLS"})
        Object next(VirtualFrame frame, PTee self, @Cached.Shared @Cached BuiltinFunctions.NextNode nextNode) {
            Object value = self.getDataobj().getItem(frame, self.getIndex(), nextNode, this);
            self.setIndex(self.getIndex() + 1);
            return value;
        }

        @Specialization(guards={"self.getIndex() >= LINKCELLS"})
        Object nextNext(VirtualFrame frame, PTee self, @Cached.Shared @Cached BuiltinFunctions.NextNode nextNode) {
            self.setDataObj(self.getDataobj().jumplink(this.factory()));
            Object value = self.getDataobj().getItem(frame, 0, nextNode, this);
            self.setIndex(1);
            return value;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PTee self) {
            return self;
        }
    }

    @Builtin(name="__copy__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class CopyNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object copy(PTee self) {
            return this.factory().createTee(self.getDataobj(), self.getIndex());
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NewNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        Object newTee(VirtualFrame frame, Object cls, Object iterable, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached(value="createCopyNode()") LookupAndCallUnaryNode copyNode, @Cached InlinedConditionProfile isTeeInstanceProfile) {
            Object it = getIter.execute((Frame)frame, inliningTarget, iterable);
            if (isTeeInstanceProfile.profile(inliningTarget, it instanceof PTee)) {
                return copyNode.executeObject(frame, it);
            }
            PTeeDataObject dataObj = this.factory().createTeeDataObject(it);
            return this.factory().createTee(dataObj, 0);
        }

        @NeverDefault
        protected LookupAndCallUnaryNode createCopyNode() {
            return LookupAndCallUnaryNode.create(SpecialMethodNames.T___COPY__);
        }
    }
}

