/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.Builtins;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.method.DecoratedMethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PDecoratedMethod;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.object.SetDictNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStaticmethod, PythonBuiltinClassType.PClassmethod})
public final class DecoratedMethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return DecoratedMethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__isabstractmethod__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class IsAbstractMethodNode
    extends PythonUnaryBuiltinNode {
        IsAbstractMethodNode() {
        }

        @Specialization
        static boolean isAbstract(VirtualFrame frame, PDecoratedMethod self, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached PyObjectIsTrueNode isTrue, @Cached InlinedConditionProfile hasAttrProfile) {
            Object result = lookup.execute((Frame)frame, inliningTarget, self.getCallable(), SpecialMethodNames.T___ISABSTRACTMETHOD__);
            if (hasAttrProfile.profile(inliningTarget, result != PNone.NO_VALUE)) {
                return isTrue.execute((Frame)frame, inliningTarget, result);
            }
            return false;
        }
    }

    @Builtin(name="__dict__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    @ImportStatic(value={PGuards.class})
    public static abstract class DictNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        protected Object getDict(PDecoratedMethod self, PNone mapping, @Bind(value="this") Node inliningTarget, @Cached GetOrCreateDictNode getDict) {
            return getDict.execute(inliningTarget, self);
        }

        @Specialization
        protected Object setDict(PDecoratedMethod self, PDict mapping, @Bind(value="this") Node inliningTarget, @Cached SetDictNode setDict) {
            setDict.execute(inliningTarget, self, mapping);
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(mapping)", "!isDict(mapping)"})
        protected Object setDict(PDecoratedMethod self, Object mapping) {
            throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.DICT_MUST_BE_SET_TO_DICT, mapping);
        }
    }

    @Builtins(value={@Builtin(name="__func__", minNumOfPositionalArgs=1, isGetter=true), @Builtin(name="__wrapped__", minNumOfPositionalArgs=1, isGetter=true)})
    @GenerateNodeFactory
    static abstract class FuncNode
    extends PythonUnaryBuiltinNode {
        FuncNode() {
        }

        @Specialization
        protected Object func(PDecoratedMethod self) {
            return self.getCallable();
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class InitNode
    extends PythonBinaryBuiltinNode {
        InitNode() {
        }

        @Specialization
        protected PNone init(VirtualFrame frame, PDecoratedMethod self, Object callable, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookupModule, @Cached PyObjectSetAttr setModule, @Cached PyObjectLookupAttr lookupName, @Cached PyObjectSetAttr setName, @Cached PyObjectLookupAttr lookupQualname, @Cached PyObjectSetAttr setQualname, @Cached PyObjectLookupAttr lookupDoc, @Cached PyObjectSetAttr setDoc, @Cached PyObjectLookupAttr lookupAnnotations, @Cached PyObjectSetAttr setAnnotations) {
            self.setCallable(callable);
            InitNode.copyAttr(frame, inliningTarget, callable, self, SpecialAttributeNames.T___MODULE__, lookupModule, setModule);
            InitNode.copyAttr(frame, inliningTarget, callable, self, SpecialAttributeNames.T___NAME__, lookupName, setName);
            InitNode.copyAttr(frame, inliningTarget, callable, self, SpecialAttributeNames.T___QUALNAME__, lookupQualname, setQualname);
            InitNode.copyAttr(frame, inliningTarget, callable, self, SpecialAttributeNames.T___DOC__, lookupDoc, setDoc);
            InitNode.copyAttr(frame, inliningTarget, callable, self, SpecialAttributeNames.T___ANNOTATIONS__, lookupAnnotations, setAnnotations);
            return PNone.NONE;
        }

        private static void copyAttr(VirtualFrame frame, Node inliningTarget, Object wrapped, Object wrapper, TruffleString name, PyObjectLookupAttr lookup, PyObjectSetAttr set) {
            Object attr = lookup.execute((Frame)frame, inliningTarget, wrapped, name);
            if (attr != PNone.NO_VALUE) {
                set.execute((Frame)frame, inliningTarget, wrapper, name, attr);
            }
        }
    }
}

