/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaIntLossyNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;

@GenerateUncached
@ImportStatic(value={SpecialMethodSlot.class})
@GenerateInline(value=false)
abstract class PyObjectSizeGenericNode
extends Node {
    PyObjectSizeGenericNode() {
    }

    abstract int execute(Frame var1, Object var2);

    protected abstract Object executeObject(Frame var1, Object var2);

    @Specialization(rewriteOn={UnexpectedResultException.class})
    static int doInt(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClass") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupLen") @Cached(parameters={"Len"}) LookupSpecialMethodSlotNode lookupLen, @Cached.Shared(value="callLen") @Cached CallUnaryMethodNode callLen, @Cached.Shared(value="index") @Cached PyNumberIndexNode indexNode, @Cached.Shared(value="castLossy") @Cached CastToJavaIntLossyNode castLossy, @Cached.Shared(value="asSize") @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) throws UnexpectedResultException {
        Object lenDescr = lookupLen.execute((Frame)frame, getClassNode.execute(inliningTarget, object), object);
        if (lenDescr == PNone.NO_VALUE) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_HAS_NO_LEN, object);
        }
        try {
            return PyObjectSizeNode.checkLen(raiseNode, PGuards.expectInteger(callLen.executeObject((Frame)frame, lenDescr, object)));
        }
        catch (UnexpectedResultException e) {
            int len = PyObjectSizeNode.convertAndCheckLen(frame, inliningTarget, e.getResult(), indexNode, castLossy, asSizeNode, raiseNode);
            throw new UnexpectedResultException((Object)len);
        }
    }

    @Specialization(replaces={"doInt"})
    static int doObject(VirtualFrame frame, Object object, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getClass") @Cached GetClassNode getClassNode, @Cached.Shared(value="lookupLen") @Cached(parameters={"Len"}) LookupSpecialMethodSlotNode lookupLen, @Cached.Shared(value="callLen") @Cached CallUnaryMethodNode callLen, @Cached.Shared(value="index") @Cached PyNumberIndexNode indexNode, @Cached.Shared(value="castLossy") @Cached CastToJavaIntLossyNode castLossy, @Cached.Shared(value="asSize") @Cached PyNumberAsSizeNode asSizeNode, @Cached.Shared(value="raise") @Cached PRaiseNode raiseNode) {
        Object lenDescr = lookupLen.execute((Frame)frame, getClassNode.execute(inliningTarget, object), object);
        if (lenDescr == PNone.NO_VALUE) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_HAS_NO_LEN, object);
        }
        Object result = callLen.executeObject((Frame)frame, lenDescr, object);
        return PyObjectSizeNode.convertAndCheckLen(frame, inliningTarget, result, indexNode, castLossy, asSizeNode, raiseNode);
    }
}

