/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.bytecode;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.exception.StopIterationBuiltins;
import com.oracle.graal.python.builtins.objects.generator.CommonGeneratorBuiltins;
import com.oracle.graal.python.builtins.objects.generator.PGenerator;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyIterCheckNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.bytecode.SendNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateInline(value=false)
public abstract class SendNode
extends PNodeWithContext {
    private static final TruffleString T_SEND = PythonUtils.tsLiteral("send");

    public abstract boolean execute(VirtualFrame var1, int var2, Object var3, Object var4);

    @Specialization
    static boolean doGenerator(VirtualFrame virtualFrame, int stackTop, PGenerator generator, Object arg, @Bind(value="this") Node inliningTarget, @Cached CommonGeneratorBuiltins.SendNode sendNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        try {
            Object value = sendNode.execute(virtualFrame, generator, arg);
            virtualFrame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            SendNode.handleException(virtualFrame, e, inliningTarget, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    @Specialization(guards={"iterCheck.execute(inliningTarget, iter)"}, limit="1")
    static boolean doIterator(VirtualFrame virtualFrame, int stackTop, Object iter, PNone arg, @Bind(value="this") Node inliningTarget, @Cached PyIterCheckNode iterCheck, @Cached GetNextNode getNextNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        try {
            Object value = getNextNode.execute((Frame)virtualFrame, iter);
            virtualFrame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            SendNode.handleException(virtualFrame, e, inliningTarget, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    @Fallback
    static boolean doOther(VirtualFrame virtualFrame, int stackTop, Object obj, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethodNode, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, @Cached.Exclusive @Cached StopIterationBuiltins.StopIterationValueNode getValue) {
        try {
            Object value = callMethodNode.execute((Frame)virtualFrame, inliningTarget, obj, T_SEND, arg);
            virtualFrame.setObject(stackTop, value);
            return false;
        }
        catch (PException e) {
            SendNode.handleException(virtualFrame, e, inliningTarget, stopIterationProfile, getValue, stackTop);
            return true;
        }
    }

    private static void handleException(VirtualFrame frame, PException e, Node inliningTarget, BuiltinClassProfiles.IsBuiltinObjectProfile stopIterationProfile, StopIterationBuiltins.StopIterationValueNode getValue, int stackTop) {
        e.expectStopIteration(inliningTarget, stopIterationProfile);
        Object value = getValue.execute((PBaseException)e.getUnreifiedException());
        frame.setObject(stackTop, null);
        frame.setObject(stackTop - 1, value);
    }

    public static SendNode create() {
        return SendNodeGen.create();
    }
}

