/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.function.BuiltinMethodDescriptor;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.nodes.builtins.FunctionNodes;
import com.oracle.graal.python.nodes.call.BoundDescriptor;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.AbstractCallMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNodeGen;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;

@GenerateUncached
public abstract class CallUnaryMethodNode
extends AbstractCallMethodNode {
    @NeverDefault
    public static CallUnaryMethodNode create() {
        return CallUnaryMethodNodeGen.create();
    }

    public static CallUnaryMethodNode getUncached() {
        return CallUnaryMethodNodeGen.getUncached();
    }

    public abstract Object executeObject(Frame var1, Object var2, Object var3);

    public final Object executeObject(Object callable, Object receiver) {
        return this.executeObject(null, callable, receiver);
    }

    @Specialization(guards={"cachedInfo == info", "node != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callUnarySpecialMethodSlotInlined(VirtualFrame frame, BuiltinMethodDescriptor.UnaryBuiltinDescriptor info, Object receiver, @Cached(value="info") BuiltinMethodDescriptor.UnaryBuiltinDescriptor cachedInfo, @Cached(value="getBuiltin(cachedInfo)") PythonUnaryBuiltinNode node) {
        return node.execute(frame, receiver);
    }

    protected static boolean hasAllowedArgsNum(BuiltinMethodDescriptor descr) {
        return descr.minNumOfPositionalArgs() <= 1;
    }

    @Specialization(guards={"cachedInfo == info", "node != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callBinarySpecialMethodSlotInlined(VirtualFrame frame, BuiltinMethodDescriptor.BinaryBuiltinDescriptor info, Object receiver, @Cached(value="info") BuiltinMethodDescriptor.BinaryBuiltinDescriptor cachedInfo, @Cached(value="hasAllowedArgsNum(cachedInfo)") boolean hasValidArgsNum, @Cached(value="getBuiltin(cachedInfo)") PythonBinaryBuiltinNode node) {
        this.raiseInvalidArgsNumUncached(hasValidArgsNum, cachedInfo);
        return node.execute(frame, receiver, PNone.NO_VALUE);
    }

    @Specialization(guards={"cachedInfo == info", "node != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callTernarySpecialMethodSlotInlined(VirtualFrame frame, BuiltinMethodDescriptor.TernaryBuiltinDescriptor info, Object receiver, @Cached(value="info") BuiltinMethodDescriptor.TernaryBuiltinDescriptor cachedInfo, @Cached(value="hasAllowedArgsNum(cachedInfo)") boolean hasValidArgsNum, @Cached(value="getBuiltin(cachedInfo)") PythonTernaryBuiltinNode node) {
        this.raiseInvalidArgsNumUncached(hasValidArgsNum, cachedInfo);
        return node.execute(frame, receiver, PNone.NO_VALUE, PNone.NO_VALUE);
    }

    @Specialization(guards={"isBuiltinDescriptor(info)"}, replaces={"callUnarySpecialMethodSlotInlined", "callBinarySpecialMethodSlotInlined", "callTernarySpecialMethodSlotInlined"})
    @HostCompilerDirectives.InliningCutoff
    Object callSpecialMethodSlotCallTarget(VirtualFrame frame, BuiltinMethodDescriptor info, Object receiver, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached InlinedConditionProfile invalidArgsProfile, @Cached GenericInvokeNode invokeNode2) {
        this.raiseInvalidArgsNumUncached(invalidArgsProfile.profile(inliningTarget, CallUnaryMethodNode.hasAllowedArgsNum(info)), info);
        RootCallTarget callTarget = PythonLanguage.get(this).getDescriptorCallTarget(info);
        Object[] arguments = PArguments.create(1);
        PArguments.setArgument(arguments, 0, receiver);
        return invokeNode2.execute(frame, callTarget, arguments);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callObjectSingle(VirtualFrame frame, PBuiltinFunction func, Object receiver, @Cached(value="func") PBuiltinFunction cachedFunc, @Cached(value="getBuiltin(frame, func, 1)") PythonBuiltinBaseNode builtinNode) {
        return CallUnaryMethodNode.callUnaryBuiltin(frame, builtinNode, receiver);
    }

    @Specialization(guards={"func.getCallTarget() == ct", "builtinNode != null"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callObject(VirtualFrame frame, PBuiltinFunction func, Object receiver, @Cached(value="func.getCallTarget()") RootCallTarget ct, @Cached(value="getBuiltin(frame, func, 1)") PythonBuiltinBaseNode builtinNode) {
        return CallUnaryMethodNode.callUnaryBuiltin(frame, builtinNode, receiver);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callMethodSingleContext(VirtualFrame frame, PBuiltinMethod func, Object receiver, @Cached(value="func") PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 1)") PythonBuiltinBaseNode builtinNode) {
        return CallUnaryMethodNode.callUnaryBuiltin(frame, builtinNode, receiver);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "!takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callMethod(VirtualFrame frame, PBuiltinMethod func, Object receiver, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 1)") PythonBuiltinBaseNode builtinNode) {
        return CallUnaryMethodNode.callUnaryBuiltin(frame, builtinNode, receiver);
    }

    @Specialization(guards={"isSingleContext()", "func == cachedFunc", "builtinNode != null", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callSelfMethodSingleContext(VirtualFrame frame, PBuiltinMethod func, Object arg, @Cached(value="func", weak=true) PBuiltinMethod cachedFunc, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 2)") PythonBuiltinBaseNode builtinNode) {
        return CallUnaryMethodNode.callBinaryBuiltin(frame, builtinNode, func.getSelf(), arg);
    }

    @Specialization(guards={"builtinNode != null", "getCallTarget(func, getCt) == ct", "takesSelfArg"}, limit="getCallSiteInlineCacheMaxDepth()")
    Object callSelfMethod(VirtualFrame frame, PBuiltinMethod func, Object arg, @Cached.Shared @Cached FunctionNodes.GetCallTargetNode getCt, @Cached(value="getCallTarget(func, getCt)") RootCallTarget ct, @Cached(value="takesSelfArg(func)") boolean takesSelfArg, @Cached(value="getBuiltin(frame, func.getBuiltinFunction(), 2)") PythonBuiltinBaseNode builtinNode) {
        return CallUnaryMethodNode.callBinaryBuiltin(frame, builtinNode, func.getSelf(), arg);
    }

    @Specialization(guards={"!isBuiltinDescriptor(func)"}, replaces={"callObjectSingle", "callObject", "callMethodSingleContext", "callSelfMethodSingleContext", "callMethod", "callSelfMethod"})
    @HostCompilerDirectives.InliningCutoff
    @ReportPolymorphism.Megamorphic
    static Object call(VirtualFrame frame, Object func, Object receiver, @Bind(value="this") Node inliningTarget, @Cached CallNode callNode, @Cached.Exclusive @Cached InlinedConditionProfile isBoundProfile) {
        if (isBoundProfile.profile(inliningTarget, func instanceof BoundDescriptor)) {
            return callNode.execute((Frame)frame, ((BoundDescriptor)func).descriptor, PythonUtils.EMPTY_OBJECT_ARRAY, PKeyword.EMPTY_KEYWORDS);
        }
        return callNode.execute((Frame)frame, func, new Object[]{receiver}, PKeyword.EMPTY_KEYWORDS);
    }
}

