/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.call.special;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupAndCallBinaryNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodSlotNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.util.Supplier;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.ReportPolymorphism;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@ReportPolymorphism
abstract class LookupAndCallReversibleBinaryNode
extends LookupAndCallBinaryNode {
    protected final SpecialMethodSlot slot;
    protected final SpecialMethodSlot rslot;
    private final boolean alwaysCheckReverse;
    @Node.Child
    private PRaiseNode raiseNode;
    @Node.Child
    private TypeNodes.GetNameNode getNameNode;
    @Node.Child
    private CallBinaryMethodNode reverseDispatchNode;

    LookupAndCallReversibleBinaryNode(SpecialMethodSlot slot, SpecialMethodSlot rslot, Supplier<LookupAndCallBinaryNode.NotImplementedHandler> handlerFactory, boolean alwaysCheckReverse, boolean ignoreDescriptorException) {
        super(handlerFactory, ignoreDescriptorException);
        assert (slot != null);
        assert (rslot != null);
        this.slot = slot;
        this.rslot = rslot;
        this.alwaysCheckReverse = alwaysCheckReverse;
    }

    private PRaiseNode ensureRaiseNode() {
        if (this.raiseNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.raiseNode = (PRaiseNode)this.insert(PRaiseNode.create());
        }
        return this.raiseNode;
    }

    private TypeNodes.GetNameNode ensureGetNameNode() {
        if (this.getNameNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getNameNode = (TypeNodes.GetNameNode)this.insert(TypeNodes.GetNameNode.create());
        }
        return this.getNameNode;
    }

    private CallBinaryMethodNode ensureReverseDispatch() {
        if (this.reverseDispatchNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.reverseDispatchNode = (CallBinaryMethodNode)this.insert(CallBinaryMethodNode.create());
        }
        return this.reverseDispatchNode;
    }

    @Specialization(guards={"left.getClass() == cachedLeftClass", "right.getClass() == cachedRightClass"}, limit="5")
    Object callObjectGenericR(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached(value="left.getClass()") Class<?> cachedLeftClass, @Cached(value="right.getClass()") Class<?> cachedRightClass, @Cached.Exclusive @Cached(value="create(slot)") LookupSpecialMethodSlotNode getattr, @Cached.Exclusive @Cached(value="create(rslot)") LookupSpecialMethodSlotNode getattrR, @Cached.Exclusive @Cached GetClassNode getLeftClassNode, @Cached.Exclusive @Cached GetClassNode getRightClassNode, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached InlinedConditionProfile hasLeftCallable, @Cached.Exclusive @Cached InlinedConditionProfile hasRightCallable, @Cached.Exclusive @Cached InlinedConditionProfile notImplementedProfile, @Cached.Exclusive @Cached InlinedBranchProfile noLeftBuiltinClassType, @Cached.Exclusive @Cached InlinedBranchProfile noRightBuiltinClassType, @Cached.Exclusive @Cached InlinedBranchProfile gotResultBranch, @Cached.Exclusive @Cached LookupAndCallBinaryNode.AreSameCallables areSameCallables, @Cached.Exclusive @Cached LookupAndCallBinaryNode.GetEnclosingType getEnclosingType) {
        return this.doCallObjectR(frame, inliningTarget, left, right, getattr, getattrR, getLeftClassNode, getRightClassNode, isSameTypeNode, isSubtype, hasLeftCallable, hasRightCallable, notImplementedProfile, noLeftBuiltinClassType, noRightBuiltinClassType, gotResultBranch, areSameCallables, getEnclosingType);
    }

    @Specialization(replaces={"callObjectGenericR"})
    @ReportPolymorphism.Megamorphic
    Object callObjectRMegamorphic(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached(value="create(slot)") LookupSpecialMethodSlotNode getattr, @Cached.Exclusive @Cached(value="create(rslot)") LookupSpecialMethodSlotNode getattrR, @Cached.Exclusive @Cached GetClassNode getLeftClassNode, @Cached.Exclusive @Cached GetClassNode getRightClassNode, @Cached.Exclusive @Cached TypeNodes.IsSameTypeNode isSameTypeNode, @Cached.Exclusive @Cached IsSubtypeNode isSubtype, @Cached.Exclusive @Cached InlinedConditionProfile hasLeftCallable, @Cached.Exclusive @Cached InlinedConditionProfile hasRightCallable, @Cached.Exclusive @Cached InlinedConditionProfile notImplementedProfile, @Cached.Exclusive @Cached InlinedBranchProfile noLeftBuiltinClassType, @Cached.Exclusive @Cached InlinedBranchProfile noRightBuiltinClassType, @Cached.Exclusive @Cached InlinedBranchProfile gotResultBranch, @Cached.Exclusive @Cached LookupAndCallBinaryNode.AreSameCallables areSameCallables, @Cached.Exclusive @Cached LookupAndCallBinaryNode.GetEnclosingType getEnclosingType) {
        return this.doCallObjectR(frame, inliningTarget, left, right, getattr, getattrR, getLeftClassNode, getRightClassNode, isSameTypeNode, isSubtype, hasLeftCallable, hasRightCallable, notImplementedProfile, noLeftBuiltinClassType, noRightBuiltinClassType, gotResultBranch, areSameCallables, getEnclosingType);
    }

    private Object doCallObjectR(VirtualFrame frame, Node inliningTarget, Object left, Object right, LookupSpecialMethodSlotNode getattr, LookupSpecialMethodSlotNode getattrR, GetClassNode getLeftClassNode, GetClassNode getRightClassNode, TypeNodes.IsSameTypeNode isSameTypeNode, IsSubtypeNode isSubtype, InlinedConditionProfile hasLeftCallable, InlinedConditionProfile hasRightCallable, InlinedConditionProfile notImplementedProfile, InlinedBranchProfile noLeftBuiltinClassType, InlinedBranchProfile noRightBuiltinClassType, InlinedBranchProfile gotResultBranch, LookupAndCallBinaryNode.AreSameCallables areSameCallables, LookupAndCallBinaryNode.GetEnclosingType getEnclosingType) {
        Object rightCallable;
        Object leftCallable;
        Object result = PNotImplemented.NOT_IMPLEMENTED;
        Object leftClass = getLeftClassNode.execute(inliningTarget, left);
        try {
            leftCallable = getattr.execute((Frame)frame, leftClass, left);
        }
        catch (PException e) {
            if (this.ignoreDescriptorException) {
                leftCallable = PNone.NO_VALUE;
            }
            throw e;
        }
        Object rightClass = getRightClassNode.execute(inliningTarget, right);
        try {
            rightCallable = getattrR.execute((Frame)frame, rightClass, right);
        }
        catch (PException e) {
            if (this.ignoreDescriptorException) {
                rightCallable = PNone.NO_VALUE;
            }
            throw e;
        }
        if (!this.alwaysCheckReverse && areSameCallables.execute(inliningTarget, leftCallable, rightCallable)) {
            rightCallable = PNone.NO_VALUE;
        }
        if (hasLeftCallable.profile(inliningTarget, leftCallable != PNone.NO_VALUE)) {
            if (hasRightCallable.profile(inliningTarget, rightCallable != PNone.NO_VALUE) && (!isSameTypeNode.execute(inliningTarget, leftClass, rightClass) && isSubtype.execute(frame, rightClass, leftClass) || LookupAndCallReversibleBinaryNode.isFlagSequenceCompat(inliningTarget, leftClass, rightClass, this.slot, noLeftBuiltinClassType, noRightBuiltinClassType))) {
                result = this.dispatch(frame, inliningTarget, this.ensureReverseDispatch(), rightCallable, right, left, rightClass, this.rslot, isSubtype, getEnclosingType);
                if (result != PNotImplemented.NOT_IMPLEMENTED) {
                    return result;
                }
                gotResultBranch.enter(inliningTarget);
                rightCallable = PNone.NO_VALUE;
            }
            if ((result = this.dispatch(frame, inliningTarget, this.ensureDispatch(), leftCallable, left, right, leftClass, this.slot, isSubtype, getEnclosingType)) != PNotImplemented.NOT_IMPLEMENTED) {
                return result;
            }
            gotResultBranch.enter(inliningTarget);
        }
        if (notImplementedProfile.profile(inliningTarget, rightCallable != PNone.NO_VALUE)) {
            result = this.dispatch(frame, inliningTarget, this.ensureReverseDispatch(), rightCallable, right, left, rightClass, this.rslot, isSubtype, getEnclosingType);
        }
        if (this.handlerFactory != null && result == PNotImplemented.NOT_IMPLEMENTED) {
            return this.runErrorHandler(frame, left, right);
        }
        return result;
    }

    private Object dispatch(VirtualFrame frame, Node inliningTarget, CallBinaryMethodNode dispatch, Object callable, Object leftValue, Object rightValue, Object leftClass, SpecialMethodSlot op, IsSubtypeNode isSubtype, LookupAndCallBinaryNode.GetEnclosingType getEnclosingType) {
        Object enclosing = getEnclosingType.execute(inliningTarget, callable);
        if (enclosing != null && !isSubtype.execute(leftClass, enclosing)) {
            throw this.ensureRaiseNode().raise(PythonBuiltinClassType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, op.getName(), this.ensureGetNameNode().executeCached(leftClass), leftValue);
        }
        return dispatch.executeObject((Frame)frame, callable, leftValue, rightValue);
    }

    private static boolean isFlagSequenceCompat(Node inliningTarget, Object leftClass, Object rightClass, SpecialMethodSlot slot, InlinedBranchProfile gotLeftBuiltinClassType, InlinedBranchProfile gotRightBuiltinClassType) {
        if (PGuards.isNativeClass(leftClass) || PGuards.isNativeClass(rightClass)) {
            return false;
        }
        boolean isSeqBugCompatOperation = slot == SpecialMethodSlot.Add || slot == SpecialMethodSlot.Mul;
        return isSeqBugCompatOperation && LookupAndCallReversibleBinaryNode.isFlagSequenceBugCompat(inliningTarget, leftClass, gotLeftBuiltinClassType) && !LookupAndCallReversibleBinaryNode.isFlagSequenceBugCompat(inliningTarget, rightClass, gotRightBuiltinClassType);
    }

    private static boolean isFlagSequenceBugCompat(Node inliningTarget, Object clazz, InlinedBranchProfile gotBuiltinClassType) {
        PythonBuiltinClassType type = null;
        if (clazz instanceof PythonBuiltinClassType) {
            type = (PythonBuiltinClassType)((Object)clazz);
        } else if (clazz instanceof PythonBuiltinClass) {
            type = ((PythonBuiltinClass)clazz).getType();
        } else {
            return false;
        }
        gotBuiltinClassType.enter(inliningTarget);
        return type == PythonBuiltinClassType.PString || type == PythonBuiltinClassType.PByteArray || type == PythonBuiltinClassType.PBytes || type == PythonBuiltinClassType.PList || type == PythonBuiltinClassType.PTuple;
    }

    @Override
    public TruffleString getName() {
        return this.slot.getName();
    }

    @Override
    public TruffleString getRname() {
        return this.rslot.getName();
    }
}

