/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.bz2;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.bz2.BZ2DecompressorBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.bz2.BZ2DecompressorBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.bz2.BZ2Object;
import com.oracle.graal.python.builtins.modules.bz2.Bz2Nodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.BytesNodes;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.bytes.PBytesLike;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.runtime.NFIBz2Support;
import com.oracle.graal.python.runtime.NativeLibrary;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.BZ2Decompressor})
public final class BZ2DecompressorBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return BZ2DecompressorBuiltinsFactory.getFactories();
    }

    @Builtin(name="eof", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class EOFNode
    extends PythonUnaryBuiltinNode {
        EOFNode() {
        }

        @Specialization
        boolean doit(BZ2Object.BZ2Decompressor self) {
            return self.isEOF();
        }
    }

    @Builtin(name="needs_input", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NeedsInputNode
    extends PythonUnaryBuiltinNode {
        NeedsInputNode() {
        }

        @Specialization
        boolean doit(BZ2Object.BZ2Decompressor self) {
            return self.needsInput();
        }
    }

    @Builtin(name="unused_data", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class UnusedDataNode
    extends PythonUnaryBuiltinNode {
        UnusedDataNode() {
        }

        @Specialization
        PBytes doit(BZ2Object.BZ2Decompressor self) {
            return this.factory().createBytes(self.getUnusedData());
        }
    }

    @Builtin(name="decompress", minNumOfPositionalArgs=1, parameterNames={"$self", "", "max_length"})
    @ArgumentClinic(name="max_length", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class DecompressNode
    extends PythonTernaryClinicBuiltinNode {
        DecompressNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return BZ2DecompressorBuiltinsClinicProviders.DecompressNodeClinicProviderGen.INSTANCE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isEOF()"})
        PBytes doNativeBytes(BZ2Object.BZ2Decompressor self, PBytesLike data, int maxLength, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalByteArrayNode toBytes, @Cached.Exclusive @Cached Bz2Nodes.Bz2NativeDecompress decompress) {
            BZ2Object.BZ2Decompressor bZ2Decompressor = self;
            synchronized (bZ2Decompressor) {
                byte[] bytes = toBytes.execute(inliningTarget, data.getSequenceStorage());
                int len = data.getSequenceStorage().length();
                return this.factory().createBytes(decompress.execute(inliningTarget, self, bytes, len, maxLength));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"!self.isEOF()"})
        PBytes doNativeObject(VirtualFrame frame, BZ2Object.BZ2Decompressor self, Object data, int maxLength, @Bind(value="this") Node inliningTarget, @Cached BytesNodes.ToBytesNode toBytes, @Cached.Exclusive @Cached Bz2Nodes.Bz2NativeDecompress decompress) {
            BZ2Object.BZ2Decompressor bZ2Decompressor = self;
            synchronized (bZ2Decompressor) {
                byte[] bytes = toBytes.execute(frame, data);
                int len = bytes.length;
                return this.factory().createBytes(decompress.execute(inliningTarget, self, bytes, len, maxLength));
            }
        }

        @Specialization(guards={"self.isEOF()"})
        Object err(BZ2Object.BZ2Decompressor self, PBytesLike data, int maxLength) {
            throw this.raise(PythonBuiltinClassType.EOFError, ErrorMessages.END_OF_STREAM_ALREADY_REACHED);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self"})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        PNone init(BZ2Object.BZ2Decompressor self, @Bind(value="this") Node inliningTarget, @Cached NativeLibrary.InvokeNativeFunction createStream, @Cached NativeLibrary.InvokeNativeFunction compressInit, @Cached InlinedConditionProfile errProfile) {
            Object bzst;
            NFIBz2Support bz2Support = PythonContext.get(this).getNFIBz2Support();
            int err = bz2Support.decompressInit(bzst = bz2Support.createStream(createStream), compressInit);
            if (errProfile.profile(inliningTarget, err != 0)) {
                Bz2Nodes.errorHandling(err, this.getRaiseNode());
            }
            self.init(bzst, bz2Support);
            return PNone.NONE;
        }
    }
}

