/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cell;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cell.CellBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCell})
public final class CellBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CellBuiltinsFactory.getFactories();
    }

    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetRefNode
    extends PNodeWithContext {
        public abstract Object execute(Node var1, PCell var2);

        @Specialization(guards={"isSingleContext()", "self == cachedSelf"}, assumptions={"cachedSelf.isEffectivelyFinalAssumption()"}, limit="1")
        Object cached(@NeverDefault PCell self, @Cached(value="self") PCell cachedSelf, @Cached(value="self.getRef()") Object ref) {
            return ref;
        }

        @Specialization(replaces={"cached"})
        Object uncached(PCell self) {
            return self.getRef();
        }
    }

    @Builtin(name="cell_contents", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, allowsDelete=true)
    @GenerateNodeFactory
    public static abstract class CellContentsNode
    extends PythonBuiltinNode {
        @Specialization(guards={"isNoValue(none)"})
        Object get(PCell self, PNone none, @Bind(value="this") Node inliningTarget, @Cached GetRefNode getRef) {
            Object ref = getRef.execute(inliningTarget, self);
            if (ref == null) {
                throw this.raise(PythonErrorType.ValueError, ErrorMessages.IS_EMPTY, "Cell");
            }
            return ref;
        }

        @Specialization(guards={"isDeleteMarker(marker)"})
        Object delete(PCell self, Object marker) {
            self.clearRef();
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(ref)", "!isDeleteMarker(ref)"})
        Object set(PCell self, Object ref) {
            self.setRef(ref);
            return PNone.NONE;
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(PCell self, @Bind(value="this") Node inliningTarget, @Cached GetRefNode getRef, @Cached GetClassNode getClassNode, @Cached TypeNodes.GetNameNode getNameNode, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object ref = getRef.execute(inliningTarget, self);
            if (ref == null) {
                return simpleTruffleStringFormatNode.format("<cell at 0x%s: empty>", PythonAbstractObject.systemHashCodeAsHexString(self));
            }
            TruffleString typeName = getNameNode.execute(inliningTarget, getClassNode.execute(inliningTarget, ref));
            return simpleTruffleStringFormatNode.format("<cell at 0x%s: %s object at 0x%s>", PythonAbstractObject.systemHashCodeAsHexString(self), typeName, PythonAbstractObject.systemHashCodeAsHexString(ref));
        }

        @Fallback
        public Object eq(Object self) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, "__repr__", "cell", self);
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GeNode
    extends PythonBuiltinNode {
        @Specialization
        public boolean ge(VirtualFrame frame, PCell self, PCell other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.GeNode geNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return geNode.compare((Frame)frame, inliningTarget, left, right);
            }
            return right == null;
        }

        @Fallback
        public Object notImplemented(Object self, Object other) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___GE__, "cell", self);
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class GtNode
    extends PythonBuiltinNode {
        @Specialization
        public boolean gt(VirtualFrame frame, PCell self, PCell other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.GtNode gtNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return gtNode.compare((Frame)frame, inliningTarget, left, right);
            }
            return left != null;
        }

        @Fallback
        public Object notImplemented(Object self, Object other) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___GT__, "cell", self);
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LeNode
    extends PythonBuiltinNode {
        @Specialization
        public boolean le(VirtualFrame frame, PCell self, PCell other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.LeNode leNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return leNode.compare((Frame)frame, inliningTarget, left, right);
            }
            return left == null;
        }

        @Fallback
        public Object notImplemented(Object self, Object other) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___LE__, "cell", self);
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class LtNode
    extends PythonBuiltinNode {
        @Specialization
        public boolean lt(VirtualFrame frame, PCell self, PCell other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.LtNode ltNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return ltNode.compare((Frame)frame, inliningTarget, left, right);
            }
            return right != null;
        }

        @Fallback
        public Object notImplemented(Object self, Object other) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___LT__, "cell", self);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class NeNode
    extends PythonBuiltinNode {
        @Specialization
        public boolean ne(VirtualFrame frame, PCell self, PCell other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.NeNode neNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return neNode.compare((Frame)frame, inliningTarget, left, right);
            }
            return left != null || right != null;
        }

        @Fallback
        public Object eq(Object self, Object other) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___NE__, "cell", self);
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class EqNode
    extends PythonBuiltinNode {
        @Specialization
        public boolean eq(VirtualFrame frame, PCell self, PCell other, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached InlinedConditionProfile nonEmptyProfile, @Cached GetRefNode getRefL, @Cached GetRefNode getRefR) {
            Object left = getRefL.execute(inliningTarget, self);
            Object right = getRefR.execute(inliningTarget, other);
            if (nonEmptyProfile.profile(inliningTarget, left != null && right != null)) {
                return eqNode.compare((Frame)frame, inliningTarget, left, right);
            }
            return left == null && right == null;
        }

        @Fallback
        public Object eq(Object self, Object other) {
            if (self instanceof PCell) {
                return PNotImplemented.NOT_IMPLEMENTED;
            }
            throw this.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, SpecialMethodNames.T___EQ__, "cell", self);
        }
    }
}

