/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.str.PString;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public abstract class UnicodeObjectNodes {

    @GenerateUncached
    public static abstract class UnicodeAsWideCharNode
    extends Node {
        public final PBytes executeNativeOrder(Object obj, long elementSize) {
            return this.execute(obj, elementSize, ByteOrder.nativeOrder());
        }

        public final PBytes executeLittleEndian(Object obj, long elementSize) {
            return this.execute(obj, elementSize, ByteOrder.LITTLE_ENDIAN);
        }

        public final PBytes executeBigEndian(Object obj, long elementSize) {
            return this.execute(obj, elementSize, ByteOrder.BIG_ENDIAN);
        }

        public abstract PBytes execute(Object var1, long var2, ByteOrder var4);

        @Specialization
        static PBytes doUnicode(PString s, long elementSize, ByteOrder byteOrder, @Bind(value="this") Node inliningTarget, @Cached StringNodes.StringMaterializeNode materializeNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            return UnicodeAsWideCharNode.doUnicode(materializeNode.execute(inliningTarget, s), elementSize, byteOrder, switchEncodingNode, copyToByteArrayNode, factory);
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PBytes doUnicode(TruffleString s, long elementSize, ByteOrder byteOrder, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode, @Cached.Shared(value="factory") @Cached PythonObjectFactory factory) {
            TruffleString.Encoding encoding;
            TruffleString.Encoding encoding2 = encoding = byteOrder == ByteOrder.LITTLE_ENDIAN ? TruffleString.Encoding.UTF_32LE : TruffleString.Encoding.UTF_32BE;
            if (elementSize == 2L) {
                ByteBuffer bytes = ByteBuffer.wrap(UnicodeAsWideCharNode.getBytes(s, switchEncodingNode, copyToByteArrayNode, encoding));
                int size = bytes.remaining() / 2;
                ByteBuffer buf = ByteBuffer.allocate(size);
                while (bytes.remaining() >= 4) {
                    if (byteOrder != ByteOrder.nativeOrder()) {
                        buf.putChar((char)((bytes.getInt() & 0xFFFF0000) >> 16));
                        continue;
                    }
                    buf.putChar((char)(bytes.getInt() & 0xFFFF));
                }
                buf.flip();
                byte[] barr = new byte[buf.remaining()];
                buf.get(barr);
                return factory.createBytes(barr);
            }
            if (elementSize == 4L) {
                return factory.createBytes(UnicodeAsWideCharNode.getBytes(s, switchEncodingNode, copyToByteArrayNode, encoding));
            }
            throw new RuntimeException("unsupported wchar size; was: " + elementSize);
        }

        private static byte[] getBytes(TruffleString s, TruffleString.SwitchEncodingNode switchEncodingNode, TruffleString.CopyToByteArrayNode copyToByteArrayNode, TruffleString.Encoding encoding) {
            TruffleString utf32String = switchEncodingNode.execute((AbstractTruffleString)s, encoding);
            int len = utf32String.byteLength(encoding);
            byte[] b = new byte[len];
            copyToByteArrayNode.execute((AbstractTruffleString)utf32String, 0, b, 0, len, encoding);
            return b;
        }
    }
}

