/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.memoryview.CExtPyBuffer;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.TruffleObject;
import com.oracle.truffle.api.interop.UnknownIdentifierException;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class GraalHPyBuffer
implements TruffleObject {
    private static final String J_MEMBER_BUF = "buf";
    private static final String J_MEMBER_OBJ = "obj";
    private static final String J_MEMBER_LEN = "len";
    private static final String J_MEMBER_ITEMSIZE = "itemsize";
    private static final String J_MEMBER_READONLY = "readonly";
    private static final String J_MEMBER_NDIM = "ndim";
    private static final String J_MEMBER_FORMAT = "format";
    private static final String J_MEMBER_SHAPE = "shape";
    private static final String J_MEMBER_STRIDES = "strides";
    private static final String J_MEMBER_SUBOFFSETS = "suboffsets";
    private static final String J_MEMBER_INTERNAL = "internal";
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private static final String[] MEMBERS = new String[]{"buf", "obj", "len", "itemsize", "readonly", "ndim", "format", "shape", "strides", "suboffsets", "internal"};
    private final GraalHPyContext context;
    private final CExtPyBuffer buffer;
    private GraalHPyHandle ownerHandle;
    Object nativePointer;

    public GraalHPyBuffer(GraalHPyContext context, CExtPyBuffer buffer) {
        this.context = context;
        this.buffer = buffer;
    }

    @ExportMessage
    boolean hasMembers() {
        return true;
    }

    @ExportMessage
    Object getMembers(boolean includeInternal) {
        return new PythonAbstractObject.Keys(new Object[]{J_MEMBER_BUF, J_MEMBER_OBJ, J_MEMBER_LEN, J_MEMBER_ITEMSIZE, J_MEMBER_READONLY, J_MEMBER_NDIM, J_MEMBER_FORMAT, J_MEMBER_SHAPE, J_MEMBER_STRIDES, J_MEMBER_SUBOFFSETS, J_MEMBER_INTERNAL});
    }

    @ExportMessage
    boolean isMemberReadable(String key) {
        for (int i = 0; i < MEMBERS.length; ++i) {
            if (!MEMBERS[i].equals(key)) continue;
            return true;
        }
        return false;
    }

    @ExportMessage
    Object readMember(String member, @Cached.Shared(value="toNativeNode") @Cached GraalHPyNodes.HPyAsHandleNode toNativeNode) throws UnknownIdentifierException {
        switch (member) {
            case "buf": {
                return this.buffer.getBuf();
            }
            case "obj": {
                if (this.ownerHandle == null) {
                    Object obj = this.buffer.getObj();
                    this.ownerHandle = toNativeNode.execute(obj != null ? obj : PNone.NO_VALUE);
                }
                return this.ownerHandle;
            }
            case "len": {
                return this.buffer.getLen();
            }
            case "itemsize": {
                return this.buffer.getItemSize();
            }
            case "readonly": {
                return PInt.intValue(this.buffer.isReadOnly());
            }
            case "ndim": {
                return this.buffer.getDims();
            }
            case "format": {
                return this.buffer.getFormat() != null ? new CArrayWrappers.CStringWrapper(this.buffer.getFormat()) : toNativeNode.execute(PNone.NO_VALUE);
            }
            case "shape": {
                return GraalHPyBuffer.toCArray(toNativeNode, this.buffer.getShape());
            }
            case "strides": {
                return GraalHPyBuffer.toCArray(toNativeNode, this.buffer.getStrides());
            }
            case "suboffsets": {
                return GraalHPyBuffer.toCArray(toNativeNode, this.buffer.getSuboffsets());
            }
            case "internal": {
                return this.buffer.getInternal();
            }
        }
        CompilerDirectives.transferToInterpreterAndInvalidate();
        throw UnknownIdentifierException.create((String)member);
    }

    private static Object toCArray(GraalHPyNodes.HPyAsHandleNode toNativeNode, int[] arr) {
        if (arr != null) {
            return new CArrayWrappers.CIntArrayWrapper(arr);
        }
        return toNativeNode.execute(PNone.NO_VALUE);
    }

    @ExportMessage
    boolean isPointer() {
        return this.nativePointer != null;
    }

    @ExportMessage(limit="1")
    long asPointer(@CachedLibrary(value="this.nativePointer") InteropLibrary lib) throws UnsupportedMessageException {
        return lib.asPointer(this.nativePointer);
    }

    @ExportMessage
    void toNative(@Cached GraalHPyNodes.PCallHPyFunction callBufferToNativeNode, @Cached.Shared(value="toNativeNode") @Cached GraalHPyNodes.HPyAsHandleNode toNativeNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        if (this.nativePointer == null) {
            if (this.ownerHandle == null) {
                Object obj = this.buffer.getObj();
                this.ownerHandle = toNativeNode.execute(obj != null ? obj : PNone.NO_VALUE);
            }
            Object[] args = new Object[]{this.buffer.getBuf(), this.ownerHandle, this.buffer.getLen(), this.buffer.getItemSize(), PInt.intValue(this.buffer.isReadOnly()), this.buffer.getDims(), CArrayWrappers.stringToNativeUtf8Bytes(this.buffer.getFormat(), switchEncodingNode, copyToByteArrayNode), GraalHPyBuffer.intArrayToNativeInt64(this.buffer.getShape()), GraalHPyBuffer.intArrayToNativeInt64(this.buffer.getStrides()), GraalHPyBuffer.intArrayToNativeInt64(this.buffer.getSuboffsets()), this.buffer.getInternal()};
            this.nativePointer = callBufferToNativeNode.execute(this.context, GraalHPyNativeSymbol.GRAAL_HPY_BUFFER_TO_NATIVE, args);
        }
    }

    private static long intArrayToNativeInt64(int[] data) {
        if (data != null) {
            return CArrayWrappers.intArrayToNativeInt64(data);
        }
        return 0L;
    }

    void free(GraalHPyNodes.PCallHPyFunction callBufferFreeNode) {
        if (this.ownerHandle != null) {
            this.ownerHandle.closeAndInvalidate(this.context);
        }
        if (this.nativePointer != null) {
            callBufferFreeNode.call(this.context, GraalHPyNativeSymbol.GRAAL_HPY_BUFFER_FREE, this.nativePointer);
        }
    }
}

