/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import sun.misc.Unsafe;

public abstract class GraalHPyNativeCache {
    private static final Unsafe UNSAFE = CArrayWrappers.UNSAFE;
    private static final long HANDLE_MIRROR_OFFSET = 1L;

    static long toBytes(long idx) {
        return (1L + idx) * 8L;
    }

    static long allocateNativeCache(int nHandleTable, int nGlobalsTable) {
        long arraySize = GraalHPyNativeCache.toBytes(nHandleTable + nGlobalsTable);
        long arrayPtr = UNSAFE.allocateMemory(arraySize);
        UNSAFE.setMemory(arrayPtr, arraySize, (byte)0);
        UNSAFE.putLong(arrayPtr, nHandleTable);
        return arrayPtr;
    }

    static long reallocateNativeCache(long cachePtr, int nHandleTableOld, int nHandleTable, int nGlobalsTableOld, int nGlobalsTable) {
        if (nHandleTableOld > nHandleTable || nGlobalsTableOld > nGlobalsTable) {
            throw new RuntimeException("shrinking HPy handle/globals table is not yet supported");
        }
        long arraySize = GraalHPyNativeCache.toBytes(nHandleTable + nGlobalsTable);
        long newCachePtr = UNSAFE.reallocateMemory(cachePtr, arraySize);
        if (nHandleTableOld != nHandleTable) {
            UNSAFE.putLong(newCachePtr, nHandleTable);
            UNSAFE.copyMemory(newCachePtr + GraalHPyNativeCache.toBytes(nHandleTableOld), newCachePtr + GraalHPyNativeCache.toBytes(nHandleTable), (long)nGlobalsTableOld * 8L);
        }
        return newCachePtr;
    }

    static void putHandleNativeSpacePointer(long cachePtr, int handleID, long value) {
        UNSAFE.putLong(cachePtr + GraalHPyNativeCache.toBytes(handleID), value);
    }

    static void putGlobalNativeSpacePointer(long cachePtr, long nHandleTable, int globalID, long value) {
        UNSAFE.putLong(cachePtr + GraalHPyNativeCache.toBytes(nHandleTable + (long)globalID), value);
    }

    static void initGlobalsNativeSpacePointer(long cachePtr, long nHandleTable, int globalStartID, int numElem) {
        UNSAFE.setMemory(cachePtr + GraalHPyNativeCache.toBytes(nHandleTable + (long)globalStartID), (long)numElem * 8L, (byte)0);
    }
}

