/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.itertools.CountBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.itertools.PCount;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectReprAsObjectNode;
import com.oracle.graal.python.lib.PyObjectTypeCheck;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToJavaLongExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PCount})
public final class CountBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return CountBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object reducePos(PCount self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached CastToJavaLongExactNode castLongNode, @Cached PyObjectTypeCheck typeCheckNode, @Cached InlinedConditionProfile hasDefaultStep) {
            Object type = getClassNode.execute(inliningTarget, self);
            PTuple tuple = hasDefaultStep.profile(inliningTarget, !typeCheckNode.execute(inliningTarget, self.getStep(), (Object)PythonBuiltinClassType.PInt) || castLongNode.execute(inliningTarget, self.getStep()) != 1L) ? this.factory().createTuple(new Object[]{self.getCnt(), self.getStep()}) : this.factory().createTuple(new Object[]{self.getCnt()});
            return this.factory().createTuple(new Object[]{type, tuple});
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static TruffleString reprPos(VirtualFrame frame, PCount self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached PyObjectGetAttr getAttrNode, @Cached PyObjectReprAsObjectNode reprNode, @Cached CastToTruffleStringNode castStringNode, @Cached CastToJavaLongExactNode castLongNode, @Cached PyObjectTypeCheck typeCheckNode, @Cached InlinedBranchProfile hasDefaultStep, @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object type = getClassNode.execute(inliningTarget, self);
            TruffleString name = castStringNode.execute(inliningTarget, getAttrNode.execute((Frame)frame, inliningTarget, type, SpecialAttributeNames.T___NAME__));
            TruffleString cntRepr = castStringNode.execute(inliningTarget, reprNode.execute((Frame)frame, inliningTarget, self.getCnt()));
            if (!typeCheckNode.execute(inliningTarget, self.getStep(), (Object)PythonBuiltinClassType.PInt) || castLongNode.execute(inliningTarget, self.getStep()) != 1L) {
                hasDefaultStep.enter(inliningTarget);
                return simpleTruffleStringFormatNode.format("%s(%s, %s)", name, cntRepr, castStringNode.execute(inliningTarget, reprNode.execute((Frame)frame, inliningTarget, self.getStep())));
            }
            return simpleTruffleStringFormatNode.format("%s(%s)", name, cntRepr);
        }
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class NextNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object next(VirtualFrame frame, PCount self, @Cached BinaryArithmetic.AddNode addNode) {
            Object cnt = self.getCnt();
            self.setCnt(addNode.executeObject(frame, self.getCnt(), self.getStep()));
            return cnt;
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object iter(PCount self) {
            return self;
        }
    }
}

