/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.method;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.method.AbstractMethodBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.method.PBuiltinMethod;
import com.oracle.graal.python.builtins.objects.method.PMethod;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.str.StringUtils;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.IndirectCallNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.attributes.GetAttributeNode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonVarargsBuiltinNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PMethod, PythonBuiltinClassType.PBuiltinFunctionOrMethod, PythonBuiltinClassType.MethodWrapper})
public final class AbstractMethodBuiltins
extends PythonBuiltins {
    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return AbstractMethodBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonBuiltinNode {
        protected static boolean isSelfModuleOrNull(PMethod method) {
            return method.getSelf() == null || PGuards.isPythonModule(method.getSelf());
        }

        protected static boolean isSelfModuleOrNull(PBuiltinMethod method) {
            return method.getSelf() == null || PGuards.isPythonModule(method.getSelf());
        }

        @Specialization(guards={"isSelfModuleOrNull(method)"})
        static TruffleString doSelfIsModule(VirtualFrame frame, PMethod method, Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getName") @Cached PyObjectGetAttr getName) {
            return ReduceNode.getName(frame, inliningTarget, method.getFunction(), toStringNode, getName);
        }

        @Specialization(guards={"isSelfModuleOrNull(method)"})
        static TruffleString doSelfIsModule(VirtualFrame frame, PBuiltinMethod method, Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getName") @Cached PyObjectGetAttr getName) {
            return ReduceNode.getName(frame, inliningTarget, method.getFunction(), toStringNode, getName);
        }

        @Specialization(guards={"!isSelfModuleOrNull(method)"})
        PTuple doSelfIsObjet(VirtualFrame frame, PMethod method, Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getGetAttr") @Cached PyObjectGetAttr getGetAttr, @Cached.Shared(value="getName") @Cached PyObjectGetAttr getName) {
            PythonModule builtins = this.getContext().getBuiltins();
            Object getattr = getGetAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_GETATTR);
            PTuple args = this.factory().createTuple(new Object[]{method.getSelf(), ReduceNode.getName(frame, inliningTarget, method.getFunction(), toStringNode, getName)});
            return this.factory().createTuple(new Object[]{getattr, args});
        }

        @Specialization(guards={"!isSelfModuleOrNull(method)"})
        PTuple doSelfIsObject(VirtualFrame frame, PBuiltinMethod method, Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getGetAttr") @Cached PyObjectGetAttr getGetAttr, @Cached.Shared(value="getName") @Cached PyObjectGetAttr getName) {
            PythonModule builtins = this.getContext().getBuiltins();
            Object getattr = getGetAttr.execute((Frame)frame, inliningTarget, builtins, BuiltinNames.T_GETATTR);
            PTuple args = this.factory().createTuple(new Object[]{method.getSelf(), ReduceNode.getName(frame, inliningTarget, method.getFunction(), toStringNode, getName)});
            return this.factory().createTuple(new Object[]{getattr, args});
        }

        private static TruffleString getName(VirtualFrame frame, Node inliningTarget, Object func, CastToTruffleStringNode toStringNode, PyObjectGetAttr getName) {
            return toStringNode.execute(inliningTarget, getName.execute((Frame)frame, inliningTarget, func, SpecialAttributeNames.T___NAME__));
        }
    }

    @Builtin(name="__qualname__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class QualNameNode
    extends PythonUnaryBuiltinNode {
        protected static boolean isSelfModuleOrNull(PMethod method) {
            return method.getSelf() == null || PGuards.isPythonModule(method.getSelf());
        }

        protected static boolean isSelfModuleOrNull(PBuiltinMethod method) {
            return method.getSelf() == null || PGuards.isPythonModule(method.getSelf());
        }

        @Specialization(guards={"isSelfModuleOrNull(method)"})
        static TruffleString doSelfIsModule(VirtualFrame frame, PMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="lookupName") @Cached PyObjectLookupAttr lookupName) {
            return QualNameNode.getName(frame, inliningTarget, method.getFunction(), toStringNode, lookupName);
        }

        @Specialization(guards={"isSelfModuleOrNull(method)"})
        static TruffleString doSelfIsModule(VirtualFrame frame, PBuiltinMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="lookupName") @Cached PyObjectLookupAttr lookupName) {
            return QualNameNode.getName(frame, inliningTarget, method.getFunction(), toStringNode, lookupName);
        }

        @Specialization(guards={"!isSelfModuleOrNull(method)"})
        TruffleString doSelfIsObjet(VirtualFrame frame, PMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getQualname") @Cached PyObjectGetAttr getQualname, @Cached.Shared(value="lookupName") @Cached PyObjectLookupAttr lookupName, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return this.getQualName(frame, inliningTarget, method.getSelf(), method.getFunction(), getClassNode, isTypeNode, toStringNode, getQualname, lookupName, simpleTruffleStringFormatNode);
        }

        @Specialization(guards={"!isSelfModuleOrNull(method)"})
        TruffleString doSelfIsObjet(VirtualFrame frame, PBuiltinMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getQualname") @Cached PyObjectGetAttr getQualname, @Cached.Shared(value="lookupName") @Cached PyObjectLookupAttr lookupName, @Cached.Shared(value="formatter") @Cached StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            return this.getQualName(frame, inliningTarget, method.getSelf(), method.getFunction(), getClassNode, isTypeNode, toStringNode, getQualname, lookupName, simpleTruffleStringFormatNode);
        }

        private TruffleString getQualName(VirtualFrame frame, Node inliningTarget, Object self, Object func, GetClassNode getClassNode, TypeNodes.IsTypeNode isTypeNode, CastToTruffleStringNode toStringNode, PyObjectGetAttr getQualname, PyObjectLookupAttr lookupName, StringUtils.SimpleTruffleStringFormatNode simpleTruffleStringFormatNode) {
            Object type = isTypeNode.execute(inliningTarget, self) ? self : getClassNode.execute(inliningTarget, self);
            try {
                TruffleString typeQualName = toStringNode.execute(inliningTarget, getQualname.execute((Frame)frame, inliningTarget, type, SpecialAttributeNames.T___QUALNAME__));
                return simpleTruffleStringFormatNode.format("%s.%s", typeQualName, QualNameNode.getName(frame, inliningTarget, func, toStringNode, lookupName));
            }
            catch (CannotCastException cce) {
                throw this.raise(PythonBuiltinClassType.TypeError, ErrorMessages.IS_NOT_A_UNICODE_OBJECT, SpecialAttributeNames.T___QUALNAME__);
            }
        }

        private static TruffleString getName(VirtualFrame frame, Node inliningTarget, Object func, CastToTruffleStringNode toStringNode, PyObjectLookupAttr lookupName) {
            return toStringNode.execute(inliningTarget, lookupName.execute((Frame)frame, inliningTarget, func, SpecialAttributeNames.T___NAME__));
        }
    }

    @Builtin(name="__name__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class NameNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        static Object getName(VirtualFrame frame, PBuiltinMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getAttr") @Cached PyObjectGetAttr getAttr) {
            try {
                return toStringNode.execute(inliningTarget, getAttr.execute((Frame)frame, inliningTarget, method.getFunction(), SpecialAttributeNames.T___NAME__));
            }
            catch (CannotCastException cce) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        @Specialization
        static Object getName(VirtualFrame frame, PMethod method, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="toStringNode") @Cached CastToTruffleStringNode toStringNode, @Cached.Shared(value="getAttr") @Cached PyObjectGetAttr getAttr) {
            try {
                return toStringNode.execute(inliningTarget, getAttr.execute((Frame)frame, inliningTarget, method.getFunction(), SpecialAttributeNames.T___NAME__));
            }
            catch (CannotCastException cce) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @Builtin(name="__doc__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class DocNode
    extends PythonUnaryBuiltinNode {
        DocNode() {
        }

        @Specialization
        static Object getDoc(PMethod self, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            Object doc = readNode.execute(self.getFunction(), SpecialAttributeNames.T___DOC__);
            if (doc == PNone.NO_VALUE) {
                return PNone.NONE;
            }
            return doc;
        }

        @Specialization
        static Object getDoc(PBuiltinMethod self, @Cached.Shared @Cached ReadAttributeFromObjectNode readNode) {
            Object doc = readNode.execute(self.getFunction(), SpecialAttributeNames.T___DOC__);
            if (doc == PNone.NO_VALUE) {
                return PNone.NONE;
            }
            return doc;
        }
    }

    @Builtin(name="__module__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true)
    @GenerateNodeFactory
    static abstract class GetModuleNode
    extends PythonBinaryBuiltinNode {
        GetModuleNode() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization(guards={"isNoValue(none)"}, limit="2")
        static Object getModule(VirtualFrame frame, PBuiltinMethod self, PNone none, @Bind(value="this") Node inliningTarget, @Bind(value="getThisAsIndirectCallNode()") IndirectCallNode indirectCallNode, @Cached PyObjectLookupAttr lookup, @CachedLibrary(value="self") DynamicObjectLibrary dylib) {
            Object module = dylib.getOrDefault((DynamicObject)self, (Object)SpecialAttributeNames.T___MODULE__, (Object)PNone.NO_VALUE);
            if (module != PNone.NO_VALUE) {
                return module;
            }
            if (self.getSelf() instanceof PythonModule) {
                PythonLanguage language = PythonLanguage.get(inliningTarget);
                Object state = ExecutionContext.IndirectCallContext.enter(frame, language, PythonContext.get(inliningTarget), indirectCallNode);
                try {
                    Object object = lookup.execute(null, inliningTarget, self.getSelf(), SpecialAttributeNames.T___NAME__);
                    return object;
                }
                finally {
                    ExecutionContext.IndirectCallContext.exit(frame, language, PythonContext.get(inliningTarget), state);
                }
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isNoValue(value)"}, limit="2")
        static Object getModule(PBuiltinMethod self, Object value, @CachedLibrary(value="self") DynamicObjectLibrary dylib) {
            dylib.put(self.getStorage(), (Object)SpecialAttributeNames.T___MODULE__, value);
            return PNone.NONE;
        }

        @Specialization(guards={"isNoValue(value)"})
        static Object getModule(VirtualFrame frame, PMethod self, Object value, @Cached(value="create(T___MODULE__)") GetAttributeNode getAttributeNode) {
            return getAttributeNode.executeObject(frame, self.getFunction());
        }

        @Specialization(guards={"!isNoValue(value)"})
        Object getModule(PMethod self, Object value) {
            throw this.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_S_HAS_NO_ATTR_S, "method", SpecialAttributeNames.T___MODULE__);
        }
    }

    @Builtin(name="__hash__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class HashNode
    extends PythonUnaryBuiltinNode {
        HashNode() {
        }

        @Specialization
        static long hash(PMethod self) {
            return PythonAbstractObject.systemHashCode(self.getSelf()) ^ PythonAbstractObject.systemHashCode(self.getFunction());
        }

        @Specialization
        static long hash(PBuiltinMethod self) {
            return PythonAbstractObject.systemHashCode(self.getSelf()) ^ PythonAbstractObject.systemHashCode(self.getFunction());
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private InteropLibrary identicalLib = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);
        @Node.Child
        private InteropLibrary identicalLib2 = (InteropLibrary)InteropLibrary.getFactory().createDispatched(3);

        EqNode() {
        }

        private boolean eq(Object function1, Object function2, Object self1, Object self2) {
            if (function1 != function2) {
                return false;
            }
            if (self1 != self2) {
                return self1 instanceof PythonAbstractNativeObject && self2 instanceof PythonAbstractNativeObject && this.identicalLib.isIdentical(((PythonAbstractNativeObject)self1).getPtr(), ((PythonAbstractNativeObject)self2).getPtr(), this.identicalLib2);
            }
            return true;
        }

        @Specialization
        boolean eq(PMethod self, PMethod other) {
            return this.eq(self.getFunction(), other.getFunction(), self.getSelf(), other.getSelf());
        }

        @Specialization
        boolean eq(PBuiltinMethod self, PBuiltinMethod other) {
            return this.eq(self.getFunction(), other.getFunction(), self.getSelf(), other.getSelf());
        }

        @Fallback
        static boolean eq(Object self, Object other) {
            return false;
        }
    }

    @Builtin(name="__self__", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    public static abstract class SelfNode
    extends PythonBuiltinNode {
        @Specialization
        protected static Object doIt(PMethod self) {
            return self.getSelf();
        }

        @Specialization
        protected static Object doIt(PBuiltinMethod self) {
            if (self.getBuiltinFunction().isStatic()) {
                return PNone.NONE;
            }
            return self.getSelf();
        }
    }

    @Builtin(name="__call__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class CallNode
    extends PythonVarargsBuiltinNode {
        @Node.Child
        private com.oracle.graal.python.nodes.call.CallNode callNode = com.oracle.graal.python.nodes.call.CallNode.create();

        @Specialization(guards={"isFunction(self.getFunction())"})
        protected Object doIt(VirtualFrame frame, PMethod self, Object[] arguments, PKeyword[] keywords) {
            return this.callNode.execute((Frame)frame, (Object)self, arguments, keywords);
        }

        @Specialization(guards={"isFunction(self.getFunction())"})
        protected Object doIt(VirtualFrame frame, PBuiltinMethod self, Object[] arguments, PKeyword[] keywords) {
            return this.callNode.execute((Frame)frame, (Object)self, arguments, keywords);
        }

        @Specialization(guards={"!isFunction(self.getFunction())"})
        protected Object doItNonFunction(VirtualFrame frame, PMethod self, Object[] arguments, PKeyword[] keywords) {
            return this.callNode.execute((Frame)frame, self.getFunction(), PythonUtils.prependArgument(self.getSelf(), arguments), keywords);
        }

        @Specialization(guards={"!isFunction(self.getFunction())"})
        protected Object doItNonFunction(VirtualFrame frame, PBuiltinMethod self, Object[] arguments, PKeyword[] keywords) {
            return this.callNode.execute((Frame)frame, self.getFunction(), PythonUtils.prependArgument(self.getSelf(), arguments), keywords);
        }

        @Override
        public Object varArgExecute(VirtualFrame frame, Object self, Object[] arguments, PKeyword[] keywords) throws PythonVarargsBuiltinNode.VarargsBuiltinDirectInvocationNotSupported {
            Object[] argsWithoutSelf = new Object[arguments.length - 1];
            PythonUtils.arraycopy(arguments, 1, argsWithoutSelf, 0, argsWithoutSelf.length);
            return this.execute(frame, arguments[0], argsWithoutSelf, keywords);
        }
    }
}

