/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes;

import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.WriteUnraisableNodeGen;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.IOException;

@GenerateUncached
public abstract class WriteUnraisableNode
extends Node {
    private static final TruffleString T_IGNORED = PythonUtils.tsLiteral("Exception ignored ");

    public final void execute(VirtualFrame frame, Object exception, TruffleString message, Object object) {
        this.executeInternal((Frame)frame, exception, message, object);
    }

    public final void execute(Object exception, TruffleString message, Object object) {
        this.executeInternal(null, exception, message, object);
    }

    protected abstract void executeInternal(Frame var1, Object var2, TruffleString var3, Object var4);

    @Specialization
    static void writeUnraisable(VirtualFrame frame, Object exception, TruffleString message, Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectLookupAttr lookup, @Cached CallNode callNode, @Cached GetClassNode getClassNode, @Cached PythonObjectFactory factory, @Cached ExceptionNodes.GetTracebackNode getTracebackNode, @Cached TruffleString.ConcatNode concatNode, @Cached TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        PythonContext context = PythonContext.get(inliningTarget);
        try {
            PythonModule sysModule = context.lookupBuiltinModule(BuiltinNames.T_SYS);
            Object unraisablehook = lookup.execute((Frame)frame, inliningTarget, sysModule, BuiltinNames.T_UNRAISABLEHOOK);
            Object exceptionType = getClassNode.execute(inliningTarget, exception);
            Object traceback = getTracebackNode.execute(inliningTarget, exception);
            PNone messageObj = PNone.NONE;
            if (message != null) {
                messageObj = WriteUnraisableNode.formatMessage(message, concatNode);
            }
            PTuple hookArguments = factory.createStructSeq(SysModuleBuiltins.UNRAISABLEHOOK_ARGS_DESC, exceptionType, exception, traceback, messageObj, object != null ? object : PNone.NONE);
            callNode.execute((Frame)frame, unraisablehook, new Object[]{hookArguments});
        }
        catch (PException e) {
            WriteUnraisableNode.ignoreException(context, message, concatNode, copyToByteArrayNode);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void ignoreException(PythonContext context, TruffleString message, TruffleString.ConcatNode concatNode, TruffleString.CopyToByteArrayNode copyToByteArrayNode) {
        try {
            if (message != null) {
                TruffleString formatedMsg = WriteUnraisableNode.formatMessage(message, concatNode);
                byte[] data = new byte[formatedMsg.byteLength(PythonUtils.TS_ENCODING)];
                copyToByteArrayNode.execute((AbstractTruffleString)formatedMsg, 0, data, 0, data.length, PythonUtils.TS_ENCODING);
                context.getEnv().err().write(data);
            } else {
                context.getEnv().err().write(WriteUnraisableNode.ignoredMsg());
            }
        }
        catch (IOException ioException) {
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    private static TruffleString formatMessage(TruffleString message, TruffleString.ConcatNode concatNode) {
        return concatNode.execute((AbstractTruffleString)T_IGNORED, (AbstractTruffleString)message, PythonUtils.TS_ENCODING, true);
    }

    @CompilerDirectives.TruffleBoundary
    private static byte[] ignoredMsg() {
        return "Exception ignored in sys.unraisablehook".getBytes();
    }

    public static WriteUnraisableNode getUncached() {
        return WriteUnraisableNodeGen.getUncached();
    }
}

