/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.attributes;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.ObjectAttributeNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToDynamicObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToObjectNodeGen;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.PythonOptions;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.TruffleString;

@ImportStatic(value={PythonOptions.class})
@GenerateInline(value=false)
public abstract class WriteAttributeToObjectNode
extends ObjectAttributeNode {
    public abstract boolean execute(Object var1, Object var2, Object var3);

    public abstract boolean execute(Object var1, HiddenKey var2, Object var3);

    @NeverDefault
    public static WriteAttributeToObjectNode create() {
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.create();
    }

    @NeverDefault
    public static WriteAttributeToObjectNode create(boolean forceType) {
        if (forceType) {
            return WriteAttributeToObjectNodeGen.WriteAttributeToObjectTpDictNodeGen.create();
        }
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.create();
    }

    @NeverDefault
    public static WriteAttributeToObjectNode createForceType() {
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectTpDictNodeGen.create();
    }

    public static WriteAttributeToObjectNode getUncached() {
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.getUncached();
    }

    public static WriteAttributeToObjectNode getUncached(boolean forceType) {
        if (forceType) {
            return WriteAttributeToObjectNodeGen.WriteAttributeToObjectTpDictNodeGen.getUncached();
        }
        return WriteAttributeToObjectNodeGen.WriteAttributeToObjectNotTypeNodeGen.getUncached();
    }

    protected static boolean isAttrWritable(PythonObject self, Object key) {
        if (WriteAttributeToObjectNode.isHiddenKey(key)) {
            return true;
        }
        return (self.getShape().getFlags() & 2) == 0;
    }

    private static TruffleString castKey(Node inliningTarget, CastToTruffleStringNode castNode, Object value) {
        try {
            return castNode.execute(inliningTarget, value);
        }
        catch (CannotCastException ex) {
            throw CompilerDirectives.shouldNotReachHere((Throwable)((Object)ex));
        }
    }

    protected static boolean writeToDynamicStorageNoTypeGuard(Object obj, Object key, GetDictIfExistsNode getDict) {
        if (WriteAttributeToObjectNode.isHiddenKey(key)) {
            return true;
        }
        return getDict.execute(obj) == null && !PythonManagedClass.isInstance(obj);
    }

    @Specialization(guards={"isAttrWritable(object, key)", "writeToDynamicStorageNoTypeGuard(object, key, getDict)"})
    static boolean writeToDynamicStorageNoType(PythonObject object, Object key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached WriteAttributeToDynamicObjectNode writeNode) {
        writeNode.execute((Object)object, key, value);
        return true;
    }

    @Specialization(guards={"isAttrWritable(klass, key)", "!isHiddenKey(key)", "getDict.execute(klass) == null"})
    boolean writeToDynamicStorageBuiltinType(PythonBuiltinClass klass, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Shared(value="castToStr") @Cached CastToTruffleStringNode castToStrNode, @Cached.Shared(value="callAttrUpdate") @Cached InlinedBranchProfile callAttrUpdate, @Cached.Shared(value="dylib") @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") DynamicObjectLibrary dylib, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (PythonContext.get(this).isInitialized()) {
            throw PRaiseNode.raiseUncached(this, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, PyObjectReprAsTruffleStringNode.executeUncached(key), klass);
        }
        return WriteAttributeToObjectNode.writeToDynamicStorageManagedClass(klass, key, value, inliningTarget, castToStrNode, callAttrUpdate, dylib, codePointLengthNode, codePointAtIndexNode);
    }

    @Specialization(guards={"isAttrWritable(klass, key)", "!isHiddenKey(key)", "getDict.execute(klass) == null"})
    static boolean writeToDynamicStoragePythonClass(PythonClass klass, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Exclusive @Cached CastToTruffleStringNode castToStrNode, @Cached.Exclusive @Cached InlinedBranchProfile callAttrUpdate, @Cached.Exclusive @Cached InlinedBranchProfile updateFlags, @Cached.Shared(value="dylib") @CachedLibrary(limit="getAttributeAccessInlineCacheMaxDepth()") DynamicObjectLibrary dylib, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (value == PNone.NO_VALUE) {
            updateFlags.enter(inliningTarget);
            dylib.setShapeFlags((DynamicObject)klass, dylib.getShapeFlags((DynamicObject)klass) | 4);
        }
        return WriteAttributeToObjectNode.writeToDynamicStorageManagedClass(klass, key, value, inliningTarget, castToStrNode, callAttrUpdate, dylib, codePointLengthNode, codePointAtIndexNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeToDynamicStorageManagedClass(PythonManagedClass klass, Object key, Object value, Node inliningTarget, CastToTruffleStringNode castToStrNode, InlinedBranchProfile callAttrUpdate, DynamicObjectLibrary dylib, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        CompilerAsserts.partialEvaluationConstant(klass.getClass());
        TruffleString strKey = WriteAttributeToObjectNode.castKey(inliningTarget, castToStrNode, key);
        try {
            dylib.put((DynamicObject)klass, (Object)strKey, value);
            boolean bl = true;
            return bl;
        }
        finally {
            if (!klass.canSkipOnAttributeUpdate(strKey, value, codePointLengthNode, codePointAtIndexNode)) {
                callAttrUpdate.enter(inliningTarget);
                klass.onAttributeUpdate(strKey, value);
            }
        }
    }

    @Specialization(guards={"!isHiddenKey(key)", "dict != null", "!isManagedClass(object)"})
    static boolean writeToDictNoType(PythonObject object, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(object)") PDict dict, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem) {
        return WriteAttributeToObjectNode.writeToDict(dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
    }

    @Specialization(guards={"!isHiddenKey(key)", "dict != null"})
    boolean writeToDictBuiltinType(PythonBuiltinClass klass, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(klass)") PDict dict, @Cached.Shared(value="castToStr") @Cached CastToTruffleStringNode castToStrNode, @Cached.Shared(value="callAttrUpdate") @Cached InlinedBranchProfile callAttrUpdate, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        if (PythonContext.get(this).isInitialized()) {
            throw PRaiseNode.raiseUncached(this, PythonErrorType.TypeError, ErrorMessages.CANT_SET_ATTRIBUTE_R_OF_IMMUTABLE_TYPE_N, PyObjectReprAsTruffleStringNode.executeUncached(key), klass);
        }
        return WriteAttributeToObjectNode.writeToDictManagedClass(klass, dict, key, value, inliningTarget, castToStrNode, callAttrUpdate, updateStorage, setHashingStorageItem, codePointLengthNode, codePointAtIndexNode);
    }

    @Specialization(guards={"!isHiddenKey(key)", "dict != null"})
    static boolean writeToDictClass(PythonClass klass, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Bind(value="getDict.execute(klass)") PDict dict, @Cached.Shared(value="castToStr") @Cached CastToTruffleStringNode castToStrNode, @Cached.Shared(value="callAttrUpdate") @Cached InlinedBranchProfile callAttrUpdate, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        return WriteAttributeToObjectNode.writeToDictManagedClass(klass, dict, key, value, inliningTarget, castToStrNode, callAttrUpdate, updateStorage, setHashingStorageItem, codePointLengthNode, codePointAtIndexNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeToDictManagedClass(PythonManagedClass klass, PDict dict, Object key, Object value, Node inliningTarget, CastToTruffleStringNode castToStrNode, InlinedBranchProfile callAttrUpdate, InlinedBranchProfile updateStorage, HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        CompilerAsserts.partialEvaluationConstant(klass.getClass());
        TruffleString strKey = WriteAttributeToObjectNode.castKey(inliningTarget, castToStrNode, key);
        try {
            boolean bl = WriteAttributeToObjectNode.writeToDict(dict, strKey, value, inliningTarget, updateStorage, setHashingStorageItem);
            return bl;
        }
        finally {
            if (!klass.canSkipOnAttributeUpdate(strKey, value, codePointLengthNode, codePointAtIndexNode)) {
                callAttrUpdate.enter(inliningTarget);
                klass.onAttributeUpdate(strKey, value);
            }
        }
    }

    static boolean writeToDict(PDict dict, Object key, Object value, Node inliningTarget, InlinedBranchProfile updateStorage, HashingStorageNodes.HashingStorageSetItem setHashingStorageItem) {
        HashingStorage hashingStorage;
        assert (dict != null);
        HashingStorage dictStorage = dict.getDictStorage();
        if (dictStorage != (hashingStorage = setHashingStorageItem.execute(null, inliningTarget, dictStorage, key, value))) {
            updateStorage.enter(inliningTarget);
            dict.setDictStorage(hashingStorage);
        }
        return true;
    }

    @Specialization
    static boolean doPBCT(PythonBuiltinClassType object, Object key, Object value, @Cached WriteAttributeToObjectNode recursive) {
        return recursive.execute((Object)PythonContext.get(recursive).lookupType(object), key, value);
    }

    protected static boolean isErrorCase(GetDictIfExistsNode getDict, Object object, Object key) {
        if (object instanceof PythonObject) {
            PythonObject self = (PythonObject)object;
            if (WriteAttributeToObjectNode.isAttrWritable(self, key) && (WriteAttributeToObjectNode.isHiddenKey(key) || getDict.execute(self) == null)) {
                return false;
            }
            if (!WriteAttributeToObjectNode.isHiddenKey(key) && getDict.execute(self) != null) {
                return false;
            }
        }
        if (object instanceof PythonAbstractNativeObject && !WriteAttributeToObjectNode.isHiddenKey(key)) {
            return false;
        }
        return !(object instanceof PythonBuiltinClassType);
    }

    @GenerateUncached
    @GenerateInline(value=false)
    protected static abstract class WriteAttributeToObjectNotTypeNode
    extends WriteAttributeToObjectNode {
        protected WriteAttributeToObjectNotTypeNode() {
        }

        @Specialization(guards={"!isHiddenKey(key)"})
        static boolean writeNativeObject(PythonAbstractNativeObject object, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            PDict dict = getDict.execute(object);
            if (dict != null) {
                return WriteAttributeToObjectNotTypeNode.writeToDict(dict, key, value, inliningTarget, updateStorage, setHashingStorageItem);
            }
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }

        @Specialization(guards={"isErrorCase(getDict, object, key)"})
        static boolean doError(Object object, Object key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }
    }

    @GenerateUncached
    @ImportStatic(value={SpecialMethodSlot.class})
    @GenerateInline(value=false)
    protected static abstract class WriteAttributeToObjectTpDictNode
    extends WriteAttributeToObjectNode {
        protected WriteAttributeToObjectTpDictNode() {
        }

        @Specialization(guards={"!canBeSpecial(keyObj, codePointLengthNode, codePointAtIndexNode)"})
        static boolean writeNativeClassSimple(PythonAbstractNativeObject object, TruffleString keyObj, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached.Shared(value="setHashingStorageItem") @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Shared(value="updateStorage") @Cached InlinedBranchProfile updateStorage, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
            Object dict = getNativeDict.readFromObj(object, CFields.PyTypeObject__tp_dict);
            if (dict instanceof PDict) {
                return WriteAttributeToObjectTpDictNode.writeToDict((PDict)dict, keyObj, value, inliningTarget, updateStorage, setHashingStorageItem);
            }
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, keyObj);
        }

        @Specialization(guards={"!isHiddenKey(keyObj)"}, replaces={"writeNativeClassSimple"})
        static boolean writeNativeClassGeneric(PythonAbstractNativeObject object, Object keyObj, Object value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached CStructAccess.ReadObjectNode getNativeDict, @Cached.Exclusive @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached.Exclusive @Cached InlinedBranchProfile updateStorage, @Cached.Exclusive @Cached InlinedBranchProfile canBeSpecialSlot, @Cached.Exclusive @Cached CastToTruffleStringNode castKeyNode, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode, @Cached.Shared(value="cpLen") @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached.Shared(value="cpAtIndex") @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.EqualNode equalNode) {
            try {
                Object dict = getNativeDict.readFromObj(object, CFields.PyTypeObject__tp_dict);
                if (dict instanceof PDict) {
                    boolean bl = WriteAttributeToObjectTpDictNode.writeToDict((PDict)dict, keyObj, value, inliningTarget, updateStorage, setHashingStorageItem);
                    return bl;
                }
                throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, keyObj);
            }
            finally {
                try {
                    TruffleString key = castKeyNode.execute(inliningTarget, keyObj);
                    if (SpecialMethodSlot.canBeSpecial(key, codePointLengthNode, codePointAtIndexNode)) {
                        canBeSpecialSlot.enter(inliningTarget);
                        SpecialMethodSlot slot = SpecialMethodSlot.findSpecialSlot(key, codePointLengthNode, codePointAtIndexNode, equalNode);
                        if (slot != null && isTypeNode.execute(inliningTarget, object)) {
                            SpecialMethodSlot.fixupSpecialMethodSlot(object, slot, value);
                        }
                    }
                }
                catch (CannotCastException cannotCastException) {}
            }
        }

        @Specialization(guards={"isErrorCase(getDict, object, key)"})
        static boolean doError(Object object, Object key, Object value, @Cached.Shared(value="getDict") @Cached GetDictIfExistsNode getDict, @Cached.Shared(value="raiseNode") @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.AttributeError, ErrorMessages.OBJ_P_HAS_NO_ATTR_S, object, key);
        }
    }
}

