/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.frame;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.frame.AccessNameNode;
import com.oracle.graal.python.nodes.frame.ReadFromLocalsNodeGen;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline(inlineByDefault=true)
@GenerateCached
public abstract class ReadFromLocalsNode
extends PNodeWithContext
implements AccessNameNode {
    public abstract Object execute(VirtualFrame var1, Node var2, Object var3, TruffleString var4);

    public final Object executeCached(VirtualFrame frame, Object locals, TruffleString name) {
        return this.execute(frame, this, locals, name);
    }

    @Specialization(guards={"locals == null"})
    static Object noLocals(VirtualFrame frame, Object locals, TruffleString name) {
        return PNone.NO_VALUE;
    }

    @Specialization(guards={"isBuiltinDict(locals)"})
    static Object readFromLocalsDict(Node inliningTarget, PDict locals, TruffleString name, @Cached HashingStorageNodes.HashingStorageGetItem getItem) {
        Object result = getItem.execute(inliningTarget, locals.getDictStorage(), name);
        if (result == null) {
            return PNone.NO_VALUE;
        }
        return result;
    }

    @Fallback
    static Object readFromLocals(VirtualFrame frame, Node inliningTarget, Object locals, TruffleString name, @Cached PyObjectGetItem getItem, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile) {
        try {
            return getItem.execute((Frame)frame, inliningTarget, locals, name);
        }
        catch (PException e) {
            e.expect(inliningTarget, PythonBuiltinClassType.KeyError, errorProfile);
            return PNone.NO_VALUE;
        }
    }

    @NeverDefault
    public static ReadFromLocalsNode create() {
        return ReadFromLocalsNodeGen.create();
    }

    @NeverDefault
    public static ReadFromLocalsNode getUncached() {
        return ReadFromLocalsNodeGen.getUncached();
    }
}

