/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.nodes.object;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.cell.PCell;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.ellipsis.PEllipsis;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.function.PFunction;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.nodes.HiddenAttributes;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.object.GetClassNodeGen;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Idempotent;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.exception.AbstractTruffleException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.object.DynamicObject;
import com.oracle.truffle.api.object.DynamicObjectLibrary;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

@TypeSystemReference(value=PythonTypes.class)
@ImportStatic(value={PGuards.class})
@GenerateUncached
@GenerateInline(inlineByDefault=true)
public abstract class GetClassNode
extends PNodeWithContext {
    public static GetClassNode getUncached() {
        return GetClassNodeGen.getUncached();
    }

    @NeverDefault
    public static GetClassNode create() {
        return GetClassNodeGen.create();
    }

    public abstract Object execute(Node var1, Object var2);

    public final Object executeCached(Object object) {
        return this.execute(this, object);
    }

    public static Object executeUncached(Object object) {
        return GetClassNodeGen.getUncached().execute(null, object);
    }

    public final Object execute(int i) {
        return PythonBuiltinClassType.PInt;
    }

    public final Object execute(double d) {
        return PythonBuiltinClassType.PFloat;
    }

    @Specialization
    static Object getBoolean(Boolean object) {
        return PythonBuiltinClassType.Boolean;
    }

    @Specialization
    static Object getInt(Integer object) {
        return PythonBuiltinClassType.PInt;
    }

    @Specialization
    static Object getLong(Long object) {
        return PythonBuiltinClassType.PInt;
    }

    @Specialization
    static Object getDouble(Double object) {
        return PythonBuiltinClassType.PFloat;
    }

    @Specialization
    static Object getString(TruffleString object) {
        return PythonBuiltinClassType.PString;
    }

    @Specialization
    static Object getNone(PNone object) {
        return PythonBuiltinClassType.PNone;
    }

    @Specialization
    static Object getBuiltinClass(PythonBuiltinClass object) {
        return object.getInitialPythonClass();
    }

    @Specialization
    static Object getFunction(PFunction object) {
        return object.getInitialPythonClass();
    }

    @Specialization
    static Object getBuiltinFunction(PBuiltinFunction object) {
        return object.getInitialPythonClass();
    }

    @Specialization(guards={"isPythonObject(object) || isNativeObject(object)"})
    static Object getPythonObjectOrNative(PythonAbstractObject object, @Cached(inline=false) GetPythonObjectClassNode getClassNode) {
        return getClassNode.executeCached(object);
    }

    @Specialization
    static Object getPBCT(PythonBuiltinClassType object) {
        return PythonBuiltinClassType.PythonClass;
    }

    @Specialization
    static Object getNotImplemented(PNotImplemented object) {
        return PythonBuiltinClassType.PNotImplemented;
    }

    @Specialization
    static Object getEllipsis(PEllipsis object) {
        return PythonBuiltinClassType.PEllipsis;
    }

    @Specialization
    static Object getCell(PCell object) {
        return PythonBuiltinClassType.PCell;
    }

    @Specialization
    static Object getNativeVoidPtr(PythonNativeVoidPtr object) {
        return PythonBuiltinClassType.PInt;
    }

    @Specialization
    static Object getTruffleException(AbstractTruffleException object) {
        assert (!(object instanceof PException));
        return PythonBuiltinClassType.PForeignException;
    }

    @Fallback
    static Object getForeign(Object object) {
        return PythonBuiltinClassType.ForeignObject;
    }

    @GenerateUncached
    @GenerateInline(inlineByDefault=true)
    public static abstract class GetPythonObjectClassNode
    extends PNodeWithContext {
        public static Object executeUncached(PythonObject object) {
            return GetClassNodeGen.getUncached().execute(null, object);
        }

        final Object executeCached(PythonAbstractObject object) {
            assert (object instanceof PythonObject || object instanceof PythonAbstractNativeObject);
            return this.executeImpl(this, object);
        }

        abstract Object executeImpl(Node var1, PythonAbstractObject var2);

        public abstract Object execute(Node var1, PythonObject var2);

        public abstract Object execute(Node var1, PythonAbstractNativeObject var2);

        @Specialization(guards={"isSingleContext()", "klass != null", "object.getShape() == cachedShape", "hasInitialClass(cachedShape)"}, limit="1")
        static Object getPythonObjectConstantClass(PythonObject object, @Cached(value="object.getShape()") Shape cachedShape, @Cached(value="object.getInitialPythonClass()", weak=true) Object klass) {
            return klass;
        }

        @Specialization(guards={"hasInitialClass(object.getShape())"})
        static Object getPythonObject(PythonObject object, @Bind(value="object.getInitialPythonClass()") Object klass) {
            assert (klass != null);
            return klass;
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization(guards={"!hasInitialClass(object.getShape())"}, replaces={"getPythonObjectConstantClass"})
        static Object getPythonObject(PythonObject object, @CachedLibrary(limit="4") DynamicObjectLibrary dylib) {
            return dylib.getOrDefault((DynamicObject)object, (Object)HiddenAttributes.CLASS, object.getInitialPythonClass());
        }

        @HostCompilerDirectives.InliningCutoff
        @Specialization
        static Object getNativeObject(PythonAbstractNativeObject object, @Cached(inline=false) CExtNodes.GetNativeClassNode getNativeClassNode) {
            return getNativeClassNode.execute(object);
        }

        @Idempotent
        protected static boolean hasInitialClass(Shape shape) {
            return (shape.getFlags() & 1) == 0;
        }
    }
}

