/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.runtime.PosixConstants;
import com.oracle.graal.python.runtime.PosixSupport;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.library.GenerateLibrary;
import com.oracle.truffle.api.library.Library;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.memory.ByteArraySupport;
import com.oracle.truffle.api.strings.TruffleString;
import java.nio.ByteBuffer;
import java.util.Arrays;

@GenerateLibrary(receiverType=PosixSupport.class)
public abstract class PosixSupportLibrary
extends Library {
    public static final char POSIX_FILENAME_SEPARATOR = '/';
    public static final int ST_MODE = 0;
    public static final int ST_SIZE = 6;
    static final LibraryFactory<PosixSupportLibrary> FACTORY = LibraryFactory.resolve(PosixSupportLibrary.class);

    public abstract TruffleString getBackend(Object var1);

    public abstract TruffleString strerror(Object var1, int var2);

    public abstract long getpid(Object var1);

    public abstract int umask(Object var1, int var2) throws PosixException;

    public abstract int openat(Object var1, int var2, Object var3, int var4, int var5) throws PosixException;

    public abstract int close(Object var1, int var2) throws PosixException;

    public abstract Buffer read(Object var1, int var2, long var3) throws PosixException;

    public abstract long write(Object var1, int var2, Buffer var3) throws PosixException;

    public abstract int dup(Object var1, int var2) throws PosixException;

    public abstract int dup2(Object var1, int var2, int var3, boolean var4) throws PosixException;

    public abstract boolean getInheritable(Object var1, int var2) throws PosixException;

    public abstract void setInheritable(Object var1, int var2, boolean var3) throws PosixException;

    public abstract int[] pipe(Object var1) throws PosixException;

    public abstract SelectResult select(Object var1, int[] var2, int[] var3, int[] var4, Timeval var5) throws PosixException;

    public abstract long lseek(Object var1, int var2, long var3, int var5) throws PosixException;

    public abstract void ftruncate(Object var1, int var2, long var3) throws PosixException;

    public abstract void fsync(Object var1, int var2) throws PosixException;

    public abstract void flock(Object var1, int var2, int var3) throws PosixException;

    public abstract boolean getBlocking(Object var1, int var2) throws PosixException;

    public abstract void setBlocking(Object var1, int var2, boolean var3) throws PosixException;

    public abstract int[] getTerminalSize(Object var1, int var2) throws PosixException;

    public abstract long[] fstatat(Object var1, int var2, Object var3, boolean var4) throws PosixException;

    public abstract long[] fstat(Object var1, int var2) throws PosixException;

    public abstract long[] statvfs(Object var1, Object var2) throws PosixException;

    public abstract long[] fstatvfs(Object var1, int var2) throws PosixException;

    public abstract Object[] uname(Object var1) throws PosixException;

    public abstract void unlinkat(Object var1, int var2, Object var3, boolean var4) throws PosixException;

    public abstract void linkat(Object var1, int var2, Object var3, int var4, Object var5, int var6) throws PosixException;

    public abstract void symlinkat(Object var1, Object var2, int var3, Object var4) throws PosixException;

    public abstract void mkdirat(Object var1, int var2, Object var3, int var4) throws PosixException;

    public abstract Object getcwd(Object var1) throws PosixException;

    public abstract void chdir(Object var1, Object var2) throws PosixException;

    public abstract void fchdir(Object var1, int var2) throws PosixException;

    public abstract boolean isatty(Object var1, int var2);

    public abstract Object opendir(Object var1, Object var2) throws PosixException;

    public abstract Object fdopendir(Object var1, int var2) throws PosixException;

    public abstract void closedir(Object var1, Object var2) throws PosixException;

    public abstract Object readdir(Object var1, Object var2) throws PosixException;

    public abstract void rewinddir(Object var1, Object var2);

    public abstract Object dirEntryGetName(Object var1, Object var2) throws PosixException;

    public abstract Object dirEntryGetPath(Object var1, Object var2, Object var3) throws PosixException;

    public abstract long dirEntryGetInode(Object var1, Object var2) throws PosixException;

    public abstract int dirEntryGetType(Object var1, Object var2);

    public abstract void utimensat(Object var1, int var2, Object var3, long[] var4, boolean var5) throws PosixException;

    public abstract void futimens(Object var1, int var2, long[] var3) throws PosixException;

    public abstract void futimes(Object var1, int var2, Timeval[] var3) throws PosixException;

    public abstract void lutimes(Object var1, Object var2, Timeval[] var3) throws PosixException;

    public abstract void utimes(Object var1, Object var2, Timeval[] var3) throws PosixException;

    public abstract void renameat(Object var1, int var2, Object var3, int var4, Object var5) throws PosixException;

    public abstract boolean faccessat(Object var1, int var2, Object var3, int var4, boolean var5, boolean var6);

    public abstract void fchmodat(Object var1, int var2, Object var3, int var4, boolean var5) throws PosixException;

    public abstract void fchmod(Object var1, int var2, int var3) throws PosixException;

    public abstract Object readlinkat(Object var1, int var2, Object var3) throws PosixException;

    public abstract void kill(Object var1, long var2, int var4) throws PosixException;

    public abstract void killpg(Object var1, long var2, int var4) throws PosixException;

    public abstract long[] waitpid(Object var1, long var2, int var4) throws PosixException;

    public abstract void abort(Object var1);

    public abstract boolean wcoredump(Object var1, int var2);

    public abstract boolean wifcontinued(Object var1, int var2);

    public abstract boolean wifstopped(Object var1, int var2);

    public abstract boolean wifsignaled(Object var1, int var2);

    public abstract boolean wifexited(Object var1, int var2);

    public abstract int wexitstatus(Object var1, int var2);

    public abstract int wtermsig(Object var1, int var2);

    public abstract int wstopsig(Object var1, int var2);

    public abstract long getuid(Object var1);

    public abstract long geteuid(Object var1);

    public abstract long getgid(Object var1);

    public abstract long getppid(Object var1);

    public abstract long getpgid(Object var1, long var2) throws PosixException;

    public abstract void setpgid(Object var1, long var2, long var4) throws PosixException;

    public abstract long getpgrp(Object var1);

    public abstract long getsid(Object var1, long var2) throws PosixException;

    public abstract long setsid(Object var1) throws PosixException;

    public abstract OpenPtyResult openpty(Object var1) throws PosixException;

    public abstract TruffleString ctermid(Object var1) throws PosixException;

    public abstract void setenv(Object var1, Object var2, Object var3, boolean var4) throws PosixException;

    public abstract void unsetenv(Object var1, Object var2) throws PosixException;

    public abstract int forkExec(Object var1, Object[] var2, Object[] var3, Object var4, Object[] var5, int var6, int var7, int var8, int var9, int var10, int var11, int var12, int var13, boolean var14, boolean var15, boolean var16, int[] var17) throws PosixException;

    public abstract void execv(Object var1, Object var2, Object[] var3) throws PosixException;

    public abstract int system(Object var1, Object var2);

    public abstract Object mmap(Object var1, long var2, int var4, int var5, int var6, long var7) throws PosixException;

    public abstract byte mmapReadByte(Object var1, Object var2, long var3) throws PosixException;

    public abstract void mmapWriteByte(Object var1, Object var2, long var3, byte var5) throws PosixException;

    public abstract int mmapReadBytes(Object var1, Object var2, long var3, byte[] var5, int var6) throws PosixException;

    public abstract void mmapWriteBytes(Object var1, Object var2, long var3, byte[] var5, int var6) throws PosixException;

    public abstract void mmapFlush(Object var1, Object var2, long var3, long var5) throws PosixException;

    public abstract void mmapUnmap(Object var1, Object var2, long var3) throws PosixException;

    public abstract long mmapGetPointer(Object var1, Object var2);

    public abstract PwdResult getpwuid(Object var1, long var2) throws PosixException;

    public abstract PwdResult getpwnam(Object var1, Object var2) throws PosixException;

    public abstract boolean hasGetpwentries(Object var1);

    public abstract PwdResult[] getpwentries(Object var1) throws PosixException;

    public abstract Object createPathFromString(Object var1, TruffleString var2);

    public abstract Object createPathFromBytes(Object var1, byte[] var2);

    public abstract TruffleString getPathAsString(Object var1, Object var2);

    public abstract Buffer getPathAsBytes(Object var1, Object var2);

    public abstract int socket(Object var1, int var2, int var3, int var4) throws PosixException;

    public abstract AcceptResult accept(Object var1, int var2) throws PosixException;

    public abstract void bind(Object var1, int var2, UniversalSockAddr var3) throws PosixException;

    public abstract void connect(Object var1, int var2, UniversalSockAddr var3) throws PosixException;

    public abstract void listen(Object var1, int var2, int var3) throws PosixException;

    public abstract UniversalSockAddr getpeername(Object var1, int var2) throws PosixException;

    public abstract UniversalSockAddr getsockname(Object var1, int var2) throws PosixException;

    public abstract int send(Object var1, int var2, byte[] var3, int var4, int var5, int var6) throws PosixException;

    public abstract int sendto(Object var1, int var2, byte[] var3, int var4, int var5, int var6, UniversalSockAddr var7) throws PosixException;

    public abstract int recv(Object var1, int var2, byte[] var3, int var4, int var5, int var6) throws PosixException;

    public abstract RecvfromResult recvfrom(Object var1, int var2, byte[] var3, int var4, int var5, int var6) throws PosixException;

    public abstract void shutdown(Object var1, int var2, int var3) throws PosixException;

    public abstract int getsockopt(Object var1, int var2, int var3, int var4, byte[] var5, int var6) throws PosixException;

    public abstract void setsockopt(Object var1, int var2, int var3, int var4, byte[] var5, int var6) throws PosixException;

    public abstract int inet_addr(Object var1, Object var2);

    public abstract int inet_aton(Object var1, Object var2) throws InvalidAddressException;

    public abstract Object inet_ntoa(Object var1, int var2);

    public abstract byte[] inet_pton(Object var1, int var2, Object var3) throws PosixException, InvalidAddressException;

    public abstract Object inet_ntop(Object var1, int var2, byte[] var3) throws PosixException;

    public abstract Object gethostname(Object var1) throws PosixException;

    public abstract Object[] getnameinfo(Object var1, UniversalSockAddr var2, int var3) throws GetAddrInfoException;

    public abstract AddrInfoCursor getaddrinfo(Object var1, Object var2, Object var3, int var4, int var5, int var6, int var7) throws GetAddrInfoException;

    public abstract TruffleString crypt(Object var1, TruffleString var2, TruffleString var3) throws PosixException;

    public abstract UniversalSockAddr createUniversalSockAddr(Object var1, FamilySpecificSockAddr var2);

    private static boolean istype(long mode, int mask) {
        return (mode & (long)PosixConstants.S_IFMT.value) == (long)mask;
    }

    public static boolean isDIR(long mode) {
        return PosixSupportLibrary.istype(mode, PosixConstants.S_IFDIR.value);
    }

    public static boolean isCHR(long mode) {
        return PosixSupportLibrary.istype(mode, PosixConstants.S_IFCHR.value);
    }

    public static boolean isBLK(long mode) {
        return PosixSupportLibrary.istype(mode, PosixConstants.S_IFBLK.value);
    }

    public static boolean isREG(long mode) {
        return PosixSupportLibrary.istype(mode, PosixConstants.S_IFREG.value);
    }

    public static boolean isFIFO(long mode) {
        return PosixSupportLibrary.istype(mode, PosixConstants.S_IFIFO.value);
    }

    public static boolean isLNK(long mode) {
        return PosixSupportLibrary.istype(mode, PosixConstants.S_IFLNK.value);
    }

    public static LibraryFactory<PosixSupportLibrary> getFactory() {
        return FACTORY;
    }

    public static PosixSupportLibrary getUncached() {
        return (PosixSupportLibrary)FACTORY.getUncached();
    }

    public static class ChannelNotSelectableException
    extends UnsupportedPosixFeatureException {
        private static final long serialVersionUID = -4185480181939639297L;
        static ChannelNotSelectableException INSTANCE = new ChannelNotSelectableException();

        private ChannelNotSelectableException() {
            super((String)null);
        }
    }

    @CompilerDirectives.ValueType
    public static final class SelectResult {
        private final boolean[] readfds;
        private final boolean[] writefds;
        private final boolean[] errorfds;

        public SelectResult(boolean[] readfds, boolean[] writefds, boolean[] errorfds) {
            this.readfds = readfds;
            this.writefds = writefds;
            this.errorfds = errorfds;
        }

        public boolean[] getReadFds() {
            return this.readfds;
        }

        public boolean[] getWriteFds() {
            return this.writefds;
        }

        public boolean[] getErrorFds() {
            return this.errorfds;
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return String.format("select[read = %s; write = %s; err = %s]", Arrays.toString(this.readfds), Arrays.toString(this.writefds), Arrays.toString(this.errorfds));
        }
    }

    @CompilerDirectives.ValueType
    public static final class Timeval {
        public static final Timeval SELECT_TIMEOUT_NOW = new Timeval(0L, 0L);
        private final long seconds;
        private final long microseconds;

        public Timeval(long seconds, long microseconds) {
            this.seconds = seconds;
            this.microseconds = microseconds;
        }

        public long getSeconds() {
            return this.seconds;
        }

        public long getMicroseconds() {
            return this.microseconds;
        }
    }

    @CompilerDirectives.ValueType
    public static class Buffer {
        public final byte[] data;
        public long length;

        public Buffer(byte[] data, long length) {
            assert (data != null && length >= 0L && length <= (long)data.length);
            this.data = data;
            this.length = length;
        }

        public static Buffer allocate(long capacity) {
            if (capacity > Integer.MAX_VALUE) {
                throw CompilerDirectives.shouldNotReachHere((String)"Long arrays are not supported yet");
            }
            return new Buffer(new byte[(int)capacity], 0L);
        }

        public static Buffer wrap(byte[] data) {
            return new Buffer(data, data.length);
        }

        public Buffer withLength(long newLength) {
            if (newLength > (long)this.data.length) {
                throw CompilerDirectives.shouldNotReachHere((String)"Actual length cannot be greater than capacity");
            }
            this.length = newLength;
            return this;
        }

        @CompilerDirectives.TruffleBoundary
        public ByteBuffer getByteBuffer() {
            return ByteBuffer.wrap(this.data, 0, (int)this.length);
        }
    }

    public static class UnsupportedPosixFeatureException
    extends RuntimeException {
        private static final long serialVersionUID = 1846254827094902593L;

        public UnsupportedPosixFeatureException(String message) {
            super(message);
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    public static class InvalidAddressException
    extends Exception {
        private static final long serialVersionUID = -2999913421191382026L;

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    public static final class PosixException
    extends Exception {
        private static final long serialVersionUID = -115762483478883093L;
        private final int errorCode;
        private final transient TruffleString msg;

        public PosixException(int errorCode, TruffleString message) {
            this.errorCode = errorCode;
            this.msg = message;
        }

        public final TruffleString getMessageAsTruffleString() {
            return this.msg;
        }

        @Override
        public String getMessage() {
            return this.msg.toJavaStringUncached();
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    @GenerateLibrary
    public static abstract class UniversalSockAddrLibrary
    extends Library {
        static final LibraryFactory<UniversalSockAddrLibrary> FACTORY = LibraryFactory.resolve(UniversalSockAddrLibrary.class);

        protected UniversalSockAddrLibrary() {
        }

        public abstract int getFamily(UniversalSockAddr var1);

        public abstract Inet4SockAddr asInet4SockAddr(UniversalSockAddr var1);

        public abstract Inet6SockAddr asInet6SockAddr(UniversalSockAddr var1);

        public abstract UnixSockAddr asUnixSockAddr(UniversalSockAddr var1);

        public static LibraryFactory<UniversalSockAddrLibrary> getFactory() {
            return FACTORY;
        }

        public static UniversalSockAddrLibrary getUncached() {
            return (UniversalSockAddrLibrary)FACTORY.getUncached();
        }
    }

    public static class GetAddrInfoException
    extends Exception {
        private static final long serialVersionUID = 3013253817849329391L;
        private final int errorCode;
        private final transient TruffleString msg;

        public GetAddrInfoException(int errorCode, TruffleString message) {
            super(message.toJavaStringUncached());
            this.errorCode = errorCode;
            this.msg = message;
        }

        public int getErrorCode() {
            return this.errorCode;
        }

        public final TruffleString getMessageAsTruffleString() {
            return this.msg;
        }

        @Override
        public final Throwable fillInStackTrace() {
            return this;
        }
    }

    @GenerateLibrary
    public static abstract class AddrInfoCursorLibrary
    extends Library {
        static final LibraryFactory<AddrInfoCursorLibrary> FACTORY = LibraryFactory.resolve(AddrInfoCursorLibrary.class);

        protected AddrInfoCursorLibrary() {
        }

        public abstract void release(AddrInfoCursor var1);

        public abstract boolean next(AddrInfoCursor var1);

        public abstract int getFlags(AddrInfoCursor var1);

        public abstract int getFamily(AddrInfoCursor var1);

        public abstract int getSockType(AddrInfoCursor var1);

        public abstract int getProtocol(AddrInfoCursor var1);

        public abstract Object getCanonName(AddrInfoCursor var1);

        public abstract UniversalSockAddr getSockAddr(AddrInfoCursor var1);

        public static LibraryFactory<AddrInfoCursorLibrary> getFactory() {
            return FACTORY;
        }

        public static AddrInfoCursorLibrary getUncached() {
            return (AddrInfoCursorLibrary)FACTORY.getUncached();
        }
    }

    public static interface AddrInfoCursor {
    }

    public static final class RecvfromResult {
        public final int readBytes;
        public final UniversalSockAddr sockAddr;

        public RecvfromResult(int readBytes, UniversalSockAddr sockAddr) {
            this.readBytes = readBytes;
            this.sockAddr = sockAddr;
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return "RecvfromResult{readBytes=" + this.readBytes + ", sockAddr=" + this.sockAddr + "}";
        }
    }

    public static final class AcceptResult {
        public final int socketFd;
        public final UniversalSockAddr sockAddr;

        public AcceptResult(int socketFd, UniversalSockAddr sockAddr) {
            this.socketFd = socketFd;
            this.sockAddr = sockAddr;
        }

        public String toString() {
            CompilerAsserts.neverPartOfCompilation();
            return "RecvfromResult{socketFd=" + this.socketFd + ", sockAddr=" + this.sockAddr + "}";
        }
    }

    @CompilerDirectives.ValueType
    public static final class UnixSockAddr
    extends FamilySpecificSockAddr {
        private final byte[] path;

        public UnixSockAddr(byte[] path) {
            this(path, 0, path.length);
        }

        public UnixSockAddr(byte[] path, int offset, int length) {
            super(PosixConstants.AF_UNIX.value);
            assert (path != null && offset >= 0 && length >= 0 && length <= PosixConstants.SIZEOF_STRUCT_SOCKADDR_UN_SUN_PATH.value && offset + length <= path.length);
            this.path = Arrays.copyOfRange(path, offset, offset + length);
        }

        public byte[] getPath() {
            return this.path;
        }
    }

    @CompilerDirectives.ValueType
    public static final class Inet6SockAddr
    extends FamilySpecificSockAddr {
        private final int port;
        private final byte[] address = new byte[16];
        private final int flowInfo;
        private final int scopeId;

        public Inet6SockAddr(int port, byte[] address, int flowInfo, int scopeId) {
            super(PosixConstants.AF_INET6.value);
            assert (port >= 0 && port <= 65535);
            assert (address != null && address.length == 16);
            assert (flowInfo >= 0 && flowInfo <= 1048575);
            this.port = port;
            PythonUtils.arraycopy(address, 0, this.address, 0, 16);
            this.flowInfo = flowInfo;
            this.scopeId = scopeId;
        }

        public int getPort() {
            return this.port;
        }

        public byte[] getAddress() {
            return Arrays.copyOf(this.address, 16);
        }

        public int getFlowInfo() {
            return this.flowInfo;
        }

        public int getScopeId() {
            return this.scopeId;
        }
    }

    @CompilerDirectives.ValueType
    public static final class Inet4SockAddr
    extends FamilySpecificSockAddr {
        private final int port;
        private final int address;

        public Inet4SockAddr(int port, int address) {
            super(PosixConstants.AF_INET.value);
            assert (port >= 0 && port <= 65535);
            this.port = port;
            this.address = address;
        }

        public Inet4SockAddr(int port, byte[] address) {
            this(port, Inet4SockAddr.bytesToInt(address));
        }

        public int getPort() {
            return this.port;
        }

        public int getAddress() {
            return this.address;
        }

        public byte[] getAddressAsBytes() {
            return Inet4SockAddr.intToBytes(this.address);
        }

        private static int bytesToInt(byte[] src) {
            assert (src != null && src.length >= 4);
            return ByteArraySupport.bigEndian().getInt(src, 0);
        }

        private static byte[] intToBytes(int src) {
            byte[] dst = new byte[4];
            ByteArraySupport.bigEndian().putInt(dst, 0, src);
            return dst;
        }
    }

    public static interface UniversalSockAddr {
    }

    public static abstract class FamilySpecificSockAddr {
        private final int family;

        protected FamilySpecificSockAddr(int family) {
            this.family = family;
        }

        public int getFamily() {
            return this.family;
        }
    }

    public static final class PwdResult {
        public final TruffleString name;
        public final long uid;
        public final long gid;
        public final TruffleString dir;
        public final TruffleString shell;

        public PwdResult(TruffleString name, long uid, long gid, TruffleString dir, TruffleString shell) {
            this.name = name;
            this.uid = uid;
            this.gid = gid;
            this.dir = dir;
            this.shell = shell;
        }

        public String toString() {
            return "PwdResult{name='" + this.name + "', uid=" + this.uid + ", gid=" + this.gid + ", dir='" + this.dir + "', shell='" + this.shell + "'}";
        }
    }

    public record OpenPtyResult(int masterFd, int slaveFd) {
    }
}

