/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime.sequence.storage;

import com.oracle.graal.python.nodes.truffle.TruffleStringMigrationHelpers;
import com.oracle.graal.python.runtime.sequence.storage.BasicSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import java.util.Arrays;

public final class ObjectSequenceStorage
extends BasicSequenceStorage {
    private Object[] values;

    public ObjectSequenceStorage(Object[] elements) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = elements.length;
        TruffleStringMigrationHelpers.assertContainsNoJavaString(elements);
    }

    public ObjectSequenceStorage(Object[] elements, int length) {
        this.values = elements;
        this.capacity = elements.length;
        this.length = length;
        TruffleStringMigrationHelpers.assertContainsNoJavaString(elements);
    }

    public ObjectSequenceStorage(int capacity) {
        this.values = new Object[capacity];
        this.capacity = capacity;
        this.length = 0;
    }

    @Override
    public Object getItemNormalized(int idx) {
        return this.values[idx];
    }

    @Override
    public void setItemNormalized(int idx, Object value) {
        this.values[idx] = TruffleStringMigrationHelpers.assertNoJavaString(value);
    }

    @Override
    public void insertItem(int idx, Object value) {
        this.ensureCapacity(this.length + 1);
        for (int i = this.values.length - 1; i > idx; --i) {
            this.values[i] = this.values[i - 1];
        }
        this.values[idx] = TruffleStringMigrationHelpers.assertNoJavaString(value);
        this.incLength();
    }

    @Override
    public void copyItem(int idxTo, int idxFrom) {
        this.values[idxTo] = this.values[idxFrom];
    }

    @Override
    public ObjectSequenceStorage getSliceInBound(int start, int stop, int step, int sliceLength) {
        Object[] newArray = new Object[sliceLength];
        if (step == 1) {
            PythonUtils.arraycopy(this.values, start, newArray, 0, sliceLength);
            return new ObjectSequenceStorage(newArray);
        }
        int i = start;
        for (int j = 0; j < sliceLength; ++j) {
            newArray[j] = this.values[i];
            i += step;
        }
        return new ObjectSequenceStorage(newArray);
    }

    @Override
    public SequenceStorage copy() {
        return new ObjectSequenceStorage(this.getCopyOfInternalArray());
    }

    @Override
    public SequenceStorage createEmpty(int newCapacity) {
        return new ObjectSequenceStorage(newCapacity);
    }

    @Override
    public Object[] getInternalArray() {
        return this.values;
    }

    @Override
    public Object[] getCopyOfInternalArray() {
        return PythonUtils.arrayCopyOf(this.values, this.length);
    }

    @Override
    public void increaseCapacityExactWithCopy(int newCapacity) {
        this.values = PythonUtils.arrayCopyOf(this.values, newCapacity);
        this.capacity = this.values.length;
    }

    @Override
    public void increaseCapacityExact(int newCapacity) {
        this.values = new Object[newCapacity];
        this.capacity = this.values.length;
    }

    @Override
    public void reverse() {
        if (this.length > 0) {
            int head = 0;
            int tail = this.length - 1;
            int middle = (this.length - 1) / 2;
            while (head <= middle) {
                Object temp = this.values[head];
                this.values[head] = this.values[tail];
                this.values[tail] = temp;
                ++head;
                --tail;
            }
        }
    }

    @Override
    public ObjectSequenceStorage generalizeFor(Object value, SequenceStorage other) {
        return this;
    }

    @Override
    public Object getIndicativeValue() {
        return null;
    }

    @Override
    public boolean equals(SequenceStorage other) {
        Object[] otherArray = other.getInternalArray();
        return Arrays.equals(this.values, otherArray);
    }

    @Override
    public Object getInternalArrayObject() {
        return this.values;
    }

    @Override
    public Object getCopyOfInternalArrayObject() {
        return Arrays.copyOf(this.values, this.length);
    }

    @Override
    public void setInternalArrayObject(Object arrayObject) {
        this.values = (Object[])arrayObject;
        this.capacity = this.values.length;
        TruffleStringMigrationHelpers.assertContainsNoJavaString(this.values);
    }

    @Override
    public SequenceStorage.ListStorageType getElementType() {
        return SequenceStorage.ListStorageType.Generic;
    }
}

