/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.GcModuleBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIterNextNode;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.nodes.call.special.CallBinaryMethodNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.util.List;

@CoreFunctions(defineModule="gc")
public final class GcModuleBuiltins
extends PythonBuiltins {
    private static final TruffleString CALLBACKS = PythonUtils.tsLiteral("callbacks");
    private static final TruffleString START = PythonUtils.tsLiteral("start");
    private static final TruffleString STOP = PythonUtils.tsLiteral("stop");
    private static final TruffleString GENERATION = PythonUtils.tsLiteral("generation");
    private static final TruffleString COLLECTED = PythonUtils.tsLiteral("collected");
    private static final TruffleString UNCOLLECTABLE = PythonUtils.tsLiteral("uncollectable");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return GcModuleBuiltinsFactory.getFactories();
    }

    @Override
    public void initialize(Python3Core core) {
        this.addBuiltinConstant("DEBUG_LEAK", (Object)0);
        this.addBuiltinConstant("DEBUG_UNCOLLECTABLE", (Object)0);
        this.addBuiltinConstant("DEBUG_UNCOLLECTABLE", (Object)0);
        this.addBuiltinConstant(CALLBACKS, (Object)PythonObjectFactory.getUncached().createList());
        super.initialize(core);
    }

    @Builtin(name="get_referrers", takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class GcGetReferrersNode
    extends PythonBuiltinNode {
        GcGetReferrersNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PList doGeneric(Object objects) {
            return PythonContext.get(null).factory().createList();
        }
    }

    @Builtin(name="get_referents", takesVarArgs=true)
    @GenerateNodeFactory
    static abstract class GcGetReferentsNode
    extends PythonBuiltinNode {
        GcGetReferentsNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        static PList getReferents(Object objects) {
            return PythonContext.get(null).factory().createList();
        }
    }

    @Builtin(name="is_tracked", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GcIsTrackedNode
    extends PythonBuiltinNode {
        GcIsTrackedNode() {
        }

        @Specialization
        public boolean isTracked(PythonNativeObject object) {
            return false;
        }

        @Fallback
        public boolean isTracked(Object object) {
            return true;
        }
    }

    @Builtin(name="get_count", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GcCountNode
    extends PythonBuiltinNode {
        GcCountNode() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        public PTuple count() {
            List<GarbageCollectorMXBean> garbageCollectorMXBeans = ManagementFactory.getGarbageCollectorMXBeans();
            long count = 0L;
            for (GarbageCollectorMXBean gcbean : garbageCollectorMXBeans) {
                long cc = gcbean.getCollectionCount();
                if (cc <= 0L) continue;
                count += cc;
            }
            return PythonObjectFactory.getUncached().createTuple(new Object[]{count, 0, 0});
        }
    }

    @Builtin(name="set_debug", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SetDebugNode
    extends PythonBuiltinNode {
        SetDebugNode() {
        }

        @Specialization
        PNone setDebug(Object ignored) {
            return PNone.NONE;
        }
    }

    @Builtin(name="get_debug", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GetDebugNode
    extends PythonBuiltinNode {
        GetDebugNode() {
        }

        @Specialization
        int getDebug() {
            return 0;
        }
    }

    @Builtin(name="enable", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class EnableNode
    extends PythonBuiltinNode {
        EnableNode() {
        }

        @Specialization
        PNone enable() {
            this.getContext().setGcEnabled(true);
            return PNone.NONE;
        }
    }

    @Builtin(name="disable", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class DisableNode
    extends PythonBuiltinNode {
        DisableNode() {
        }

        @Specialization
        PNone disable() {
            this.getContext().setGcEnabled(false);
            return PNone.NONE;
        }
    }

    @Builtin(name="isenabled", minNumOfPositionalArgs=0)
    @GenerateNodeFactory
    static abstract class GcIsEnabledNode
    extends PythonBuiltinNode {
        GcIsEnabledNode() {
        }

        @Specialization
        boolean isenabled() {
            return this.getContext().isGcEnabled();
        }
    }

    @Builtin(name="collect", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, declaresExplicitSelf=true)
    @GenerateNodeFactory
    static abstract class GcCollectNode
    extends PythonBuiltinNode {
        GcCollectNode() {
        }

        @Specialization
        static PNone collect(VirtualFrame frame, PythonModule self, Object level, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr, @Cached PyObjectGetIter getIter, @Cached(neverDefault=true) PyIterNextNode next, @Cached PythonObjectFactory factory, @Cached CallBinaryMethodNode call, @Cached GilNode gil) {
            Object callbacks = getAttr.execute((Frame)frame, inliningTarget, self, CALLBACKS);
            Object iter = getIter.execute((Frame)frame, inliningTarget, callbacks);
            Object cb = next.execute((Frame)frame, iter);
            TruffleString phase = null;
            PDict info = null;
            if (cb != null) {
                phase = START;
                info = factory.createDict(new PKeyword[]{new PKeyword(GENERATION, 2), new PKeyword(COLLECTED, 0), new PKeyword(UNCOLLECTABLE, 0)});
                do {
                    call.executeObject((Frame)frame, cb, phase, info);
                } while ((cb = next.execute((Frame)frame, iter)) != null);
            }
            long freedMemory = GcCollectNode.javaCollect(inliningTarget, gil);
            if (phase != null) {
                phase = STOP;
                info = factory.createDict(new PKeyword[]{new PKeyword(GENERATION, 2), new PKeyword(COLLECTED, freedMemory), new PKeyword(UNCOLLECTABLE, 0)});
                iter = getIter.execute((Frame)frame, inliningTarget, callbacks);
                while ((cb = next.execute((Frame)frame, iter)) != null) {
                    call.executeObject((Frame)frame, cb, phase, info);
                }
            }
            return PNone.NONE;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @CompilerDirectives.TruffleBoundary
        static long javaCollect(Node inliningTarget, GilNode gil) {
            gil.release(true);
            Runtime runtime = Runtime.getRuntime();
            long freeMemory = runtime.freeMemory();
            try {
                PythonUtils.forceFullGC();
                try {
                    Thread.sleep(15L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            finally {
                gil.acquire();
            }
            PythonContext.triggerAsyncActions(inliningTarget);
            CApiTransitions.pollReferenceQueue();
            return Math.max(0L, runtime.freeMemory() - freeMemory);
        }
    }
}

