/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules;

import com.oracle.truffle.api.CompilerDirectives;
import sun.misc.Signal;
import sun.misc.SignalHandler;

final class Signals {
    static final int SIG_DFL = 0;
    static final int SIG_IGN = 1;
    static final int SIGMAX = 64;
    static final String[] SIGNAL_NAMES = new String[65];

    Signals() {
    }

    @CompilerDirectives.TruffleBoundary
    static void raiseSignal(String name) {
        Signal.raise(new Signal(name));
    }

    static String signalNumberToName(int signum) {
        return signum > 64 ? "INVALID SIGNAL" : SIGNAL_NAMES[signum];
    }

    @CompilerDirectives.TruffleBoundary
    static synchronized SignalHandler setSignalHandler(int signum, Runnable handler) throws IllegalArgumentException {
        return Signals.setSignalHandler(signum, new PythonSignalHandler(handler));
    }

    @CompilerDirectives.TruffleBoundary
    static synchronized SignalHandler setSignalHandler(int signum, SignalHandler handler) throws IllegalArgumentException {
        return Signal.handle(new Signal(Signals.signalNumberToName(signum)), handler);
    }

    @CompilerDirectives.TruffleBoundary
    static synchronized SignalHandler setSignalHandler(int signum, int handler) throws IllegalArgumentException {
        SignalHandler h;
        if (handler == 0) {
            h = SignalHandler.SIG_DFL;
        } else if (handler == 1) {
            h = SignalHandler.SIG_IGN;
        } else {
            throw new IllegalArgumentException();
        }
        return Signal.handle(new Signal(Signals.signalNumberToName(signum)), h);
    }

    @CompilerDirectives.TruffleBoundary
    static synchronized SignalHandler getCurrentSignalHandler(int signum) {
        SignalHandler oldH;
        try {
            oldH = Signal.handle(new Signal(Signals.signalNumberToName(signum)), SignalHandler.SIG_DFL);
        }
        catch (IllegalArgumentException e) {
            return SignalHandler.SIG_DFL;
        }
        try {
            Signal.handle(new Signal(Signals.signalNumberToName(signum)), oldH);
        }
        catch (IllegalArgumentException e) {
            return SignalHandler.SIG_DFL;
        }
        return oldH;
    }

    static {
        for (String signal : new String[]{"HUP", "INT", "BREAK", "QUIT", "ILL", "TRAP", "IOT", "ABRT", "EMT", "FPE", "KILL", "BUS", "SEGV", "SYS", "PIPE", "ALRM", "TERM", "USR1", "USR2", "CLD", "CHLD", "PWR", "IO", "URG", "WINCH", "POLL", "STOP", "TSTP", "CONT", "TTIN", "TTOU", "VTALRM", "PROF", "XCPU", "XFSZ", "RTMIN", "RTMAX", "INFO", "STKFLT"}) {
            try {
                int number = new Signal(signal).getNumber();
                if (number > 64) continue;
                Signals.SIGNAL_NAMES[number] = signal;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    static class PythonSignalHandler
    implements SignalHandler {
        private final Runnable handler;

        public PythonSignalHandler(Runnable handler) {
            this.handler = handler;
        }

        @Override
        public void handle(Signal arg0) {
            this.handler.run();
        }
    }

    static final class Alarm {
        final int seconds;
        final long startMillis;
        private Thread thread;

        public Alarm(int seconds) {
            this.seconds = seconds;
            this.startMillis = System.currentTimeMillis();
        }

        public void start() {
            this.thread = new Thread(() -> {
                try {
                    Thread.sleep((long)this.seconds * 1000L);
                    Signal.raise(new Signal("ALRM"));
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            });
            this.thread.start();
        }

        public boolean isRunning() {
            return this.thread.isAlive();
        }

        public void cancel() {
            this.thread.interrupt();
        }

        public int getRemainingSeconds() {
            return this.seconds - (int)((System.currentTimeMillis() - this.startMillis) / 1000L);
        }
    }
}

