/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.BuiltinConstructors;
import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.cext.PythonNativeVoidPtr;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.ints.IntBuiltins;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.lib.PyLongFromDoubleNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.truffle.PythonTypes;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnexpectedResultException;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.math.BigInteger;

public final class PythonCextLongBuiltins {

    static abstract class PyLong_FromUnicodeObject
    extends PythonCextBuiltins.CApiBinaryBuiltinNode {
        PyLong_FromUnicodeObject() {
        }

        @Specialization
        static Object convert(TruffleString s, int base, @Cached BuiltinConstructors.IntNode intNode) {
            return intNode.executeWith(null, s, base);
        }
    }

    static abstract class _PyLong_AsByteArray
    extends PythonCextBuiltins.CApi5BuiltinNode {
        _PyLong_AsByteArray() {
        }

        private static void checkSign(Node inliningTarget, boolean negative, int isSigned, PRaiseNode.Lazy raiseNode) {
            if (negative && isSigned == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.MESSAGE_CONVERT_NEGATIVE);
            }
        }

        @Specialization
        static Object get(int value, Object bytes, long n, int littleEndian, int isSigned, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile profile, @Cached.Shared @Cached CStructAccess.WriteByteNode write, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            _PyLong_AsByteArray.checkSign(inliningTarget, value < 0, isSigned, raiseNode);
            byte[] array = IntBuiltins.ToBytesNode.fromLong(value, PythonUtils.toIntError(n), littleEndian == 0, isSigned != 0, inliningTarget, profile, raiseNode);
            write.writeByteArray(bytes, array);
            return 0;
        }

        @Specialization
        static Object get(long value, Object bytes, long n, int littleEndian, int isSigned, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile profile, @Cached.Shared @Cached CStructAccess.WriteByteNode write, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            _PyLong_AsByteArray.checkSign(inliningTarget, value < 0L, isSigned, raiseNode);
            byte[] array = IntBuiltins.ToBytesNode.fromLong(value, PythonUtils.toIntError(n), littleEndian == 0, isSigned != 0, inliningTarget, profile, raiseNode);
            write.writeByteArray(bytes, array);
            return 0;
        }

        @Specialization
        static Object get(PInt value, Object bytes, long n, int littleEndian, int isSigned, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached InlinedConditionProfile profile, @Cached.Shared @Cached CStructAccess.WriteByteNode write, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
            _PyLong_AsByteArray.checkSign(inliningTarget, value.isNegative(), isSigned, raiseNode);
            byte[] array = IntBuiltins.ToBytesNode.fromBigInteger(value, PythonUtils.toIntError(n), littleEndian == 0, isSigned != 0, inliningTarget, profile, raiseNode);
            write.writeByteArray(bytes, array);
            return 0;
        }
    }

    public static abstract class PyLong_AsVoidPtr
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        @Node.Child
        private CExtCommonNodes.ConvertPIntToPrimitiveNode asPrimitiveNode;
        @Node.Child
        private CExtCommonNodes.TransformExceptionToNativeNode transformExceptionToNativeNode;

        @Specialization
        static long doPointer(int n) {
            return n;
        }

        @Specialization
        static long doPointer(long n) {
            return n;
        }

        @Specialization
        long doPointer(PInt n, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile overflowProfile, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                return n.longValueExact();
            }
            catch (OverflowException e) {
                overflowProfile.enter(inliningTarget);
                try {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "C long");
                }
                catch (PException pe) {
                    this.ensureTransformExcNode().executeCached(pe);
                    return 0L;
                }
            }
        }

        @Specialization
        static Object doPointer(PythonNativeVoidPtr n) {
            return n.getPointerObject();
        }

        @Fallback
        long doGeneric(Object n, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            if (this.asPrimitiveNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.asPrimitiveNode = (CExtCommonNodes.ConvertPIntToPrimitiveNode)this.insert(CExtCommonNodesFactory.ConvertPIntToPrimitiveNodeGen.create());
            }
            try {
                try {
                    return this.asPrimitiveNode.executeLongCached(n, 0, 8);
                }
                catch (UnexpectedResultException e) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.PYTHON_INT_TOO_LARGE_TO_CONV_TO, "C long");
                }
            }
            catch (PException e) {
                this.ensureTransformExcNode().executeCached(e);
                return 0L;
            }
        }

        private CExtCommonNodes.TransformExceptionToNativeNode ensureTransformExcNode() {
            if (this.transformExceptionToNativeNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.transformExceptionToNativeNode = (CExtCommonNodes.TransformExceptionToNativeNode)this.insert(CExtCommonNodesFactory.TransformExceptionToNativeNodeGen.create());
            }
            return this.transformExceptionToNativeNode;
        }
    }

    static abstract class PyLong_FromUnsignedLongLong
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyLong_FromUnsignedLongLong() {
        }

        @Specialization
        static long doUnsignedInt(int n) {
            if (n < 0) {
                return (long)n & 0xFFFFFFFFL;
            }
            return n;
        }

        @Specialization(guards={"n >= 0"})
        static Object doUnsignedLongPositive(long n) {
            return n;
        }

        @Specialization(guards={"n < 0"})
        static Object doUnsignedLongNegative(long n, @Cached.Shared @Cached PythonObjectFactory factory) {
            return factory.createInt(PyLong_FromUnsignedLongLong.convertToBigInteger(n));
        }

        @Specialization(guards={"!isInteger(pointer)"}, limit="2")
        static Object doPointer(Object pointer, @CachedLibrary(value="pointer") InteropLibrary lib, @Cached.Shared @Cached PythonObjectFactory factory) {
            if (lib.isPointer(pointer)) {
                try {
                    return factory.createNativeVoidPtr(pointer, lib.asPointer(pointer));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return factory.createNativeVoidPtr(pointer);
        }

        @CompilerDirectives.TruffleBoundary
        private static BigInteger convertToBigInteger(long n) {
            return BigInteger.valueOf(n).add(BigInteger.ONE.shiftLeft(64));
        }
    }

    static abstract class PyTruffleLong_FromLongLong
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleLong_FromLongLong() {
        }

        @Specialization
        static int doSignedInt(int n) {
            return n;
        }

        @Specialization
        static long doSignedLong(long n) {
            return n;
        }

        @Specialization(guards={"!isInteger(pointer)"}, limit="2")
        static Object doPointer(Object pointer, @CachedLibrary(value="pointer") InteropLibrary lib, @Cached PythonObjectFactory factory) {
            if (lib.isPointer(pointer)) {
                try {
                    return factory.createNativeVoidPtr(pointer, lib.asPointer(pointer));
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            return factory.createNativeVoidPtr(pointer);
        }
    }

    static abstract class PyTruffleLong_AsPrimitive
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleLong_AsPrimitive() {
        }

        @Specialization
        static Object doGeneric(Object object, int mode, long targetTypeSize, @Bind(value="this") Node inliningTarget, @Cached IsSubtypeNode isSubtypeNode, @Cached GetClassNode getClassNode, @Cached CExtCommonNodes.ConvertPIntToPrimitiveNode convertPIntToPrimitiveNode, @Cached CExtNodes.CastToNativeLongNode castToNativeLongNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                if (PyTruffleLong_AsPrimitive.requiredPInt(mode) && !isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PInt)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
                }
                Object coerced = convertPIntToPrimitiveNode.execute(inliningTarget, object, PyTruffleLong_AsPrimitive.signed(mode), PInt.intValueExact(targetTypeSize), PyTruffleLong_AsPrimitive.exact(mode));
                return castToNativeLongNode.execute(inliningTarget, coerced);
            }
            catch (OverflowException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }

        private static int signed(int mode) {
            return mode & 1;
        }

        private static boolean requiredPInt(int mode) {
            return (mode & 2) != 0;
        }

        private static boolean exact(int mode) {
            return (mode & 4) == 0;
        }
    }

    @TypeSystemReference(value=PythonTypes.class)
    static abstract class PyTruffleLong_FromString
    extends PythonCextBuiltins.CApiTernaryBuiltinNode {
        PyTruffleLong_FromString() {
        }

        @Specialization(guards={"negative == 0"})
        Object fromString(Object s, int base, int negative, @Cached.Shared @Cached BuiltinConstructors.IntNode intNode) {
            return intNode.executeWith(null, s, base);
        }

        @Specialization(guards={"negative != 0"})
        Object fromString(Object s, int base, int negative, @Cached.Shared @Cached BuiltinConstructors.IntNode intNode, @Cached IntBuiltins.NegNode negNode) {
            return negNode.execute(null, intNode.executeWith(null, s, base));
        }
    }

    static abstract class PyLong_FromDouble
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyLong_FromDouble() {
        }

        @Specialization
        static Object fromDouble(double d, @Bind(value="this") Node inliningTarget, @Cached PyLongFromDoubleNode pyLongFromDoubleNode) {
            return pyLongFromDoubleNode.execute(inliningTarget, d);
        }
    }

    static abstract class _PyLong_Sign
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        _PyLong_Sign() {
        }

        @Specialization(guards={"n == 0"})
        static int sign(int n) {
            return 0;
        }

        @Specialization(guards={"n < 0"})
        static int signNeg(int n) {
            return -1;
        }

        @Specialization(guards={"n > 0"})
        static int signPos(int n) {
            return 1;
        }

        @Specialization(guards={"n == 0"})
        static int sign(long n) {
            return 0;
        }

        @Specialization(guards={"n < 0"})
        static int signNeg(long n) {
            return -1;
        }

        @Specialization(guards={"n > 0"})
        static int signPos(long n) {
            return 1;
        }

        @Specialization(guards={"b"})
        static int signTrue(boolean b) {
            return 1;
        }

        @Specialization(guards={"!b"})
        static int signFalse(boolean b) {
            return 0;
        }

        @Specialization
        static int sign(PInt n, @Bind(value="this") Node inliningTarget, @Cached InlinedBranchProfile zeroProfile, @Cached InlinedBranchProfile negProfile) {
            if (n.isNegative()) {
                negProfile.enter(inliningTarget);
                return -1;
            }
            if (n.isZero()) {
                zeroProfile.enter(inliningTarget);
                return 0;
            }
            return 1;
        }

        @Specialization(guards={"!canBeInteger(obj)", "isPIntSubtype(inliningTarget, obj, getClassNode, isSubtypeNode)"})
        static Object signNative(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            throw CompilerDirectives.shouldNotReachHere((String)"not yet implemented");
        }

        @Specialization(guards={"!isInteger(obj)", "!isPInt(obj)", "!isPIntSubtype(inliningTarget, obj,getClassNode,isSubtypeNode)"})
        static Object sign(Object obj, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GetClassNode getClassNode, @Cached.Shared @Cached IsSubtypeNode isSubtypeNode) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        protected boolean isPIntSubtype(Node inliningTarget, Object obj, GetClassNode getClassNode, IsSubtypeNode isSubtypeNode) {
            return isSubtypeNode.execute(getClassNode.execute(inliningTarget, obj), (Object)PythonBuiltinClassType.PInt);
        }
    }
}

