/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.cext;

import com.oracle.graal.python.builtins.modules.cext.PythonCextBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.frame.PFrame;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.nodes.frame.GetCurrentFrameRef;
import com.oracle.graal.python.nodes.frame.ReadCallerFrameNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;

public final class PythonCextPyStateBuiltins {

    static abstract class PyTruffleState_FindModule
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleState_FindModule() {
        }

        @Specialization
        Object doGeneric(long mIndex) {
            try {
                int i = PInt.intValueExact(mIndex);
                Object result = this.getCApiContext().getModuleByIndex(i);
                if (result == null) {
                    return this.getNativeNull();
                }
                return result;
            }
            catch (CannotCastException | OverflowException e) {
                return this.getNativeNull();
            }
        }
    }

    static abstract class PyThreadState_GetFrame
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyThreadState_GetFrame() {
        }

        @Specialization
        PFrame get(@Bind(value="this") Node inliningTarget, @Cached GetCurrentFrameRef getCurrentFrameRef, @Cached ReadCallerFrameNode readCallerFrameNode) {
            PFrame.Reference frameRef = getCurrentFrameRef.execute(null, inliningTarget);
            return readCallerFrameNode.executeWith(frameRef, 0);
        }
    }

    static abstract class PyThreadState_GetDict
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyThreadState_GetDict() {
        }

        @Specialization
        @CompilerDirectives.TruffleBoundary
        PDict get(@Cached PythonObjectFactory factory) {
            PythonContext.PythonThreadState threadState = this.getContext().getThreadState(this.getLanguage());
            PDict threadStateDict = threadState.getDict();
            if (threadStateDict == null) {
                threadStateDict = factory.createDict();
                threadState.setDict(threadStateDict);
            }
            return threadStateDict;
        }
    }

    static abstract class PyTruffleThreadState_Get
    extends PythonCextBuiltins.CApiUnaryBuiltinNode {
        PyTruffleThreadState_Get() {
        }

        @Specialization(limit="1")
        Object get(Object tstateCurrentPtr, @CachedLibrary(value="tstateCurrentPtr") InteropLibrary lib) {
            PythonContext.PythonThreadState pythonThreadState = this.getContext().getThreadState(this.getLanguage());
            if (!lib.isNull(tstateCurrentPtr)) {
                pythonThreadState.setNativeThreadLocalVarPointer(tstateCurrentPtr);
            }
            return PThreadState.getOrCreateNativeThreadState(pythonThreadState);
        }
    }

    static abstract class PyTruffleGILState_Release
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleGILState_Release() {
        }

        @Specialization
        static Object restore(@Cached GilNode gil) {
            gil.release(true);
            return PNone.NO_VALUE;
        }
    }

    static abstract class PyTruffleGILState_Ensure
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleGILState_Ensure() {
        }

        @Specialization
        static Object save(@Cached GilNode gil) {
            boolean acquired = gil.acquire();
            return acquired ? 1 : 0;
        }
    }

    static abstract class PyTruffleGILState_Check
    extends PythonCextBuiltins.CApiNullaryBuiltinNode {
        PyTruffleGILState_Check() {
        }

        @Specialization
        Object check() {
            return PythonContext.get(this).ownsGil() ? 1 : 0;
        }
    }
}

