/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.ctypes;

import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CDataObject;
import com.oracle.graal.python.builtins.modules.ctypes.CDataTypeBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.CtypesNodes;
import com.oracle.graal.python.builtins.modules.ctypes.FFIType;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.ctypes.PyCArrayBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictBuiltins;
import com.oracle.graal.python.builtins.modules.ctypes.StgDictObject;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PyCArray})
public final class PyCArrayBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = PyCArrayBuiltinsSlotsGen.SLOTS;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return PyCArrayBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        core.getContext().registerCApiHook(() -> CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_CDATA_INIT_BUFFER_PROTOCOL, CApiTransitions.PythonToNativeNode.executeUncached((Object)PythonBuiltinClassType.PyCArray)));
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Cached PythonObjectFactory factory) {
            return factory.createGenericAlias(cls, key);
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.sq_length), @Slot(value=Slot.SlotKind.mp_length)})
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        LenNode() {
        }

        @Specialization
        static int Array_length(CDataObject self) {
            return self.b_length;
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class PyCArraySubscriptNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        PyCArraySubscriptNode() {
        }

        protected static boolean isInvalid(CDataObject self, int index) {
            return index < 0 || index >= self.b_length;
        }

        @Specialization(guards={"!isInvalid(self, index)"})
        static Object doInt(CDataObject self, int index, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            return PyCArrayGetItemNode.getItem(inliningTarget, self, index, pyCDataGetNode, pyObjectStgDictNode);
        }

        @Specialization(limit="1")
        static Object doSlice(CDataObject self, PSlice slice, @CachedLibrary(value="self") PythonBufferAccessLibrary bufferLib, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached TruffleString.FromByteArrayNode fromByteArrayNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached PythonObjectFactory factory) {
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for array object instances";
            Object proto = stgdict.proto;
            StgDictObject itemdict = pyTypeStgDictNode.execute(inliningTarget, proto);
            assert (itemdict != null) : "proto is the item type of the array, a ctypes type, so this cannot be NULL";
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, self.b_length, sliceUnpack.execute(inliningTarget, slice));
            int slicelen = sliceInfo.sliceLength;
            if (itemdict.getfunc == FFIType.FieldDesc.c.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (slicelen <= 0) {
                    return factory.createEmptyBytes();
                }
                if (sliceInfo.step == 1) {
                    return factory.createBytes(ptr, sliceInfo.start, slicelen);
                }
                byte[] dest = new byte[slicelen];
                int cur = sliceInfo.start;
                for (int i = 0; i < slicelen; ++i) {
                    dest[i] = ptr[cur];
                    cur += sliceInfo.step;
                }
                return factory.createBytes(dest);
            }
            if (itemdict.getfunc == FFIType.FieldDesc.u.getfunc) {
                byte[] ptr = bufferLib.getInternalOrCopiedByteArray(self);
                if (slicelen <= 0) {
                    return StringLiterals.T_EMPTY_STRING;
                }
                if (sliceInfo.step == 1) {
                    byte[] bytes = PythonUtils.arrayCopyOfRange(ptr, sliceInfo.start, slicelen);
                    return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(bytes, TruffleString.Encoding.UTF_8), PythonUtils.TS_ENCODING);
                }
                byte[] dest = new byte[slicelen];
                int cur = sliceInfo.start;
                for (int i = 0; i < slicelen; ++i) {
                    dest[i] = ptr[cur];
                    cur += sliceInfo.step;
                }
                return switchEncodingNode.execute((AbstractTruffleString)fromByteArrayNode.execute(dest, TruffleString.Encoding.UTF_8), PythonUtils.TS_ENCODING);
            }
            Object[] np = new Object[slicelen];
            int cur = sliceInfo.start;
            for (int i = 0; i < slicelen; ++i) {
                np[i] = PyCArraySubscriptNode.doInt(self, cur, inliningTarget, pyCDataGetNode, pyObjectStgDictNode);
                cur += sliceInfo.step;
            }
            return factory.createList(np);
        }

        @Specialization(guards={"!isPSlice(item)"}, replaces={"doInt"})
        static Object doGeneric(VirtualFrame frame, CDataObject self, Object item, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached InlinedConditionProfile negativeIndexProfile, @Cached.Exclusive @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (!indexCheckNode.execute(inliningTarget, item)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INDICES_MUST_BE_INTEGERS);
            }
            Object idx = indexNode.execute((Frame)frame, inliningTarget, item);
            int index = asSizeNode.executeExact((Frame)frame, inliningTarget, idx);
            if (negativeIndexProfile.profile(inliningTarget, index < 0)) {
                index += self.b_length;
            }
            PyCArrayGetItemNode.checkIndex(inliningTarget, self, index, raiseNode);
            return PyCArraySubscriptNode.doInt(self, index, inliningTarget, pyCDataGetNode, pyObjectStgDictNode);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class PyCArrayGetItemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        PyCArrayGetItemNode() {
        }

        @Specialization
        static Object doIt(CDataObject self, int index, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode, @Cached CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            PyCArrayGetItemNode.checkIndex(inliningTarget, self, index, raiseNode);
            return PyCArrayGetItemNode.getItem(inliningTarget, self, index, pyCDataGetNode, pyObjectStgDictNode);
        }

        static Object getItem(Node inliningTarget, CDataObject self, int index, CDataTypeBuiltins.PyCDataGetNode pyCDataGetNode, StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode) {
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for array object instances";
            int size = stgdict.size / stgdict.length;
            int offset = index * size;
            return pyCDataGetNode.execute(inliningTarget, stgdict.proto, stgdict.getfunc, self, index, size, self.b_ptr.withOffset(offset));
        }

        private static void checkIndex(Node inliningTarget, CDataObject self, int index, PRaiseNode.Lazy raiseNode) {
            if (index < 0 || index >= self.b_length) {
                PyCArrayGetItemNode.raiseInvalidIndex(inliningTarget, raiseNode);
            }
        }

        @HostCompilerDirectives.InliningCutoff
        private static void raiseInvalidIndex(Node inliningTarget, PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX);
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class PyCArraySetItemNode
    extends PythonTernaryBuiltinNode {
        PyCArraySetItemNode() {
        }

        @Specialization(guards={"!isPNone(value)"})
        static Object Array_ass_item(VirtualFrame frame, CDataObject self, int index, Object value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Shared @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject stgdict = pyObjectStgDictNode.execute(inliningTarget, self);
            assert (stgdict != null) : "Cannot be NULL for array object instances";
            if (index < 0 || index >= stgdict.length) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.IndexError, ErrorMessages.INVALID_INDEX);
            }
            int size = stgdict.size / stgdict.length;
            int offset = index * size;
            pyCDataSetNode.execute(frame, self, stgdict.proto, stgdict.setfunc, value, index, size, self.b_ptr.withOffset(offset));
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(value)", "!isPSlice(item)"})
        static Object Array_ass_subscript(VirtualFrame frame, CDataObject self, Object item, Object value, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSint, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Shared @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            int i;
            if (indexCheckNode.execute(inliningTarget, item)) {
                i = asSint.executeExact((Frame)frame, inliningTarget, item, PythonErrorType.IndexError);
                if (i < 0) {
                    i += self.b_length;
                }
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.INDICES_MUST_BE_INTEGER);
            }
            PyCArraySetItemNode.Array_ass_item(frame, self, i, value, inliningTarget, pyObjectStgDictNode, pyCDataSetNode, raiseNode);
            return PNone.NONE;
        }

        @Specialization(guards={"!isPNone(value)"})
        static Object Array_ass_subscript(VirtualFrame frame, CDataObject self, PSlice slice, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectSizeNode pySequenceLength, @Cached PyObjectGetItem pySequenceGetItem, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached.Exclusive @Cached StgDictBuiltins.PyObjectStgDictNode pyObjectStgDictNode, @Cached.Shared @Cached CDataTypeBuiltins.PyCDataSetNode pyCDataSetNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, self.b_length, sliceUnpack.execute(inliningTarget, slice));
            int start = sliceInfo.start;
            int stop = sliceInfo.stop;
            int step = sliceInfo.step;
            int slicelen = sliceInfo.sliceLength;
            int otherlen = pySequenceLength.execute((Frame)frame, inliningTarget, value);
            if (otherlen != slicelen) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.CAN_ONLY_ASSIGN_SEQUENCE_OF_SAME_SIZE);
            }
            int cur = start;
            for (int i = 0; i < otherlen; ++i) {
                PyCArraySetItemNode.Array_ass_item(frame, self, cur, pySequenceGetItem.execute((Frame)frame, inliningTarget, value, i), inliningTarget, pyObjectStgDictNode, pyCDataSetNode, raiseNode);
                cur += step;
            }
            return PNone.NONE;
        }

        @Specialization
        static Object error(CDataObject self, Object item, PNone value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.ARRAY_DOES_NOT_SUPPORT_ITEM_DELETION);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class InitNode
    extends PythonBuiltinNode {
        protected InitNode() {
        }

        @Specialization
        static Object Array_init(VirtualFrame frame, CDataObject self, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetItem pySequenceSetItem) {
            int n = args.length;
            for (int i = 0; i < n; ++i) {
                pySequenceSetItem.execute((Frame)frame, inliningTarget, self, i, args[i]);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__new__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    protected static abstract class NewNode
    extends PythonBuiltinNode {
        protected NewNode() {
        }

        @Specialization
        static Object newCData(Object type, Object[] args, PKeyword[] kwds, @Bind(value="this") Node inliningTarget, @Cached StgDictBuiltins.PyTypeStgDictNode pyTypeStgDictNode, @Cached CtypesNodes.GenericPyCDataNewNode newNode2, @Cached PRaiseNode.Lazy raiseNode) {
            StgDictObject dict = pyTypeStgDictNode.checkAbstractClass(inliningTarget, type, raiseNode);
            return newNode2.execute(inliningTarget, type, dict);
        }
    }
}

