/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.modules.io;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.modules.io.IncrementalNewlineDecoderBuiltins;
import com.oracle.graal.python.builtins.modules.io.PNLDecoder;
import com.oracle.graal.python.builtins.modules.io.PStringIO;
import com.oracle.graal.python.builtins.modules.io.StringIOBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.modules.io.StringIOBuiltinsFactory;
import com.oracle.graal.python.builtins.modules.io.TextIOWrapperNodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.str.StringNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetOrCreateDictNode;
import com.oracle.graal.python.nodes.truffle.PythonArithmeticTypes;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.dsl.TypeSystemReference;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PStringIO})
public final class StringIOBuiltins
extends PythonBuiltins {
    private static final int NIL_CODEPOINT = 0;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return StringIOBuiltinsFactory.getFactories();
    }

    static void writeString(VirtualFrame frame, Node inliningTarget, PStringIO self, TruffleString obj, PRaiseNode.Lazy raiseNode, IncrementalNewlineDecoderBuiltins.DecodeNode decodeNode, StringNodes.StringReplaceNode replaceNode, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.SubstringNode substringNode, TruffleStringBuilder.AppendStringNode appendStringNode, TruffleStringBuilder.AppendCodePointNode appendCodePointNode, TruffleStringBuilder.ToStringNode toStringNode) {
        assert (self.getPos() >= 0);
        TruffleString decoded = self.getDecoder() != null ? (TruffleString)decodeNode.execute(frame, self.getDecoder(), obj, true) : obj;
        if (self.hasWriteNewline()) {
            decoded = replaceNode.execute(decoded, StringLiterals.T_NEWLINE, self.getWriteNewline(), -1);
        }
        int decodedLen = codePointLengthNode.execute((AbstractTruffleString)decoded, PythonUtils.TS_ENCODING);
        if (self.getPos() > Integer.MAX_VALUE - decodedLen) {
            throw raiseNode.get(inliningTarget).raise(PythonErrorType.OverflowError, ErrorMessages.NEW_POSITION_TOO_LARGE);
        }
        if (self.isAccumulating()) {
            if (self.getStringSize() == self.getPos()) {
                self.append(decoded, appendStringNode);
                self.incPos(decodedLen);
                if (self.getStringSize() < self.getPos()) {
                    self.setStringsize(self.getPos());
                }
                return;
            }
            self.realize();
        }
        TruffleStringBuilder sb = self.getBuf();
        self.invalidateBufCache();
        if (self.getPos() > self.getStringSize()) {
            appendCodePointNode.execute(sb, 0, self.getPos() - self.getStringSize());
            appendStringNode.execute(sb, (AbstractTruffleString)decoded);
        } else if (self.getPos() < self.getStringSize()) {
            TruffleString currentBuf = toStringNode.execute(sb, true);
            TruffleString left = substringNode.execute((AbstractTruffleString)currentBuf, 0, self.getPos(), PythonUtils.TS_ENCODING, true);
            sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)(self.getPos() + decodedLen));
            self.setBuf(sb);
            appendStringNode.execute(sb, (AbstractTruffleString)left);
            appendStringNode.execute(sb, (AbstractTruffleString)decoded);
            int end = self.getPos() + decodedLen;
            if (end < self.getStringSize()) {
                TruffleString right = substringNode.execute((AbstractTruffleString)currentBuf, end, self.getStringSize() - end, PythonUtils.TS_ENCODING, true);
                appendStringNode.execute(sb, (AbstractTruffleString)right);
            }
        } else {
            appendStringNode.execute(sb, (AbstractTruffleString)decoded);
        }
        self.incPos(decodedLen);
        if (self.getStringSize() < self.getPos()) {
            self.setStringsize(self.getPos());
        }
    }

    static TruffleString stringioReadline(Node inliningTarget, PStringIO self, int lim, TextIOWrapperNodes.FindLineEndingNode findLineEndingNode, TruffleString.SubstringNode substringNode, TruffleStringBuilder.ToStringNode toStringNode) {
        if (self.getPos() >= self.getStringSize()) {
            return StringLiterals.T_EMPTY_STRING;
        }
        int limit = lim;
        int start = self.getPos();
        if (limit < 0 || limit > self.getStringSize() - self.getPos()) {
            limit = self.getStringSize() - self.getPos();
        }
        int[] consumed = new int[1];
        TruffleString lazyBuf = toStringNode.execute(self.getBuf(), true);
        int len = findLineEndingNode.execute(inliningTarget, self, lazyBuf, start, consumed);
        if (len < 0 || len > limit) {
            len = limit;
        }
        self.incPos(len);
        return substringNode.execute((AbstractTruffleString)lazyBuf, start, len, PythonUtils.TS_ENCODING, false);
    }

    @Builtin(name="__next__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IternextNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        IternextNode() {
        }

        protected static boolean isStringIO(Node inliningTarget, PStringIO self, BuiltinClassProfiles.IsBuiltinObjectExactProfile profile) {
            return profile.profileObject(inliningTarget, self, PythonBuiltinClassType.PStringIO);
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "isStringIO(inliningTarget, self, profile)"}, limit="1")
        static Object builtin(PStringIO self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectExactProfile profile, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached TextIOWrapperNodes.FindLineEndingNode findLineEndingNode, @Cached TruffleString.SubstringNode substringNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            self.realize();
            TruffleString line = StringIOBuiltins.stringioReadline(inliningTarget, self, -1, findLineEndingNode, substringNode, toStringNode);
            if (line.isEmpty()) {
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            return line;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "!isStringIO(inliningTarget, self, profile)"}, limit="1")
        static Object slowpath(VirtualFrame frame, PStringIO self, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached BuiltinClassProfiles.IsBuiltinObjectExactProfile profile, @Cached PyObjectCallMethodObjArgs callMethodReadline, @Cached CastToTruffleStringNode toString, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            self.realize();
            Object res = callMethodReadline.execute((Frame)frame, inliningTarget, self, IONodes.T_READLINE, new Object[0]);
            if (!PGuards.isString(res)) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.OSError, ErrorMessages.S_SHOULD_HAVE_RETURNED_A_STR_OBJECT_NOT_P, IONodes.T_READLINE, res);
            }
            TruffleString line = toString.execute(inliningTarget, res);
            if (line.isEmpty()) {
                throw raiseNode.get(inliningTarget).raiseStopIteration();
            }
            return line;
        }
    }

    @Builtin(name="close", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class CloseNode
    extends PythonUnaryBuiltinNode {
        CloseNode() {
        }

        @Specialization
        static Object close(PStringIO self) {
            self.setClosed(true);
            self.clearAll();
            return PNone.NONE;
        }
    }

    @Builtin(name="closed", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ClosedNode
    extends PythonUnaryBuiltinNode {
        ClosedNode() {
        }

        @Specialization(guards={"self.isOK()"})
        static boolean closed(PStringIO self) {
            return self.isClosed();
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PStringIO self, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }
    }

    @Builtin(name="newlines", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class NewlinesNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        NewlinesNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "!self.hasDecoder()"})
        static Object none(PStringIO self) {
            return PNone.NONE;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "self.hasDecoder()"})
        static Object doit(VirtualFrame frame, PStringIO self, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttr getAttr) {
            return getAttr.execute((Frame)frame, inliningTarget, self.getDecoder(), IONodes.T_NEWLINES);
        }
    }

    @Builtin(name="line_buffering", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class LineBufferingNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        LineBufferingNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static Object lineBuffering(PStringIO self) {
            return false;
        }
    }

    @Builtin(name="writable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class WritableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        WritableNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static boolean writable(PStringIO self) {
            return true;
        }
    }

    @Builtin(name="readable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReadableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        ReadableNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static boolean readable(PStringIO self) {
            return true;
        }
    }

    @Builtin(name="seekable", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class SeekableNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        SeekableNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static boolean seekable(PStringIO self) {
            return true;
        }
    }

    @Builtin(name="__setstate__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class SetStateNode
    extends PythonBinaryBuiltinNode {
        SetStateNode() {
        }

        @Specialization(guards={"!self.isClosed()"})
        static Object doit(VirtualFrame frame, PStringIO self, PTuple state, @Bind(value="this") Node inliningTarget, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getArray, @Cached InitNode initNode, @Cached CastToTruffleStringNode toString, @Cached PyIndexCheckNode indexCheckNode, @Cached PyNumberAsSizeNode asSizeNode, @Cached GetOrCreateDictNode getDict, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached HashingStorageNodes.HashingStorageAddAllToOther addAllToOtherNode, @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage storage = state.getSequenceStorage();
            Object[] array = getArray.execute(inliningTarget, storage);
            if (storage.length() < 4) {
                return SetStateNode.notTuple(self, state, raiseNode.get(inliningTarget));
            }
            initNode.execute(frame, self, array[0], array[1]);
            TruffleString buf = toString.execute(inliningTarget, array[0]);
            int bufsize = codePointLengthNode.execute((AbstractTruffleString)buf, PythonUtils.TS_ENCODING);
            self.setRealized();
            TruffleStringBuilder newBuf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)bufsize);
            appendStringNode.execute(newBuf, (AbstractTruffleString)buf);
            self.setBuf(newBuf);
            self.setStringsize(bufsize);
            if (!indexCheckNode.execute(inliningTarget, array[2])) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.THIRD_ITEM_OF_STATE_MUST_BE_AN_INTEGER_GOT_P, array[2]);
            }
            int pos = asSizeNode.executeExact((Frame)frame, inliningTarget, array[2]);
            if (pos < 0) {
                throw raiseNode.get(inliningTarget).raise(PythonErrorType.ValueError, ErrorMessages.POSITION_VALUE_CANNOT_BE_NEGATIVE);
            }
            self.setPos(pos);
            if (!PGuards.isNone(array[3])) {
                if (!PGuards.isDict(array[3])) {
                    throw raiseNode.get(inliningTarget).raise(PythonErrorType.TypeError, ErrorMessages.THIRD_ITEM_OF_STATE_SHOULD_BE_A_DICT_GOT_A_P, array[3]);
                }
                PDict dict = getDict.execute(inliningTarget, self);
                addAllToOtherNode.execute((Frame)frame, inliningTarget, ((PDict)array[3]).getDictStorage(), dict.getDictStorage());
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!self.isClosed()", "!isPTuple(state)"})
        static Object notTuple(PStringIO self, Object state, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.P_SETSTATE_ARGUMENT_SHOULD_BE_D_TUPLE_GOT_P, self, 4, state);
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PStringIO self, Object arg, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="__getstate__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetStateNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetStateNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static Object doit(VirtualFrame frame, PStringIO self, @Bind(value="this") Node inliningTarget, @Cached GetValueNode getValueNode, @Cached GetOrCreateDictNode getDict, @Cached PythonObjectFactory factory) {
            Object initValue = getValueNode.execute(frame, self);
            PNone readnl = self.getReadNewline() == null ? PNone.NONE : self.getReadNewline();
            Object[] state = new Object[]{initValue, readnl, self.getPos(), getDict.execute(inliningTarget, self)};
            return factory.createTuple(state);
        }
    }

    @Builtin(name="getvalue", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class GetValueNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        GetValueNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "self.isAccumulating()"})
        static Object copy(PStringIO self, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            return self.makeIntermediate(toStringNode);
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "!self.isAccumulating()"})
        static Object doit(PStringIO self, @Bind(value="this") Node inliningTarget, @Cached PStringIO.PStringIOBufToStringNode bufToStringNode) {
            return bufToStringNode.execute(inliningTarget, self);
        }
    }

    @Builtin(name="seek", minNumOfPositionalArgs=2, parameterNames={"$self", "pos", "whence"})
    @ArgumentsClinic(value={@ArgumentClinic(name="pos", conversion=ArgumentClinic.ClinicConversion.Index), @ArgumentClinic(name="whence", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="BufferedIOUtil.SEEK_SET", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class SeekNode
    extends PythonTernaryClinicBuiltinNode {
        SeekNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringIOBuiltinsClinicProviders.SeekNodeClinicProviderGen.INSTANCE;
        }

        protected static boolean isSupportedWhence(int whence) {
            return whence == 0 || whence == 1 || whence == 2;
        }

        protected static boolean validPos(int pos, int whence) {
            return !(pos < 0 && whence == 0 || pos != 0 && whence != 0);
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "isSupportedWhence(whence)", "validPos(pos, whence)"})
        static Object seek(PStringIO self, int pos, int whence) {
            int p = pos;
            if (whence == 1) {
                p = self.getPos();
            } else if (whence == 2) {
                p = self.getStringSize();
            }
            self.setPos(p);
            return self.getPos();
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "!isSupportedWhence(whence)"})
        static Object whenceError(PStringIO self, int pos, int whence, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.INVALID_WHENCE_D_SHOULD_BE_0_1_OR_2, whence);
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "isSupportedWhence(whence)", "pos != 0", "whence != 0"})
        static Object largePos1(PStringIO self, int pos, int whence, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.OSError, ErrorMessages.CAN_T_DO_NONZERO_CUR_RELATIVE_SEEKS);
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "pos < 0", "whence == 0"})
        static Object negPos(PStringIO self, int pos, int whence, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SEEK_VALUE_D, pos);
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PStringIO self, int pos, int whence, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PStringIO self, int pos, int whence, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    @Builtin(name="tell", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class TellNode
    extends ClosedCheckPythonUnaryBuiltinNode {
        TellNode() {
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static Object tell(PStringIO self) {
            return self.getPos();
        }
    }

    @Builtin(name="write", minNumOfPositionalArgs=2, parameterNames={"self", "s"})
    @ArgumentClinic(name="s", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    static abstract class WriteNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        WriteNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringIOBuiltinsClinicProviders.WriteNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static Object doWrite(VirtualFrame frame, PStringIO self, TruffleString s, @Bind(value="this") Node inliningTarget, @Cached IncrementalNewlineDecoderBuiltins.DecodeNode decodeNode, @Cached StringNodes.StringReplaceNode replaceNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            int size = codePointLengthNode.execute((AbstractTruffleString)s, PythonUtils.TS_ENCODING);
            if (size > 0) {
                StringIOBuiltins.writeString(frame, inliningTarget, self, s, raiseNode, decodeNode, replaceNode, codePointLengthNode, substringNode, appendStringNode, appendCodePointNode, toStringNode);
            }
            return size;
        }
    }

    @Builtin(name="truncate", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", defaultValue="PNone.NONE", useDefaultForNone=true)
    @TypeSystemReference(value=PythonArithmeticTypes.class)
    @GenerateNodeFactory
    static abstract class TruncateNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        TruncateNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringIOBuiltinsClinicProviders.TruncateNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static Object truncate(PStringIO self, PNone size, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
            return TruncateNode.truncate(self, self.getPos(), substringNode, toStringNode, appendStringNode);
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "size >= 0", "size < self.getStringSize()"})
        static Object truncate(PStringIO self, int size, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode) {
            self.realize();
            TruffleString currentBuf = toStringNode.execute(self.getBuf(), true);
            TruffleStringBuilder newBuf = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING, (int)size);
            appendStringNode.execute(newBuf, (AbstractTruffleString)substringNode.execute((AbstractTruffleString)currentBuf, 0, size, PythonUtils.TS_ENCODING, true));
            self.setBuf(newBuf);
            self.setStringsize(size);
            return size;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "size >= 0", "size >= self.getStringSize()"})
        static Object same(PStringIO self, int size) {
            return size;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "!isInteger(arg)", "!isPNone(arg)"})
        static Object obj(VirtualFrame frame, PStringIO self, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode, @Cached PyNumberIndexNode indexNode, @Cached.Shared @Cached TruffleString.SubstringNode substringNode, @Cached.Shared @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached.Shared @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            int size = asSizeNode.executeExact((Frame)frame, inliningTarget, indexNode.execute((Frame)frame, inliningTarget, arg), PythonErrorType.OverflowError);
            if (size >= 0) {
                if (size < self.getStringSize()) {
                    return TruncateNode.truncate(self, size, substringNode, toStringNode, appendStringNode);
                }
                return size;
            }
            return TruncateNode.negSize(self, size, raiseNode.get(inliningTarget));
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()", "size < 0"})
        static Object negSize(PStringIO self, int size, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.NEGATIVE_SIZE_VALUE_D, size);
        }
    }

    @Builtin(name="readline", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadlineNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadlineNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringIOBuiltinsClinicProviders.ReadlineNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static TruffleString readline(PStringIO self, int size, @Bind(value="this") Node inliningTarget, @Cached TextIOWrapperNodes.FindLineEndingNode findLineEndingNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            self.realize();
            return StringIOBuiltins.stringioReadline(inliningTarget, self, size, findLineEndingNode, substringNode, toStringNode);
        }
    }

    @Builtin(name="read", minNumOfPositionalArgs=1, parameterNames={"$self", "size"})
    @ArgumentClinic(name="size", conversion=ArgumentClinic.ClinicConversion.Int, defaultValue="-1", useDefaultForNone=true)
    @GenerateNodeFactory
    static abstract class ReadNode
    extends ClosedCheckPythonBinaryClinicBuiltinNode {
        ReadNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringIOBuiltinsClinicProviders.ReadNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"self.isOK()", "!self.isClosed()"})
        static TruffleString read(PStringIO self, int len, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            int size = len;
            int n = self.getStringSize() - self.getPos();
            if ((size < 0 || size > n) && (size = n) < 0) {
                size = 0;
            }
            if (size == 0) {
                return StringLiterals.T_EMPTY_STRING;
            }
            if (self.isAccumulating() && self.getPos() == 0 && size == n) {
                self.setPos(self.getStringSize());
                return self.makeIntermediate(toStringNode);
            }
            self.realize();
            int newPos = self.getPos() + size;
            TruffleString lazyBuf = toStringNode.execute(self.getBuf(), true);
            TruffleString output = substringNode.execute((AbstractTruffleString)lazyBuf, self.getPos(), size, PythonUtils.TS_ENCODING, false);
            self.setPos(newPos);
            return output;
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "initial_value", "newline"})
    @ArgumentClinic(name="initial_value", conversion=ArgumentClinic.ClinicConversion.TString, defaultValue="T_EMPTY_STRING", useDefaultForNone=true)
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonTernaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return StringIOBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        @Specialization
        static PNone init(VirtualFrame frame, PStringIO self, TruffleString initialValue, Object newlineArg, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy lazyRaiseNode, @Cached IncrementalNewlineDecoderBuiltins.DecodeNode decodeNode, @Cached IncrementalNewlineDecoderBuiltins.InitNode initNode, @Cached StringNodes.StringReplaceNode replaceNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CodePointAtIndexNode codePointAtIndexNode, @Cached TruffleString.SubstringNode substringNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached TruffleStringBuilder.AppendCodePointNode appendCodePointNode, @Cached IONodes.ToTruffleStringNode toTruffleStringNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            Object newline = newlineArg == PNone.NO_VALUE ? StringLiterals.T_NEWLINE : (newlineArg == PNone.NONE ? null : toTruffleStringNode.execute(inliningTarget, newlineArg));
            if (newline != null) {
                TextIOWrapperNodes.validateNewline(newline, inliningTarget, lazyRaiseNode, codePointLengthNode, codePointAtIndexNode);
            }
            self.setOK(false);
            self.clearAll();
            if (newline != null) {
                self.setReadNewline((TruffleString)newline);
            }
            self.setReadUniversal(newline == null || newline.isEmpty() || codePointAtIndexNode.execute((AbstractTruffleString)newline, 0, PythonUtils.TS_ENCODING) == 0);
            self.setReadTranslate(newline == null);
            if (newline != null && !newline.isEmpty() && codePointAtIndexNode.execute((AbstractTruffleString)newline, 0, PythonUtils.TS_ENCODING) == 13) {
                self.setWriteNewline(self.getReadNewline());
            }
            if (self.isReadUniversal()) {
                PNLDecoder incDecoder = factory.createNLDecoder((Object)PythonBuiltinClassType.PIncrementalNewlineDecoder);
                initNode.execute(frame, incDecoder, self.getDecoder(), self.isReadTranslate(), PNone.NO_VALUE);
                self.setDecoder(incDecoder);
            }
            self.setStringsize(0);
            if (!initialValue.isEmpty()) {
                self.setRealized();
                self.setPos(0);
                StringIOBuiltins.writeString(frame, inliningTarget, self, initialValue, raiseNode, decodeNode, replaceNode, codePointLengthNode, substringNode, appendStringNode, appendCodePointNode, toStringNode);
            } else {
                self.setAccumulating();
            }
            self.setPos(0);
            self.setClosed(false);
            self.setOK(true);
            return PNone.NONE;
        }
    }

    static abstract class ClosedCheckPythonBinaryClinicBuiltinNode
    extends PythonBinaryClinicBuiltinNode {
        ClosedCheckPythonBinaryClinicBuiltinNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PStringIO self, Object arg, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PStringIO self, Object arg, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }

    static abstract class ClosedCheckPythonUnaryBuiltinNode
    extends PythonUnaryBuiltinNode {
        ClosedCheckPythonUnaryBuiltinNode() {
        }

        @Specialization(guards={"!self.isOK()"})
        static Object initError(PStringIO self, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_UNINIT);
        }

        @Specialization(guards={"self.isClosed()"})
        static Object closedError(PStringIO self, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.ValueError, ErrorMessages.IO_CLOSED);
        }
    }
}

