/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.array;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.io.IONodes;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PNotImplemented;
import com.oracle.graal.python.builtins.objects.array.ArrayBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.array.ArrayBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.array.ArrayBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.array.ArrayNodes;
import com.oracle.graal.python.builtins.objects.array.PArray;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.common.IndexNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.module.PythonModule;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.lib.GetNextNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectCallMethodObjArgs;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetIter;
import com.oracle.graal.python.lib.PyObjectLookupAttr;
import com.oracle.graal.python.lib.PyObjectRichCompareBool;
import com.oracle.graal.python.lib.PyObjectSizeNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.expression.BinaryComparisonNode;
import com.oracle.graal.python.nodes.expression.CoerceToBooleanNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonTernaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.BuiltinClassProfiles;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.exception.PythonErrorType;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ByteSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.BufferFormat;
import com.oracle.graal.python.util.ComparisonOp;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.ExplodeLoop;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedByteValueProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.api.strings.TruffleStringBuilder;
import com.oracle.truffle.api.strings.TruffleStringIterator;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PArray})
public final class ArrayBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = ArrayBuiltinsSlotsGen.SLOTS;
    private static final TruffleString T_ARRAY_RECONSTRUCTOR = PythonUtils.tsLiteral("_array_reconstructor");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return ArrayBuiltinsFactory.getFactories();
    }

    @Builtin(name="reverse", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReverseNode
    extends PythonUnaryBuiltinNode {
        ReverseNode() {
        }

        @Specialization
        static Object reverse(PArray self, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            int itemsize = self.getFormat().bytesize;
            int itemShift = self.getItemSizeShift();
            byte[] tmp = new byte[itemsize];
            int length = self.getLength();
            for (int i = 0; i < length / 2; ++i) {
                bufferLib.readIntoByteArray(self.getBuffer(), i << itemShift, tmp, 0, itemsize);
                bufferLib.readIntoBuffer(self.getBuffer(), length - i - 1 << itemShift, self.getBuffer(), i << itemShift, itemsize, bufferLib);
                bufferLib.writeFromByteArray(self.getBuffer(), length - i - 1 << itemShift, tmp, 0, itemsize);
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="count", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class CountNode
    extends PythonBinaryBuiltinNode {
        CountNode() {
        }

        @Specialization
        static int count(VirtualFrame frame, PArray self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached ArrayNodes.GetValueNode getValueNode) {
            int count = 0;
            for (int i = 0; i < self.getLength(); ++i) {
                if (!eqNode.compare((Frame)frame, inliningTarget, getValueNode.execute(inliningTarget, self, i), value)) continue;
                ++count;
            }
            return count;
        }
    }

    @Builtin(name="index", minNumOfPositionalArgs=2, parameterNames={"$self", "sub", "start", "end"})
    @ArgumentsClinic(value={@ArgumentClinic(name="start", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="0", useDefaultForNone=true), @ArgumentClinic(name="end", conversion=ArgumentClinic.ClinicConversion.SliceIndex, defaultValue="Integer.MAX_VALUE", useDefaultForNone=true)})
    @GenerateNodeFactory
    static abstract class IndexNode
    extends PythonQuaternaryClinicBuiltinNode {
        IndexNode() {
        }

        @Specialization
        static int index(VirtualFrame frame, PArray self, Object value, int start, int stop, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached ArrayNodes.GetValueNode getValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            int length = self.getLength();
            if (start < 0 && (start += length) < 0) {
                start = 0;
            }
            if (stop < 0) {
                stop += length;
            }
            for (int i = start; i < stop && i < length; ++i) {
                if (!eqNode.compare((Frame)frame, inliningTarget, getValueNode.execute(inliningTarget, self, i), value)) continue;
                return i;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ARRAY_INDEX_X_NOT_IN_ARRAY);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.IndexNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="byteswap", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ByteSwapNode
    extends PythonUnaryBuiltinNode {
        @Specialization(guards={"self.getFormat().bytesize == 1"})
        static Object byteswap1(PArray self) {
            return PNone.NONE;
        }

        @Specialization(guards={"self.getFormat().bytesize == 2"})
        static Object byteswap2(PArray self, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            ByteSwapNode.doByteSwapExploded(self, 2, self.getBuffer(), bufferLib);
            return PNone.NONE;
        }

        @Specialization(guards={"self.getFormat().bytesize == 4"})
        static Object byteswap4(PArray self, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            ByteSwapNode.doByteSwapExploded(self, 4, self.getBuffer(), bufferLib);
            return PNone.NONE;
        }

        @Specialization(guards={"self.getFormat().bytesize == 8"})
        static Object byteswap8(PArray self, @Cached.Shared @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib) {
            ByteSwapNode.doByteSwapExploded(self, 8, self.getBuffer(), bufferLib);
            return PNone.NONE;
        }

        private static void doByteSwapExploded(PArray self, int itemsize, Object buffer, PythonBufferAccessLibrary bufferLib) {
            for (int i = 0; i < self.getBytesLength(); i += itemsize) {
                ByteSwapNode.doByteSwapExplodedInnerLoop(buffer, itemsize, i, bufferLib);
            }
        }

        @ExplodeLoop
        private static void doByteSwapExplodedInnerLoop(Object buffer, int itemsize, int i, PythonBufferAccessLibrary bufferLib) {
            for (int j = 0; j < itemsize / 2; ++j) {
                byte b = bufferLib.readByte(buffer, i + j);
                bufferLib.writeByte(buffer, i + j, bufferLib.readByte(buffer, i + itemsize - j - 1));
                bufferLib.writeByte(buffer, i + itemsize - j - 1, b);
            }
        }
    }

    @Builtin(name="tofile", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ToFileNode
    extends PythonBinaryBuiltinNode {
        ToFileNode() {
        }

        @Specialization
        static Object tofile(VirtualFrame frame, PArray self, Object file, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PythonObjectFactory factory) {
            if (self.getLength() > 0) {
                int remaining = self.getBytesLength();
                int blocksize = 65536;
                int nblocks = (remaining + blocksize - 1) / blocksize;
                byte[] buffer = null;
                for (int i = 0; i < nblocks; ++i) {
                    if (remaining < blocksize) {
                        buffer = new byte[remaining];
                    } else if (buffer == null) {
                        buffer = new byte[blocksize];
                    }
                    bufferLib.readIntoByteArray(self.getBuffer(), i * blocksize, buffer, 0, buffer.length);
                    callMethod.execute((Frame)frame, inliningTarget, file, IONodes.T_WRITE, factory.createBytes(buffer));
                    remaining -= blocksize;
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="tounicode", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ToUnicodeNode
    extends PythonUnaryBuiltinNode {
        ToUnicodeNode() {
        }

        @Specialization
        static TruffleString tounicode(PArray self, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile formatProfile, @Cached ArrayNodes.GetValueNode getValueNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (formatProfile.profile(inliningTarget, self.getFormat() != BufferFormat.UNICODE)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.MAY_ONLY_BE_CALLED_ON_UNICODE_TYPE_ARRAYS);
            }
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            int length = self.getLength();
            for (int i = 0; i < length; ++i) {
                appendStringNode.execute(sb, (AbstractTruffleString)((TruffleString)getValueNode.execute(inliningTarget, self, i)));
            }
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="tolist", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ToListNode
    extends PythonUnaryBuiltinNode {
        ToListNode() {
        }

        @Specialization
        static Object tolist(VirtualFrame frame, PArray self, @Cached ListNodes.ConstructListNode constructListNode) {
            return constructListNode.execute((Frame)frame, self);
        }
    }

    @Builtin(name="tobytes", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ToBytesNode
    extends PythonUnaryBuiltinNode {
        ToBytesNode() {
        }

        @Specialization
        Object tobytes(PArray self, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PythonObjectFactory factory) {
            byte[] bytes = new byte[self.getBytesLength()];
            bufferLib.readIntoByteArray(self.getBuffer(), 0, bytes, 0, bytes.length);
            return factory.createBytes(bytes);
        }
    }

    @Builtin(name="fromunicode", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "str"})
    @ArgumentClinic(name="str", conversion=ArgumentClinic.ClinicConversion.TString)
    @GenerateNodeFactory
    public static abstract class FromUnicodeNode
    extends PythonBinaryClinicBuiltinNode {
        @Specialization
        static Object fromunicode(VirtualFrame frame, PArray self, TruffleString str, @Bind(value="this") Node inliningTarget, @Cached ArrayNodes.PutValueNode putValueNode, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached TruffleString.CreateCodePointIteratorNode createCodePointIteratorNode, @Cached TruffleStringIterator.NextNode nextNode, @Cached TruffleString.FromCodePointNode fromCodePointNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int length = codePointLengthNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
                int newLength = PythonUtils.addExact(self.getLength(), length);
                self.checkCanResize(inliningTarget, raiseNode);
                ensureCapacityNode.execute(inliningTarget, self, newLength);
                TruffleStringIterator it = createCodePointIteratorNode.execute((AbstractTruffleString)str, PythonUtils.TS_ENCODING);
                int codePointIndex = 0;
                while (it.hasNext()) {
                    TruffleString value = fromCodePointNode.execute(nextNode.execute(it), PythonUtils.TS_ENCODING, true);
                    putValueNode.execute(frame, inliningTarget, self, self.getLength() + codePointIndex++, value);
                }
                setLengthNode.execute(inliningTarget, self, newLength);
                return PNone.NONE;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }

        @Fallback
        static Object error(Object self, Object arg, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.FROMUNICODE_ARG_MUST_BE_STR_NOT_P, arg);
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.FromUnicodeNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="fromlist", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class FromListNode
    extends PythonBinaryBuiltinNode {
        FromListNode() {
        }

        @Specialization
        static Object fromlist(VirtualFrame frame, PArray self, PList list, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemScalarNode, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached ArrayNodes.PutValueNode putValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, list);
                int length = storage.length();
                int newLength = PythonUtils.addExact(self.getLength(), length);
                self.checkCanResize(inliningTarget, raiseNode);
                ensureCapacityNode.execute(inliningTarget, self, newLength);
                for (int i = 0; i < length; ++i) {
                    putValueNode.execute(frame, inliningTarget, self, self.getLength() + i, getItemScalarNode.execute(inliningTarget, storage, i));
                }
                setLengthNode.execute(inliningTarget, self, newLength);
                return PNone.NONE;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }

        @Fallback
        static Object error(Object self, Object arg, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_LIST);
        }
    }

    @Builtin(name="fromfile", minNumOfPositionalArgs=3, numOfPositionalOnlyArgs=3, parameterNames={"$self", "file", "n"})
    @ArgumentClinic(name="n", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    public static abstract class FromFileNode
    extends PythonTernaryClinicBuiltinNode {
        @Specialization
        static Object fromfile(VirtualFrame frame, PArray self, Object file, int n, @Bind(value="this") Node inliningTarget, @Cached PyObjectCallMethodObjArgs callMethod, @Cached PyObjectSizeNode sizeNode, @Cached InlinedConditionProfile nNegativeProfile, @Cached FromBytesNode fromBytesNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (nNegativeProfile.profile(inliningTarget, n < 0)) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.NEGATIVE_COUNT);
            }
            int nbytes = n << self.getItemSizeShift();
            Object readResult = callMethod.execute((Frame)frame, inliningTarget, file, IONodes.T_READ, nbytes);
            if (readResult instanceof PBytes) {
                int readLength = sizeNode.execute((Frame)frame, inliningTarget, readResult);
                fromBytesNode.executeWithoutClinic(frame, self, readResult);
                if (readLength != nbytes) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.EOFError, ErrorMessages.READ_DIDNT_RETURN_ENOUGH_BYTES);
                }
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.READ_DIDNT_RETURN_BYTES);
            }
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.FromFileNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="frombytes", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "buffer"})
    @ArgumentClinic(name="buffer", conversion=ArgumentClinic.ClinicConversion.ReadableBuffer)
    @GenerateNodeFactory
    public static abstract class FromBytesNode
    extends PythonBinaryClinicBuiltinNode {
        @Override
        public abstract Object executeWithoutClinic(VirtualFrame var1, Object var2, Object var3);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Specialization
        static Object frombytes(VirtualFrame frame, PArray self, Object buffer, @Bind(value="this") Node inliningTarget, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(limit="3") PythonBufferAccessLibrary bufferLib, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int itemShift = self.getItemSizeShift();
                int oldSize = self.getLength();
                try {
                    int bufferLength = bufferLib.getBufferLength(buffer);
                    if (!PythonUtils.isDivisible(bufferLength, itemShift)) {
                        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.BYTES_ARRAY_NOT_MULTIPLE_OF_ARRAY_SIZE);
                    }
                    int newLength = PythonUtils.addExact(oldSize, bufferLength >> itemShift);
                    self.checkCanResize(inliningTarget, raiseNode);
                    ensureCapacityNode.execute(inliningTarget, self, newLength);
                    setLengthNode.execute(inliningTarget, self, newLength);
                    bufferLib.readIntoBuffer(buffer, 0, self.getBuffer(), oldSize << itemShift, bufferLength, bufferLib);
                }
                catch (OverflowException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
                }
                PNone pNone = PNone.NONE;
                return pNone;
            }
            finally {
                bufferLib.release(buffer, frame, indirectCallData);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.FromBytesNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="pop", minNumOfPositionalArgs=1, numOfPositionalOnlyArgs=2, parameterNames={"$self", "index"})
    @ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index, defaultValue="-1")
    @GenerateNodeFactory
    static abstract class PopNode
    extends PythonBinaryClinicBuiltinNode {
        PopNode() {
        }

        @Specialization
        static Object pop(PArray self, int inputIndex, @Bind(value="this") Node inliningTarget, @Cached(value="forPop()") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached ArrayNodes.GetValueNode getValueNode, @Cached ArrayNodes.DeleteArraySliceNode deleteSliceNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (self.getLength() == 0) {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.IndexError, ErrorMessages.POP_FROM_EMPTY_ARRAY);
            }
            int index = normalizeIndexNode.execute(inputIndex, self.getLength());
            Object value = getValueNode.execute(inliningTarget, self, index);
            self.checkCanResize(inliningTarget, raiseNode);
            deleteSliceNode.execute(inliningTarget, self, index, 1);
            return value;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.PopNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="remove", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class RemoveNode
    extends PythonBinaryBuiltinNode {
        RemoveNode() {
        }

        @Specialization
        static Object remove(VirtualFrame frame, PArray self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached ArrayNodes.GetValueNode getValueNode, @Cached ArrayNodes.DeleteArraySliceNode deleteSliceNode, @Cached PRaiseNode.Lazy raiseNode) {
            for (int i = 0; i < self.getLength(); ++i) {
                Object item = getValueNode.execute(inliningTarget, self, i);
                if (!eqNode.compare((Frame)frame, inliningTarget, item, value)) continue;
                self.checkCanResize(inliningTarget, raiseNode);
                deleteSliceNode.execute(inliningTarget, self, i, 1);
                return PNone.NONE;
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ARRAY_REMOVE_X_NOT_IN_ARRAY);
        }
    }

    @Builtin(name="insert", minNumOfPositionalArgs=3, numOfPositionalOnlyArgs=3, parameterNames={"$self", "index", "value"})
    @ArgumentClinic(name="index", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class InsertNode
    extends PythonTernaryClinicBuiltinNode {
        InsertNode() {
        }

        @Specialization
        static Object insert(VirtualFrame frame, PArray self, int inputIndex, Object value, @Bind(value="this") Node inliningTarget, @Cached(value="create(false)") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached ArrayNodes.CheckValueNode checkValueNode, @Cached ArrayNodes.PutValueNode putValueNode, @Cached ArrayNodes.ShiftNode shiftNode, @Cached PRaiseNode.Lazy raiseNode) {
            int index = normalizeIndexNode.execute(inputIndex, self.getLength());
            if (index > self.getLength()) {
                index = self.getLength();
            } else if (index < 0) {
                index = 0;
            }
            checkValueNode.execute(frame, inliningTarget, self, value);
            self.checkCanResize(inliningTarget, raiseNode);
            shiftNode.execute(inliningTarget, self, index, 1);
            putValueNode.execute(frame, inliningTarget, self, index, value);
            return PNone.NONE;
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.InsertNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="extend", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ExtendNode
    extends PythonBinaryBuiltinNode {
        ExtendNode() {
        }

        @Specialization(guards={"self.getFormat() == value.getFormat()"})
        static Object extend(PArray self, PArray value, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached.Exclusive @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int newLength = PythonUtils.addExact(self.getLength(), value.getLength());
                if (newLength != self.getLength()) {
                    self.checkCanResize(inliningTarget, raiseNode);
                }
                int itemShift = self.getItemSizeShift();
                ensureCapacityNode.execute(inliningTarget, self, newLength);
                bufferLib.readIntoBuffer(value.getBuffer(), 0, self.getBuffer(), self.getLength() << itemShift, value.getLength() << itemShift, bufferLib);
                setLengthNode.execute(inliningTarget, self, newLength);
                return PNone.NONE;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization
        static Object extend(VirtualFrame frame, PArray self, PSequence value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached ArrayNodes.PutValueNode putValueNode, @Cached SequenceNodes.GetSequenceStorageNode getSequenceStorageNode, @Cached SequenceStorageNodes.GetItemScalarNode getItemNode, @Cached.Exclusive @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached.Exclusive @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            SequenceStorage storage = getSequenceStorageNode.execute(inliningTarget, value);
            int storageLength = storage.length();
            try {
                int newLength = PythonUtils.addExact(self.getLength(), storageLength);
                if (newLength != self.getLength()) {
                    self.checkCanResize(inliningTarget, raiseNode);
                    ensureCapacityNode.execute(inliningTarget, self, newLength);
                }
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
            int length = self.getLength();
            for (int i = 0; i < storageLength; ++i) {
                putValueNode.execute(frame, inliningTarget, self, length, getItemNode.execute(inliningTarget, storage, i));
                setLengthNode.execute(inliningTarget, self, ++length);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"!isArray(value)"})
        static Object extend(VirtualFrame frame, PArray self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetIter getIter, @Cached.Exclusive @Cached ArrayNodes.PutValueNode putValueNode, @Cached GetNextNode nextNode, @Cached BuiltinClassProfiles.IsBuiltinObjectProfile errorProfile, @Cached.Exclusive @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached.Exclusive @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            Object iter = getIter.execute((Frame)frame, inliningTarget, value);
            int length = self.getLength();
            while (true) {
                Object nextValue;
                try {
                    nextValue = nextNode.execute((Frame)frame, iter);
                }
                catch (PException e) {
                    e.expectStopIteration(inliningTarget, errorProfile);
                    break;
                }
                try {
                    length = PythonUtils.addExact(length, 1);
                    self.checkCanResize(inliningTarget, raiseNode);
                    ensureCapacityNode.execute(inliningTarget, self, length);
                }
                catch (OverflowException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
                }
                putValueNode.execute(frame, inliningTarget, self, length - 1, nextValue);
                setLengthNode.execute(inliningTarget, self, length);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"self.getFormat() != value.getFormat()"})
        static Object error(PArray self, PArray value, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_EXTEND_WITH_ARRAY_OF_SAME_KIND);
        }
    }

    @Builtin(name="append", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AppendNode
    extends PythonBinaryBuiltinNode {
        AppendNode() {
        }

        @Specialization
        static Object append(VirtualFrame frame, PArray self, Object value, @Bind(value="this") Node inliningTarget, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached ArrayNodes.PutValueNode putValueNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int index = self.getLength();
                int newLength = PythonUtils.addExact(index, 1);
                self.checkCanResize(inliningTarget, raiseNode);
                ensureCapacityNode.execute(inliningTarget, self, newLength);
                setLengthNode.execute(inliningTarget, self, newLength);
                putValueNode.execute(frame, inliningTarget, self, index, value);
                return PNone.NONE;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @Builtin(name="buffer_info", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class BufferInfoNode
    extends PythonUnaryBuiltinNode {
        BufferInfoNode() {
        }

        @Specialization
        static Object bufferinfo(PArray self, @Bind(value="this") Node inliningTarget, @Cached ArrayNodes.EnsureNativeStorageNode ensureNativeStorageNode, @Cached PythonObjectFactory factory, @CachedLibrary(limit="1") InteropLibrary lib) {
            Object nativePointer = ensureNativeStorageNode.execute(inliningTarget, self).getPtr();
            if (!(nativePointer instanceof Long)) {
                try {
                    nativePointer = lib.asPointer(nativePointer);
                }
                catch (UnsupportedMessageException e) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.NotImplementedError);
                }
            }
            return factory.createTuple(new Object[]{nativePointer, self.getLength()});
        }
    }

    @Builtin(name="typecode", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class TypeCodeNode
    extends PythonUnaryBuiltinNode {
        TypeCodeNode() {
        }

        @Specialization
        static TruffleString getTypeCode(PArray self) {
            return self.getFormatString();
        }
    }

    @Builtin(name="itemsize", minNumOfPositionalArgs=1, isGetter=true)
    @GenerateNodeFactory
    static abstract class ItemSizeNode
    extends PythonUnaryBuiltinNode {
        ItemSizeNode() {
        }

        @Specialization
        static int getItemSize(PArray self) {
            return self.getFormat().bytesize;
        }
    }

    @Builtin(name="__reduce_ex__", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "protocol"})
    @ArgumentClinic(name="protocol", conversion=ArgumentClinic.ClinicConversion.Int)
    @GenerateNodeFactory
    static abstract class ReduceExNode
    extends PythonBinaryClinicBuiltinNode {
        ReduceExNode() {
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.ReduceExNodeClinicProviderGen.INSTANCE;
        }

        @Specialization(guards={"protocol < 3"})
        static Object reduceLegacy(VirtualFrame frame, PArray self, int protocol, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive GetClassNode getClassNode, @Cached @Cached.Exclusive PyObjectLookupAttr lookupDict, @Cached ToListNode toListNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            Object cls = getClassNode.execute(inliningTarget, self);
            Object dict = lookupDict.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___DICT__);
            if (dict == PNone.NO_VALUE) {
                dict = PNone.NONE;
            }
            PTuple args = factory.createTuple(new Object[]{self.getFormatString(), toListNode.execute(frame, self)});
            return factory.createTuple(new Object[]{cls, args, dict});
        }

        @Specialization(guards={"protocol >= 3"})
        static Object reduce(VirtualFrame frame, PArray self, int protocol, @Bind(value="this") Node inliningTarget, @Cached @Cached.Exclusive GetClassNode getClassNode, @Cached @Cached.Exclusive PyObjectLookupAttr lookupDict, @Cached PyObjectGetAttr getReconstructor, @Cached ToBytesNode toBytesNode, @Cached.Shared @Cached PythonObjectFactory factory) {
            PythonModule arrayModule = PythonContext.get(inliningTarget).lookupBuiltinModule(BuiltinNames.T_ARRAY);
            PArray.MachineFormat mformat = PArray.MachineFormat.forFormat(self.getFormat());
            assert (mformat != null);
            Object cls = getClassNode.execute(inliningTarget, self);
            Object dict = lookupDict.execute((Frame)frame, inliningTarget, self, SpecialAttributeNames.T___DICT__);
            if (dict == PNone.NO_VALUE) {
                dict = PNone.NONE;
            }
            Object reconstructor = getReconstructor.execute((Frame)frame, inliningTarget, arrayModule, T_ARRAY_RECONSTRUCTOR);
            PTuple args = factory.createTuple(new Object[]{cls, self.getFormatString(), mformat.code, toBytesNode.execute(frame, self)});
            return factory.createTuple(new Object[]{reconstructor, args, dict});
        }
    }

    @Slot.Slots(value={@Slot(value=Slot.SlotKind.sq_length), @Slot(value=Slot.SlotKind.mp_length)})
    @GenerateUncached
    @GenerateNodeFactory
    static abstract class LenNode
    extends TpSlotLen.LenBuiltinNode {
        LenNode() {
        }

        @Specialization
        static int len(PArray self) {
            return self.getLength();
        }
    }

    @Builtin(name="__iter__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class IterNode
    extends PythonUnaryBuiltinNode {
        IterNode() {
        }

        @Specialization
        static Object getitem(PArray self, @Cached PythonObjectFactory factory) {
            return factory.createArrayIterator(self);
        }
    }

    @Builtin(name="__delitem__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class DelItemNode
    extends PythonBinaryBuiltinNode {
        DelItemNode() {
        }

        public abstract Object executeSlice(VirtualFrame var1, PArray var2, PSlice var3);

        @Specialization(guards={"!isPSlice(idx)"})
        static Object delitem(VirtualFrame frame, PArray self, Object idx, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached(value="forArrayAssign()") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached.Exclusive @Cached ArrayNodes.DeleteArraySliceNode deleteSliceNode, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            int index = normalizeIndexNode.execute(indexNode.execute((Frame)frame, inliningTarget, idx), self.getLength());
            deleteSliceNode.execute(inliningTarget, self, index, 1);
            return PNone.NONE;
        }

        @Specialization
        static Object delitem(PArray self, PSlice slice, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached.Exclusive @Cached ArrayNodes.DeleteArraySliceNode deleteSliceNode, @Cached InlinedByteValueProfile itemShiftProfile, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached InlinedConditionProfile simpleStepProfile, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached.Exclusive @Cached PRaiseNode.Lazy raiseNode) {
            self.checkCanResize(inliningTarget, raiseNode);
            int length = self.getLength();
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, length, sliceUnpack.execute(inliningTarget, slice));
            int start = sliceInfo.start;
            int step = sliceInfo.step;
            int sliceLength = sliceInfo.sliceLength;
            byte itemShift = itemShiftProfile.profile(inliningTarget, (byte)self.getItemSizeShift());
            if (sliceLength > 0) {
                if (simpleStepProfile.profile(inliningTarget, step == 1)) {
                    deleteSliceNode.execute(inliningTarget, self, start, sliceLength);
                } else {
                    int offset;
                    if (step < 0) {
                        start += 1 + step * (sliceLength - 1) - 1;
                        step = -step;
                    }
                    int cur = start;
                    for (offset = 0; offset < sliceLength - 1; ++offset) {
                        bufferLib.readIntoBuffer(self.getBuffer(), cur + 1 << itemShift, self.getBuffer(), cur - offset << itemShift, step - 1 << itemShift, bufferLib);
                        cur += step;
                    }
                    bufferLib.readIntoBuffer(self.getBuffer(), cur + 1 << itemShift, self.getBuffer(), cur - offset << itemShift, length - cur - 1 << itemShift, bufferLib);
                    setLengthNode.execute(inliningTarget, self, length - sliceLength);
                }
            }
            return PNone.NONE;
        }
    }

    @Builtin(name="__setitem__", minNumOfPositionalArgs=3)
    @GenerateNodeFactory
    static abstract class SetItemNode
    extends PythonTernaryBuiltinNode {
        SetItemNode() {
        }

        @Specialization(guards={"!isPSlice(idx)"})
        static Object setitem(VirtualFrame frame, PArray self, Object idx, Object value, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode, @Cached(value="forArrayAssign()") IndexNodes.NormalizeIndexNode normalizeIndexNode, @Cached ArrayNodes.PutValueNode putValueNode) {
            int index = normalizeIndexNode.execute(indexNode.execute((Frame)frame, inliningTarget, idx), self.getLength());
            putValueNode.execute(frame, inliningTarget, self, index, value);
            return PNone.NONE;
        }

        @Specialization(guards={"self.getFormat() == other.getFormat()"})
        static Object setitem(VirtualFrame frame, PArray self, PSlice slice, PArray other, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached InlinedConditionProfile sameArrayProfile, @Cached InlinedConditionProfile simpleStepProfile, @Cached InlinedConditionProfile complexDeleteProfile, @Cached InlinedConditionProfile differentLengthProfile, @Cached InlinedConditionProfile growProfile, @Cached InlinedConditionProfile stepAssignProfile, @Cached InlinedByteValueProfile itemShiftProfile, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached ArrayNodes.DeleteArraySliceNode deleteSliceNode, @Cached ArrayNodes.ShiftNode shiftNode, @Cached DelItemNode delItemNode, @Cached PRaiseNode.Lazy raiseNode) {
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, self.getLength(), sliceUnpack.execute(inliningTarget, slice));
            int start = sliceInfo.start;
            int stop = sliceInfo.stop;
            int step = sliceInfo.step;
            int sliceLength = sliceInfo.sliceLength;
            byte itemShift = itemShiftProfile.profile(inliningTarget, (byte)self.getItemSizeShift());
            int itemsize = self.getItemSize();
            Object sourceBuffer = other.getBuffer();
            int needed = other.getLength();
            if (sameArrayProfile.profile(inliningTarget, sourceBuffer == self.getBuffer())) {
                byte[] tmp = new byte[needed * itemsize];
                bufferLib.readIntoByteArray(other.getBuffer(), 0, tmp, 0, tmp.length);
                sourceBuffer = new ByteSequenceStorage(tmp);
            }
            if (simpleStepProfile.profile(inliningTarget, step == 1)) {
                if (differentLengthProfile.profile(inliningTarget, sliceLength != needed)) {
                    self.checkCanResize(inliningTarget, raiseNode);
                    if (growProfile.profile(inliningTarget, sliceLength < needed)) {
                        if (stop < start) {
                            stop = start;
                        }
                        shiftNode.execute(inliningTarget, self, stop, needed - sliceLength);
                    } else {
                        deleteSliceNode.execute(inliningTarget, self, start, sliceLength - needed);
                    }
                }
                bufferLib.readIntoBuffer(sourceBuffer, 0, self.getBuffer(), start << itemShift, needed << itemShift, bufferLib);
            } else if (complexDeleteProfile.profile(inliningTarget, needed == 0)) {
                delItemNode.executeSlice(frame, self, slice);
            } else if (stepAssignProfile.profile(inliningTarget, needed == sliceLength)) {
                int cur = start;
                for (int i = 0; i < sliceLength; ++i) {
                    bufferLib.readIntoBuffer(sourceBuffer, i << itemShift, self.getBuffer(), cur << itemShift, itemsize, bufferLib);
                    cur += step;
                }
            } else {
                throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.ATTEMPT_ASSIGN_ARRAY_OF_SIZE, needed, sliceLength);
            }
            return PNone.NONE;
        }

        @Specialization(guards={"self.getFormat() != other.getFormat()"})
        static Object setitemWrongFormat(PArray self, PSlice slice, PArray other, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }

        @Specialization(guards={"!isArray(other)"})
        static Object setitemWrongType(PArray self, PSlice slice, Object other, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_ASSIGN_ARRAY, other);
        }
    }

    @Slot(value=Slot.SlotKind.mp_subscript, isComplex=true)
    @GenerateNodeFactory
    static abstract class MpSubscriptNode
    extends TpSlotBinaryFunc.MpSubscriptBuiltinNode {
        MpSubscriptNode() {
        }

        @Specialization(guards={"!isPSlice(idx)"})
        static Object doIndex(VirtualFrame frame, PArray self, Object idx, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PyNumberAsSizeNode numberAsSizeNode, @Cached.Exclusive @Cached InlinedConditionProfile negativeIndexProfile, @Cached ArrayNodes.GetValueNode getValueNode) {
            if (!indexCheckNode.execute(inliningTarget, idx)) {
                throw MpSubscriptNode.raiseNonIntIndex(inliningTarget, raiseNode);
            }
            int index = numberAsSizeNode.executeExact((Frame)frame, inliningTarget, idx, PythonBuiltinClassType.IndexError);
            if (negativeIndexProfile.profile(inliningTarget, index < 0)) {
                index += self.getLength();
            }
            return SqItemNode.getItem(inliningTarget, self, index, raiseNode, getValueNode);
        }

        @Specialization
        static Object doSlice(PArray self, PSlice slice, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached InlinedByteValueProfile itemShiftProfile, @Cached.Exclusive @Cached InlinedConditionProfile simpleStepProfile, @Cached SliceNodes.SliceUnpack sliceUnpack, @Cached SliceNodes.AdjustIndices adjustIndices, @Cached PythonObjectFactory factory) {
            PArray newArray;
            PSlice.SliceInfo sliceInfo = adjustIndices.execute(inliningTarget, self.getLength(), sliceUnpack.execute(inliningTarget, slice));
            byte itemShift = itemShiftProfile.profile(inliningTarget, (byte)self.getItemSizeShift());
            int itemsize = self.getItemSize();
            try {
                newArray = factory.createArray(self.getFormatString(), self.getFormat(), sliceInfo.sliceLength);
            }
            catch (OverflowException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            if (simpleStepProfile.profile(inliningTarget, sliceInfo.step == 1)) {
                bufferLib.readIntoBuffer(self.getBuffer(), sliceInfo.start << itemShift, newArray.getBuffer(), 0, sliceInfo.sliceLength << itemShift, bufferLib);
            } else {
                int i = sliceInfo.start;
                for (int j = 0; j < sliceInfo.sliceLength; ++j) {
                    bufferLib.readIntoBuffer(self.getBuffer(), i << itemShift, newArray.getBuffer(), j << itemShift, itemsize, bufferLib);
                    i += sliceInfo.step;
                }
            }
            return newArray;
        }

        @HostCompilerDirectives.InliningCutoff
        private static PException raiseNonIntIndex(Node inliningTarget, PRaiseNode.Lazy raiseNode) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARRAY_INDICES_MUST_BE_INTS);
        }
    }

    @Slot(value=Slot.SlotKind.sq_item, isComplex=true)
    @GenerateNodeFactory
    static abstract class SqItemNode
    extends TpSlotSizeArgFun.SqItemBuiltinNode {
        SqItemNode() {
        }

        @Specialization
        static Object doIt(VirtualFrame frame, PArray self, int index, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode.Lazy raiseNode, @Cached ArrayNodes.GetValueNode getValueNode) {
            return SqItemNode.getItem(inliningTarget, self, index, raiseNode, getValueNode);
        }

        private static Object getItem(Node inliningTarget, PArray self, int index, PRaiseNode.Lazy raiseNode, ArrayNodes.GetValueNode getValueNode) {
            IndexNodes.checkBounds(inliningTarget, raiseNode, ErrorMessages.ARRAY_OUT_OF_BOUNDS, index, self.getLength());
            return getValueNode.execute(inliningTarget, self, index);
        }
    }

    @Builtin(name="__repr__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class ReprNode
    extends PythonUnaryBuiltinNode {
        ReprNode() {
        }

        @Specialization
        static TruffleString repr(VirtualFrame frame, PArray self, @Bind(value="this") Node inliningTarget, @Cached(value="create(Repr)") LookupAndCallUnaryNode reprNode, @Cached InlinedConditionProfile isEmptyProfile, @Cached InlinedConditionProfile isUnicodeProfile, @Cached CastToTruffleStringNode cast, @Cached ToUnicodeNode toUnicodeNode, @Cached ArrayNodes.GetValueNode getValueNode, @Cached TruffleStringBuilder.AppendStringNode appendStringNode, @Cached TruffleStringBuilder.ToStringNode toStringNode) {
            TruffleStringBuilder sb = TruffleStringBuilder.create((TruffleString.Encoding)PythonUtils.TS_ENCODING);
            appendStringNode.execute(sb, (AbstractTruffleString)BuiltinNames.T_ARRAY);
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LPAREN);
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_SINGLE_QUOTE);
            appendStringNode.execute(sb, (AbstractTruffleString)self.getFormatString());
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_SINGLE_QUOTE);
            int length = self.getLength();
            if (isEmptyProfile.profile(inliningTarget, length != 0)) {
                if (isUnicodeProfile.profile(inliningTarget, self.getFormat() == BufferFormat.UNICODE)) {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    appendStringNode.execute(sb, (AbstractTruffleString)cast.execute(inliningTarget, reprNode.executeObject(frame, toUnicodeNode.execute(frame, self))));
                } else {
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_LBRACKET);
                    for (int i = 0; i < length; ++i) {
                        if (i > 0) {
                            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_COMMA_SPACE);
                        }
                        Object value = getValueNode.execute(inliningTarget, self, i);
                        appendStringNode.execute(sb, (AbstractTruffleString)cast.execute(inliningTarget, reprNode.executeObject(frame, value)));
                    }
                    appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RBRACKET);
                }
            }
            appendStringNode.execute(sb, (AbstractTruffleString)StringLiterals.T_RPAREN);
            return toStringNode.execute(sb);
        }
    }

    @Builtin(name="__contains__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class ContainsNode
    extends PythonBinaryBuiltinNode {
        ContainsNode() {
        }

        @Specialization
        static boolean contains(VirtualFrame frame, PArray self, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached ArrayNodes.GetValueNode getValueNode) {
            for (int i = 0; i < self.getLength(); ++i) {
                if (!eqNode.compare((Frame)frame, inliningTarget, getValueNode.execute(inliningTarget, self, i), value)) continue;
                return true;
            }
            return false;
        }
    }

    @Builtin(name="__ge__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GeNode
    extends PythonBinaryBuiltinNode {
        GeNode() {
        }

        @Specialization
        static Object cmp(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode, @Cached BinaryComparisonNode.GeNode cmpNode) {
            return helperNode.execute(frame, inliningTarget, left, right, ComparisonOp.GE, cmpNode);
        }
    }

    @Builtin(name="__le__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LeNode
    extends PythonBinaryBuiltinNode {
        LeNode() {
        }

        @Specialization
        static Object cmp(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode, @Cached BinaryComparisonNode.LeNode cmpNode) {
            return helperNode.execute(frame, inliningTarget, left, right, ComparisonOp.LE, cmpNode);
        }
    }

    @Builtin(name="__gt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class GtNode
    extends PythonBinaryBuiltinNode {
        GtNode() {
        }

        @Specialization
        static Object cmp(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode, @Cached BinaryComparisonNode.GtNode cmpNode) {
            return helperNode.execute(frame, inliningTarget, left, right, ComparisonOp.GT, cmpNode);
        }
    }

    @Builtin(name="__lt__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class LtNode
    extends PythonBinaryBuiltinNode {
        LtNode() {
        }

        @Specialization
        static Object cmp(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached ComparisonHelperNode helperNode, @Cached BinaryComparisonNode.LtNode cmpNode) {
            return helperNode.execute(frame, inliningTarget, left, right, ComparisonOp.LT, cmpNode);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={BufferFormat.class, PGuards.class})
    static abstract class ComparisonHelperNode
    extends Node {
        ComparisonHelperNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, ComparisonOp var5, BinaryComparisonNode var6);

        @Specialization(guards={"!isFloatingPoint(left.getFormat()) || (left.getFormat() != right.getFormat())"})
        static boolean cmpItems(VirtualFrame frame, Node inliningTarget, PArray left, PArray right, ComparisonOp op, BinaryComparisonNode compareNode, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Exclusive @Cached CoerceToBooleanNode.YesNode coerceToBooleanNode, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getLeft, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getRight) {
            int commonLength = Math.min(left.getLength(), right.getLength());
            for (int i = 0; i < commonLength; ++i) {
                Object rightValue;
                Object leftValue = getLeft.execute(inliningTarget, left, i);
                if (eqNode.compare((Frame)frame, inliningTarget, leftValue, rightValue = getRight.execute(inliningTarget, right, i))) continue;
                return coerceToBooleanNode.executeBoolean(frame, inliningTarget, compareNode.executeObject(frame, leftValue, rightValue));
            }
            return op.cmpResultToBool(left.getLength() - right.getLength());
        }

        @Specialization(guards={"isFloatingPoint(left.getFormat())", "left.getFormat() == right.getFormat()"})
        static boolean cmpDoubles(VirtualFrame frame, Node inliningTarget, PArray left, PArray right, ComparisonOp op, BinaryComparisonNode compareNode, @Cached.Exclusive @Cached CoerceToBooleanNode.YesNode coerceToBooleanNode, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getLeft, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getRight) {
            int commonLength = Math.min(left.getLength(), right.getLength());
            for (int i = 0; i < commonLength; ++i) {
                double rightValue;
                double leftValue = (Double)getLeft.execute(inliningTarget, left, i);
                if (leftValue == (rightValue = ((Double)getRight.execute(inliningTarget, right, i)).doubleValue())) continue;
                return coerceToBooleanNode.executeBoolean(frame, inliningTarget, compareNode.executeObject(frame, leftValue, rightValue));
            }
            return op.cmpResultToBool(left.getLength() - right.getLength());
        }

        @Specialization(guards={"!isArray(right)"})
        static Object cmp(PArray left, Object right, ComparisonOp op, BinaryComparisonNode compareNode) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"!isArray(left)"})
        static Object error(Object left, Object right, ComparisonOp op, BinaryComparisonNode compareNode, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, op.builtinName, "array.array", left);
        }
    }

    @Builtin(name="__ne__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class NeNode
    extends PythonBinaryBuiltinNode {
        NeNode() {
        }

        @Specialization
        static Object eqBytes(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached EqNeHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, left, right, ComparisonOp.NE);
        }
    }

    @Builtin(name="__eq__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class EqNode
    extends PythonBinaryBuiltinNode {
        EqNode() {
        }

        @Specialization
        static Object eqBytes(VirtualFrame frame, Object left, Object right, @Bind(value="this") Node inliningTarget, @Cached EqNeHelperNode helperNode) {
            return helperNode.execute(frame, inliningTarget, left, right, ComparisonOp.EQ);
        }
    }

    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={BufferFormat.class, PGuards.class})
    static abstract class EqNeHelperNode
    extends Node {
        EqNeHelperNode() {
        }

        abstract Object execute(VirtualFrame var1, Node var2, Object var3, Object var4, ComparisonOp var5);

        @Specialization(guards={"left.getFormat() == right.getFormat()", "!isFloatingPoint(left.getFormat())"})
        static boolean eqBytes(PArray left, PArray right, ComparisonOp op, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib) {
            if (left.getBytesLength() != right.getBytesLength()) {
                return op == ComparisonOp.NE;
            }
            for (int i = 0; i < left.getBytesLength(); ++i) {
                if (bufferLib.readByte(left.getBuffer(), i) == bufferLib.readByte(right.getBuffer(), i)) continue;
                return op == ComparisonOp.NE;
            }
            return op == ComparisonOp.EQ;
        }

        @Specialization(guards={"left.getFormat() != right.getFormat()"})
        static boolean eqItems(VirtualFrame frame, Node inliningTarget, PArray left, PArray right, ComparisonOp op, @Cached PyObjectRichCompareBool.EqNode eqNode, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getLeft, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getRight) {
            if (left.getLength() != right.getLength()) {
                return op == ComparisonOp.NE;
            }
            for (int i = 0; i < left.getLength(); ++i) {
                if (eqNode.compare((Frame)frame, inliningTarget, getLeft.execute(inliningTarget, left, i), getRight.execute(inliningTarget, right, i))) continue;
                return op == ComparisonOp.NE;
            }
            return op == ComparisonOp.EQ;
        }

        @Specialization(guards={"left.getFormat() == right.getFormat()", "isFloatingPoint(left.getFormat())"})
        static boolean eqDoubles(Node inliningTarget, PArray left, PArray right, ComparisonOp op, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getLeft, @Cached.Exclusive @Cached ArrayNodes.GetValueNode getRight) {
            if (left.getLength() != right.getLength()) {
                return op == ComparisonOp.NE;
            }
            for (int i = 0; i < left.getLength(); ++i) {
                double rightValue;
                double leftValue = (Double)getLeft.execute(inliningTarget, left, i);
                if (leftValue == (rightValue = ((Double)getRight.execute(inliningTarget, right, i)).doubleValue())) continue;
                return op == ComparisonOp.NE;
            }
            return op == ComparisonOp.EQ;
        }

        @Specialization(guards={"!isArray(right)"})
        static Object eq(PArray left, Object right, ComparisonOp op) {
            return PNotImplemented.NOT_IMPLEMENTED;
        }

        @Specialization(guards={"!isArray(left)"})
        static Object error(Object left, Object right, ComparisonOp op, @Cached(inline=false) PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonErrorType.TypeError, ErrorMessages.DESCRIPTOR_S_REQUIRES_S_OBJ_RECEIVED_P, op.builtinName, "array.array", left);
        }
    }

    @Builtin(name="__imul__", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "value"})
    @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class IMulNode
    extends PythonBinaryClinicBuiltinNode {
        IMulNode() {
        }

        @Specialization
        static Object concat(PArray self, int value, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached ArrayNodes.EnsureCapacityNode ensureCapacityNode, @Cached ArrayNodes.SetLengthNode setLengthNode, @Cached PRaiseNode.Lazy raiseNode) {
            try {
                int newLength = Math.max(PythonUtils.multiplyExact(self.getLength(), value), 0);
                if (newLength != self.getLength()) {
                    self.checkCanResize(inliningTarget, raiseNode);
                }
                int segmentLength = self.getBytesLength();
                ensureCapacityNode.execute(inliningTarget, self, newLength);
                setLengthNode.execute(inliningTarget, self, newLength);
                for (int i = 0; i < value; ++i) {
                    bufferLib.readIntoBuffer(self.getBuffer(), 0, self.getBuffer(), segmentLength * i, segmentLength, bufferLib);
                }
                return self;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.IMulNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__rmul__", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "value"})
    static abstract class RMulNode
    extends MulNode {
        RMulNode() {
        }
    }

    @Builtin(name="__mul__", minNumOfPositionalArgs=2, numOfPositionalOnlyArgs=2, parameterNames={"$self", "value"})
    @ArgumentClinic(name="value", conversion=ArgumentClinic.ClinicConversion.Index)
    @GenerateNodeFactory
    static abstract class MulNode
    extends PythonBinaryClinicBuiltinNode {
        MulNode() {
        }

        @Specialization
        Object concat(PArray self, int value, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PythonObjectFactory factory) {
            try {
                int newLength = Math.max(PythonUtils.multiplyExact(self.getLength(), value), 0);
                PArray newArray = factory.createArray(self.getFormatString(), self.getFormat(), newLength);
                int segmentLength = self.getBytesLength();
                for (int i = 0; i < value; ++i) {
                    bufferLib.readIntoBuffer(self.getBuffer(), 0, newArray.getBuffer(), segmentLength * i, segmentLength, bufferLib);
                }
                return newArray;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.MemoryError);
            }
        }

        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return ArrayBuiltinsClinicProviders.MulNodeClinicProviderGen.INSTANCE;
        }
    }

    @Builtin(name="__iadd__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class IAddNode
    extends PythonBinaryBuiltinNode {
        IAddNode() {
        }

        @Specialization
        static Object concat(VirtualFrame frame, PArray left, PArray right, @Cached ExtendNode extendNode) {
            extendNode.execute(frame, left, right);
            return left;
        }

        @Fallback
        static Object error(Object left, Object right, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_EXTEND_ARRAY_WITH_ARRAY, right);
        }
    }

    @Builtin(name="__add__", minNumOfPositionalArgs=2)
    @GenerateNodeFactory
    static abstract class AddNode
    extends PythonBinaryBuiltinNode {
        AddNode() {
        }

        @Specialization(guards={"left.getFormat() == right.getFormat()"})
        Object concat(PArray left, PArray right, @CachedLibrary(limit="2") PythonBufferAccessLibrary bufferLib, @Cached PythonObjectFactory factory) {
            try {
                int newLength = PythonUtils.addExact(left.getLength(), right.getLength());
                int itemShift = left.getItemSizeShift();
                PArray newArray = factory.createArray(left.getFormatString(), left.getFormat(), newLength);
                bufferLib.readIntoBuffer(left.getBuffer(), 0, newArray.getBuffer(), 0, left.getLength() << itemShift, bufferLib);
                bufferLib.readIntoBuffer(right.getBuffer(), 0, newArray.getBuffer(), left.getLength() << itemShift, right.getLength() << itemShift, bufferLib);
                return newArray;
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(this, PythonBuiltinClassType.MemoryError);
            }
        }

        @Specialization(guards={"left.getFormat() != right.getFormat()"})
        static Object error(PArray left, PArray right, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
        }

        @Fallback
        static Object error(Object left, Object right, @Cached.Shared @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.CAN_ONLY_APPEND_ARRAY_TO_ARRAY, right);
        }
    }
}

