/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.capsule;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.object.PythonBuiltinObject;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.library.ExportLibrary;
import com.oracle.truffle.api.library.ExportMessage;
import com.oracle.truffle.api.strings.TruffleString;

@ExportLibrary(value=InteropLibrary.class)
public final class PyCapsule
extends PythonBuiltinObject {
    private final CapsuleData data;
    private CApiTransitions.PyCapsuleReference reference;

    public PyCapsule(PythonLanguage lang, CapsuleData data) {
        super((Object)PythonBuiltinClassType.Capsule, PythonBuiltinClassType.Capsule.getInstanceShape(lang));
        this.data = data;
    }

    public CapsuleData getData() {
        return this.data;
    }

    public Object getPointer() {
        return this.data.pointer;
    }

    public void setPointer(Object pointer) {
        this.data.pointer = pointer;
    }

    public Object getName() {
        return this.data.name;
    }

    public void setName(Object name) {
        this.data.name = name;
    }

    public Object getContext() {
        return this.data.context;
    }

    public void setContext(Object context) {
        this.data.context = context;
    }

    public Object getDestructor() {
        return this.data.destructor;
    }

    public void registerDestructor(Object destructor) {
        assert (destructor == null || !InteropLibrary.getUncached().isNull(destructor));
        if (this.reference == null && destructor != null) {
            this.reference = CApiTransitions.registerPyCapsuleDestructor(this);
        }
        this.data.destructor = destructor;
    }

    @ExportMessage
    @CompilerDirectives.TruffleBoundary
    public String toDisplayString(boolean allowSideEffects) {
        String n;
        String quote;
        if (this.data.name != null) {
            quote = "\"";
            n = this.data.name instanceof TruffleString ? ((TruffleString)this.getName()).toJavaStringUncached() : CastToJavaStringNode.getUncached().execute(CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(this.data.name, false));
        } else {
            quote = "";
            n = "NULL";
        }
        return String.format("<capsule object %s%s%s at %x>", quote, n, quote, this.hashCode());
    }

    public static class CapsuleData {
        private Object pointer;
        private Object name;
        private Object context;
        private Object destructor;

        public CapsuleData(Object pointer, Object name) {
            this.pointer = pointer;
            this.name = name;
        }

        public Object getDestructor() {
            return this.destructor;
        }
    }
}

