/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.interop.InteropLibrary;

public final class PThreadState
extends PythonNativeWrapper.PythonStructNativeWrapper {
    @CompilerDirectives.TruffleBoundary
    private PThreadState(PythonContext.PythonThreadState threadState) {
        super(threadState, true);
        this.replacement = this.registerReplacement(PThreadState.allocateCLayout(threadState), false, InteropLibrary.getUncached());
    }

    public static Object getOrCreateNativeThreadState(PythonLanguage language, PythonContext context) {
        return PThreadState.getOrCreateNativeThreadState(context.getThreadState(language));
    }

    public static Object getOrCreateNativeThreadState(PythonContext.PythonThreadState threadState) {
        PThreadState nativeWrapper = threadState.getNativeWrapper();
        if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (nativeWrapper == null ? 1 : 0) != 0)) {
            nativeWrapper = new PThreadState(threadState);
            threadState.setNativeWrapper(nativeWrapper);
        }
        return nativeWrapper.replacement;
    }

    public static Object getNativeThreadState(PythonContext.PythonThreadState threadState) {
        PThreadState nativeWrapper = threadState.getNativeWrapper();
        if (nativeWrapper != null) {
            return nativeWrapper.replacement;
        }
        return null;
    }

    public PythonContext.PythonThreadState getThreadState() {
        return (PythonContext.PythonThreadState)this.getDelegate();
    }

    @CompilerDirectives.TruffleBoundary
    private static Object allocateCLayout(PythonContext.PythonThreadState threadState) {
        CApiTransitions.PythonToNativeNode toNative = CApiTransitionsFactory.PythonToNativeNodeGen.getUncached();
        Object ptr = CStructAccess.AllocateNode.allocUncached(CStructs.PyThreadState);
        CStructAccess.WritePointerNode writePtrNode = CStructAccessFactory.WritePointerNodeGen.getUncached();
        PythonContext pythonContext = PythonContext.get(null);
        PDict threadStateDict = threadState.getDict();
        if (threadStateDict == null) {
            threadStateDict = pythonContext.factory().createDict();
            threadState.setDict(threadStateDict);
        }
        writePtrNode.write(ptr, CFields.PyThreadState__dict, toNative.execute(threadStateDict));
        CApiContext cApiContext = PythonContext.get(null).getCApiContext();
        writePtrNode.write(ptr, CFields.PyThreadState__small_ints, cApiContext.getOrCreateSmallInts());
        if (threadState.getCurrentException() != null) {
            Object exceptionType = GetClassNode.executeUncached(threadState.getCurrentException().getUnreifiedException());
            CStructAccess.WritePointerNode.getUncached().write(ptr, CFields.PyThreadState__curexc_type, CApiTransitions.PythonToNativeNode.getUncached().execute(exceptionType));
        }
        return ptr;
    }
}

