/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.capi.transitions;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.PythonAbstractObject;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiContext;
import com.oracle.graal.python.builtins.objects.cext.capi.CApiGuards;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PThreadState;
import com.oracle.graal.python.builtins.objects.cext.capi.PrimitiveNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.TruffleObjectNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetNativeWrapperNode;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.GetReplacementNode;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.NativeObjectReferenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToJavaNode;
import com.oracle.graal.python.builtins.objects.cext.common.CExtToNativeNode;
import com.oracle.graal.python.builtins.objects.cext.common.HandleStack;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.floats.PFloat;
import com.oracle.graal.python.builtins.objects.getsetdescriptor.DescriptorDeleteMarker;
import com.oracle.graal.python.builtins.objects.traceback.LazyTraceback;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.NativeSequenceStorage;
import com.oracle.graal.python.runtime.sequence.storage.SequenceStorage;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import sun.misc.Unsafe;

public abstract class CApiTransitions {
    private static final int GCALot = Integer.getInteger("python.GCALot", 0);
    private static final int GCALotWait = Integer.getInteger("python.GCALotWait", 0);
    private static long GCALotTotalCounter = 0L;
    private static int GCALotCounter = 0;
    private static final TruffleLogger LOGGER = CApiContext.getLogger(CApiTransitions.class);
    private static final Unsafe UNSAFE = PythonUtils.initUnsafe();
    private static final int TP_REFCNT_OFFSET = 0;

    private CApiTransitions() {
    }

    private static HandleContext getContext() {
        return PythonContext.get(null).nativeContext;
    }

    @CompilerDirectives.TruffleBoundary
    public static void registerNativeSequenceStorage(NativeSequenceStorage storage) {
        assert (PythonContext.get(null).ownsGil());
        HandleContext handleContext = CApiTransitions.getContext();
        NativeStorageReference ref = new NativeStorageReference(handleContext, storage);
        storage.setReference(ref);
        handleContext.nativeStorageReferences.add(ref);
    }

    @CompilerDirectives.TruffleBoundary
    public static PyCapsuleReference registerPyCapsuleDestructor(PyCapsule capsule) {
        assert (PythonContext.get(null).ownsGil());
        HandleContext handleContext = CApiTransitions.getContext();
        PyCapsuleReference ref = new PyCapsuleReference(handleContext, capsule);
        handleContext.pyCapsuleReferences.add(ref);
        return ref;
    }

    @CompilerDirectives.TruffleBoundary
    public static void pollReferenceQueue() {
        PythonContext context = PythonContext.get(null);
        HandleContext handleContext = context.nativeContext;
        if (!handleContext.referenceQueuePollActive) {
            try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
                ReferenceQueue<Object> queue = handleContext.referenceQueue;
                int count = 0;
                long start = 0L;
                NativeObjectReferenceArrayWrapper referencesToBeFreed = handleContext.referencesToBeFreed;
                PythonContext.PythonThreadState threadState = context.getThreadState(context.getLanguage());
                PException savedException = null;
                LazyTraceback savedTraceback = null;
                Object savedNativeException = null;
                if (threadState.getCurrentException() != null) {
                    savedException = threadState.getCurrentException();
                    savedTraceback = threadState.getCurrentTraceback();
                    threadState.clearCurrentException();
                    Object nativeThreadState = PThreadState.getNativeThreadState(threadState);
                    if (nativeThreadState != null) {
                        savedNativeException = CStructAccess.ReadPointerNode.readUncached(nativeThreadState, CFields.PyThreadState__curexc_type);
                        CStructAccess.WritePointerNode.writeUncached(nativeThreadState, CFields.PyThreadState__curexc_type, (Object)0L);
                    }
                }
                try {
                    while (true) {
                        Reference<Object> entry;
                        if ((entry = queue.poll()) == null) {
                            if (count > 0) {
                                assert (handleContext.referenceQueuePollActive);
                                CApiTransitions.releaseNativeObjects(referencesToBeFreed);
                                handleContext.referenceQueuePollActive = false;
                                LOGGER.fine("collected " + count + " references from native reference queue in " + (System.nanoTime() - start) / 1000000L + "ms");
                            }
                            return;
                        }
                        if (count == 0) {
                            assert (!handleContext.referenceQueuePollActive);
                            handleContext.referenceQueuePollActive = true;
                            start = System.nanoTime();
                        } else assert (handleContext.referenceQueuePollActive);
                        ++count;
                        if (entry instanceof PythonObjectReference) {
                            PythonObjectReference reference = (PythonObjectReference)entry;
                            LOGGER.fine(() -> PythonUtils.formatJString("releasing %s", reference.toString()));
                            if (HandlePointerConverter.pointsToPyHandleSpace(reference.pointer)) {
                                assert (CApiTransitions.nativeStubLookupGet(handleContext, reference.pointer, reference.handleTableIndex) != null) : Long.toHexString(reference.pointer);
                                CApiTransitions.nativeStubLookupRemove(handleContext, reference);
                                long stubPointer = HandlePointerConverter.pointerToStub(reference.pointer);
                                if (CApiTransitions.subNativeRefCount(stubPointer, 10L) == 0L) {
                                    CApiTransitions.freeNativeStub(stubPointer);
                                    continue;
                                }
                                CStructAccess.WriteIntNode.writeUncached(reference.pointer, CFields.GraalPyObject__handle_table_index, 0);
                                continue;
                            }
                            assert (CApiTransitions.nativeLookupGet(handleContext, reference.pointer) != null) : Long.toHexString(reference.pointer);
                            CApiTransitions.nativeLookupRemove(handleContext, reference.pointer);
                            if (!reference.freeAtCollection) continue;
                            CApiTransitions.freeNativeStruct(reference);
                            continue;
                        }
                        if (entry instanceof NativeObjectReference) {
                            NativeObjectReference reference = (NativeObjectReference)entry;
                            CApiTransitions.nativeLookupRemove(handleContext, reference.pointer);
                            CApiTransitions.processNativeObjectReference(reference, referencesToBeFreed);
                            continue;
                        }
                        if (entry instanceof NativeStorageReference) {
                            NativeStorageReference reference = (NativeStorageReference)entry;
                            handleContext.nativeStorageReferences.remove(reference);
                            CApiTransitions.processNativeStorageReference(reference);
                            continue;
                        }
                        if (!(entry instanceof PyCapsuleReference)) continue;
                        PyCapsuleReference reference = (PyCapsuleReference)entry;
                        handleContext.pyCapsuleReferences.remove(reference);
                        CApiTransitions.processPyCapsuleReference(reference);
                    }
                }
                finally {
                    if (savedException != null) {
                        threadState.setCurrentException(savedException, savedTraceback);
                        Object nativeThreadState = PThreadState.getNativeThreadState(threadState);
                        if (nativeThreadState != null) {
                            CStructAccess.WritePointerNode.writeUncached(nativeThreadState, CFields.PyThreadState__curexc_type, savedNativeException);
                        }
                    }
                }
            }
        }
    }

    private static void processNativeObjectReference(NativeObjectReference reference, NativeObjectReferenceArrayWrapper referencesToBeFreed) {
        LOGGER.fine(() -> PythonUtils.formatJString("releasing %s", reference.toString()));
        if (CApiTransitions.subNativeRefCount(reference.pointer, 10L) == 0L) {
            referencesToBeFreed.add(reference.pointer);
        }
    }

    private static void processNativeStorageReference(NativeStorageReference reference) {
        if (reference.type == SequenceStorage.StorageType.Generic) {
            CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_OBJECT_ARRAY_RELEASE, reference.ptr, reference.size);
        }
        CApiTransitions.freeNativeStorage(reference);
    }

    private static void processPyCapsuleReference(PyCapsuleReference reference) {
        LOGGER.fine(() -> PythonUtils.formatJString("releasing %s", reference.toString()));
        if (reference.data.getDestructor() != null) {
            PyCapsule capsule = PythonObjectFactory.getUncached().createCapsule(reference.data);
            CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PY_TRUFFLE_CAPSULE_CALL_DESTRUCTOR, PythonToNativeNode.executeUncached(capsule), capsule.getDestructor());
        }
    }

    private static void releaseNativeObjects(NativeObjectReferenceArrayWrapper referencesToBeFreed) {
        if (!referencesToBeFreed.isEmpty()) {
            assert (PythonContext.get(null).ownsGil());
            LOGGER.fine(() -> PythonUtils.formatJString("releasing %d NativeObjectReference instances", referencesToBeFreed.getArraySize()));
            Object array = CStructAccess.AllocateNode.allocUncached(referencesToBeFreed.getArraySize() * 8L);
            CStructAccess.WriteLongNode.getUncached().writeLongArray(array, referencesToBeFreed.getArray(), (int)referencesToBeFreed.getArraySize(), 0, 0L);
            CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_BULK_DEALLOC, array, referencesToBeFreed.getArraySize());
            CStructAccess.FreeNode.executeUncached(array);
            referencesToBeFreed.reset();
        }
    }

    public static void freeClassReplacements(HandleContext handleContext) {
        assert (PythonContext.get(null).ownsGil());
        handleContext.nativeLookup.forEach((l, ref) -> {
            if (ref instanceof PythonObjectReference) {
                PythonObjectReference reference = (PythonObjectReference)ref;
                assert (reference.handleTableIndex == -1);
                if (reference.freeAtCollection) {
                    CApiTransitions.freeNativeStruct(reference);
                }
            }
        });
        handleContext.nativeLookup.clear();
    }

    public static void disableReferenceQueuePolling(HandleContext handleContext) {
        handleContext.referenceQueuePollActive = true;
    }

    private static void freeNativeStub(long stubPointer) {
        LOGGER.fine(() -> PythonUtils.formatJString("releasing native object stub 0x%x", stubPointer));
        CStructAccess.FreeNode.executeUncached(stubPointer);
    }

    private static void freeNativeStub(PythonObjectReference ref) {
        assert (HandlePointerConverter.pointsToPyHandleSpace(ref.pointer));
        CApiTransitions.freeNativeStub(HandlePointerConverter.pointerToStub(ref.pointer));
    }

    private static void freeNativeStruct(PythonObjectReference ref) {
        assert (ref.handleTableIndex == -1);
        assert (ref.freeAtCollection);
        LOGGER.fine(() -> PythonUtils.formatJString("releasing %s", ref.toString()));
        CStructAccess.FreeNode.executeUncached(ref.pointer);
    }

    private static void freeNativeStorage(NativeStorageReference ref) {
        LOGGER.fine(() -> PythonUtils.formatJString("releasing %s", ref.toString()));
        CStructAccess.FreeNode.executeUncached(ref.ptr);
    }

    public static void freeNativeObjectStubs(HandleContext handleContext) {
        assert (PythonContext.get(null).ownsGil());
        assert (PythonContext.get(null).isFinalizing());
        for (PythonObjectReference ref : handleContext.nativeStubLookup) {
            if (ref == null) continue;
            CApiTransitions.nativeStubLookupRemove(handleContext, ref);
            CApiTransitions.freeNativeStub(ref);
        }
    }

    public static void freeNativeStorages(HandleContext handleContext) {
        assert (PythonContext.get(null).ownsGil());
        assert (PythonContext.get(null).isFinalizing());
        handleContext.nativeStorageReferences.forEach(CApiTransitions::freeNativeStorage);
        handleContext.nativeStorageReferences.clear();
    }

    @CompilerDirectives.TruffleBoundary
    public static void addNativeWeakRef(PythonContext pythonContext, PythonAbstractNativeObject object) {
        pythonContext.nativeContext.nativeWeakRef.put(CApiTransitions.getNativePointer(object), 0L);
    }

    @CompilerDirectives.TruffleBoundary
    public static void removeNativeWeakRef(PythonContext pythonContext, long pointer) {
        pythonContext.nativeContext.nativeWeakRef.remove(pointer);
    }

    public static long getNativePointer(Object obj) {
        if (obj instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject object = (PythonAbstractNativeObject)obj;
            return object.ref.pointer;
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deallocateNativeWeakRefs(PythonContext pythonContext) {
        CompilerAsserts.neverPartOfCompilation();
        assert (pythonContext.ownsGil());
        HandleContext context = pythonContext.nativeContext;
        int idx = -1;
        Object[] list = context.nativeWeakRef.values().toArray();
        context.nativeWeakRef.clear();
        long[] ptrArray = new long[list.length];
        for (Object ptr : list) {
            if (!context.nativeLookup.containsKey(ptr)) continue;
            ptrArray[++idx] = (Long)ptr;
        }
        if (idx != -1) {
            int len = idx + 1;
            Object array = CStructAccess.AllocateNode.allocUncached((long)len * 8L);
            try {
                CStructAccess.WritePointerNode.getUncached().writePointerArray(array, ptrArray, len, 0, 0L);
                CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_SHUTDOWN_BULK_DEALLOC, array, len);
            }
            finally {
                CStructAccess.FreeNode.executeUncached(array);
                context.nativeWeakRef.clear();
            }
        }
        assert (context.nativeWeakRef.isEmpty());
    }

    public static void maybeGCALot() {
        if (GCALot != 0) {
            CApiTransitions.maybeGC();
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void maybeGC() {
        if (++GCALotTotalCounter >= (long)GCALotWait && ++GCALotCounter >= GCALot) {
            LOGGER.info("GC A Lot - calling System.gc (opportunities=" + GCALotTotalCounter + ")");
            GCALotCounter = 0;
            PythonUtils.forceFullGC();
            CApiTransitions.pollReferenceQueue();
        }
    }

    @CompilerDirectives.TruffleBoundary
    public static Object lookupNative(long pointer) {
        CApiTransitions.log(pointer);
        IdReference<?> reference = CApiTransitions.nativeLookupGet(CApiTransitions.getContext(), pointer);
        if (reference != null) {
            return CApiTransitions.logResultBoundary(reference.get());
        }
        return CApiTransitions.logResult(null);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupGet(HandleContext context, long pointer) {
        return context.nativeLookup.get(pointer);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupPut(HandleContext context, long pointer, NativeObjectReference value) {
        return context.nativeLookup.put(pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupPut(HandleContext context, long pointer, PythonObjectReference value) {
        return context.nativeLookup.put(pointer, value);
    }

    @CompilerDirectives.TruffleBoundary
    public static IdReference<?> nativeLookupRemove(HandleContext context, long pointer) {
        return context.nativeLookup.remove(pointer);
    }

    public static PythonObjectReference nativeStubLookupGet(HandleContext context, long pointer, int idx) {
        if (idx <= 0) {
            if (PythonContext.DEBUG_CAPI && HandleContext.getShadowTable(context.nativeStubLookupShadowTable, pointer) != null) {
                throw CompilerDirectives.shouldNotReachHere();
            }
            return null;
        }
        PythonObjectReference result = context.nativeStubLookup[idx];
        if (PythonContext.DEBUG_CAPI && HandleContext.getShadowTable(context.nativeStubLookupShadowTable, pointer) != result) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return result;
    }

    private static int nativeStubLookupReserve(HandleContext context) throws OverflowException {
        int idx = context.nativeStubLookupFreeStack.pop();
        if (idx == -1) {
            idx = CApiTransitions.resizeNativeStubLookupTable(context);
        }
        assert (context.nativeStubLookup[idx] == null);
        return idx;
    }

    @CompilerDirectives.TruffleBoundary
    private static int resizeNativeStubLookupTable(HandleContext context) throws OverflowException {
        int newSize;
        int oldSize = context.nativeStubLookup.length;
        int n = newSize = oldSize >= 262144 ? PythonUtils.addExact(oldSize, 262144) : PythonUtils.multiplyExact(oldSize, 2);
        assert (newSize != oldSize);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(String.format("Resizing native stub lookup table: %d -> %d", oldSize, newSize));
        }
        context.nativeStubLookup = Arrays.copyOf(context.nativeStubLookup, newSize);
        context.nativeStubLookupFreeStack.pushRange(oldSize, newSize);
        return context.nativeStubLookupFreeStack.pop();
    }

    private static int nativeStubLookupPut(HandleContext context, PythonObjectReference value) {
        PythonObjectReference prev;
        assert (value.handleTableIndex > 0);
        int idx = value.handleTableIndex;
        assert (context.nativeStubLookup[idx] == null || context.nativeStubLookup[idx] == value);
        context.nativeStubLookup[idx] = value;
        if (PythonContext.DEBUG_CAPI && (prev = HandleContext.putShadowTable(context.nativeStubLookupShadowTable, value.pointer, value)) != null && prev != value) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return idx;
    }

    public static PythonObjectReference nativeStubLookupRemove(HandleContext context, PythonObjectReference ref) {
        assert (ref.handleTableIndex > 0);
        int idx = ref.handleTableIndex;
        PythonObjectReference result = context.nativeStubLookup[idx];
        context.nativeStubLookup[idx] = null;
        context.nativeStubLookupFreeStack.push(idx);
        if (PythonContext.DEBUG_CAPI && HandleContext.removeShadowTable(context.nativeStubLookupShadowTable, ref.pointer) != result) {
            throw CompilerDirectives.shouldNotReachHere();
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static void createReference(PythonNativeWrapper obj, long ptr, boolean freeAtCollection) {
        try (GilNode.UncachedAcquire ignored = GilNode.uncachedAcquire();){
            if (!obj.isNative()) {
                CApiTransitions.logVoid(obj, ptr);
                obj.setNativePointer(ptr);
                CApiTransitions.pollReferenceQueue();
                HandleContext context = CApiTransitions.getContext();
                CApiTransitions.nativeLookupPut(context, ptr, PythonObjectReference.create(context, obj, ptr, freeAtCollection));
            }
        }
    }

    public static void createManagedReference(Object delegate, Object pointer) {
        assert (PythonContext.get(null).ownsGil());
        CApiTransitions.getContext().managedNativeLookup.put(pointer, new WeakReference<Object>(delegate));
    }

    private static void log(Object ... args) {
        if (LOGGER.isLoggable(Level.FINER)) {
            CApiTransitions.logBoundary(args);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static void logBoundary(Object ... args) {
        if (LOGGER.isLoggable(Level.FINER)) {
            CompilerAsserts.neverPartOfCompilation();
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            StringBuilder str = new StringBuilder();
            String className = element.getClassName();
            if (className.contains(".")) {
                className = className.substring(className.lastIndexOf(46) + 1);
            }
            str.append(className).append(".").append(element.getMethodName()).append(": ");
            for (int i = 0; i < args.length; ++i) {
                Object a = args[i];
                str.append(i == 0 ? "" : ", ");
                CApiTransitions.format(str, a);
            }
            LOGGER.finer(str.toString());
        }
    }

    private static void logVoid(Object ... args) {
        CApiTransitions.log(args);
    }

    private static void format(StringBuilder str, Object a) {
        if (a instanceof Long) {
            str.append(String.format("0x%x", (long)((Long)a)));
        } else if (a instanceof Integer) {
            str.append(String.format("0x%x", (int)((Integer)a)));
        } else {
            str.append(a);
        }
    }

    @CompilerDirectives.TruffleBoundary
    private static <T> T logResultBoundary(T value) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            CompilerAsserts.neverPartOfCompilation();
            StackTraceElement element = new RuntimeException().getStackTrace()[1];
            StringBuilder str = new StringBuilder("    ==> <").append(element.getLineNumber()).append("> ");
            CApiTransitions.format(str, value);
            LOGGER.finest(str.toString());
        }
        return value;
    }

    private static <T> T logResult(T value) {
        if (LOGGER.isLoggable(Level.FINEST)) {
            CApiTransitions.logResultBoundary(value);
        }
        return value;
    }

    private static long addNativeRefCount(long pointer, long refCntDelta) {
        return CApiTransitions.addNativeRefCount(pointer, refCntDelta, false);
    }

    private static long addNativeRefCount(long pointer, long refCntDelta, boolean ignoreIfDead) {
        assert (PythonContext.get(null).isNativeAccessAllowed());
        long refCount = UNSAFE.getLong(pointer + 0L);
        if (ignoreIfDead && refCount == 0L) {
            return 0L;
        }
        assert ((refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        assert (refCount + refCntDelta > 0L) : String.format("refcnt reached zero during managed adjustment for %016x (%d %016x + %d)\n", pointer, refCount, refCount, refCntDelta);
        LOGGER.finest(() -> PythonUtils.formatJString("addNativeRefCount %x %x %d + %d", pointer, refCount, refCount, refCntDelta));
        UNSAFE.putLong(pointer + 0L, refCount + refCntDelta);
        return refCount + refCntDelta;
    }

    private static long subNativeRefCount(long pointer, long refCntDelta) {
        assert (PythonContext.get(null).isNativeAccessAllowed());
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert ((refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value during managed adjustment for %016x (%d %016x - %d)\n", pointer, refCount, refCount, refCntDelta);
        assert (refCount - refCntDelta >= 0L) : String.format("refcnt below zero during managed adjustment for %016x (%d %016x - %d)\n", pointer, refCount, refCount, refCntDelta);
        LOGGER.finest(() -> PythonUtils.formatJString("subNativeRefCount %x %x %d + %d", pointer, refCount, refCount, refCntDelta));
        UNSAFE.putLong(pointer + 0L, refCount - refCntDelta);
        return refCount - refCntDelta;
    }

    public static long readNativeRefCount(long pointer) {
        assert (PythonContext.get(null).isNativeAccessAllowed());
        long refCount = UNSAFE.getLong(pointer + 0L);
        assert (refCount == 0x3FFFFFFFFFFFFFFFL || (refCount & 0xFFFFFFFF00000000L) == 0L) : String.format("suspicious refcnt value for %016x (%d %016x)\n", pointer, refCount, refCount);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(PythonUtils.formatJString("readNativeRefCount(%x) = %d (%x)", pointer, refCount, refCount));
        }
        return refCount;
    }

    public static void writeNativeRefCount(long pointer, long newValue) {
        assert (newValue > 0L) : PythonUtils.formatJString("refcnt value to write below zero for %016x (%d %016x)\n", pointer, newValue, newValue);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest(PythonUtils.formatJString("writeNativeRefCount(%x, %d (%x))", pointer, newValue, newValue));
        }
        UNSAFE.putLong(pointer + 0L, newValue);
    }

    private static Object createAbstractNativeObject(HandleContext handleContext, Object obj, boolean transfer, long pointer) {
        assert (CApiTransitions.isBackendPointerObject(obj)) : obj.getClass();
        CApiTransitions.pollReferenceQueue();
        PythonAbstractNativeObject result = new PythonAbstractNativeObject(obj);
        long refCntDelta = 10L - (long)(transfer ? 1 : 0);
        long refCount = CApiTransitions.addNativeRefCount(pointer, refCntDelta, true);
        if (refCount > 0L) {
            NativeObjectReference ref = new NativeObjectReference(handleContext, result, pointer);
            CApiTransitions.nativeLookupPut(CApiTransitions.getContext(), pointer, ref);
        } else if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine(PythonUtils.formatJString("createAbstractNativeObject: creating PythonAbstractNativeObject for a dying object (refcount 0): 0x%x", pointer));
        }
        return result;
    }

    @CompilerDirectives.TruffleBoundary
    public static boolean isBackendPointerObject(Object obj) {
        return obj != null && (obj.getClass().toString().contains("LLVMPointerImpl") || obj.getClass().toString().contains("NFIPointer") || obj.getClass().toString().contains("NativePointer"));
    }

    public static final class HandleContext {
        private static final int DEFAULT_CAPACITY = 16;
        private static final int LINEAR_THRESHOLD = 262144;
        public final NativeObjectReferenceArrayWrapper referencesToBeFreed = new NativeObjectReferenceArrayWrapper();
        public final HashMap<Long, IdReference<?>> nativeLookup = new HashMap();
        public final ConcurrentHashMap<Long, Long> nativeWeakRef = new ConcurrentHashMap();
        public final WeakHashMap<Object, WeakReference<Object>> managedNativeLookup = new WeakHashMap();
        private final HashMap<Long, PythonObjectReference> nativeStubLookupShadowTable;
        public PythonObjectReference[] nativeStubLookup;
        public final HandleStack nativeStubLookupFreeStack;
        public final Set<NativeStorageReference> nativeStorageReferences = new HashSet<NativeStorageReference>();
        public final Set<PyCapsuleReference> pyCapsuleReferences = new HashSet<PyCapsuleReference>();
        public final ReferenceQueue<Object> referenceQueue = new ReferenceQueue();
        volatile boolean referenceQueuePollActive = false;

        public HandleContext(boolean useShadowTable) {
            this.nativeStubLookupShadowTable = useShadowTable ? new HashMap() : null;
            this.nativeStubLookup = new PythonObjectReference[16];
            this.nativeStubLookupFreeStack = new HandleStack(16);
            this.nativeStubLookupFreeStack.pushRange(1, 16);
        }

        @CompilerDirectives.TruffleBoundary
        static <T> T putShadowTable(HashMap<Long, T> table, long pointer, T ref) {
            return table.put(pointer, ref);
        }

        @CompilerDirectives.TruffleBoundary
        static <T> T removeShadowTable(HashMap<Long, T> table, long pointer) {
            return table.remove(pointer);
        }

        @CompilerDirectives.TruffleBoundary
        static <T> T getShadowTable(HashMap<Long, T> table, long pointer) {
            return table.get(pointer);
        }
    }

    public static final class NativeStorageReference
    extends IdReference<NativeSequenceStorage> {
        private final SequenceStorage.StorageType type;
        private Object ptr;
        private int size;

        public NativeStorageReference(HandleContext handleContext, NativeSequenceStorage storage) {
            super(handleContext, storage);
            this.type = storage.getElementType();
            this.ptr = storage.getPtr();
            this.size = storage.length();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(PythonUtils.formatJString("new %s", this.toString()));
            }
        }

        public Object getPtr() {
            return this.ptr;
        }

        public void setPtr(Object ptr) {
            this.ptr = ptr;
        }

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            Object ptrStr;
            try {
                ptrStr = Long.toHexString(InteropLibrary.getUncached().asPointer(this.ptr));
            }
            catch (UnsupportedMessageException e) {
                ptrStr = this.ptr;
            }
            return String.format("NativeStorageReference<0x%s, %d>", ptrStr, this.size);
        }
    }

    public static final class PyCapsuleReference
    extends IdReference<PyCapsule> {
        private final PyCapsule.CapsuleData data;

        public PyCapsuleReference(HandleContext handleContext, PyCapsule capsule) {
            super(handleContext, capsule);
            this.data = capsule.getData();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(PythonUtils.formatJString("new %s", this.toString()));
            }
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            return String.format("PyCapsuleReference<%s>", this.data);
        }
    }

    public static final class PythonObjectReference
    extends IdReference<PythonNativeWrapper> {
        private PythonNativeWrapper strongReference;
        private final long pointer;
        private final int handleTableIndex;
        private final boolean freeAtCollection;

        private PythonObjectReference(HandleContext handleContext, PythonNativeWrapper referent, boolean strong, long pointer, int handleTableIndex, boolean freeAtCollection) {
            super(handleContext, referent);
            this.pointer = pointer;
            this.strongReference = strong ? referent : null;
            referent.ref = this;
            this.handleTableIndex = handleTableIndex;
            this.freeAtCollection = freeAtCollection;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(PythonUtils.formatJString("new %s", this.toString()));
            }
        }

        static PythonObjectReference create(HandleContext handleContext, PythonNativeWrapper.PythonAbstractObjectNativeWrapper referent, boolean strong, long pointer, int idx) {
            assert (HandlePointerConverter.pointsToPyHandleSpace(pointer));
            return new PythonObjectReference(handleContext, referent, strong, pointer, idx, true);
        }

        static PythonObjectReference create(HandleContext handleContext, PythonNativeWrapper referent, long pointer, boolean freeAtCollection) {
            return new PythonObjectReference(handleContext, referent, true, pointer, -1, freeAtCollection);
        }

        public boolean isStrongReference() {
            return this.strongReference != null;
        }

        public void setStrongReference(PythonNativeWrapper wrapper) {
            this.strongReference = wrapper;
        }

        public int getHandleTableIndex() {
            return this.handleTableIndex;
        }

        public boolean isFreeAtCollection() {
            return this.freeAtCollection;
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            String type = this.strongReference != null ? "strong" : "weak";
            PythonNativeWrapper referent = (PythonNativeWrapper)this.get();
            return String.format("PythonObjectReference<0x%x,%s,%s,id=%d>", this.pointer, type, referent != null ? referent : "freed", this.handleTableIndex);
        }
    }

    public static final class HandlePointerConverter {
        private static final long HANDLE_BASE = Long.MIN_VALUE;
        private static final int POINTER_ALIGNMENT_SHIFT = 3;
        private static final long POINTER_ALIGNMENT_MASK = 7L;

        public static long stubToPointer(long stubPointer) {
            assert ((stubPointer & 7L) == 0L);
            return stubPointer | Long.MIN_VALUE;
        }

        public static long pointerToStub(long pointer) {
            assert ((pointer & Long.MAX_VALUE & 7L) == 0L);
            return pointer & Long.MAX_VALUE;
        }

        public static boolean pointsToPyHandleSpace(long pointer) {
            return (pointer & Long.MIN_VALUE) != 0L;
        }
    }

    public static abstract class IdReference<T>
    extends WeakReference<T> {
        public IdReference(HandleContext handleContext, T referent) {
            super(referent, handleContext.referenceQueue);
        }
    }

    public static final class NativeObjectReference
    extends IdReference<PythonAbstractNativeObject> {
        final Object object;
        final long pointer;

        public NativeObjectReference(HandleContext handleContext, PythonAbstractNativeObject referent, long pointer) {
            super(handleContext, referent);
            this.object = referent.object;
            this.pointer = pointer;
            referent.ref = this;
            assert ((pointer & 7L) == 0L);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine(PythonUtils.formatJString("new %s", this.toString()));
            }
        }

        @CompilerDirectives.TruffleBoundary
        public String toString() {
            PythonAbstractNativeObject referent = (PythonAbstractNativeObject)this.get();
            return String.format("NativeObjectReference<0x%x,%s>", this.pointer, referent != null ? referent : "freed");
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class, PGuards.class})
    public static abstract class PythonToNativeNode
    extends CExtToNativeNode {
        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNodeGen.getUncached().execute(obj);
        }

        protected boolean needsTransfer() {
            return false;
        }

        @Specialization
        Object doNative(PythonAbstractNativeObject obj, @CachedLibrary(limit="2") InteropLibrary lib) {
            if (this.needsTransfer() && this.getContext().isNativeAccessAllowed()) {
                long ptr = PythonUtils.coerceToLong(obj.getPtr(), lib);
                CApiTransitions.addNativeRefCount(ptr, 1L);
            }
            return obj.getPtr();
        }

        @Specialization
        static Object doNativePointer(NativePointer obj) {
            return obj;
        }

        @Specialization(guards={"mapsToNull(obj)"})
        Object doNoValue(Object obj) {
            return this.getContext().getNativeNull();
        }

        static boolean mapsToNull(Object object) {
            return PGuards.isNoValue(object) || object instanceof DescriptorDeleteMarker;
        }

        static boolean isOther(Object obj) {
            return !(obj instanceof PythonAbstractNativeObject) && !(obj instanceof NativePointer) && !PythonToNativeNode.mapsToNull(obj);
        }

        @Specialization(guards={"isOther(obj)"})
        static Object doOther(Object obj, @Bind(value="needsTransfer()") boolean needsTransfer, @Bind(value="this") Node inliningTarget, @Cached GetNativeWrapperNode getWrapper, @Cached GetReplacementNode getReplacementNode, @Cached InlinedConditionProfile isStrongProfile, @CachedLibrary(limit="3") InteropLibrary lib) {
            CompilerAsserts.partialEvaluationConstant((boolean)needsTransfer);
            CApiTransitions.pollReferenceQueue();
            PythonNativeWrapper wrapper = getWrapper.execute(obj);
            Object replacement = getReplacementNode.execute(inliningTarget, wrapper);
            if (replacement != null) {
                return replacement;
            }
            assert (PythonContext.get(inliningTarget).isNativeAccessAllowed());
            assert (obj != PNone.NO_VALUE);
            if (!lib.isPointer((Object)wrapper)) {
                lib.toNative((Object)wrapper);
            }
            if (needsTransfer && wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                objectNativeWrapper.incRef();
                assert (wrapper.ref != null);
                if (isStrongProfile.profile(inliningTarget, !objectNativeWrapper.ref.isStrongReference())) {
                    objectNativeWrapper.ref.setStrongReference(objectNativeWrapper);
                }
            }
            assert (wrapper != null);
            return wrapper;
        }

        @NeverDefault
        public static PythonToNativeNode create() {
            return CApiTransitionsFactory.PythonToNativeNodeGen.create();
        }

        public static PythonToNativeNode getUncached() {
            return CApiTransitionsFactory.PythonToNativeNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class WrappedPointerToNativeNode
    extends CExtToNativeNode {
        @Specialization
        static Object doGeneric(Object object, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile isWrapperProfile, @Cached GetReplacementNode getReplacementNode) {
            Object replacement;
            if (isWrapperProfile.profile(inliningTarget, object instanceof PythonNativeWrapper) && (replacement = getReplacementNode.execute(inliningTarget, (PythonNativeWrapper)object)) != null) {
                return replacement;
            }
            return object;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class WrappedPointerToPythonNode
    extends CExtToJavaNode {
        @Specialization
        static Object doIt(Object object) {
            if (object instanceof PythonNativeWrapper) {
                return ((PythonNativeWrapper)object).getDelegate();
            }
            return object;
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class ToPythonWrapperNode
    extends CExtToJavaNode {
        public static PythonNativeWrapper executeUncached(Object obj, boolean strict) {
            return ToPythonWrapperNode.getUncached().executeWrapper(obj, strict);
        }

        @Override
        public final Object execute(Object object) {
            return this.executeWrapper(object, true);
        }

        public abstract PythonNativeWrapper executeWrapper(Object var1, boolean var2);

        @Specialization(guards={"!isNativeWrapper(obj)"}, limit="3")
        static PythonNativeWrapper doNonWrapper(Object obj, boolean strict, @Bind(value="this") Node inliningTarget, @Cached CStructAccess.ReadI32Node readI32Node, @CachedLibrary(value="obj") InteropLibrary interopLibrary, @Cached InlinedConditionProfile isNullProfile, @Cached InlinedConditionProfile isLongProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedExactClassProfile nativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile) {
            long pointer;
            if (isLongProfile.profile(inliningTarget, obj instanceof Long)) {
                pointer = (Long)obj;
            } else {
                if (!interopLibrary.isPointer(obj)) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("not a pointer: " + String.valueOf(obj)));
                }
                try {
                    pointer = interopLibrary.asPointer(obj);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
            }
            if (isNullProfile.profile(inliningTarget, pointer == 0L)) {
                return null;
            }
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                int idx = readI32Node.read(HandlePointerConverter.pointerToStub(pointer), CFields.GraalPyObject__handle_table_index);
                PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer, idx);
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                PythonNativeWrapper wrapper = (PythonNativeWrapper)reference.get();
                if (strict && wrapper == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
                }
                return wrapper;
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (isNativeProfile.profile(inliningTarget, lookup != null)) {
                Object ref = lookup.get();
                if (ref == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
                }
                Object profiled = nativeWrapperProfile.profile(inliningTarget, ref);
                if (profiled instanceof PythonNativeWrapper) {
                    PythonNativeWrapper nativeWrapper = (PythonNativeWrapper)profiled;
                    return nativeWrapper;
                }
            }
            return null;
        }

        @Specialization
        static PythonNativeWrapper doWrapper(PythonNativeWrapper wrapper, boolean strict) {
            return wrapper;
        }

        @NeverDefault
        public static ToPythonWrapperNode create() {
            return CApiTransitionsFactory.ToPythonWrapperNodeGen.create();
        }

        public static ToPythonWrapperNode getUncached() {
            return CApiTransitionsFactory.ToPythonWrapperNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class NativePtrToPythonNode
    extends PNodeWithContext {
        public abstract Object execute(long var1, boolean var3);

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(long object, boolean stealing) {
            return CApiTransitionsFactory.NativePtrToPythonNodeGen.getUncached().execute(object, stealing);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization
        Object doNonWrapper(long pointer, boolean stealing, @Bind(value="$node") Node inliningTarget, @Cached CStructAccess.ReadI32Node readI32Node, @Cached InlinedConditionProfile isZeroProfile, @Cached InlinedConditionProfile createNativeProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile isNativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile, @Cached InlinedExactClassProfile wrapperProfile) {
            PythonNativeWrapper wrapper;
            CompilerAsserts.partialEvaluationConstant((boolean)stealing);
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            if (isZeroProfile.profile(inliningTarget, pointer == 0L)) {
                return PNone.NO_VALUE;
            }
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                int idx = readI32Node.read(HandlePointerConverter.pointerToStub(pointer), CFields.GraalPyObject__handle_table_index);
                PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer, idx);
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                wrapper = (PythonNativeWrapper)reference.get();
                if (wrapper != null) return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, stealing, wrapper);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (!isNativeProfile.profile(inliningTarget, lookup != null)) return CApiTransitions.createAbstractNativeObject(nativeContext, new NativePointer(pointer), stealing, pointer);
            Object ref = lookup.get();
            if (createNativeProfile.profile(inliningTarget, ref == null)) {
                LOGGER.fine(() -> "re-creating collected PythonAbstractNativeObject reference" + Long.toHexString(pointer));
                return CApiTransitions.createAbstractNativeObject(nativeContext, new NativePointer(pointer), stealing, pointer);
            }
            if (isNativeWrapperProfile.profile(inliningTarget, ref instanceof PythonNativeWrapper)) {
                wrapper = (PythonNativeWrapper)ref;
                return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, stealing, wrapper);
            } else {
                PythonAbstractNativeObject result = (PythonAbstractNativeObject)ref;
                if (!stealing) return result;
                CApiTransitions.addNativeRefCount(pointer, -1L);
                return result;
            }
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class NativeToPythonTransferNode
    extends NativeToPythonNode {
        @Specialization
        static Object dummy(Void dummy) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.NativeToPythonTransferNodeGen.getUncached().execute(obj);
        }

        @Override
        protected final boolean needsTransfer() {
            return true;
        }

        @NeverDefault
        public static NativeToPythonTransferNode create() {
            return CApiTransitionsFactory.NativeToPythonTransferNodeGen.create();
        }

        public static NativeToPythonTransferNode getUncached() {
            return CApiTransitionsFactory.NativeToPythonTransferNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class NativeToPythonNode
    extends CExtToJavaNode {
        public abstract Object execute(PythonNativeWrapper var1);

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.NativeToPythonNodeGen.getUncached().execute(obj);
        }

        protected boolean needsTransfer() {
            return false;
        }

        @Specialization
        static Object doWrapper(PythonNativeWrapper value, @Bind(value="$node") Node inliningTarget, @Cached.Exclusive @Cached InlinedExactClassProfile wrapperProfile) {
            return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, false, value);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Specialization(guards={"!isNativeWrapper(value)"}, limit="3")
        Object doNonWrapper(Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(value="value") InteropLibrary interopLibrary, @Cached CStructAccess.ReadI32Node readI32Node, @Cached InlinedConditionProfile isNullProfile, @Cached InlinedConditionProfile isZeroProfile, @Cached InlinedConditionProfile createNativeProfile, @Cached InlinedConditionProfile isNativeProfile, @Cached InlinedConditionProfile isNativeWrapperProfile, @Cached InlinedConditionProfile isHandleSpaceProfile, @Cached.Exclusive @Cached InlinedExactClassProfile wrapperProfile) {
            PythonNativeWrapper wrapper;
            long pointer;
            assert (!(value instanceof TruffleString));
            assert (!(value instanceof PythonAbstractObject));
            assert (!(value instanceof Number));
            if (isNullProfile.profile(inliningTarget, interopLibrary.isNull(value))) {
                return PNone.NO_VALUE;
            }
            PythonContext pythonContext = PythonContext.get(inliningTarget);
            HandleContext nativeContext = pythonContext.nativeContext;
            if (!interopLibrary.isPointer(value)) {
                return NativeToPythonNode.getManagedReference(value, nativeContext);
            }
            try {
                pointer = interopLibrary.asPointer(value);
            }
            catch (UnsupportedMessageException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
            if (isZeroProfile.profile(inliningTarget, pointer == 0L)) {
                return PNone.NO_VALUE;
            }
            assert (pythonContext.ownsGil());
            if (isHandleSpaceProfile.profile(inliningTarget, HandlePointerConverter.pointsToPyHandleSpace(pointer))) {
                int idx = readI32Node.read(HandlePointerConverter.pointerToStub(pointer), CFields.GraalPyObject__handle_table_index);
                PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer, idx);
                if (reference == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    throw CompilerDirectives.shouldNotReachHere((String)("reference was freed: " + Long.toHexString(pointer)));
                }
                wrapper = (PythonNativeWrapper)reference.get();
                if (wrapper != null) return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, this.needsTransfer(), wrapper);
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw CompilerDirectives.shouldNotReachHere((String)("reference was collected: " + Long.toHexString(pointer)));
            }
            IdReference<?> lookup = CApiTransitions.nativeLookupGet(nativeContext, pointer);
            if (!isNativeProfile.profile(inliningTarget, lookup != null)) return CApiTransitions.createAbstractNativeObject(nativeContext, value, this.needsTransfer(), pointer);
            Object ref = lookup.get();
            if (createNativeProfile.profile(inliningTarget, ref == null)) {
                if (!LOGGER.isLoggable(Level.FINE)) return CApiTransitions.createAbstractNativeObject(nativeContext, value, this.needsTransfer(), pointer);
                LOGGER.fine(() -> "re-creating collected PythonAbstractNativeObject reference" + Long.toHexString(pointer));
                return CApiTransitions.createAbstractNativeObject(nativeContext, value, this.needsTransfer(), pointer);
            }
            if (isNativeWrapperProfile.profile(inliningTarget, ref instanceof PythonNativeWrapper)) {
                wrapper = (PythonNativeWrapper)ref;
                return NativeToPythonNode.handleWrapper(inliningTarget, wrapperProfile, this.needsTransfer(), wrapper);
            } else {
                PythonAbstractNativeObject result = (PythonAbstractNativeObject)ref;
                if (!this.needsTransfer()) return result;
                CApiTransitions.addNativeRefCount(pointer, -1L);
                return result;
            }
        }

        static Object handleWrapper(Node node, InlinedExactClassProfile wrapperProfile, boolean transfer, PythonNativeWrapper wrapper) {
            PythonNativeWrapper profiledWrapper = (PythonNativeWrapper)wrapperProfile.profile(node, (Object)wrapper);
            if (transfer && profiledWrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)profiledWrapper;
                assert (objectNativeWrapper.getRefCount() > 10L);
                objectNativeWrapper.decRef();
            }
            if (profiledWrapper instanceof PrimitiveNativeWrapper) {
                PrimitiveNativeWrapper primitive = (PrimitiveNativeWrapper)profiledWrapper;
                if (primitive.isBool()) {
                    return primitive.getBool();
                }
                if (primitive.isInt()) {
                    return primitive.getInt();
                }
                if (primitive.isLong()) {
                    return primitive.getLong();
                }
                if (primitive.isDouble()) {
                    return primitive.getDouble();
                }
                throw CompilerDirectives.shouldNotReachHere();
            }
            return wrapper.getDelegate();
        }

        @CompilerDirectives.TruffleBoundary
        private static Object getManagedReference(Object value, HandleContext nativeContext) {
            assert (value.toString().startsWith("ManagedMemoryBlock"));
            assert (PythonContext.get(null).ownsGil());
            WeakReference ref = nativeContext.managedNativeLookup.computeIfAbsent(value, o -> new WeakReference<PythonAbstractNativeObject>(new PythonAbstractNativeObject(o)));
            Object result = ref.get();
            if (result == null) {
                result = new PythonAbstractNativeObject(value);
                nativeContext.managedNativeLookup.put(value, new WeakReference<PythonAbstractNativeObject>((PythonAbstractNativeObject)result));
            }
            return result;
        }

        @NeverDefault
        public static NativeToPythonNode create() {
            return CApiTransitionsFactory.NativeToPythonNodeGen.create();
        }

        public static NativeToPythonNode getUncached() {
            return CApiTransitionsFactory.NativeToPythonNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class PythonToNativeNewRefNode
    extends PythonToNativeNode {
        @Specialization
        static Object dummy(Void dummy) {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @CompilerDirectives.TruffleBoundary
        public static Object executeUncached(Object obj) {
            return CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached().execute(obj);
        }

        @Override
        protected final boolean needsTransfer() {
            return true;
        }

        @NeverDefault
        public static PythonToNativeNewRefNode create() {
            return CApiTransitionsFactory.PythonToNativeNewRefNodeGen.create();
        }

        public static PythonToNativeNewRefNode getUncached() {
            return CApiTransitionsFactory.PythonToNativeNewRefNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline(value=false)
    public static abstract class CharPtrToPythonNode
    extends CExtToJavaNode {
        @Specialization
        static Object doForeign(Object value, @Bind(value="this") Node inliningTarget, @CachedLibrary(limit="3") InteropLibrary interopLibrary, @Cached InlinedExactClassProfile classProfile, @Cached InlinedConditionProfile isNullProfile, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached ResolveHandleNode resolveHandleNode) {
            Object profiledValue = classProfile.profile(inliningTarget, value);
            if (isNullProfile.profile(inliningTarget, interopLibrary.isNull(profiledValue))) {
                return PNone.NO_VALUE;
            }
            CApiTransitions.log(profiledValue);
            assert (!(profiledValue instanceof Long));
            if (profiledValue instanceof String) {
                return CApiTransitions.logResult(PythonUtils.toTruffleStringUncached((String)profiledValue));
            }
            if (profiledValue instanceof TruffleString) {
                return CApiTransitions.logResult(profiledValue);
            }
            if (interopLibrary.isPointer(profiledValue)) {
                PythonNativeWrapper obj;
                long pointer;
                try {
                    pointer = interopLibrary.asPointer(profiledValue);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere((Throwable)e);
                }
                if (HandlePointerConverter.pointsToPyHandleSpace(pointer) && (obj = resolveHandleNode.execute(inliningTarget, pointer)) != null) {
                    return CApiTransitions.logResult(obj.getDelegate());
                }
            }
            return CApiTransitions.logResult(fromCharPointerNode.execute(profiledValue));
        }

        @NeverDefault
        public static CharPtrToPythonNode create() {
            return CApiTransitionsFactory.CharPtrToPythonNodeGen.create();
        }

        public static CharPtrToPythonNode getUncached() {
            return CApiTransitionsFactory.CharPtrToPythonNodeGen.getUncached();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class ResolveHandleNode
    extends Node {
        public abstract PythonNativeWrapper execute(Node var1, long var2);

        @Specialization
        static PythonNativeWrapper doGeneric(Node inliningTarget, long pointer, @Cached(inline=false) CStructAccess.ReadI32Node readI32Node, @Cached InlinedExactClassProfile profile) {
            HandleContext nativeContext = PythonContext.get((Node)inliningTarget).nativeContext;
            int idx = readI32Node.read(HandlePointerConverter.pointerToStub(pointer), CFields.GraalPyObject__handle_table_index);
            PythonObjectReference reference = CApiTransitions.nativeStubLookupGet(nativeContext, pointer, idx);
            PythonNativeWrapper wrapper = (PythonNativeWrapper)profile.profile(inliningTarget, (Object)((PythonNativeWrapper)reference.get()));
            assert (wrapper != null) : "reference was collected: " + Long.toHexString(pointer);
            if (wrapper instanceof PythonNativeWrapper.PythonAbstractObjectNativeWrapper) {
                PythonNativeWrapper.PythonAbstractObjectNativeWrapper objectNativeWrapper = (PythonNativeWrapper.PythonAbstractObjectNativeWrapper)wrapper;
                objectNativeWrapper.incRef();
            }
            return wrapper;
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    static abstract class AllocateNativeObjectStubNode
    extends Node {
        AllocateNativeObjectStubNode() {
        }

        abstract long execute(Node var1, PythonNativeWrapper.PythonAbstractObjectNativeWrapper var2, Object var3, CStructs var4, boolean var5);

        @Specialization
        static long doGeneric(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper, Object type, CStructs ctype, boolean immortal, @Cached(inline=false) GilNode gil, @Cached(inline=false) CStructAccess.AllocateNode allocateNode, @Cached(inline=false) CStructAccess.WriteLongNode writeLongNode, @Cached(inline=false) CStructAccess.WriteObjectNewRefNode writeObjectNode, @Cached(inline=false) CStructAccess.WriteIntNode writeIntNode, @Cached CExtCommonNodes.CoerceNativePointerToLongNode coerceToLongNode) {
            CApiTransitions.log(wrapper);
            CApiTransitions.pollReferenceQueue();
            long initialRefCount = immortal ? 0x3FFFFFFFFFFFFFFFL : 10L;
            Object nativeObjectStub = allocateNode.alloc(ctype);
            HandleContext handleContext = PythonContext.get((Node)inliningTarget).nativeContext;
            long stubPointer = coerceToLongNode.execute(inliningTarget, nativeObjectStub);
            long taggedPointer = HandlePointerConverter.stubToPointer(stubPointer);
            writeLongNode.write(stubPointer, CFields.PyObject__ob_refcnt, initialRefCount);
            writeObjectNode.write(stubPointer, CFields.PyObject__ob_type, type);
            boolean acquired = gil.acquire();
            try {
                int idx = CApiTransitions.nativeStubLookupReserve(handleContext);
                assert (idx > 0);
                writeIntNode.write(stubPointer, CFields.GraalPyObject__handle_table_index, idx);
                PythonObjectReference ref = PythonObjectReference.create(handleContext, wrapper, immortal, taggedPointer, idx);
                CApiTransitions.nativeStubLookupPut(handleContext, ref);
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.MemoryError);
            }
            finally {
                gil.release(acquired);
            }
            return CApiTransitions.logResult(taggedPointer);
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    @ImportStatic(value={CApiGuards.class})
    public static abstract class FirstToNativeNode
    extends Node {
        public static long executeUncached(PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper, boolean immortal) {
            return CApiTransitionsFactory.FirstToNativeNodeGen.getUncached().execute(null, wrapper, immortal);
        }

        public final long execute(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper) {
            return this.execute(inliningTarget, wrapper, false);
        }

        public abstract long execute(Node var1, PythonNativeWrapper.PythonAbstractObjectNativeWrapper var2, boolean var3);

        @Specialization
        static long doPrimitiveNativeWrapper(Node inliningTarget, PrimitiveNativeWrapper wrapper, boolean immortal, @Cached.Shared @Cached(inline=false) CStructAccess.WriteDoubleNode writeDoubleNode, @Cached.Shared @Cached InlinedConditionProfile isFloatObjectProfile, @Cached.Shared @Cached AllocateNativeObjectStubNode allocateNativeObjectStubNode) {
            PythonBuiltinClassType type;
            CStructs ctype;
            boolean isFloat = isFloatObjectProfile.profile(inliningTarget, wrapper.isDouble());
            CStructs cStructs = ctype = isFloat ? CStructs.GraalPyFloatObject : CStructs.GraalPyObject;
            if (wrapper.isBool()) {
                type = PythonBuiltinClassType.Boolean;
            } else if (wrapper.isIntLike()) {
                type = PythonBuiltinClassType.PInt;
            } else if (isFloat) {
                type = PythonBuiltinClassType.PFloat;
            } else {
                throw CompilerDirectives.shouldNotReachHere();
            }
            long taggedPointer = allocateNativeObjectStubNode.execute(inliningTarget, wrapper, (Object)type, ctype, immortal);
            if (isFloat) {
                long realPointer = HandlePointerConverter.pointerToStub(taggedPointer);
                writeDoubleNode.write(realPointer, CFields.GraalPyFloatObject__ob_fval, wrapper.getDouble());
            }
            return taggedPointer;
        }

        @Specialization(guards={"!isPrimitiveNativeWrapper(wrapper)"})
        static long doOther(Node inliningTarget, PythonNativeWrapper.PythonAbstractObjectNativeWrapper wrapper, boolean immortal, @Cached(inline=false) CStructAccess.WriteLongNode writeLongNode, @Cached(inline=false) CStructAccess.WritePointerNode writePointerNode, @Cached.Shared @Cached(inline=false) CStructAccess.WriteDoubleNode writeDoubleNode, @Cached.Exclusive @Cached InlinedConditionProfile isVarObjectProfile, @Cached.Shared @Cached InlinedConditionProfile isFloatObjectProfile, @Cached GetClassNode getClassNode, @Cached.Shared @Cached AllocateNativeObjectStubNode allocateNativeObjectStubNode) {
            assert (!(wrapper instanceof TruffleObjectNativeWrapper));
            assert (!(wrapper instanceof PrimitiveNativeWrapper));
            Object delegate = wrapper.getDelegate();
            Object type = getClassNode.execute(inliningTarget, delegate);
            CStructs ctype = isVarObjectProfile.profile(inliningTarget, delegate instanceof PTuple) ? CStructs.GraalPyVarObject : (isFloatObjectProfile.profile(inliningTarget, delegate instanceof Double || delegate instanceof PFloat) ? CStructs.GraalPyFloatObject : CStructs.GraalPyObject);
            long taggedPointer = allocateNativeObjectStubNode.execute(inliningTarget, wrapper, type, ctype, immortal);
            if (ctype == CStructs.GraalPyVarObject) {
                assert (delegate instanceof PTuple);
                SequenceStorage sequenceStorage = ((PTuple)delegate).getSequenceStorage();
                long realPointer = HandlePointerConverter.pointerToStub(taggedPointer);
                writeLongNode.write(realPointer, CFields.GraalPyVarObject__ob_size, sequenceStorage.length());
                Object obItemPtr = 0L;
                if (sequenceStorage instanceof NativeSequenceStorage) {
                    NativeSequenceStorage nativeSequenceStorage = (NativeSequenceStorage)sequenceStorage;
                    obItemPtr = nativeSequenceStorage.getPtr();
                }
                writePointerNode.write(realPointer, CFields.GraalPyVarObject__ob_item, obItemPtr);
            } else if (ctype == CStructs.GraalPyFloatObject) {
                double fval;
                assert (delegate instanceof Double || delegate instanceof PFloat);
                long realPointer = HandlePointerConverter.pointerToStub(taggedPointer);
                if (delegate instanceof Double) {
                    Double d = (Double)delegate;
                    fval = d;
                } else {
                    fval = ((PFloat)delegate).getValue();
                }
                writeDoubleNode.write(realPointer, CFields.GraalPyFloatObject__ob_fval, fval);
            }
            return taggedPointer;
        }
    }
}

