/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.hpy;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.modules.CodecsModuleBuiltins;
import com.oracle.graal.python.builtins.modules.SysModuleBuiltins;
import com.oracle.graal.python.builtins.modules.WarningsModuleBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.bytes.PBytes;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsule;
import com.oracle.graal.python.builtins.objects.capsule.PyCapsuleNameMatchesNode;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodesFactory;
import com.oracle.graal.python.builtins.objects.cext.capi.PySequenceArrayWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.common.CArrayWrappers;
import com.oracle.graal.python.builtins.objects.cext.common.CExtCommonNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyArithmeticNode;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyBoxing;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCAccess;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyCField;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContext;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyContextFunctionsFactory;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyData;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyHandle;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNativeSymbol;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPySourceKind;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyTracker;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyContextMember;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructs;
import com.oracle.graal.python.builtins.objects.code.CodeNodes;
import com.oracle.graal.python.builtins.objects.code.PCode;
import com.oracle.graal.python.builtins.objects.common.DynamicObjectStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorage;
import com.oracle.graal.python.builtins.objects.common.HashingStorageNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceNodes;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVar;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ints.PInt;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.slice.PSlice;
import com.oracle.graal.python.builtins.objects.slice.SliceNodes;
import com.oracle.graal.python.builtins.objects.str.StringBuiltins;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.lib.CanBeDoubleNode;
import com.oracle.graal.python.lib.PyCallableCheckNode;
import com.oracle.graal.python.lib.PyDictKeys;
import com.oracle.graal.python.lib.PyExceptionInstanceCheckNode;
import com.oracle.graal.python.lib.PyFloatAsDoubleNode;
import com.oracle.graal.python.lib.PyIndexCheckNode;
import com.oracle.graal.python.lib.PyLongAsDoubleNode;
import com.oracle.graal.python.lib.PyNumberIndexNode;
import com.oracle.graal.python.lib.PyObjectDelItem;
import com.oracle.graal.python.lib.PyObjectGetAttr;
import com.oracle.graal.python.lib.PyObjectGetAttrO;
import com.oracle.graal.python.lib.PyObjectGetItem;
import com.oracle.graal.python.lib.PyObjectGetMethod;
import com.oracle.graal.python.lib.PyObjectIsTrueNode;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.lib.PyObjectSetAttr;
import com.oracle.graal.python.lib.PyObjectSetAttrO;
import com.oracle.graal.python.lib.PyObjectSetItem;
import com.oracle.graal.python.lib.PySequenceContainsNode;
import com.oracle.graal.python.lib.PyTupleSizeNode;
import com.oracle.graal.python.lib.PyUnicodeFromEncodedObject;
import com.oracle.graal.python.lib.PyUnicodeReadCharNode;
import com.oracle.graal.python.nodes.BuiltinNames;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.StringLiterals;
import com.oracle.graal.python.nodes.WriteUnraisableNode;
import com.oracle.graal.python.nodes.argument.keywords.ExpandKeywordStarargsNode;
import com.oracle.graal.python.nodes.argument.positional.ExecutePositionalStarargsNode;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.builtins.ListNodes;
import com.oracle.graal.python.nodes.call.CallNode;
import com.oracle.graal.python.nodes.call.GenericInvokeNode;
import com.oracle.graal.python.nodes.call.special.CallTernaryMethodNode;
import com.oracle.graal.python.nodes.call.special.CallUnaryMethodNode;
import com.oracle.graal.python.nodes.call.special.LookupSpecialMethodNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.expression.BinaryArithmetic;
import com.oracle.graal.python.nodes.expression.InplaceArithmetic;
import com.oracle.graal.python.nodes.expression.TernaryArithmetic;
import com.oracle.graal.python.nodes.expression.UnaryArithmetic;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.nodes.statement.AbstractImportNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaIntExactNode;
import com.oracle.graal.python.nodes.util.CastToTruffleStringNode;
import com.oracle.graal.python.runtime.GilNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.PSequence;
import com.oracle.graal.python.runtime.sequence.storage.ObjectSequenceStorage;
import com.oracle.graal.python.util.CharsetMapping;
import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.profiles.InlinedExactClassProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.InternalByteArray;
import com.oracle.truffle.api.strings.TruffleString;
import java.io.PrintWriter;
import java.lang.annotation.Repeatable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.logging.Level;

public abstract class GraalHPyContextFunctions {
    private static final int SIZEOF_INT32 = 4;
    private static final int SIZEOF_INT64 = 8;
    private static final int SIZEOF_INTPTR = 8;

    @HPyContextFunction(value="ctx_SetCallFunction")
    @GenerateUncached
    public static abstract class GraalHPySetCallFunction
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(GraalHPyContext hpyContext, PythonObject object, Object callFunctionDefPtr, @Bind(value="this") Node inliningTarget, @Cached GetClassNode.GetPythonObjectClassNode getClassNode, @Cached InlinedBranchProfile errorProfile, @Cached GraalHPyNodes.HPyReadCallFunctionNode readCallFunctionNode) {
            PythonClass pythonClass;
            Object clazz = getClassNode.execute(inliningTarget, object);
            if (!(clazz instanceof PythonClass) || !(pythonClass = (PythonClass)clazz).isHPyType()) {
                errorProfile.enter(inliningTarget);
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.TypeError, ErrorMessages.HPY_TYPE_DOES_NOT_IMPLEMENT_CALL_PROTOCOL, clazz);
            }
            Object callFunction = readCallFunctionNode.execute(inliningTarget, hpyContext, callFunctionDefPtr);
            GraalHPyData.setHPyCallFunction(object, callFunction);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_EvalCode")
    @GenerateUncached
    public static abstract class GraalHPyEvalCode
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, PCode code, Object globals, Object locals, @Bind(value="this") Node inliningTarget, @Cached PRaiseNode raiseNode, @Cached CodeNodes.GetCodeCallTargetNode getCallTargetNode, @Cached GenericInvokeNode invokeNode2) {
            Object[] pArguments = PArguments.create();
            if (locals == PNone.NO_VALUE) {
                locals = globals;
            }
            PArguments.setSpecialArgument(pArguments, locals);
            if (!(globals instanceof PythonObject)) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            PArguments.setGlobals(pArguments, (PythonObject)globals);
            RootCallTarget rootCallTarget = getCallTargetNode.execute(inliningTarget, code);
            return invokeNode2.execute(rootCallTarget, pArguments);
        }
    }

    @HPyContextFunction(value="ctx_Compile_s")
    @GenerateUncached
    public static abstract class GraalHPyCompile
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object srcPtr, Object filenamePtr, int kind, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CallNode callNode, @Cached PRaiseNode raiseNode) {
            TruffleString src = fromCharPointerNode.execute(srcPtr);
            TruffleString filename = fromCharPointerNode.execute(filenamePtr);
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_COMPILE);
            GraalHPySourceKind sourceKind = GraalHPySourceKind.fromValue(kind);
            if (sourceKind == null) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.HPY_INVALID_SOURCE_KIND);
            }
            return callNode.executeWithoutFrame(builtinFunction, src, filename, sourceKind.getMode());
        }
    }

    @HPyContextFunction(value="ctx_Type_GetBuiltinShape")
    @GenerateUncached
    public static abstract class GraalHPyTypeGetBuiltinShape
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object typeObject, @Bind(value="this") Node inliningTarget, @Cached InlinedExactClassProfile classProfile, @Cached PRaiseNode raiseNode) {
            Object profiledTypeObject = classProfile.profile(inliningTarget, typeObject);
            int result = GraalHPyDef.getBuiltinShapeFromHiddenAttribute(profiledTypeObject);
            if (result == -2) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.S_MUST_BE_S, "arg", "type");
            }
            return result;
        }
    }

    @HPyContextFunction(value="ctx_Slice_Unpack")
    @GenerateUncached
    public static abstract class GraalHPySliceUnpack
    extends HPy5ContextFunction {
        @Specialization
        static int doGeneric(GraalHPyContext hpyContext, Object obj, Object startPtr, Object endPtr, Object stepPtr, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.WriteI64Node writeHPyNode, @Cached SliceNodes.SliceUnpackLong sliceUnpack) {
            if (obj instanceof PSlice) {
                PSlice slice = (PSlice)obj;
                PSlice.SliceInfoLong info = sliceUnpack.execute(inliningTarget, slice);
                writeHPyNode.write(hpyContext, startPtr, info.start());
                writeHPyNode.write(hpyContext, endPtr, info.stop());
                writeHPyNode.write(hpyContext, stepPtr, info.step());
                return 0;
            }
            return -1;
        }
    }

    @HPyContextFunction(value="ctx_Unicode_Substring")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeSubstring
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object obj, long lstart, long lend, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castStr, @Cached CastToJavaIntExactNode castStart, @Cached CastToJavaIntExactNode castEnd, @Cached InlinedConditionProfile profile, @Cached TruffleString.CodePointLengthNode codePointLengthNode, @Cached StringBuiltins.StrGetItemNodeWithSlice getSlice) {
            TruffleString value = castStr.execute(inliningTarget, obj);
            int start = castStart.execute(inliningTarget, lstart);
            int end = castEnd.execute(inliningTarget, lend);
            if (profile.profile(inliningTarget, start < 0 || end < 0)) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.IndexError, ErrorMessages.STRING_INDEX_OUT_OF_RANGE);
            }
            PSlice.SliceInfo sliceInfo = PSlice.computeIndices(start, end, 1, codePointLengthNode.execute((AbstractTruffleString)value, PythonUtils.TS_ENCODING));
            return getSlice.execute(value, sliceInfo);
        }
    }

    @HPyContextFunction(value="ctx_Unicode_FromEncodedObject")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeFromEncodedObject
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object obj, Object encodingPtr, Object errorsPtr, @Bind(value="this") Node inliningTarget, @Cached InlinedConditionProfile nullProfile, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyFromCharPointerNode fromNativeCharPointerNode, @Cached PyUnicodeFromEncodedObject libNode) {
            if (nullProfile.profile(inliningTarget, obj == PNone.NO_VALUE)) {
                throw PRaiseNode.raiseUncached(inliningTarget, PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
            }
            TruffleString encoding = !isNullNode.execute(hpyContext, encodingPtr) ? fromNativeCharPointerNode.execute(hpyContext, encodingPtr, true) : StringLiterals.T_UTF8;
            TruffleString errors = !isNullNode.execute(hpyContext, errorsPtr) ? fromNativeCharPointerNode.execute(hpyContext, errorsPtr, true) : StringLiterals.T_STRICT;
            return libNode.execute(null, inliningTarget, obj, encoding, errors);
        }
    }

    @HPyContextFunction(value="ctx_ContextVar_Set")
    @GenerateUncached
    public static abstract class GraalHPyContextVarSet
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object var, Object val, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            if (!(var instanceof PContextVar)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED);
            }
            PContextVar contextVar = (PContextVar)var;
            PythonContext.PythonThreadState threadState = hpyContext.getContext().getThreadState(PythonLanguage.get(raiseNode));
            Object oldValue = contextVar.getValue(threadState);
            contextVar.setValue(threadState, val);
            return factory.createContextVarsToken(contextVar, oldValue);
        }
    }

    @HPyContextFunction(value="ctx_ContextVar_Get")
    @GenerateUncached
    public static abstract class GraalHPyContextVarGet
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(GraalHPyContext hpyContext, Object var, Object def, Object outPtr, @Cached PRaiseNode raiseNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.WriteHPyNode writeHPyNode) {
            if (!(var instanceof PContextVar)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INSTANCE_OF_CONTEXTVAR_EXPECTED);
            }
            PContextVar contextVar = (PContextVar)var;
            PythonContext.PythonThreadState threadState = hpyContext.getContext().getThreadState(PythonLanguage.get(raiseNode));
            Object result = GraalHPyContextVarGet.getObject(threadState, contextVar, def);
            writeHPyNode.write(hpyContext, outPtr, result);
            return 0;
        }

        public static Object getObject(PythonContext.PythonThreadState threadState, PContextVar var, Object def) {
            Object result = var.getValue(threadState);
            if (result == null) {
                if (def == GraalHPyHandle.NULL_HANDLE_DELEGATE && (def = var.getDefault()) == PContextVar.NO_DEFAULT) {
                    def = GraalHPyHandle.NULL_HANDLE_DELEGATE;
                }
                result = def;
            }
            return result;
        }
    }

    @HPyContextFunction(value="ctx_ContextVar_New")
    @GenerateUncached
    public static abstract class GraalHPyContextVarNew
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object namePtr, Object def, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CallNode callContextvar) {
            TruffleString name = fromCharPointerNode.execute(namePtr);
            return callContextvar.executeWithoutFrame((Object)PythonBuiltinClassType.ContextVar, name, def);
        }
    }

    @HPyContextFunction(value="ctx_Capsule_IsValid")
    @GenerateUncached
    public static abstract class GraalHPyCapsuleIsValid
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object capsule, Object namePtr, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode) {
            PyCapsule pyCapsule;
            return PInt.intValue(capsule instanceof PyCapsule && nameMatchesNode.execute(inliningTarget, (pyCapsule = (PyCapsule)capsule).getName(), namePtr));
        }
    }

    @HPyContextFunction(value="ctx_Capsule_Set")
    @GenerateUncached
    public static abstract class GraalHPyCapsuleSet
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(GraalHPyContext hpyContext, Object capsule, int key, Object valuePtr, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PRaiseNode raiseNode) {
            GraalHPyCapsuleGet.isLegalCapsule(capsule, key, raiseNode);
            PyCapsule pyCapsule = (PyCapsule)capsule;
            switch (key) {
                case 0: {
                    if (isNullNode.execute(hpyContext, valuePtr)) {
                        throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.CAPSULE_SETPOINTER_CALLED_WITH_NULL_POINTER);
                    }
                    pyCapsule.setPointer(valuePtr);
                    break;
                }
                case 2: {
                    pyCapsule.setContext(valuePtr);
                    break;
                }
                case 1: {
                    pyCapsule.setName(fromCharPointerNode.execute(valuePtr, false));
                    break;
                }
                case 3: {
                    pyCapsule.registerDestructor(isNullNode.execute(hpyContext, valuePtr) ? null : valuePtr);
                    break;
                }
                default: {
                    throw CompilerDirectives.shouldNotReachHere((String)"invalid key");
                }
            }
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Capsule_Get")
    @GenerateUncached
    public static abstract class GraalHPyCapsuleGet
    extends HPyQuaternaryContextFunction {
        public static final TruffleString INCORRECT_NAME = PythonUtils.tsLiteral("HPyCapsule_GetPointer called with incorrect name");

        @Specialization
        static Object doGeneric(Object hpyContext, Object capsule, int key, Object namePtr, @Bind(value="this") Node inliningTarget, @Cached PyCapsuleNameMatchesNode nameMatchesNode, @Cached PRaiseNode raiseNode) {
            GraalHPyCapsuleGet.isLegalCapsule(capsule, key, raiseNode);
            PyCapsule pyCapsule = (PyCapsule)capsule;
            Object result = switch (key) {
                case 0 -> {
                    if (!nameMatchesNode.execute(inliningTarget, pyCapsule.getName(), namePtr)) {
                        throw raiseNode.raise(PythonBuiltinClassType.ValueError, INCORRECT_NAME);
                    }
                    yield pyCapsule.getPointer();
                }
                case 2 -> pyCapsule.getContext();
                case 1 -> pyCapsule.getName();
                case 3 -> pyCapsule.getDestructor();
                default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid key");
            };
            if (result == null) {
                return PNone.NO_VALUE;
            }
            return result;
        }

        public static void isLegalCapsule(Object object, int key, PRaiseNode raiseNode) {
            if (!(object instanceof PyCapsule) || ((PyCapsule)object).getPointer() == null) {
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, GraalHPyCapsuleGet.getErrorMessage(key));
            }
        }

        @CompilerDirectives.TruffleBoundary
        public static TruffleString getErrorMessage(int key) {
            return switch (key) {
                case 0 -> ErrorMessages.CAPSULE_GETPOINTER_WITH_INVALID_CAPSULE;
                case 2 -> ErrorMessages.CAPSULE_GETCONTEXT_WITH_INVALID_CAPSULE;
                case 1 -> ErrorMessages.CAPSULE_GETNAME_WITH_INVALID_CAPSULE;
                case 3 -> ErrorMessages.CAPSULE_GETDESTRUCTOR_WITH_INVALID_CAPSULE;
                default -> throw CompilerDirectives.shouldNotReachHere((String)"invalid key");
            };
        }
    }

    @HPyContextFunction(value="ctx_Capsule_New")
    @GenerateUncached
    public static abstract class GraalHPyCapsuleNew
    extends HPyQuaternaryContextFunction {
        @Specialization
        static PyCapsule doGeneric(GraalHPyContext hpyContext, Object pointer, Object namePtr, Object dtorPtr, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode raiseNode) {
            if (isNullNode.execute(hpyContext, pointer)) {
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.HPYCAPSULE_NEW_NULL_PTR_ERROR);
            }
            Object hpyDestructor = null;
            if (!isNullNode.execute(hpyContext, dtorPtr)) {
                Object cpyTrampoline = readPointerNode.read(hpyContext, dtorPtr, GraalHPyCField.HPyCapsule_Destructor__cpy_trampoline);
                hpyDestructor = readPointerNode.read(hpyContext, dtorPtr, GraalHPyCField.HPyCapsule_Destructor__impl);
                if (isNullNode.execute(hpyContext, cpyTrampoline) || isNullNode.execute(hpyContext, hpyDestructor)) {
                    throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.INVALID_HPYCAPSULE_DESTRUCTOR);
                }
            }
            PyCapsule capsule = factory.createCapsule(pointer, namePtr);
            if (hpyDestructor != null) {
                capsule.registerDestructor(hpyDestructor);
            }
            return capsule;
        }
    }

    public static final class CapsuleKey {
        public static final byte Pointer = 0;
        public static final byte Name = 1;
        public static final byte Context = 2;
        public static final byte Destructor = 3;
    }

    @HPyContextFunction(value="ctx_Dict_Copy")
    @GenerateUncached
    public static abstract class GraalHPyDictCopy
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object dictObj, @Bind(value="this") Node inliningTarget, @Cached HashingStorageNodes.HashingStorageCopy copyNode, @Cached PythonObjectFactory factory, @Cached PRaiseNode.Lazy raiseNode) {
            if (dictObj instanceof PDict) {
                PDict dict = (PDict)dictObj;
                return factory.createDict(copyNode.execute(inliningTarget, dict.getDictStorage()));
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }
    }

    @HPyContextFunction(value="ctx_Dict_Keys")
    @GenerateUncached
    public static abstract class GraalHPyDictKeys
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object dictObj, @Bind(value="this") Node inliningTarget, @Cached PyDictKeys keysNode, @Cached PRaiseNode.Lazy raiseNode) {
            if (dictObj instanceof PDict) {
                PDict dict = (PDict)dictObj;
                return keysNode.execute(inliningTarget, dict);
            }
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
        }
    }

    @HPyContextFunction(value="ctx_Type_GetName")
    @GenerateUncached
    public static abstract class GraalHPyTypeGetName
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object type, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyTypeGetNameNode getName) {
            return getName.execute(inliningTarget, hpyContext, type);
        }
    }

    @HPyContextFunction(value="ctx_Type_IsSubtype")
    @GenerateUncached
    public static abstract class GraalHPyTypeIsSubtype
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object derived, Object type, @Cached IsSubtypeNode isSubtype) {
            return PInt.intValue(isSubtype.execute(derived, type));
        }
    }

    @HPyContextFunction(value="ctx_Contains")
    @ImportStatic(value={SpecialMethodSlot.class})
    @GenerateUncached
    public static abstract class GraalHPyContains
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object container, Object key, @Bind(value="this") Node inliningTarget, @Cached PySequenceContainsNode containsNode) {
            return PInt.intValue(containsNode.execute(null, inliningTarget, container, key));
        }
    }

    @HPyContextFunction(value="ctx_ReenterPythonExecution")
    @GenerateUncached
    public static abstract class GraalHPyReenterPythonExecution
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object threadState, @Cached GilNode gil) {
            gil.acquire(hpyContext.getContext());
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_LeavePythonExecution")
    @GenerateUncached
    public static abstract class GraalHPyLeavePythonExecution
    extends HPyUnaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, @Cached GilNode gil) {
            PythonContext context = hpyContext.getContext();
            PythonContext.PythonThreadState threadState = context.getThreadState(PythonLanguage.get(gil));
            gil.release(context, true);
            return threadState;
        }
    }

    @HPyContextFunction(value="ctx_Global_Load")
    @GenerateUncached
    public static abstract class GraalHPyGlobalLoad
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object hpyGlobal, @CachedLibrary(limit="3") InteropLibrary lib) {
            long bits;
            if (hpyGlobal instanceof GraalHPyHandle) {
                GraalHPyHandle h = (GraalHPyHandle)hpyGlobal;
                return h.getDelegate();
            }
            if (!(hpyGlobal instanceof Long) && lib.isNull(hpyGlobal)) {
                return GraalHPyHandle.NULL_HANDLE_DELEGATE;
            }
            if (hpyGlobal instanceof Long) {
                bits = (Long)hpyGlobal;
            } else {
                try {
                    bits = lib.asPointer(hpyGlobal);
                }
                catch (UnsupportedMessageException e) {
                    throw CompilerDirectives.shouldNotReachHere();
                }
            }
            if (GraalHPyBoxing.isBoxedHandle(bits)) {
                return hpyContext.getObjectForHPyGlobal(GraalHPyBoxing.unboxHandle(bits));
            }
            return bits;
        }
    }

    @HPyContextFunction(value="ctx_Global_Store")
    @GenerateUncached
    public static abstract class GraalHPyGlobalStore
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object hpyGlobalPtr, Object value, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadPointerNode readPointerNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.WritePointerNode writePointerNode, @Cached InlinedExactClassProfile typeProfile, @CachedLibrary(limit="3") InteropLibrary lib) {
            Object hpyGlobal = typeProfile.profile(inliningTarget, readPointerNode.execute(hpyContext, hpyGlobalPtr, 0L));
            int idx = -1;
            if (hpyGlobal instanceof GraalHPyHandle) {
                idx = ((GraalHPyHandle)hpyGlobal).getGlobalId();
            } else if (hpyGlobal instanceof Long || !lib.isNull(hpyGlobal)) {
                long bits;
                if (hpyGlobal instanceof Long) {
                    bits = (Long)hpyGlobal;
                } else {
                    try {
                        bits = lib.asPointer(hpyGlobal);
                    }
                    catch (UnsupportedMessageException e) {
                        throw CompilerDirectives.shouldNotReachHere();
                    }
                }
                if (GraalHPyBoxing.isBoxedHandle(bits)) {
                    idx = GraalHPyBoxing.unboxHandle(bits);
                }
            }
            idx = hpyContext.createGlobal(value, idx);
            GraalHPyHandle newHandle = GraalHPyHandle.createGlobal(value, idx);
            writePointerNode.execute(hpyContext, hpyGlobalPtr, 0L, newHandle);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Field_Load")
    @GenerateUncached
    public static abstract class GraalHPyFieldLoad
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, PythonObject owner, Object hpyFieldPtr, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyFieldLoadNode hPyFieldLoadNode) {
            return hPyFieldLoadNode.execute(inliningTarget, owner, hpyFieldPtr);
        }
    }

    @HPyContextFunction(value="ctx_Field_Store")
    @GenerateUncached
    public static abstract class GraalHPyFieldStore
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, PythonObject owner, Object hpyFieldPtr, Object referent, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.WriteHPyFieldNode writeHPyFieldNode) {
            writeHPyFieldNode.write(hpyContext, owner, hpyFieldPtr, referent);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Import_ImportModule")
    @GenerateUncached
    public static abstract class GraalHPyImportModule
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object charPtr, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode) {
            return AbstractImportNode.importModule(fromCharPointerNode.execute(charPtr));
        }
    }

    @HPyContextFunction(value="ctx_Is")
    @GenerateUncached
    public static abstract class GraalHPyIs
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object left, Object right, @Cached IsNode isNode) {
            return PInt.intValue(isNode.execute(left, right));
        }
    }

    @HPyContextFunction(value="ctx_Err_NewException")
    @GenerateUncached
    public static abstract class GraalHPyNewException
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object namePtr, Object base, Object dictObj, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodepointNode, @Cached TruffleString.CodePointLengthNode codepointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached HashingStorageNodes.HashingStorageGetItem getHashingStorageItem, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached CallNode callTypeConstructorNode, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            return GraalHPyNewExceptionWithDoc.createNewExceptionWithDoc(inliningTarget, namePtr, base, dictObj, null, fromCharPointerNode, castToTruffleStringNode, indexOfCodepointNode, codepointLengthNode, substringNode, getHashingStorageItem, setHashingStorageItem, callTypeConstructorNode, raiseNode, factory);
        }
    }

    @HPyContextFunction(value="ctx_Err_NewExceptionWithDoc")
    @GenerateUncached
    public static abstract class GraalHPyNewExceptionWithDoc
    extends HPy5ContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object namePtr, Object docPtr, Object base, Object dictObj, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached TruffleString.IndexOfCodePointNode indexOfCodepointNode, @Cached TruffleString.CodePointLengthNode codepointLengthNode, @Cached TruffleString.SubstringNode substringNode, @Cached HashingStorageNodes.HashingStorageGetItem getHashingStorageItem, @Cached HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, @Cached CallNode callTypeConstructorNode, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            TruffleString doc = !isNullNode.execute(hpyContext, docPtr) ? fromCharPointerNode.execute(docPtr) : null;
            return GraalHPyNewExceptionWithDoc.createNewExceptionWithDoc(inliningTarget, namePtr, base, dictObj, doc, fromCharPointerNode, castToTruffleStringNode, indexOfCodepointNode, codepointLengthNode, substringNode, getHashingStorageItem, setHashingStorageItem, callTypeConstructorNode, raiseNode, factory);
        }

        static Object createNewExceptionWithDoc(Node inliningTarget, Object namePtr, Object base, Object dictObj, TruffleString doc, CExtNodes.FromCharPointerNode fromCharPointerNode, CastToTruffleStringNode castToTruffleStringNode, TruffleString.IndexOfCodePointNode indexOfCodepointNode, TruffleString.CodePointLengthNode codepointLengthNode, TruffleString.SubstringNode substringNode, HashingStorageNodes.HashingStorageGetItem getHashingStorageItem, HashingStorageNodes.HashingStorageSetItem setHashingStorageItem, CallNode callTypeConstructorNode, PRaiseNode raiseNode, PythonObjectFactory factory) {
            PDict dict;
            HashingStorage dictStorage;
            int len;
            TruffleString name = fromCharPointerNode.execute(namePtr);
            int dotIdx = indexOfCodepointNode.execute((AbstractTruffleString)name, 46, 0, len = codepointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING), PythonUtils.TS_ENCODING);
            if (dotIdx < 0) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.NAME_MUST_BE_MOD_CLS);
            }
            if (base == PNone.NO_VALUE) {
                base = PythonBuiltinClassType.Exception;
            }
            if (dictObj == PNone.NO_VALUE) {
                dictStorage = new DynamicObjectStorage(PythonLanguage.get(castToTruffleStringNode));
                dict = factory.createDict(dictStorage);
            } else {
                if (!(dictObj instanceof PDict)) {
                    throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_ARG_TO_INTERNAL_FUNC);
                }
                dict = (PDict)dictObj;
                dictStorage = dict.getDictStorage();
            }
            if (!getHashingStorageItem.hasKey(inliningTarget, dictStorage, SpecialAttributeNames.T___MODULE__)) {
                dictStorage = setHashingStorageItem.execute(inliningTarget, dictStorage, SpecialAttributeNames.T___MODULE__, substringNode.execute((AbstractTruffleString)name, 0, dotIdx, PythonUtils.TS_ENCODING, false));
            }
            if (doc != null) {
                dictStorage = setHashingStorageItem.execute(inliningTarget, dictStorage, SpecialAttributeNames.T___DOC__, doc);
            }
            dict.setDictStorage(dictStorage);
            PTuple bases = base instanceof PTuple ? (PTuple)base : factory.createTuple(new Object[]{base});
            return callTypeConstructorNode.executeWithoutFrame((Object)PythonBuiltinClassType.PythonClass, substringNode.execute((AbstractTruffleString)name, dotIdx + 1, len - dotIdx - 1, PythonUtils.TS_ENCODING, false), bases, dict);
        }
    }

    @HPyContextFunction(value="ctx_TypeCheck")
    @GenerateUncached
    public static abstract class GraalHPyTypeCheck
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, Object type, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), type));
        }
    }

    @HPyContextFunction(value="ctx_Type")
    @GenerateUncached
    public static abstract class GraalHPyType
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode) {
            return getClassNode.execute(inliningTarget, object);
        }
    }

    @HPyContextFunction(value="ctx_Dump")
    @GenerateUncached
    public static abstract class GraalHPyDump
    extends HPyBinaryContextFunction {
        @Specialization
        @CompilerDirectives.TruffleBoundary
        static int doGeneric(GraalHPyContext hpyContext, Object object) {
            PythonContext context = hpyContext.getContext();
            Object type = GetClassNode.executeUncached(object);
            PrintWriter stderr = new PrintWriter(context.getStandardErr());
            stderr.println("object type     : " + String.valueOf(type));
            stderr.println("object type name: " + String.valueOf(TypeNodes.GetNameNode.executeUncached(type)));
            stderr.println("object repr     : ");
            stderr.flush();
            try {
                stderr.println(PyObjectReprAsTruffleStringNode.executeUncached(object).toJavaStringUncached());
                stderr.flush();
            }
            catch (CannotCastException | PException object2) {
                // empty catch block
            }
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_CallMethod")
    @GenerateUncached
    @ImportStatic(value={PGuards.class})
    public static abstract class GraalHPyCallMethod
    extends HPy5ContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, TruffleString name, Object args, long lnargs, Object kwnames, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadHPyArrayNode readHPyArrayNode, @Cached PyTupleSizeNode tupleSizeNode, @Cached GraalHPyNodes.HPyPackKeywordArgsNode packKeywordArgsNode, @Cached PyObjectGetMethod getMethodNode, @Cached CallNode callNode, @Cached PRaiseNode raiseNode) {
            PKeyword[] keywords;
            if (!PInt.isIntRange(lnargs)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, 0);
            }
            int nargs = (int)lnargs;
            int nkw = kwnames != PNone.NO_VALUE ? tupleSizeNode.execute(inliningTarget, kwnames) : 0;
            Object[] positionalArgs = readHPyArrayNode.execute(hpyContext, args, 0L, nargs);
            Object receiver = positionalArgs[0];
            Object callable = getMethodNode.execute(null, inliningTarget, receiver, name);
            if (nkw > 0) {
                Object[] kwObjs = readHPyArrayNode.execute(hpyContext, args, nargs, nkw);
                keywords = packKeywordArgsNode.execute(inliningTarget, kwObjs, (PTuple)kwnames, nkw);
            } else {
                keywords = PKeyword.EMPTY_KEYWORDS;
            }
            return callNode.executeWithoutFrame(callable, positionalArgs, keywords);
        }
    }

    @HPyContextFunction(value="ctx_Call")
    @GenerateUncached
    public static abstract class GraalHPyCall
    extends HPy5ContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object callable, Object args, long lnargs, Object kwnamesObj, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadHPyArrayNode readHPyArrayNode, @Cached PyTupleSizeNode tupleSizeNode, @Cached GraalHPyNodes.HPyPackKeywordArgsNode packKeywordArgsNode, @Cached PRaiseNode raiseNode) {
            PKeyword[] keywords;
            int nkw;
            PTuple kwnames;
            if (!PInt.isIntRange(lnargs)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.OBJ_DOES_NOT_SUPPORT_ITEM_ASSIGMENT, 0);
            }
            int nargs = (int)lnargs;
            if (kwnamesObj instanceof PTuple) {
                kwnames = (PTuple)kwnamesObj;
                nkw = tupleSizeNode.execute(inliningTarget, kwnames);
            } else {
                nkw = 0;
                kwnames = null;
            }
            Object[] positionalArgs = readHPyArrayNode.execute(hpyContext, args, 0L, nargs);
            if (nkw > 0) {
                Object[] kwObjs = readHPyArrayNode.execute(hpyContext, args, nargs, nkw);
                keywords = packKeywordArgsNode.execute(inliningTarget, kwObjs, kwnames, nkw);
            } else {
                keywords = PKeyword.EMPTY_KEYWORDS;
            }
            return CallNode.executeUncached(callable, positionalArgs, keywords);
        }
    }

    @HPyContextFunction(value="ctx_CallTupleDict")
    @GenerateUncached
    public static abstract class GraalHPyCallTupleDict
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object callable, Object argsObject, Object kwargsObject, @Bind(value="this") Node inliningTarget, @Cached ExecutePositionalStarargsNode expandArgsNode, @Cached HashingStorageNodes.HashingStorageLen lenNode, @Cached ExpandKeywordStarargsNode expandKwargsNode, @Cached CallNode callNode, @Cached PRaiseNode raiseNode) {
            Object[] args = GraalHPyCallTupleDict.castArgs(argsObject, expandArgsNode, raiseNode);
            PKeyword[] keywords = GraalHPyCallTupleDict.castKwargs(inliningTarget, kwargsObject, lenNode, expandKwargsNode, raiseNode);
            return callNode.executeWithoutFrame(callable, args, keywords);
        }

        private static Object[] castArgs(Object args, ExecutePositionalStarargsNode expandArgsNode, PRaiseNode raiseNode) {
            if (args == PNone.NO_VALUE) {
                return PythonUtils.EMPTY_OBJECT_ARRAY;
            }
            if (PGuards.isPTuple(args)) {
                return expandArgsNode.executeWith(null, args);
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CALLTUPLEDICT_REQUIRES_ARGS_TUPLE_OR_NULL);
        }

        private static PKeyword[] castKwargs(Node inliningTarget, Object kwargs, HashingStorageNodes.HashingStorageLen lenNode, ExpandKeywordStarargsNode expandKwargsNode, PRaiseNode raiseNode) {
            if (kwargs == PNone.NO_VALUE || GraalHPyCallTupleDict.isEmptyDict(inliningTarget, kwargs, lenNode)) {
                return PKeyword.EMPTY_KEYWORDS;
            }
            if (PGuards.isDict(kwargs)) {
                return expandKwargsNode.execute(inliningTarget, kwargs);
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_CALLTUPLEDICT_REQUIRES_KW_DICT_OR_NULL);
        }

        private static boolean isEmptyDict(Node inliningTarget, Object delegate, HashingStorageNodes.HashingStorageLen lenNode) {
            return delegate instanceof PDict && lenNode.execute(inliningTarget, ((PDict)delegate).getDictStorage()) == 0;
        }
    }

    @HPyContextFunction(value="ctx_Callable_Check")
    @GenerateUncached
    public static abstract class GraalHPyIsCallable
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached PyCallableCheckNode callableCheck) {
            return PInt.intValue(callableCheck.execute(inliningTarget, object));
        }
    }

    @HPyContextFunction(value="ctx_Tracker_ForgetAll")
    @GenerateUncached
    public static abstract class GraalHPyTrackerForgetAll
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object builderArg, @Cached GraalHPyNodes.HPyAsPythonObjectNode asPythonObjectNode) {
            GraalHPyTracker builder = GraalHPyTrackerAdd.cast(asPythonObjectNode.execute(builderArg));
            if (builder == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"invalid builder object");
            }
            builder.removeAll();
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Tracker_Close")
    @GenerateUncached
    public static abstract class GraalHPyTrackerCleanup
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object builderHandle, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyCloseAndGetHandleNode closeAndGetHandleNode, @Cached GraalHPyNodes.HPyCloseHandleNode closeHandleNode) {
            GraalHPyTracker builder = GraalHPyTrackerAdd.cast(closeAndGetHandleNode.execute(inliningTarget, builderHandle));
            if (builder == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"invalid builder object");
            }
            builder.free(inliningTarget, closeHandleNode);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Tracker_Add")
    @GenerateUncached
    public static abstract class GraalHPyTrackerAdd
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object builderArg, Object item, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyAsPythonObjectNode asPythonObjectNode, @Cached GraalHPyNodes.HPyEnsureHandleNode ensureHandleNode) {
            GraalHPyTracker builder = GraalHPyTrackerAdd.cast(asPythonObjectNode.execute(builderArg));
            if (builder == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"invalid builder object");
            }
            try {
                GraalHPyHandle handle = ensureHandleNode.execute(inliningTarget, item);
                if (handle != null) {
                    builder.add(handle);
                }
            }
            catch (OverflowException | OutOfMemoryError e) {
                return -1;
            }
            return 0;
        }

        static GraalHPyTracker cast(Object object) {
            if (object instanceof GraalHPyTracker) {
                return (GraalHPyTracker)object;
            }
            return null;
        }
    }

    @HPyContextFunction(value="ctx_Tracker_New")
    @GenerateUncached
    public static abstract class GraalHPyTrackerNew
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, long lcapacity, @Cached GraalHPyNodes.HPyAsHandleNode asHandleNode) {
            int capacity;
            if (PInt.isIntRange(lcapacity) && (capacity = (int)lcapacity) >= 0) {
                return asHandleNode.execute(new GraalHPyTracker(capacity));
            }
            return GraalHPyHandle.NULL_HANDLE;
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_TupleBuilder_Cancel"), @HPyContextFunction(value="ctx_ListBuilder_Cancel")})
    @GenerateUncached
    public static abstract class GraalHPyBuilderCancel
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object builderHandle, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyCloseAndGetHandleNode closeAndGetHandleNode) {
            ObjectSequenceStorage builder = HPyBuilderBuild.cast(closeAndGetHandleNode.execute(inliningTarget, builderHandle));
            if (builder == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"invalid builder object");
            }
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_ListBuilder_Build")
    @GenerateUncached
    public static abstract class GraalHPyListBuilderBuild
    extends HPyBuilderBuild {
        @Override
        final boolean isTupleBuilder() {
            return false;
        }
    }

    @HPyContextFunction(value="ctx_TupleBuilder_Build")
    @GenerateUncached
    public static abstract class GraalHPyTupleBuilderBuild
    extends HPyBuilderBuild {
        @Override
        final boolean isTupleBuilder() {
            return true;
        }
    }

    @GenerateCached(value=false)
    static abstract class HPyBuilderBuild
    extends HPyBinaryContextFunction {
        HPyBuilderBuild() {
        }

        boolean isTupleBuilder() {
            throw CompilerDirectives.shouldNotReachHere();
        }

        @Specialization
        Object doGeneric(Object hpyContext, Object builderHandle, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyCloseAndGetHandleNode closeAndGetHandleNode, @Cached PythonObjectFactory factory) {
            ObjectSequenceStorage builder = HPyBuilderBuild.cast(closeAndGetHandleNode.execute(inliningTarget, builderHandle));
            if (builder == null) {
                throw CompilerDirectives.shouldNotReachHere((String)"invalid builder object");
            }
            return this.isTupleBuilder() ? factory.createTuple(builder) : factory.createList(builder);
        }

        static ObjectSequenceStorage cast(Object object) {
            if (object instanceof ObjectSequenceStorage) {
                return (ObjectSequenceStorage)object;
            }
            return null;
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_TupleBuilder_Set"), @HPyContextFunction(value="ctx_ListBuilder_Set")})
    @GenerateUncached
    public static abstract class GraalHPyBuilderSet
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object builderHandle, long lidx, Object value, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyAsPythonObjectNode asPythonObjectNode, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached SequenceStorageNodes.SetItemDynamicNode setItemNode) {
            Object builder = asPythonObjectNode.execute(builderHandle);
            if (builder instanceof ObjectSequenceStorage) {
                ObjectSequenceStorage storage = (ObjectSequenceStorage)builder;
                try {
                    int idx = castToJavaIntExactNode.execute(inliningTarget, lidx);
                    setItemNode.execute(null, SequenceStorageNodes.NoGeneralizationNode.DEFAULT, storage, idx, value);
                }
                catch (CannotCastException cannotCastException) {
                    // empty catch block
                }
                return 0;
            }
            throw CompilerDirectives.shouldNotReachHere((String)"invalid builder object");
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_TupleBuilder_New"), @HPyContextFunction(value="ctx_ListBuilder_New")})
    @GenerateUncached
    public static abstract class GraalHPyBuilderNew
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, long lcapacity, @Cached GraalHPyNodes.HPyAsHandleNode asHandleNode) {
            int capacity;
            if (PInt.isIntRange(lcapacity) && (capacity = (int)lcapacity) >= 0) {
                Object[] data = new Object[capacity];
                Arrays.fill(data, PNone.NONE);
                return asHandleNode.execute(new ObjectSequenceStorage(data));
            }
            return GraalHPyHandle.NULL_HANDLE;
        }
    }

    @HPyContextFunction(value="ctx_Tuple_FromArray")
    @GenerateUncached
    public static abstract class GraalHPyTupleFromArray
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arrayPtr, long nelements, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntExactNode castToJavaIntExactNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadHPyArrayNode readHPyArrayNode, @Cached PythonObjectFactory factory) {
            int n;
            try {
                n = castToJavaIntExactNode.execute(inliningTarget, nelements);
            }
            catch (CannotCastException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw PRaiseNode.raiseUncached(castToJavaIntExactNode, PythonBuiltinClassType.MemoryError);
            }
            Object[] elements = readHPyArrayNode.execute(hpyContext, arrayPtr, 0L, n);
            return factory.createTuple(elements);
        }
    }

    @HPyContextFunction(value="ctx_Number_Check")
    @GenerateUncached
    @ImportStatic(value={SpecialMethodSlot.class})
    public static abstract class GraalHPyIsNumber
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached PyIndexCheckNode indexCheckNode, @Cached CanBeDoubleNode canBeDoubleNode, @Cached GetClassNode getClassNode, @Cached(parameters={"Int"}) LookupCallableSlotInMRONode lookup) {
            if (indexCheckNode.execute(inliningTarget, object) || canBeDoubleNode.execute(inliningTarget, object)) {
                return 1;
            }
            Object receiverType = getClassNode.execute(inliningTarget, object);
            return PInt.intValue(lookup.execute(receiverType) != PNone.NO_VALUE);
        }
    }

    @HPyContextFunction(value="ctx_Index")
    @GenerateUncached
    public static abstract class GraalHPyAsIndex
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached PyNumberIndexNode indexNode) {
            return indexNode.execute(null, inliningTarget, object);
        }
    }

    @HPyContextFunction(value="ctx_RichCompareBool")
    @GenerateUncached
    public static abstract class GraalHPyRichcompareBool
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object ctx, Object receiver, Object arg1, int arg2, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached LookupSpecialMethodNode.Dynamic lookupRichcmp, @Cached CallTernaryMethodNode callRichcmp, @Cached PyObjectIsTrueNode isTrueNode) {
            Object result = GraalHPyRichcompare.doGeneric(ctx, receiver, arg1, arg2, inliningTarget, getClassNode, lookupRichcmp, callRichcmp);
            return PInt.intValue(isTrueNode.execute(null, inliningTarget, result));
        }
    }

    @HPyContextFunction(value="ctx_RichCompare")
    @GenerateUncached
    public static abstract class GraalHPyRichcompare
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object receiver, Object arg1, int arg2, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached LookupSpecialMethodNode.Dynamic lookupRichcmp, @Cached CallTernaryMethodNode callRichcmp) {
            Object richcmp = lookupRichcmp.execute(null, inliningTarget, getClassNode.execute(inliningTarget, receiver), SpecialMethodNames.T___TRUFFLE_RICHCOMPARE__, receiver);
            return callRichcmp.execute(null, richcmp, receiver, arg1, arg2);
        }
    }

    @HPyContextFunction(value="ctx_Length")
    @GenerateUncached
    public static abstract class GraalHPyLength
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_LEN);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Hash")
    @GenerateUncached
    public static abstract class GraalHPyHash
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_HASH);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Bytes")
    @GenerateUncached
    public static abstract class GraalHPyBytes
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_BYTES);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_ASCII")
    @GenerateUncached
    public static abstract class GraalHPyASCII
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_ASCII);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Repr")
    @GenerateUncached
    public static abstract class GraalHPyRepr
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_REPR);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Str")
    @GenerateUncached
    public static abstract class GraalHPyStr
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_STR);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Float")
    @GenerateUncached
    public static abstract class GraalHPyFloat
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_FLOAT);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Long")
    @GenerateUncached
    public static abstract class GraalHPyLong
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_INT);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Absolute")
    @GenerateUncached
    public static abstract class GraalHPyAbsolute
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object arg, @Cached ReadAttributeFromObjectNode readAttributeFromObjectNode, @Cached CallUnaryMethodNode callNode) {
            Object builtinFunction = readAttributeFromObjectNode.execute(hpyContext.getContext().getBuiltins(), BuiltinNames.T_ABS);
            return callNode.executeObject(builtinFunction, arg);
        }
    }

    @HPyContextFunction(value="ctx_Type_GenericNew")
    @GenerateUncached
    public static abstract class GraalHPyTypeGenericNew
    extends HPy5ContextFunction {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyTypeGenericNew.class);

        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object type, Object args, long nargs, Object kw, @Bind(value="this") Node inliningTarget, @Cached PythonObjectFactory factory, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.AllocateNode allocateNode, @Cached InlinedExactClassProfile classProfile) {
            PythonClass clazz;
            long basicSize;
            Object profiledTypeObject = classProfile.profile(inliningTarget, type);
            Object dataPtr = null;
            Object destroyFunc = null;
            if (type instanceof PythonClass && (basicSize = (clazz = (PythonClass)type).getBasicSize()) != -1L) {
                dataPtr = allocateNode.calloc(hpyContext, 1L, basicSize);
                destroyFunc = clazz.getHPyDestroyFunc();
                if (LOGGER.isLoggable(Level.FINEST)) {
                    LOGGER.finest(PythonUtils.formatJString("Allocated HPy object with native space of size %d at %s", basicSize, dataPtr));
                }
            }
            int builtinShape = GraalHPyDef.getBuiltinShapeFromHiddenAttribute(profiledTypeObject);
            PythonObject pythonObject = GraalHPyNew.createFromBuiltinShape(builtinShape, type, dataPtr, factory);
            if (destroyFunc != null) {
                hpyContext.createHandleReference(pythonObject, dataPtr, destroyFunc != PNone.NO_VALUE ? destroyFunc : null);
            }
            return pythonObject;
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_AsStruct_Object"), @HPyContextFunction(value="ctx_AsStruct_Legacy"), @HPyContextFunction(value="ctx_AsStruct_Type"), @HPyContextFunction(value="ctx_AsStruct_Long"), @HPyContextFunction(value="ctx_AsStruct_Float"), @HPyContextFunction(value="ctx_AsStruct_Unicode"), @HPyContextFunction(value="ctx_AsStruct_Tuple"), @HPyContextFunction(value="ctx_AsStruct_List")})
    @GenerateUncached
    public static abstract class GraalHPyCast
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyGetNativeSpacePointerNode getNativeSpacePointerNode) {
            return getNativeSpacePointerNode.execute(inliningTarget, object);
        }
    }

    @HPyContextFunction(value="ctx_New")
    @GenerateUncached
    public static abstract class GraalHPyNew
    extends HPyTernaryContextFunction {
        private static final TruffleLogger LOGGER = GraalHPyContext.getLogger(GraalHPyNew.class);
        public static final String INVALID_BUILT_IN_SHAPE = "invalid built-in shape";

        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object type, Object dataOutVar, @Bind(value="this") Node inliningTarget, @Cached TypeNodes.IsTypeNode isTypeNode, @Cached PRaiseNode.Lazy raiseNode, @Cached PythonObjectFactory factory, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.AllocateNode allocateNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.WritePointerNode writePointerNode, @Cached InlinedExactClassProfile classProfile) {
            Object profiledTypeObject = classProfile.profile(inliningTarget, type);
            if (!isTypeNode.execute(inliningTarget, profiledTypeObject)) {
                return raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.HPY_NEW_ARG_1_MUST_BE_A_TYPE);
            }
            Object dataPtr = null;
            Object destroyFunc = null;
            Object defaultCallFunc = null;
            if (profiledTypeObject instanceof PythonClass) {
                PythonClass clazz = (PythonClass)profiledTypeObject;
                long basicSize = clazz.getBasicSize();
                if (basicSize != -1L) {
                    dataPtr = allocateNode.calloc(hpyContext, 1L, basicSize);
                    destroyFunc = clazz.getHPyDestroyFunc();
                    writePointerNode.write(hpyContext, dataOutVar, dataPtr);
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest(PythonUtils.formatJString("Allocated HPy object with native space of size %d at %s", basicSize, dataPtr));
                    }
                }
                defaultCallFunc = clazz.getHPyDefaultCallFunc();
            }
            int builtinShape = GraalHPyDef.getBuiltinShapeFromHiddenAttribute(profiledTypeObject);
            PythonObject pythonObject = GraalHPyNew.createFromBuiltinShape(builtinShape, profiledTypeObject, dataPtr, factory);
            if (destroyFunc != null) {
                hpyContext.createHandleReference(pythonObject, dataPtr, destroyFunc != PNone.NO_VALUE ? destroyFunc : null);
            }
            if (defaultCallFunc != null) {
                GraalHPyData.setHPyCallFunction(pythonObject, defaultCallFunc);
            }
            return pythonObject;
        }

        static PythonObject createFromBuiltinShape(int builtinShape, Object type, Object dataPtr, PythonObjectFactory factory) {
            PythonObject result = switch (builtinShape) {
                case -1, 0 -> factory.createPythonHPyObject(type, dataPtr);
                case 1 -> throw CompilerDirectives.shouldNotReachHere((String)"built-in shape type not yet implemented");
                case 2 -> factory.createInt(type, BigInteger.ZERO);
                case 3 -> factory.createFloat(type, 0.0);
                case 4 -> factory.createString(type, StringLiterals.T_EMPTY_STRING);
                case 5 -> factory.createEmptyTuple(type);
                case 6 -> factory.createList(type);
                default -> throw CompilerDirectives.shouldNotReachHere((String)INVALID_BUILT_IN_SHAPE);
            };
            if (builtinShape != -1 && builtinShape != 0) {
                GraalHPyData.setHPyNativeSpace(result, dataPtr);
            }
            return result;
        }
    }

    @HPyContextFunction(value="ctx_FromPyObject")
    @GenerateUncached
    public static abstract class GraalHPyFromPyObject
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object object, @Cached CApiTransitions.NativeToPythonNode toJavaNode) {
            return toJavaNode.execute(object);
        }
    }

    @HPyContextFunction(value="ctx_DelItem_s")
    @GenerateUncached
    public static abstract class GraalHPyDelItemS
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object charPtr, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PyObjectDelItem delItemNode) {
            delItemNode.execute(null, inliningTarget, receiver, fromCharPointerNode.execute(charPtr));
            return 0;
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_DelItem"), @HPyContextFunction(value="ctx_DelItem_i")})
    @GenerateUncached
    public static abstract class GraalHPyDelItem
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectDelItem delItemNode) {
            delItemNode.execute(null, inliningTarget, receiver, key);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_SetItem_s")
    @GenerateUncached
    public static abstract class GraalHPySetItemS
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object charPtr, Object value, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PyObjectSetItem setItemNode) {
            setItemNode.execute(null, inliningTarget, receiver, fromCharPointerNode.execute(charPtr), value);
            return 0;
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_SetItem"), @HPyContextFunction(value="ctx_SetItem_i")})
    @GenerateUncached
    public static abstract class GraalHPySetItem
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetItem setItemNode) {
            setItemNode.execute(null, inliningTarget, receiver, key, value);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_GetItem_s")
    @GenerateUncached
    public static abstract class GraalHPyGetItemS
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object receiver, Object charPtr, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PyObjectGetItem getItemNode) {
            return getItemNode.execute(null, inliningTarget, receiver, fromCharPointerNode.execute(charPtr));
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_GetItem"), @HPyContextFunction(value="ctx_GetItem_i")})
    @GenerateUncached
    public static abstract class GraalHPyGetItem
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object receiver, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetItem getItemNode) {
            return getItemNode.execute(null, inliningTarget, receiver, key);
        }
    }

    @HPyContextFunction(value="ctx_SetAttr_s")
    @GenerateUncached
    public static abstract class GraalHPySetAttrS
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object charPtr, Object value, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PyObjectSetAttr setAttrNode) {
            TruffleString key = fromCharPointerNode.execute(charPtr);
            if (value == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
                setAttrNode.execute(inliningTarget, receiver, key, PNone.NO_VALUE);
            } else {
                setAttrNode.execute(inliningTarget, receiver, key, value);
            }
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_SetAttr")
    @GenerateUncached
    public static abstract class GraalHPySetAttr
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object key, Object value, @Bind(value="this") Node inliningTarget, @Cached PyObjectSetAttrO setAttrNode) {
            if (value == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
                setAttrNode.execute(null, inliningTarget, receiver, key, PNone.NO_VALUE);
            } else {
                setAttrNode.execute(null, inliningTarget, receiver, key, value);
            }
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_HasAttr_s")
    @GenerateUncached
    public static abstract class GraalHPyHasAttrS
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object charPtr, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PyObjectGetAttr getAttributeNode) {
            try {
                Object attr = getAttributeNode.execute(inliningTarget, receiver, fromCharPointerNode.execute(charPtr));
                return PInt.intValue(attr != PNone.NO_VALUE);
            }
            catch (PException e) {
                return 0;
            }
        }
    }

    @HPyContextFunction(value="ctx_HasAttr")
    @GenerateUncached
    public static abstract class GraalHPyHasAttr
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object receiver, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttrO getAttributeNode) {
            try {
                Object attr = getAttributeNode.execute(null, inliningTarget, receiver, key);
                return PInt.intValue(attr != PNone.NO_VALUE);
            }
            catch (PException e) {
                return 0;
            }
        }
    }

    @HPyContextFunction(value="ctx_Type_FromSpec")
    @GenerateUncached
    public static abstract class GraalHPyTypeFromSpec
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object typeSpecPtr, Object typeSpecParamArrayPtr, @Cached GraalHPyNodes.HPyCreateTypeFromSpecNode createTypeFromSpecNode) {
            Object newType = createTypeFromSpecNode.execute(hpyContext, typeSpecPtr, typeSpecParamArrayPtr);
            assert (PGuards.isClassUncached(newType)) : "Object created from type spec is not a type";
            return newType;
        }
    }

    @HPyContextFunction(value="ctx_GetAttr_s")
    @GenerateUncached
    public static abstract class GraalHPyGetAttrS
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object receiver, Object charPtr, @Bind(value="this") Node inliningTarget, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached PyObjectGetAttr getAttributeNode) {
            return getAttributeNode.execute(inliningTarget, receiver, fromCharPointerNode.execute(charPtr));
        }
    }

    @HPyContextFunction(value="ctx_GetAttr")
    @GenerateUncached
    public static abstract class GraalHPyGetAttr
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object receiver, Object key, @Bind(value="this") Node inliningTarget, @Cached PyObjectGetAttrO getAttributeNode) {
            return getAttributeNode.execute(null, inliningTarget, receiver, key);
        }
    }

    @HPyContextFunction(value="ctx_IsTrue")
    @GenerateUncached
    public static abstract class GraalHPyIsTrue
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached PyObjectIsTrueNode isTrueNode) {
            return PInt.intValue(isTrueNode.execute(null, inliningTarget, object));
        }
    }

    @HPyContextFunction(value="ctx_Bytes_FromStringAndSize")
    @GenerateUncached
    public static abstract class GraalHPyBytesFromStringAndSize
    extends HPyTernaryContextFunction {
        @Specialization
        static PBytes doGeneric(GraalHPyContext hpyContext, Object charPtr, long lsize, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadI8ArrayNode readI8ArrayNode, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            if (isNullNode.execute(hpyContext, charPtr)) {
                throw raiseNode.raise(PythonBuiltinClassType.ValueError, ErrorMessages.NULL_CHAR_PASSED);
            }
            if (lsize < 0L) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.NEGATIVE_SIZE_PASSED);
            }
            if (lsize == 0L) {
                return factory.createEmptyBytes();
            }
            byte[] bytes = readI8ArrayNode.execute(hpyContext, charPtr, 0L, lsize);
            return factory.createBytes(bytes);
        }
    }

    @HPyContextFunction(value="ctx_Bytes_FromString")
    @GenerateUncached
    public static abstract class GraalHPyBytesFromString
    extends HPyBinaryContextFunction {
        @Specialization
        static PBytes doGeneric(GraalHPyContext hpyContext, Object charPtr, @Bind(value="this") Node inliningTarget, @Cached CastToJavaIntExactNode castToJavaIntNode, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyCallHelperFunctionNode callHelperNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadI8ArrayNode readI8ArrayNode, @Cached PRaiseNode raiseNode, @Cached PythonObjectFactory factory) {
            int size;
            try {
                size = castToJavaIntNode.execute(inliningTarget, callHelperNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_STRLEN, charPtr));
            }
            catch (PException e) {
                throw raiseNode.raise(PythonBuiltinClassType.OverflowError, ErrorMessages.BYTE_STR_IS_TOO_LARGE);
            }
            byte[] bytes = readI8ArrayNode.execute(hpyContext, charPtr, 0L, size);
            return factory.createBytes(bytes);
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_Bytes_Size"), @HPyContextFunction(value="ctx_Bytes_GET_SIZE")})
    @GenerateUncached
    public static abstract class GraalHPyBytesGetSize
    extends HPyBinaryContextFunction {
        @Specialization
        static long doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached SequenceNodes.LenNode lenNode, @Cached PRaiseNode raiseNode) {
            if (object instanceof PBytes) {
                return lenNode.execute(inliningTarget, (PSequence)object);
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_BYTES_P_FOUND, object);
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_Bytes_AsString"), @HPyContextFunction(value="ctx_Bytes_AS_STRING")})
    @GenerateUncached
    public static abstract class GraalHPyBytesAsString
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Cached PRaiseNode raiseNode) {
            if (object instanceof PBytes) {
                PBytes bytes = (PBytes)object;
                return PySequenceArrayWrapper.ensureNativeSequence(bytes);
            }
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.EXPECTED_BYTES_P_FOUND, object);
        }
    }

    @HPyContextFunction(value="ctx_AsPyObject")
    @GenerateUncached
    public static abstract class GraalHPyAsPyObject
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Cached CApiTransitions.PythonToNativeNewRefNode toPyObjectPointerNode) {
            return toPyObjectPointerNode.execute(object);
        }
    }

    @HPyContextFunction(value="ctx_Unicode_ReadChar")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeReadChar
    extends HPyTernaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object unicodeObject, long index, @Bind(value="this") Node inliningTarget, @Cached PyUnicodeReadCharNode unicodeReadChar) {
            return unicodeReadChar.execute(inliningTarget, unicodeObject, index);
        }
    }

    @HPyContextFunction(value="ctx_Unicode_DecodeLatin1")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeDecodeLatin1
    extends HPyQuaternaryContextFunction {
        @Specialization
        Object doGeneric(GraalHPyContext hpyContext, Object charPtr, long lsize, Object errorsPtr, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyFromCharPointerNode fromCharPointerNode) {
            if (PInt.isIntRange(lsize)) {
                return fromCharPointerNode.execute(hpyContext, charPtr, (int)lsize, TruffleString.Encoding.ISO_8859_1, true);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @HPyContextFunction(value="ctx_Unicode_DecodeASCII")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeDecodeASCII
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object charPtr, long size, Object errorsPtr, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyFromCharPointerNode fromCharPointerNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.ReadI8ArrayNode readI8ArrayNode, @Cached TruffleString.FromJavaStringNode fromJavaStringNode, @Cached PRaiseNode raiseNode, @Cached TruffleString.EqualNode equalNode) {
            CodingErrorAction errorAction;
            if (isNullNode.execute(hpyContext, errorsPtr)) {
                errorAction = CodingErrorAction.REPORT;
            } else {
                TruffleString errors = fromCharPointerNode.execute(hpyContext, errorsPtr, false);
                errorAction = CodecsModuleBuiltins.convertCodingErrorAction(errors, equalNode);
            }
            byte[] bytes = readI8ArrayNode.execute(hpyContext, charPtr, 0L, size);
            String decoded = GraalHPyUnicodeDecodeASCII.decode(StandardCharsets.US_ASCII, errorAction, bytes);
            if (decoded != null) {
                return fromJavaStringNode.execute(decoded, PythonUtils.TS_ENCODING);
            }
            throw raiseNode.raise(PythonBuiltinClassType.UnicodeDecodeError, ErrorMessages.MALFORMED_INPUT);
        }

        @CompilerDirectives.TruffleBoundary
        static String decode(Charset charset, CodingErrorAction errorAction, byte[] bytes) {
            try {
                return charset.newDecoder().onMalformedInput(errorAction).onUnmappableCharacter(errorAction).decode(ByteBuffer.wrap(bytes)).toString();
            }
            catch (CharacterCodingException ex) {
                return null;
            }
        }
    }

    @HPyContextFunction(value="ctx_Unicode_DecodeFSDefaultAndSize")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeDecodeCharsetAndSize
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object charPtr, long lsize, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyFromCharPointerNode fromCharPointerNode) {
            TruffleString.Encoding fsDefault = GraalHPyUnicodeDecodeCharset.getFSDefault();
            try {
                return fromCharPointerNode.execute(hpyContext, charPtr, PInt.intValueExact(lsize), fsDefault, true);
            }
            catch (OverflowException e) {
                throw CompilerDirectives.shouldNotReachHere();
            }
        }
    }

    @HPyContextFunction(value="ctx_Unicode_DecodeFSDefault")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeDecodeCharset
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object charPtr, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyFromCharPointerNode fromCharPointerNode) {
            return fromCharPointerNode.execute(hpyContext, charPtr, GraalHPyUnicodeDecodeCharset.getFSDefault());
        }

        @CompilerDirectives.TruffleBoundary
        static TruffleString.Encoding getFSDefault() {
            String fileEncoding = System.getProperty("file.encoding");
            if (fileEncoding != null) {
                try {
                    return TruffleString.Encoding.valueOf((String)fileEncoding.replace('-', '_'));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            return TruffleString.Encoding.UTF_8;
        }
    }

    @HPyContextFunction(value="ctx_Unicode_FromWideChar")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeFromWchar
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object wcharPtr, long len, @Bind(value="this") Node inliningTarget, @Cached CExtCommonNodes.ReadUnicodeArrayNode readArray, @Cached TruffleString.FromIntArrayUTF32Node fromArray) {
            try {
                return fromArray.execute(readArray.execute(inliningTarget, wcharPtr, PInt.intValueExact(len), CStructs.wchar_t.size()));
            }
            catch (OverflowException e) {
                throw CompilerDirectives.shouldNotReachHere((Throwable)e);
            }
        }
    }

    @HPyContextFunction(value="ctx_Unicode_FromString")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeFromString
    extends HPyBinaryContextFunction {
        @Specialization
        static TruffleString doGeneric(Object hpyContext, Object charPtr, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode) {
            if (charPtr instanceof TruffleString) {
                TruffleString ts = (TruffleString)charPtr;
                return ts;
            }
            return fromCharPointerNode.execute(charPtr);
        }
    }

    @HPyContextFunction(value="ctx_Unicode_AsUTF8AndSize")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeAsUTF8AndSize
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object unicodeObject, Object sizePtr, @Bind(value="this") Node inliningTarget, @Cached CastToTruffleStringNode castToTruffleStringNode, @Cached PRaiseNode raiseNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.WriteSizeTNode writeSizeTNode, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached TruffleString.SwitchEncodingNode switchEncodingNode, @Cached TruffleString.GetInternalByteArrayNode getInternalByteArrayNode) {
            TruffleString tsUtf8;
            try {
                tsUtf8 = switchEncodingNode.execute((AbstractTruffleString)castToTruffleStringNode.execute(inliningTarget, unicodeObject), TruffleString.Encoding.UTF_8);
            }
            catch (CannotCastException e) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.BAD_ARG_TYPE_FOR_BUILTIN_OP);
            }
            InternalByteArray internalByteArray = getInternalByteArrayNode.execute((AbstractTruffleString)tsUtf8, TruffleString.Encoding.UTF_8);
            if (!isNullNode.execute(hpyContext, sizePtr)) {
                writeSizeTNode.write(hpyContext, sizePtr, internalByteArray.getLength());
            }
            return new CArrayWrappers.CByteArrayWrapper(internalByteArray.getArray());
        }
    }

    @HPyContextFunction(value="ctx_Unicode_EncodeFSDefault")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeEncodeFSDefault
    extends HPyBinaryContextFunction {
        @Specialization
        static PBytes doGeneric(Object hpyContext, Object unicodeObject, @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached PythonObjectFactory factory) {
            return factory.createBytes(encodeNativeStringNode.execute(GraalHPyUnicodeEncodeFSDefault.getFSDefaultCharset(), unicodeObject, StringLiterals.T_STRICT));
        }

        @CompilerDirectives.TruffleBoundary
        public static Charset getFSDefaultCharset() {
            TruffleString normalizedEncoding = CharsetMapping.normalizeUncached(SysModuleBuiltins.GetFileSystemEncodingNode.getFileSystemEncoding());
            return CharsetMapping.getCharsetNormalized(normalizedEncoding);
        }
    }

    @HPyContextFunction(value="ctx_Unicode_AsASCIIString")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeAsASCIIString
    extends HPyBinaryContextFunction {
        @Specialization
        static PBytes doGeneric(Object hpyContext, Object unicodeObject, @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached PythonObjectFactory factory) {
            return factory.createBytes(encodeNativeStringNode.execute(StandardCharsets.US_ASCII, unicodeObject, StringLiterals.T_STRICT));
        }
    }

    @HPyContextFunction(value="ctx_Unicode_AsLatin1String")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeAsLatin1String
    extends HPyBinaryContextFunction {
        @Specialization
        static PBytes doGeneric(Object hpyContext, Object unicodeObject, @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached PythonObjectFactory factory) {
            return factory.createBytes(encodeNativeStringNode.execute(StandardCharsets.ISO_8859_1, unicodeObject, StringLiterals.T_STRICT));
        }
    }

    @HPyContextFunction(value="ctx_Unicode_AsUTF8String")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeAsUTF8String
    extends HPyBinaryContextFunction {
        @Specialization
        static PBytes doGeneric(Object hpyContext, Object unicodeObject, @Cached CExtCommonNodes.EncodeNativeStringNode encodeNativeStringNode, @Cached PythonObjectFactory factory) {
            return factory.createBytes(encodeNativeStringNode.execute(StandardCharsets.UTF_8, unicodeObject, StringLiterals.T_STRICT));
        }
    }

    @HPyContextFunction(value="ctx_Err_WriteUnraisable")
    @GenerateUncached
    public static abstract class GraalHPyErrWriteUnraisable
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached WriteUnraisableNode writeUnraisableNode, @Cached CExtCommonNodes.ClearCurrentExceptionNode clearCurrentExceptionNode) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, hpyContext.getContext());
            PException exception = threadState.getCurrentException();
            clearCurrentExceptionNode.execute(inliningTarget, threadState);
            writeUnraisableNode.execute(null, exception.getEscapedException(), null, object instanceof PNone ? PNone.NONE : object);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Err_WarnEx")
    @GenerateUncached
    public static abstract class GraalHPyErrWarnEx
    extends HPyQuaternaryContextFunction {
        @Specialization
        static int doGeneric(GraalHPyContext hpyContext, Object categoryArg, Object messageArg, long stackLevel, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached WarningsModuleBuiltins.WarnNode warnNode) {
            Object category = categoryArg == GraalHPyHandle.NULL_HANDLE_DELEGATE ? PythonBuiltinClassType.RuntimeWarning : categoryArg;
            TruffleString message = isNullNode.execute(hpyContext, messageArg) ? StringLiterals.T_EMPTY_STRING : fromCharPointerNode.execute(messageArg);
            warnNode.warnEx(null, category, message, (int)stackLevel);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Err_Clear")
    @GenerateUncached
    public static abstract class GraalHPyErrClear
    extends HPyUnaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached CExtCommonNodes.ClearCurrentExceptionNode clearCurrentExceptionNode) {
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, hpyContext.getContext());
            clearCurrentExceptionNode.execute(inliningTarget, threadState);
            return GraalHPyHandle.NULL_HANDLE_DELEGATE;
        }
    }

    @HPyContextFunction(value="ctx_Err_ExceptionMatches")
    @GenerateUncached
    public static abstract class GraalHPyErrExceptionMatches
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object exc, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached GraalHPyNodes.RecursiveExceptionMatches exceptionMatches) {
            PException err = getThreadStateNode.execute(inliningTarget, hpyContext.getContext()).getCurrentException();
            if (err == null) {
                return 0;
            }
            if (exc == GraalHPyHandle.NULL_HANDLE_DELEGATE) {
                return 0;
            }
            return exceptionMatches.execute(hpyContext, err.getUnreifiedException(), exc);
        }
    }

    @HPyContextFunction(value="ctx_Err_Occurred")
    @GenerateUncached
    public static abstract class GraalHPyErrOccurred
    extends HPyUnaryContextFunction {
        @Specialization
        static int doGeneric(GraalHPyContext hpyContext, @Bind(value="this") Node inliningTarget, @Cached PythonContext.GetThreadStateNode getThreadStateNode) {
            return getThreadStateNode.execute(inliningTarget, hpyContext.getContext()).getCurrentException() != null ? 1 : 0;
        }
    }

    @HPyContextFunction(value="ctx_FatalError")
    @GenerateUncached
    public static abstract class GraalHPyFatalError
    extends HPyBinaryContextFunction {
        @CompilerDirectives.TruffleBoundary
        @Specialization
        Object doGeneric(GraalHPyContext hpyContext, Object charPtr) {
            TruffleString errorMessage = GraalHPyCAccess.IsNullNode.getUncached(hpyContext).execute(hpyContext, charPtr) ? ErrorMessages.MSG_NOT_SET : CExtNodesFactory.FromCharPointerNodeGen.getUncached().execute(charPtr, false);
            CExtCommonNodes.fatalError((Node)this, hpyContext.getContext(), null, errorMessage, -1);
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @HPyContextFunction(value="ctx_Err_SetFromErrnoWithFilenameObjects")
    @GenerateUncached
    public static abstract class GraalHPyErrSetFromErrnoWithFilenameObjects
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object errTypeObj, Object filenameObject1, Object filenameObject2, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyCallHelperFunctionNode callHelperNode, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CallNode callExceptionConstructorNode, @Cached PyExceptionInstanceCheckNode exceptionCheckNode, @Cached PRaiseNode raiseNode) {
            Object i = callHelperNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_GET_ERRNO, new Object[0]);
            TruffleString message = fromCharPointerNode.execute(callHelperNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_GET_STRERROR, i));
            if (!isSubtypeNode.execute(errTypeObj, (Object)PythonBuiltinClassType.PBaseException)) {
                return raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, errTypeObj);
            }
            Object exception = null;
            if (filenameObject1 != GraalHPyHandle.NULL_HANDLE_DELEGATE) {
                exception = filenameObject2 != GraalHPyHandle.NULL_HANDLE_DELEGATE ? callExceptionConstructorNode.executeWithoutFrame(errTypeObj, i, message, filenameObject1, 0, filenameObject2) : callExceptionConstructorNode.executeWithoutFrame(errTypeObj, i, message, filenameObject1);
            }
            if (exception == null) {
                exception = callExceptionConstructorNode.executeWithoutFrame(errTypeObj, i, message);
            }
            if (exceptionCheckNode.execute(inliningTarget, exception)) {
                throw raiseNode.raiseExceptionObject(exception);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @HPyContextFunction(value="ctx_Err_SetFromErrnoWithFilename")
    @GenerateUncached
    public static abstract class GraalHPyErrSetFromErrnoWithFilename
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(GraalHPyContext hpyContext, Object errTypeObj, Object errMessagePtr, @Bind(value="this") Node inliningTarget, @Cached(parameters={"hpyContext"}) GraalHPyCAccess.IsNullNode isNullNode, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyCallHelperFunctionNode callHelperFunctionNode, @Cached(parameters={"hpyContext"}) GraalHPyNodes.HPyFromCharPointerNode fromCharPointerNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CallNode callExceptionConstructorNode, @Cached PyExceptionInstanceCheckNode exceptionCheckNode, @Cached PRaiseNode raiseNode) {
            Object i = callHelperFunctionNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_GET_ERRNO, new Object[0]);
            TruffleString message = fromCharPointerNode.execute(hpyContext, callHelperFunctionNode.call(hpyContext, GraalHPyNativeSymbol.GRAAL_HPY_GET_STRERROR, i), true);
            if (!isSubtypeNode.execute(errTypeObj, (Object)PythonBuiltinClassType.PBaseException)) {
                return raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, errTypeObj);
            }
            Object exception = null;
            if (!isNullNode.execute(hpyContext, errMessagePtr)) {
                TruffleString filename_fsencoded = fromCharPointerNode.execute(hpyContext, errMessagePtr, true);
                exception = callExceptionConstructorNode.executeWithoutFrame(errTypeObj, i, message, filename_fsencoded);
            }
            if (exception == null) {
                exception = callExceptionConstructorNode.executeWithoutFrame(errTypeObj, i, message);
            }
            if (exceptionCheckNode.execute(inliningTarget, exception)) {
                throw raiseNode.raiseExceptionObject(exception);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @HPyContextFunction(value="ctx_Err_SetString")
    @GenerateUncached
    public static abstract class GraalHPyErrSetString
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object errTypeObj, Object charPtr, @Cached CExtNodes.FromCharPointerNode fromCharPointerNode, @Cached IsSubtypeNode isSubtypeNode, @Cached CallNode callExceptionConstructorNode, @Cached PyExceptionInstanceCheckNode exceptionCheckNode, @Cached PRaiseNode raiseNode) {
            if (!PGuards.isPythonClass(errTypeObj) || !isSubtypeNode.execute(errTypeObj, (Object)PythonBuiltinClassType.PBaseException)) {
                return raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, errTypeObj);
            }
            Object exception = callExceptionConstructorNode.executeWithoutFrame(errTypeObj, fromCharPointerNode.execute(charPtr));
            if (exceptionCheckNode.execute(isSubtypeNode, exception)) {
                throw raiseNode.raiseExceptionObject(exception);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @HPyContextFunction(value="ctx_Err_SetObject")
    @GenerateUncached
    public static abstract class GraalHPyErrSetObject
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object errTypeObj, Object valueObj, @Bind(value="this") Node inliningTarget, @Cached IsSubtypeNode isSubtypeNode, @Cached IsSubtypeNode isExcValueSubtypeNode, @Cached GetClassNode getClassNode, @Cached CallNode callExceptionConstructorNode, @Cached PyExceptionInstanceCheckNode exceptionCheckNode, @Cached PRaiseNode raiseNode) {
            if (!PGuards.isPythonClass(errTypeObj) || !isSubtypeNode.execute(errTypeObj, (Object)PythonBuiltinClassType.PBaseException)) {
                return raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.EXCEPTION_NOT_BASEEXCEPTION, errTypeObj);
            }
            Object exception = isExcValueSubtypeNode.execute(getClassNode.execute(inliningTarget, valueObj), (Object)PythonBuiltinClassType.PBaseException) ? valueObj : callExceptionConstructorNode.executeWithoutFrame(errTypeObj, valueObj);
            if (exceptionCheckNode.execute(inliningTarget, exception)) {
                throw raiseNode.raiseExceptionObject(exception);
            }
            throw CompilerDirectives.shouldNotReachHere();
        }
    }

    @HPyContextFunction(value="ctx_Err_NoMemory")
    @GenerateUncached
    public static abstract class GraalHPyErrNoMemory
    extends HPyUnaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.MemoryError);
        }
    }

    @HPyContextFunction(value="ctx_List_Check")
    @GenerateUncached
    public static abstract class GraalHPyListCheck
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PList));
        }
    }

    @HPyContextFunction(value="ctx_Tuple_Check")
    @GenerateUncached
    public static abstract class GraalHPyTupleCheck
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PTuple));
        }
    }

    @HPyContextFunction(value="ctx_Unicode_Check")
    @GenerateUncached
    public static abstract class GraalHPyUnicodeCheck
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PString));
        }
    }

    @HPyContextFunction(value="ctx_Bytes_Check")
    @GenerateUncached
    public static abstract class GraalHPyBytesCheck
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PBytes));
        }
    }

    @HPyContextFunction(value="ctx_Dict_Check")
    @GenerateUncached
    public static abstract class GraalHPyDictCheck
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode) {
            return PInt.intValue(isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PDict));
        }
    }

    static abstract class HPyCheckBuiltinType
    extends HPyBinaryContextFunction {
        HPyCheckBuiltinType() {
        }

        abstract PythonBuiltinClassType getExpectedType();
    }

    @HPyContextFunction(value="ctx_Float_AsDouble")
    @GenerateUncached
    public static abstract class GraalHPyFloatAsDouble
    extends HPyBinaryContextFunction {
        @Specialization
        static double doGeneric(Object hpyContext, Object value, @Bind(value="this") Node inliningTarget, @Cached PyFloatAsDoubleNode asDoubleNode) {
            return asDoubleNode.execute(null, inliningTarget, value);
        }
    }

    @HPyContextFunction(value="ctx_Float_FromDouble")
    @GenerateUncached
    public static abstract class GraalHPyFloatFromDouble
    extends HPyBinaryContextFunction {
        @Specialization
        static double doGeneric(Object hpyContext, double value) {
            return value;
        }
    }

    @HPyContextFunction(value="ctx_List_Append")
    @GenerateUncached
    public static abstract class GraalHPyListAppend
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object left, Object value, @Bind(value="this") Node inliningTarget, @Cached ListNodes.AppendNode appendNode, @Cached PRaiseNode raiseNode) {
            if (!PGuards.isList(left)) {
                throw raiseNode.raise(PythonBuiltinClassType.SystemError, ErrorMessages.BAD_INTERNAL_CALL);
            }
            appendNode.execute((PList)left, value);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_List_New")
    @GenerateUncached
    public static abstract class GraalHPyListNew
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, long len, @Cached PythonObjectFactory factory, @Cached PRaiseNode raiseNode) {
            try {
                Object[] data = new Object[PInt.intValueExact(len)];
                Arrays.fill(data, PNone.NONE);
                return factory.createList(data);
            }
            catch (OverflowException e) {
                throw raiseNode.raise(PythonBuiltinClassType.MemoryError);
            }
        }
    }

    @HPyContextFunction(value="ctx_Dict_New")
    @GenerateUncached
    public static abstract class GraalHPyDictNew
    extends HPyUnaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, @Cached PythonObjectFactory factory) {
            return factory.createDict();
        }
    }

    @HPyContextFunction(value="ctx_Long_AsDouble")
    @GenerateUncached
    public static abstract class GraalHPyLongAsDouble
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg, @Bind(value="this") Node inliningTarget, @Cached PyLongAsDoubleNode asDoubleNode) {
            return asDoubleNode.execute(inliningTarget, arg);
        }
    }

    @HPyContextFunction(value="ctx_Long_AsSsize_t")
    @GenerateUncached
    public static abstract class GraalHPyLongAsSsizeT
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            if (!isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PInt)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
            return asNativePrimitiveNode.execute(object, 1, 8, true);
        }
    }

    @HPyContextFunction(value="ctx_Long_AsUInt64_tMask")
    @GenerateUncached
    public static abstract class GraalHPyLongAsUInt64Mask
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(object, 0, 8, false);
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_Long_AsUInt64_t"), @HPyContextFunction(value="ctx_Long_AsSize_t"), @HPyContextFunction(value="ctx_Long_AsVoidPtr")})
    @GenerateUncached
    public static abstract class GraalHPyLongAsUInt64
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            if (!isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PInt)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
            return asNativePrimitiveNode.execute(object, 0, 8, true);
        }
    }

    @HPyContextFunction(value="ctx_Long_AsInt64_t")
    @GenerateUncached
    public static abstract class GraalHPyLongAsInt64
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(object, 1, 8, true);
        }
    }

    @HPyContextFunction(value="ctx_Long_AsUInt32_tMask")
    @GenerateUncached
    public static abstract class GraalHPyLongAsUInt32Mask
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(object, 0, 4, false);
        }
    }

    @HPyContextFunction(value="ctx_Long_AsUInt32_t")
    @GenerateUncached
    public static abstract class GraalHPyLongAsUInt32
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClassNode, @Cached IsSubtypeNode isSubtypeNode, @Cached PRaiseNode raiseNode, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            if (!isSubtypeNode.execute(getClassNode.execute(inliningTarget, object), (Object)PythonBuiltinClassType.PInt)) {
                throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.INTEGER_REQUIRED);
            }
            return asNativePrimitiveNode.execute(object, 0, 4, true);
        }
    }

    @HPyContextFunction(value="ctx_Long_AsInt32_t")
    @GenerateUncached
    public static abstract class GraalHPyLongAsInt32
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object, @Cached CExtCommonNodes.AsNativePrimitiveNode asNativePrimitiveNode) {
            return asNativePrimitiveNode.execute(object, 1, 4, true);
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_Long_FromUInt64_t"), @HPyContextFunction(value="ctx_Long_FromSize_t")})
    @GenerateUncached
    public static abstract class GraalHPyLongFromUInt64
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, long value, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyLongFromLong fromLongNode) {
            return fromLongNode.execute(inliningTarget, value, false);
        }
    }

    @HPyContextFunctions(value={@HPyContextFunction(value="ctx_Long_FromInt64_t"), @HPyContextFunction(value="ctx_Long_FromSsize_t")})
    @GenerateUncached
    public static abstract class GraalHPyLongFromInt64
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, long value, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyLongFromLong fromLongNode) {
            return fromLongNode.execute(inliningTarget, value, true);
        }
    }

    @HPyContextFunction(value="ctx_Long_FromUInt32_t")
    @GenerateUncached
    public static abstract class GraalHPyLongFromUInt32
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doInt(Object hpyContext, int value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GraalHPyNodes.HPyLongFromLong fromLongNode) {
            return fromLongNode.execute(inliningTarget, value, false);
        }

        @Specialization
        static Object doLong(Object hpyContext, long value, @Bind(value="this") Node inliningTarget, @Cached.Shared @Cached GraalHPyNodes.HPyLongFromLong fromLongNode) {
            return GraalHPyLongFromUInt32.doInt(hpyContext, (int)value, inliningTarget, fromLongNode);
        }
    }

    @HPyContextFunction(value="ctx_Long_FromInt32_t")
    @GenerateUncached
    public static abstract class GraalHPyLongFromInt32
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doInt(Object hpyContext, int value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GraalHPyNodes.HPyLongFromLong fromLongNode) {
            return fromLongNode.execute(inliningTarget, value, true);
        }

        @Specialization
        static Object doLong(Object hpyContext, long value, @Bind(value="this") Node inliningTarget, @Cached.Exclusive @Cached GraalHPyNodes.HPyLongFromLong fromLongNode) {
            return fromLongNode.execute(inliningTarget, value, true);
        }
    }

    @HPyContextFunction(value="ctx_Bool_FromBool")
    @GenerateUncached
    public static abstract class GraalHPyBoolFromBool
    extends HPyBinaryContextFunction {
        @Specialization
        static PInt doBoolean(GraalHPyContext hpyContext, boolean value) {
            PythonContext core = hpyContext.getContext();
            return value ? core.getTrue() : core.getFalse();
        }

        @Specialization
        static PInt doByte(GraalHPyContext hpyContext, byte value) {
            return GraalHPyBoolFromBool.doBoolean(hpyContext, value != 0);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceOr")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceOr
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IOr"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceXor")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceXor
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IXor"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceAnd")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceAnd
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IAnd"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceRshift")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceRshift
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IRShift"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceLshift")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceLshift
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"ILShift"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlacePower")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlacePower
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, Object arg2, @Cached(parameters={"IPow"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1, arg2);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceRemainder")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceRemainder
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IMod"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceTrueDivide")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceTrueDivide
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"ITrueDiv"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceFloorDivide")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceFloorDivide
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IFloorDiv"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceMatrixMultiply")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceMatrixMultiply
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IMatMul"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceMultiply")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceMultiply
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IMul"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceSubtract")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceSubtract
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"ISub"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_InPlaceAdd")
    @GenerateUncached
    @ImportStatic(value={InplaceArithmetic.class})
    public static abstract class GraalHPyInPlaceAdd
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"IAdd"}) GraalHPyArithmeticNode.HPyInplaceArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Power")
    @GenerateUncached
    @ImportStatic(value={TernaryArithmetic.class})
    public static abstract class GraalHPyPower
    extends HPyQuaternaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, Object arg2, @Cached(parameters={"Pow"}) GraalHPyArithmeticNode.HPyTernaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1, arg2);
        }
    }

    @HPyContextFunction(value="ctx_Rshift")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyRshift
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"RShift"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Lshift")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyLshift
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"LShift"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Or")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyOr
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"Or"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Xor")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyXor
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"Xor"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_And")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyAnd
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"And"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Divmod")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyDivmod
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"DivMod"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Remainder")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyRemainder
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"Mod"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_TrueDivide")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyTrueDivide
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"TrueDiv"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_FloorDivide")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyFloorDivide
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"FloorDiv"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_MatrixMultiply")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyMatrixMultiply
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"MatMul"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Multiply")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyMultiply
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"Mul"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Subtract")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPySubtract
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"Sub"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Add")
    @GenerateUncached
    @ImportStatic(value={BinaryArithmetic.class})
    public static abstract class GraalHPyAdd
    extends HPyTernaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg0, Object arg1, @Cached(parameters={"Add"}) GraalHPyArithmeticNode.HPyBinaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg0, arg1);
        }
    }

    @HPyContextFunction(value="ctx_Invert")
    @GenerateUncached
    @ImportStatic(value={UnaryArithmetic.class})
    public static abstract class GraalHPyInvert
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg, @Cached(parameters={"Invert"}) GraalHPyArithmeticNode.HPyUnaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg);
        }
    }

    @HPyContextFunction(value="ctx_Negative")
    @GenerateUncached
    @ImportStatic(value={UnaryArithmetic.class})
    public static abstract class GraalHPyNegative
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg, @Cached(parameters={"Neg"}) GraalHPyArithmeticNode.HPyUnaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg);
        }
    }

    @HPyContextFunction(value="ctx_Positive")
    @GenerateUncached
    @ImportStatic(value={UnaryArithmetic.class})
    public static abstract class GraalHPyPositive
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object arg, @Cached(parameters={"Pos"}) GraalHPyArithmeticNode.HPyUnaryArithmeticNode arithmeticNode) {
            return arithmeticNode.execute(arg);
        }
    }

    @HPyContextFunction(value="ctx_Close")
    @GenerateUncached
    public static abstract class GraalHPyClose
    extends HPyBinaryContextFunction {
        @Specialization
        static int doGeneric(Object hpyContext, Object handle, @Bind(value="this") Node inliningTarget, @Cached GraalHPyNodes.HPyCloseHandleNode closeHandleNode) {
            closeHandleNode.execute(inliningTarget, handle);
            return 0;
        }
    }

    @HPyContextFunction(value="ctx_Dup")
    @GenerateUncached
    public static abstract class GraalHPyDup
    extends HPyBinaryContextFunction {
        @Specialization
        static Object doGeneric(Object hpyContext, Object object) {
            return object;
        }
    }

    public static abstract class HPy5ContextFunction
    extends GraalHPyContextFunction {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4, Object var5);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3], args[4]);
        }
    }

    public static abstract class HPyQuaternaryContextFunction
    extends GraalHPyContextFunction {
        public abstract Object execute(Object var1, Object var2, Object var3, Object var4);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2], args[3]);
        }
    }

    public static abstract class HPyTernaryContextFunction
    extends GraalHPyContextFunction {
        public abstract Object execute(Object var1, Object var2, Object var3);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1], args[2]);
        }
    }

    public static abstract class HPyBinaryContextFunction
    extends GraalHPyContextFunction {
        public abstract Object execute(Object var1, Object var2);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0], args[1]);
        }
    }

    public static abstract class HPyUnaryContextFunction
    extends GraalHPyContextFunction {
        public abstract Object execute(Object var1);

        @Override
        public final Object execute(Object[] args) {
            return this.execute(args[0]);
        }
    }

    public static abstract class GraalHPyContextFunction
    extends Node {
        public abstract Object execute(Object[] var1);

        @NeverDefault
        public static GraalHPyContextFunction create(HPyContextMember member) {
            return switch (member) {
                case HPyContextMember.CTX_DUP -> GraalHPyContextFunctionsFactory.GraalHPyDupNodeGen.create();
                case HPyContextMember.CTX_CLOSE -> GraalHPyContextFunctionsFactory.GraalHPyCloseNodeGen.create();
                case HPyContextMember.CTX_POSITIVE -> GraalHPyContextFunctionsFactory.GraalHPyPositiveNodeGen.create();
                case HPyContextMember.CTX_NEGATIVE -> GraalHPyContextFunctionsFactory.GraalHPyNegativeNodeGen.create();
                case HPyContextMember.CTX_INVERT -> GraalHPyContextFunctionsFactory.GraalHPyInvertNodeGen.create();
                case HPyContextMember.CTX_ADD -> GraalHPyContextFunctionsFactory.GraalHPyAddNodeGen.create();
                case HPyContextMember.CTX_SUBTRACT -> GraalHPyContextFunctionsFactory.GraalHPySubtractNodeGen.create();
                case HPyContextMember.CTX_MULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyMultiplyNodeGen.create();
                case HPyContextMember.CTX_MATRIXMULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyMatrixMultiplyNodeGen.create();
                case HPyContextMember.CTX_FLOORDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyFloorDivideNodeGen.create();
                case HPyContextMember.CTX_TRUEDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyTrueDivideNodeGen.create();
                case HPyContextMember.CTX_REMAINDER -> GraalHPyContextFunctionsFactory.GraalHPyRemainderNodeGen.create();
                case HPyContextMember.CTX_DIVMOD -> GraalHPyContextFunctionsFactory.GraalHPyDivmodNodeGen.create();
                case HPyContextMember.CTX_AND -> GraalHPyContextFunctionsFactory.GraalHPyAndNodeGen.create();
                case HPyContextMember.CTX_XOR -> GraalHPyContextFunctionsFactory.GraalHPyXorNodeGen.create();
                case HPyContextMember.CTX_OR -> GraalHPyContextFunctionsFactory.GraalHPyOrNodeGen.create();
                case HPyContextMember.CTX_LSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyLshiftNodeGen.create();
                case HPyContextMember.CTX_RSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyRshiftNodeGen.create();
                case HPyContextMember.CTX_POWER -> GraalHPyContextFunctionsFactory.GraalHPyPowerNodeGen.create();
                case HPyContextMember.CTX_INPLACEADD -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceAddNodeGen.create();
                case HPyContextMember.CTX_INPLACESUBTRACT -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceSubtractNodeGen.create();
                case HPyContextMember.CTX_INPLACEMULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceMultiplyNodeGen.create();
                case HPyContextMember.CTX_INPLACEMATRIXMULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceMatrixMultiplyNodeGen.create();
                case HPyContextMember.CTX_INPLACEFLOORDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceFloorDivideNodeGen.create();
                case HPyContextMember.CTX_INPLACETRUEDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceTrueDivideNodeGen.create();
                case HPyContextMember.CTX_INPLACEREMAINDER -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceRemainderNodeGen.create();
                case HPyContextMember.CTX_INPLACEPOWER -> GraalHPyContextFunctionsFactory.GraalHPyInPlacePowerNodeGen.create();
                case HPyContextMember.CTX_INPLACELSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceLshiftNodeGen.create();
                case HPyContextMember.CTX_INPLACERSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceRshiftNodeGen.create();
                case HPyContextMember.CTX_INPLACEAND -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceAndNodeGen.create();
                case HPyContextMember.CTX_INPLACEXOR -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceXorNodeGen.create();
                case HPyContextMember.CTX_INPLACEOR -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceOrNodeGen.create();
                case HPyContextMember.CTX_BOOL_FROMBOOL -> GraalHPyContextFunctionsFactory.GraalHPyBoolFromBoolNodeGen.create();
                case HPyContextMember.CTX_LONG_FROMINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromInt32NodeGen.create();
                case HPyContextMember.CTX_LONG_FROMUINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromUInt32NodeGen.create();
                case HPyContextMember.CTX_LONG_FROMINT64_T, HPyContextMember.CTX_LONG_FROMSSIZE_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromInt64NodeGen.create();
                case HPyContextMember.CTX_LONG_FROMUINT64_T, HPyContextMember.CTX_LONG_FROMSIZE_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromUInt64NodeGen.create();
                case HPyContextMember.CTX_LONG_ASINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsInt32NodeGen.create();
                case HPyContextMember.CTX_LONG_ASUINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt32NodeGen.create();
                case HPyContextMember.CTX_LONG_ASUINT32_TMASK -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt32MaskNodeGen.create();
                case HPyContextMember.CTX_LONG_ASINT64_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsInt64NodeGen.create();
                case HPyContextMember.CTX_LONG_ASUINT64_T, HPyContextMember.CTX_LONG_ASSIZE_T, HPyContextMember.CTX_LONG_ASVOIDPTR -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt64NodeGen.create();
                case HPyContextMember.CTX_LONG_ASUINT64_TMASK -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt64MaskNodeGen.create();
                case HPyContextMember.CTX_LONG_ASSSIZE_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsSsizeTNodeGen.create();
                case HPyContextMember.CTX_LONG_ASDOUBLE -> GraalHPyContextFunctionsFactory.GraalHPyLongAsDoubleNodeGen.create();
                case HPyContextMember.CTX_DICT_NEW -> GraalHPyContextFunctionsFactory.GraalHPyDictNewNodeGen.create();
                case HPyContextMember.CTX_LIST_NEW -> GraalHPyContextFunctionsFactory.GraalHPyListNewNodeGen.create();
                case HPyContextMember.CTX_LIST_APPEND -> GraalHPyContextFunctionsFactory.GraalHPyListAppendNodeGen.create();
                case HPyContextMember.CTX_FLOAT_FROMDOUBLE -> GraalHPyContextFunctionsFactory.GraalHPyFloatFromDoubleNodeGen.create();
                case HPyContextMember.CTX_FLOAT_ASDOUBLE -> GraalHPyContextFunctionsFactory.GraalHPyFloatAsDoubleNodeGen.create();
                case HPyContextMember.CTX_DICT_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyDictCheckNodeGen.create();
                case HPyContextMember.CTX_BYTES_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyBytesCheckNodeGen.create();
                case HPyContextMember.CTX_UNICODE_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeCheckNodeGen.create();
                case HPyContextMember.CTX_TUPLE_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyTupleCheckNodeGen.create();
                case HPyContextMember.CTX_LIST_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyListCheckNodeGen.create();
                case HPyContextMember.CTX_ERR_NOMEMORY -> GraalHPyContextFunctionsFactory.GraalHPyErrNoMemoryNodeGen.create();
                case HPyContextMember.CTX_ERR_SETOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyErrSetObjectNodeGen.create();
                case HPyContextMember.CTX_ERR_SETSTRING -> GraalHPyContextFunctionsFactory.GraalHPyErrSetStringNodeGen.create();
                case HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAME -> GraalHPyContextFunctionsFactory.GraalHPyErrSetFromErrnoWithFilenameNodeGen.create();
                case HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAMEOBJECTS -> GraalHPyContextFunctionsFactory.GraalHPyErrSetFromErrnoWithFilenameObjectsNodeGen.create();
                case HPyContextMember.CTX_FATALERROR -> GraalHPyContextFunctionsFactory.GraalHPyFatalErrorNodeGen.create();
                case HPyContextMember.CTX_ERR_OCCURRED -> GraalHPyContextFunctionsFactory.GraalHPyErrOccurredNodeGen.create();
                case HPyContextMember.CTX_ERR_EXCEPTIONMATCHES -> GraalHPyContextFunctionsFactory.GraalHPyErrExceptionMatchesNodeGen.create();
                case HPyContextMember.CTX_ERR_CLEAR -> GraalHPyContextFunctionsFactory.GraalHPyErrClearNodeGen.create();
                case HPyContextMember.CTX_ERR_WARNEX -> GraalHPyContextFunctionsFactory.GraalHPyErrWarnExNodeGen.create();
                case HPyContextMember.CTX_ERR_WRITEUNRAISABLE -> GraalHPyContextFunctionsFactory.GraalHPyErrWriteUnraisableNodeGen.create();
                case HPyContextMember.CTX_UNICODE_ASUTF8STRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsUTF8StringNodeGen.create();
                case HPyContextMember.CTX_UNICODE_ASLATIN1STRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsLatin1StringNodeGen.create();
                case HPyContextMember.CTX_UNICODE_ASASCIISTRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsASCIIStringNodeGen.create();
                case HPyContextMember.CTX_UNICODE_ENCODEFSDEFAULT -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeEncodeFSDefaultNodeGen.create();
                case HPyContextMember.CTX_UNICODE_ASUTF8ANDSIZE -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsUTF8AndSizeNodeGen.create();
                case HPyContextMember.CTX_UNICODE_FROMSTRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeFromStringNodeGen.create();
                case HPyContextMember.CTX_UNICODE_FROMWIDECHAR -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeFromWcharNodeGen.create();
                case HPyContextMember.CTX_UNICODE_DECODEFSDEFAULT -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeCharsetNodeGen.create();
                case HPyContextMember.CTX_UNICODE_DECODEFSDEFAULTANDSIZE -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeCharsetAndSizeNodeGen.create();
                case HPyContextMember.CTX_UNICODE_DECODEASCII -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeASCIINodeGen.create();
                case HPyContextMember.CTX_UNICODE_DECODELATIN1 -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeLatin1NodeGen.create();
                case HPyContextMember.CTX_UNICODE_READCHAR -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeReadCharNodeGen.create();
                case HPyContextMember.CTX_ASPYOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyAsPyObjectNodeGen.create();
                case HPyContextMember.CTX_BYTES_ASSTRING, HPyContextMember.CTX_BYTES_AS_STRING -> GraalHPyContextFunctionsFactory.GraalHPyBytesAsStringNodeGen.create();
                case HPyContextMember.CTX_BYTES_SIZE, HPyContextMember.CTX_BYTES_GET_SIZE -> GraalHPyContextFunctionsFactory.GraalHPyBytesGetSizeNodeGen.create();
                case HPyContextMember.CTX_BYTES_FROMSTRING -> GraalHPyContextFunctionsFactory.GraalHPyBytesFromStringNodeGen.create();
                case HPyContextMember.CTX_BYTES_FROMSTRINGANDSIZE -> GraalHPyContextFunctionsFactory.GraalHPyBytesFromStringAndSizeNodeGen.create();
                case HPyContextMember.CTX_ISTRUE -> GraalHPyContextFunctionsFactory.GraalHPyIsTrueNodeGen.create();
                case HPyContextMember.CTX_GETATTR -> GraalHPyContextFunctionsFactory.GraalHPyGetAttrNodeGen.create();
                case HPyContextMember.CTX_GETATTR_S -> GraalHPyContextFunctionsFactory.GraalHPyGetAttrSNodeGen.create();
                case HPyContextMember.CTX_TYPE_FROMSPEC -> GraalHPyContextFunctionsFactory.GraalHPyTypeFromSpecNodeGen.create();
                case HPyContextMember.CTX_HASATTR -> GraalHPyContextFunctionsFactory.GraalHPyHasAttrNodeGen.create();
                case HPyContextMember.CTX_HASATTR_S -> GraalHPyContextFunctionsFactory.GraalHPyHasAttrSNodeGen.create();
                case HPyContextMember.CTX_SETATTR -> GraalHPyContextFunctionsFactory.GraalHPySetAttrNodeGen.create();
                case HPyContextMember.CTX_SETATTR_S -> GraalHPyContextFunctionsFactory.GraalHPySetAttrSNodeGen.create();
                case HPyContextMember.CTX_GETITEM, HPyContextMember.CTX_GETITEM_I -> GraalHPyContextFunctionsFactory.GraalHPyGetItemNodeGen.create();
                case HPyContextMember.CTX_GETITEM_S -> GraalHPyContextFunctionsFactory.GraalHPyGetItemSNodeGen.create();
                case HPyContextMember.CTX_SETITEM, HPyContextMember.CTX_SETITEM_I -> GraalHPyContextFunctionsFactory.GraalHPySetItemNodeGen.create();
                case HPyContextMember.CTX_SETITEM_S -> GraalHPyContextFunctionsFactory.GraalHPySetItemSNodeGen.create();
                case HPyContextMember.CTX_DELITEM, HPyContextMember.CTX_DELITEM_I -> GraalHPyContextFunctionsFactory.GraalHPyDelItemNodeGen.create();
                case HPyContextMember.CTX_DELITEM_S -> GraalHPyContextFunctionsFactory.GraalHPyDelItemSNodeGen.create();
                case HPyContextMember.CTX_FROMPYOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyFromPyObjectNodeGen.create();
                case HPyContextMember.CTX_NEW -> GraalHPyContextFunctionsFactory.GraalHPyNewNodeGen.create();
                case HPyContextMember.CTX_ASSTRUCT_OBJECT, HPyContextMember.CTX_ASSTRUCT_LEGACY, HPyContextMember.CTX_ASSTRUCT_TYPE, HPyContextMember.CTX_ASSTRUCT_LONG, HPyContextMember.CTX_ASSTRUCT_FLOAT, HPyContextMember.CTX_ASSTRUCT_UNICODE, HPyContextMember.CTX_ASSTRUCT_TUPLE, HPyContextMember.CTX_ASSTRUCT_LIST -> GraalHPyContextFunctionsFactory.GraalHPyCastNodeGen.create();
                case HPyContextMember.CTX_TYPE_GENERICNEW -> GraalHPyContextFunctionsFactory.GraalHPyTypeGenericNewNodeGen.create();
                case HPyContextMember.CTX_ABSOLUTE -> GraalHPyContextFunctionsFactory.GraalHPyAbsoluteNodeGen.create();
                case HPyContextMember.CTX_LONG -> GraalHPyContextFunctionsFactory.GraalHPyLongNodeGen.create();
                case HPyContextMember.CTX_FLOAT -> GraalHPyContextFunctionsFactory.GraalHPyFloatNodeGen.create();
                case HPyContextMember.CTX_STR -> GraalHPyContextFunctionsFactory.GraalHPyStrNodeGen.create();
                case HPyContextMember.CTX_REPR -> GraalHPyContextFunctionsFactory.GraalHPyReprNodeGen.create();
                case HPyContextMember.CTX_ASCII -> GraalHPyContextFunctionsFactory.GraalHPyASCIINodeGen.create();
                case HPyContextMember.CTX_BYTES -> GraalHPyContextFunctionsFactory.GraalHPyBytesNodeGen.create();
                case HPyContextMember.CTX_HASH -> GraalHPyContextFunctionsFactory.GraalHPyHashNodeGen.create();
                case HPyContextMember.CTX_LENGTH -> GraalHPyContextFunctionsFactory.GraalHPyLengthNodeGen.create();
                case HPyContextMember.CTX_RICHCOMPARE -> GraalHPyContextFunctionsFactory.GraalHPyRichcompareNodeGen.create();
                case HPyContextMember.CTX_RICHCOMPAREBOOL -> GraalHPyContextFunctionsFactory.GraalHPyRichcompareBoolNodeGen.create();
                case HPyContextMember.CTX_INDEX -> GraalHPyContextFunctionsFactory.GraalHPyAsIndexNodeGen.create();
                case HPyContextMember.CTX_NUMBER_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyIsNumberNodeGen.create();
                case HPyContextMember.CTX_TUPLE_FROMARRAY -> GraalHPyContextFunctionsFactory.GraalHPyTupleFromArrayNodeGen.create();
                case HPyContextMember.CTX_TUPLEBUILDER_NEW, HPyContextMember.CTX_LISTBUILDER_NEW -> GraalHPyContextFunctionsFactory.GraalHPyBuilderNewNodeGen.create();
                case HPyContextMember.CTX_TUPLEBUILDER_SET, HPyContextMember.CTX_LISTBUILDER_SET -> GraalHPyContextFunctionsFactory.GraalHPyBuilderSetNodeGen.create();
                case HPyContextMember.CTX_TUPLEBUILDER_BUILD -> GraalHPyContextFunctionsFactory.GraalHPyTupleBuilderBuildNodeGen.create();
                case HPyContextMember.CTX_LISTBUILDER_BUILD -> GraalHPyContextFunctionsFactory.GraalHPyListBuilderBuildNodeGen.create();
                case HPyContextMember.CTX_TUPLEBUILDER_CANCEL, HPyContextMember.CTX_LISTBUILDER_CANCEL -> GraalHPyContextFunctionsFactory.GraalHPyBuilderCancelNodeGen.create();
                case HPyContextMember.CTX_TRACKER_NEW -> GraalHPyContextFunctionsFactory.GraalHPyTrackerNewNodeGen.create();
                case HPyContextMember.CTX_TRACKER_ADD -> GraalHPyContextFunctionsFactory.GraalHPyTrackerAddNodeGen.create();
                case HPyContextMember.CTX_TRACKER_CLOSE -> GraalHPyContextFunctionsFactory.GraalHPyTrackerCleanupNodeGen.create();
                case HPyContextMember.CTX_TRACKER_FORGETALL -> GraalHPyContextFunctionsFactory.GraalHPyTrackerForgetAllNodeGen.create();
                case HPyContextMember.CTX_CALLABLE_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyIsCallableNodeGen.create();
                case HPyContextMember.CTX_CALLTUPLEDICT -> GraalHPyContextFunctionsFactory.GraalHPyCallTupleDictNodeGen.create();
                case HPyContextMember.CTX_CALL -> GraalHPyContextFunctionsFactory.GraalHPyCallNodeGen.create();
                case HPyContextMember.CTX_CALLMETHOD -> GraalHPyContextFunctionsFactory.GraalHPyCallMethodNodeGen.create();
                case HPyContextMember.CTX_DUMP -> GraalHPyContextFunctionsFactory.GraalHPyDumpNodeGen.create();
                case HPyContextMember.CTX_TYPE -> GraalHPyContextFunctionsFactory.GraalHPyTypeNodeGen.create();
                case HPyContextMember.CTX_TYPECHECK -> GraalHPyContextFunctionsFactory.GraalHPyTypeCheckNodeGen.create();
                case HPyContextMember.CTX_ERR_NEWEXCEPTIONWITHDOC -> GraalHPyContextFunctionsFactory.GraalHPyNewExceptionWithDocNodeGen.create();
                case HPyContextMember.CTX_ERR_NEWEXCEPTION -> GraalHPyContextFunctionsFactory.GraalHPyNewExceptionNodeGen.create();
                case HPyContextMember.CTX_IS -> GraalHPyContextFunctionsFactory.GraalHPyIsNodeGen.create();
                case HPyContextMember.CTX_IMPORT_IMPORTMODULE -> GraalHPyContextFunctionsFactory.GraalHPyImportModuleNodeGen.create();
                case HPyContextMember.CTX_FIELD_STORE -> GraalHPyContextFunctionsFactory.GraalHPyFieldStoreNodeGen.create();
                case HPyContextMember.CTX_FIELD_LOAD -> GraalHPyContextFunctionsFactory.GraalHPyFieldLoadNodeGen.create();
                case HPyContextMember.CTX_GLOBAL_STORE -> GraalHPyContextFunctionsFactory.GraalHPyGlobalStoreNodeGen.create();
                case HPyContextMember.CTX_GLOBAL_LOAD -> GraalHPyContextFunctionsFactory.GraalHPyGlobalLoadNodeGen.create();
                case HPyContextMember.CTX_LEAVEPYTHONEXECUTION -> GraalHPyContextFunctionsFactory.GraalHPyLeavePythonExecutionNodeGen.create();
                case HPyContextMember.CTX_REENTERPYTHONEXECUTION -> GraalHPyContextFunctionsFactory.GraalHPyReenterPythonExecutionNodeGen.create();
                case HPyContextMember.CTX_CONTAINS -> GraalHPyContextFunctionsFactory.GraalHPyContainsNodeGen.create();
                case HPyContextMember.CTX_TYPE_ISSUBTYPE -> GraalHPyContextFunctionsFactory.GraalHPyTypeIsSubtypeNodeGen.create();
                case HPyContextMember.CTX_TYPE_GETNAME -> GraalHPyContextFunctionsFactory.GraalHPyTypeGetNameNodeGen.create();
                case HPyContextMember.CTX_DICT_KEYS -> GraalHPyContextFunctionsFactory.GraalHPyDictKeysNodeGen.create();
                case HPyContextMember.CTX_DICT_COPY -> GraalHPyContextFunctionsFactory.GraalHPyDictCopyNodeGen.create();
                case HPyContextMember.CTX_CAPSULE_NEW -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleNewNodeGen.create();
                case HPyContextMember.CTX_CAPSULE_GET -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleGetNodeGen.create();
                case HPyContextMember.CTX_CAPSULE_SET -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleSetNodeGen.create();
                case HPyContextMember.CTX_CAPSULE_ISVALID -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleIsValidNodeGen.create();
                case HPyContextMember.CTX_CONTEXTVAR_NEW -> GraalHPyContextFunctionsFactory.GraalHPyContextVarNewNodeGen.create();
                case HPyContextMember.CTX_CONTEXTVAR_GET -> GraalHPyContextFunctionsFactory.GraalHPyContextVarGetNodeGen.create();
                case HPyContextMember.CTX_CONTEXTVAR_SET -> GraalHPyContextFunctionsFactory.GraalHPyContextVarSetNodeGen.create();
                case HPyContextMember.CTX_UNICODE_FROMENCODEDOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeFromEncodedObjectNodeGen.create();
                case HPyContextMember.CTX_UNICODE_SUBSTRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeSubstringNodeGen.create();
                case HPyContextMember.CTX_SLICE_UNPACK -> GraalHPyContextFunctionsFactory.GraalHPySliceUnpackNodeGen.create();
                case HPyContextMember.CTX_TYPE_GETBUILTINSHAPE -> GraalHPyContextFunctionsFactory.GraalHPyTypeGetBuiltinShapeNodeGen.create();
                case HPyContextMember.CTX_COMPILE_S -> GraalHPyContextFunctionsFactory.GraalHPyCompileNodeGen.create();
                case HPyContextMember.CTX_EVALCODE -> GraalHPyContextFunctionsFactory.GraalHPyEvalCodeNodeGen.create();
                case HPyContextMember.CTX_SETCALLFUNCTION -> GraalHPyContextFunctionsFactory.GraalHPySetCallFunctionNodeGen.create();
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }

        public static GraalHPyContextFunction getUncached(HPyContextMember member) {
            return switch (member) {
                case HPyContextMember.CTX_DUP -> GraalHPyContextFunctionsFactory.GraalHPyDupNodeGen.getUncached();
                case HPyContextMember.CTX_CLOSE -> GraalHPyContextFunctionsFactory.GraalHPyCloseNodeGen.getUncached();
                case HPyContextMember.CTX_POSITIVE -> GraalHPyContextFunctionsFactory.GraalHPyPositiveNodeGen.getUncached();
                case HPyContextMember.CTX_NEGATIVE -> GraalHPyContextFunctionsFactory.GraalHPyNegativeNodeGen.getUncached();
                case HPyContextMember.CTX_INVERT -> GraalHPyContextFunctionsFactory.GraalHPyInvertNodeGen.getUncached();
                case HPyContextMember.CTX_ADD -> GraalHPyContextFunctionsFactory.GraalHPyAddNodeGen.getUncached();
                case HPyContextMember.CTX_SUBTRACT -> GraalHPyContextFunctionsFactory.GraalHPySubtractNodeGen.getUncached();
                case HPyContextMember.CTX_MULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyMultiplyNodeGen.getUncached();
                case HPyContextMember.CTX_MATRIXMULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyMatrixMultiplyNodeGen.getUncached();
                case HPyContextMember.CTX_FLOORDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyFloorDivideNodeGen.getUncached();
                case HPyContextMember.CTX_TRUEDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyTrueDivideNodeGen.getUncached();
                case HPyContextMember.CTX_REMAINDER -> GraalHPyContextFunctionsFactory.GraalHPyRemainderNodeGen.getUncached();
                case HPyContextMember.CTX_DIVMOD -> GraalHPyContextFunctionsFactory.GraalHPyDivmodNodeGen.getUncached();
                case HPyContextMember.CTX_AND -> GraalHPyContextFunctionsFactory.GraalHPyAndNodeGen.getUncached();
                case HPyContextMember.CTX_XOR -> GraalHPyContextFunctionsFactory.GraalHPyXorNodeGen.getUncached();
                case HPyContextMember.CTX_OR -> GraalHPyContextFunctionsFactory.GraalHPyOrNodeGen.getUncached();
                case HPyContextMember.CTX_LSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyLshiftNodeGen.getUncached();
                case HPyContextMember.CTX_RSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyRshiftNodeGen.getUncached();
                case HPyContextMember.CTX_POWER -> GraalHPyContextFunctionsFactory.GraalHPyPowerNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEADD -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceAddNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACESUBTRACT -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceSubtractNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEMULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceMultiplyNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEMATRIXMULTIPLY -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceMatrixMultiplyNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEFLOORDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceFloorDivideNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACETRUEDIVIDE -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceTrueDivideNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEREMAINDER -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceRemainderNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEPOWER -> GraalHPyContextFunctionsFactory.GraalHPyInPlacePowerNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACELSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceLshiftNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACERSHIFT -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceRshiftNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEAND -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceAndNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEXOR -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceXorNodeGen.getUncached();
                case HPyContextMember.CTX_INPLACEOR -> GraalHPyContextFunctionsFactory.GraalHPyInPlaceOrNodeGen.getUncached();
                case HPyContextMember.CTX_BOOL_FROMBOOL -> GraalHPyContextFunctionsFactory.GraalHPyBoolFromBoolNodeGen.getUncached();
                case HPyContextMember.CTX_LONG_FROMINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromInt32NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_FROMUINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromUInt32NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_FROMINT64_T, HPyContextMember.CTX_LONG_FROMSSIZE_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromInt64NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_FROMUINT64_T, HPyContextMember.CTX_LONG_FROMSIZE_T -> GraalHPyContextFunctionsFactory.GraalHPyLongFromUInt64NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsInt32NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASUINT32_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt32NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASUINT32_TMASK -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt32MaskNodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASINT64_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsInt64NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASUINT64_T, HPyContextMember.CTX_LONG_ASSIZE_T, HPyContextMember.CTX_LONG_ASVOIDPTR -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt64NodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASUINT64_TMASK -> GraalHPyContextFunctionsFactory.GraalHPyLongAsUInt64MaskNodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASSSIZE_T -> GraalHPyContextFunctionsFactory.GraalHPyLongAsSsizeTNodeGen.getUncached();
                case HPyContextMember.CTX_LONG_ASDOUBLE -> GraalHPyContextFunctionsFactory.GraalHPyLongAsDoubleNodeGen.getUncached();
                case HPyContextMember.CTX_DICT_NEW -> GraalHPyContextFunctionsFactory.GraalHPyDictNewNodeGen.getUncached();
                case HPyContextMember.CTX_LIST_NEW -> GraalHPyContextFunctionsFactory.GraalHPyListNewNodeGen.getUncached();
                case HPyContextMember.CTX_LIST_APPEND -> GraalHPyContextFunctionsFactory.GraalHPyListAppendNodeGen.getUncached();
                case HPyContextMember.CTX_FLOAT_FROMDOUBLE -> GraalHPyContextFunctionsFactory.GraalHPyFloatFromDoubleNodeGen.getUncached();
                case HPyContextMember.CTX_FLOAT_ASDOUBLE -> GraalHPyContextFunctionsFactory.GraalHPyFloatAsDoubleNodeGen.getUncached();
                case HPyContextMember.CTX_DICT_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyDictCheckNodeGen.getUncached();
                case HPyContextMember.CTX_BYTES_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyBytesCheckNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeCheckNodeGen.getUncached();
                case HPyContextMember.CTX_TUPLE_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyTupleCheckNodeGen.getUncached();
                case HPyContextMember.CTX_LIST_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyListCheckNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_NOMEMORY -> GraalHPyContextFunctionsFactory.GraalHPyErrNoMemoryNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_SETOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyErrSetObjectNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_SETSTRING -> GraalHPyContextFunctionsFactory.GraalHPyErrSetStringNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAME -> GraalHPyContextFunctionsFactory.GraalHPyErrSetFromErrnoWithFilenameNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_SETFROMERRNOWITHFILENAMEOBJECTS -> GraalHPyContextFunctionsFactory.GraalHPyErrSetFromErrnoWithFilenameObjectsNodeGen.getUncached();
                case HPyContextMember.CTX_FATALERROR -> GraalHPyContextFunctionsFactory.GraalHPyFatalErrorNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_OCCURRED -> GraalHPyContextFunctionsFactory.GraalHPyErrOccurredNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_EXCEPTIONMATCHES -> GraalHPyContextFunctionsFactory.GraalHPyErrExceptionMatchesNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_CLEAR -> GraalHPyContextFunctionsFactory.GraalHPyErrClearNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_WARNEX -> GraalHPyContextFunctionsFactory.GraalHPyErrWarnExNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_WRITEUNRAISABLE -> GraalHPyContextFunctionsFactory.GraalHPyErrWriteUnraisableNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_ASUTF8STRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsUTF8StringNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_ASLATIN1STRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsLatin1StringNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_ASASCIISTRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsASCIIStringNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_ENCODEFSDEFAULT -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeEncodeFSDefaultNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_ASUTF8ANDSIZE -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeAsUTF8AndSizeNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_FROMSTRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeFromStringNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_FROMWIDECHAR -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeFromWcharNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_DECODEFSDEFAULT -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeCharsetNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_DECODEFSDEFAULTANDSIZE -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeCharsetAndSizeNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_DECODEASCII -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeASCIINodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_DECODELATIN1 -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeDecodeLatin1NodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_READCHAR -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeReadCharNodeGen.getUncached();
                case HPyContextMember.CTX_ASPYOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyAsPyObjectNodeGen.getUncached();
                case HPyContextMember.CTX_BYTES_ASSTRING, HPyContextMember.CTX_BYTES_AS_STRING -> GraalHPyContextFunctionsFactory.GraalHPyBytesAsStringNodeGen.getUncached();
                case HPyContextMember.CTX_BYTES_SIZE, HPyContextMember.CTX_BYTES_GET_SIZE -> GraalHPyContextFunctionsFactory.GraalHPyBytesGetSizeNodeGen.getUncached();
                case HPyContextMember.CTX_BYTES_FROMSTRING -> GraalHPyContextFunctionsFactory.GraalHPyBytesFromStringNodeGen.getUncached();
                case HPyContextMember.CTX_BYTES_FROMSTRINGANDSIZE -> GraalHPyContextFunctionsFactory.GraalHPyBytesFromStringAndSizeNodeGen.getUncached();
                case HPyContextMember.CTX_ISTRUE -> GraalHPyContextFunctionsFactory.GraalHPyIsTrueNodeGen.getUncached();
                case HPyContextMember.CTX_GETATTR -> GraalHPyContextFunctionsFactory.GraalHPyGetAttrNodeGen.getUncached();
                case HPyContextMember.CTX_GETATTR_S -> GraalHPyContextFunctionsFactory.GraalHPyGetAttrSNodeGen.getUncached();
                case HPyContextMember.CTX_TYPE_FROMSPEC -> GraalHPyContextFunctionsFactory.GraalHPyTypeFromSpecNodeGen.getUncached();
                case HPyContextMember.CTX_HASATTR -> GraalHPyContextFunctionsFactory.GraalHPyHasAttrNodeGen.getUncached();
                case HPyContextMember.CTX_HASATTR_S -> GraalHPyContextFunctionsFactory.GraalHPyHasAttrSNodeGen.getUncached();
                case HPyContextMember.CTX_SETATTR -> GraalHPyContextFunctionsFactory.GraalHPySetAttrNodeGen.getUncached();
                case HPyContextMember.CTX_SETATTR_S -> GraalHPyContextFunctionsFactory.GraalHPySetAttrSNodeGen.getUncached();
                case HPyContextMember.CTX_GETITEM, HPyContextMember.CTX_GETITEM_I -> GraalHPyContextFunctionsFactory.GraalHPyGetItemNodeGen.getUncached();
                case HPyContextMember.CTX_GETITEM_S -> GraalHPyContextFunctionsFactory.GraalHPyGetItemSNodeGen.getUncached();
                case HPyContextMember.CTX_SETITEM, HPyContextMember.CTX_SETITEM_I -> GraalHPyContextFunctionsFactory.GraalHPySetItemNodeGen.getUncached();
                case HPyContextMember.CTX_SETITEM_S -> GraalHPyContextFunctionsFactory.GraalHPySetItemSNodeGen.getUncached();
                case HPyContextMember.CTX_DELITEM, HPyContextMember.CTX_DELITEM_I -> GraalHPyContextFunctionsFactory.GraalHPyDelItemNodeGen.getUncached();
                case HPyContextMember.CTX_DELITEM_S -> GraalHPyContextFunctionsFactory.GraalHPyDelItemSNodeGen.getUncached();
                case HPyContextMember.CTX_FROMPYOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyFromPyObjectNodeGen.getUncached();
                case HPyContextMember.CTX_NEW -> GraalHPyContextFunctionsFactory.GraalHPyNewNodeGen.getUncached();
                case HPyContextMember.CTX_ASSTRUCT_OBJECT, HPyContextMember.CTX_ASSTRUCT_LEGACY, HPyContextMember.CTX_ASSTRUCT_TYPE, HPyContextMember.CTX_ASSTRUCT_LONG, HPyContextMember.CTX_ASSTRUCT_FLOAT, HPyContextMember.CTX_ASSTRUCT_UNICODE, HPyContextMember.CTX_ASSTRUCT_TUPLE, HPyContextMember.CTX_ASSTRUCT_LIST -> GraalHPyContextFunctionsFactory.GraalHPyCastNodeGen.getUncached();
                case HPyContextMember.CTX_TYPE_GENERICNEW -> GraalHPyContextFunctionsFactory.GraalHPyTypeGenericNewNodeGen.getUncached();
                case HPyContextMember.CTX_ABSOLUTE -> GraalHPyContextFunctionsFactory.GraalHPyAbsoluteNodeGen.getUncached();
                case HPyContextMember.CTX_LONG -> GraalHPyContextFunctionsFactory.GraalHPyLongNodeGen.getUncached();
                case HPyContextMember.CTX_FLOAT -> GraalHPyContextFunctionsFactory.GraalHPyFloatNodeGen.getUncached();
                case HPyContextMember.CTX_STR -> GraalHPyContextFunctionsFactory.GraalHPyStrNodeGen.getUncached();
                case HPyContextMember.CTX_REPR -> GraalHPyContextFunctionsFactory.GraalHPyReprNodeGen.getUncached();
                case HPyContextMember.CTX_ASCII -> GraalHPyContextFunctionsFactory.GraalHPyASCIINodeGen.getUncached();
                case HPyContextMember.CTX_BYTES -> GraalHPyContextFunctionsFactory.GraalHPyBytesNodeGen.getUncached();
                case HPyContextMember.CTX_HASH -> GraalHPyContextFunctionsFactory.GraalHPyHashNodeGen.getUncached();
                case HPyContextMember.CTX_LENGTH -> GraalHPyContextFunctionsFactory.GraalHPyLengthNodeGen.getUncached();
                case HPyContextMember.CTX_RICHCOMPARE -> GraalHPyContextFunctionsFactory.GraalHPyRichcompareNodeGen.getUncached();
                case HPyContextMember.CTX_RICHCOMPAREBOOL -> GraalHPyContextFunctionsFactory.GraalHPyRichcompareBoolNodeGen.getUncached();
                case HPyContextMember.CTX_INDEX -> GraalHPyContextFunctionsFactory.GraalHPyAsIndexNodeGen.getUncached();
                case HPyContextMember.CTX_NUMBER_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyIsNumberNodeGen.getUncached();
                case HPyContextMember.CTX_TUPLE_FROMARRAY -> GraalHPyContextFunctionsFactory.GraalHPyTupleFromArrayNodeGen.getUncached();
                case HPyContextMember.CTX_TUPLEBUILDER_NEW, HPyContextMember.CTX_LISTBUILDER_NEW -> GraalHPyContextFunctionsFactory.GraalHPyBuilderNewNodeGen.getUncached();
                case HPyContextMember.CTX_TUPLEBUILDER_SET, HPyContextMember.CTX_LISTBUILDER_SET -> GraalHPyContextFunctionsFactory.GraalHPyBuilderSetNodeGen.getUncached();
                case HPyContextMember.CTX_TUPLEBUILDER_BUILD -> GraalHPyContextFunctionsFactory.GraalHPyTupleBuilderBuildNodeGen.getUncached();
                case HPyContextMember.CTX_LISTBUILDER_BUILD -> GraalHPyContextFunctionsFactory.GraalHPyListBuilderBuildNodeGen.getUncached();
                case HPyContextMember.CTX_TUPLEBUILDER_CANCEL, HPyContextMember.CTX_LISTBUILDER_CANCEL -> GraalHPyContextFunctionsFactory.GraalHPyBuilderCancelNodeGen.getUncached();
                case HPyContextMember.CTX_TRACKER_NEW -> GraalHPyContextFunctionsFactory.GraalHPyTrackerNewNodeGen.getUncached();
                case HPyContextMember.CTX_TRACKER_ADD -> GraalHPyContextFunctionsFactory.GraalHPyTrackerAddNodeGen.getUncached();
                case HPyContextMember.CTX_TRACKER_CLOSE -> GraalHPyContextFunctionsFactory.GraalHPyTrackerCleanupNodeGen.getUncached();
                case HPyContextMember.CTX_TRACKER_FORGETALL -> GraalHPyContextFunctionsFactory.GraalHPyTrackerForgetAllNodeGen.getUncached();
                case HPyContextMember.CTX_CALLABLE_CHECK -> GraalHPyContextFunctionsFactory.GraalHPyIsCallableNodeGen.getUncached();
                case HPyContextMember.CTX_CALLTUPLEDICT -> GraalHPyContextFunctionsFactory.GraalHPyCallTupleDictNodeGen.getUncached();
                case HPyContextMember.CTX_CALL -> GraalHPyContextFunctionsFactory.GraalHPyCallNodeGen.getUncached();
                case HPyContextMember.CTX_CALLMETHOD -> GraalHPyContextFunctionsFactory.GraalHPyCallMethodNodeGen.getUncached();
                case HPyContextMember.CTX_DUMP -> GraalHPyContextFunctionsFactory.GraalHPyDumpNodeGen.getUncached();
                case HPyContextMember.CTX_TYPE -> GraalHPyContextFunctionsFactory.GraalHPyTypeNodeGen.getUncached();
                case HPyContextMember.CTX_TYPECHECK -> GraalHPyContextFunctionsFactory.GraalHPyTypeCheckNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_NEWEXCEPTIONWITHDOC -> GraalHPyContextFunctionsFactory.GraalHPyNewExceptionWithDocNodeGen.getUncached();
                case HPyContextMember.CTX_ERR_NEWEXCEPTION -> GraalHPyContextFunctionsFactory.GraalHPyNewExceptionNodeGen.getUncached();
                case HPyContextMember.CTX_IS -> GraalHPyContextFunctionsFactory.GraalHPyIsNodeGen.getUncached();
                case HPyContextMember.CTX_IMPORT_IMPORTMODULE -> GraalHPyContextFunctionsFactory.GraalHPyImportModuleNodeGen.getUncached();
                case HPyContextMember.CTX_FIELD_STORE -> GraalHPyContextFunctionsFactory.GraalHPyFieldStoreNodeGen.getUncached();
                case HPyContextMember.CTX_FIELD_LOAD -> GraalHPyContextFunctionsFactory.GraalHPyFieldLoadNodeGen.getUncached();
                case HPyContextMember.CTX_GLOBAL_STORE -> GraalHPyContextFunctionsFactory.GraalHPyGlobalStoreNodeGen.getUncached();
                case HPyContextMember.CTX_GLOBAL_LOAD -> GraalHPyContextFunctionsFactory.GraalHPyGlobalLoadNodeGen.getUncached();
                case HPyContextMember.CTX_LEAVEPYTHONEXECUTION -> GraalHPyContextFunctionsFactory.GraalHPyLeavePythonExecutionNodeGen.getUncached();
                case HPyContextMember.CTX_REENTERPYTHONEXECUTION -> GraalHPyContextFunctionsFactory.GraalHPyReenterPythonExecutionNodeGen.getUncached();
                case HPyContextMember.CTX_CONTAINS -> GraalHPyContextFunctionsFactory.GraalHPyContainsNodeGen.getUncached();
                case HPyContextMember.CTX_TYPE_ISSUBTYPE -> GraalHPyContextFunctionsFactory.GraalHPyTypeIsSubtypeNodeGen.getUncached();
                case HPyContextMember.CTX_TYPE_GETNAME -> GraalHPyContextFunctionsFactory.GraalHPyTypeGetNameNodeGen.getUncached();
                case HPyContextMember.CTX_DICT_KEYS -> GraalHPyContextFunctionsFactory.GraalHPyDictKeysNodeGen.getUncached();
                case HPyContextMember.CTX_DICT_COPY -> GraalHPyContextFunctionsFactory.GraalHPyDictCopyNodeGen.getUncached();
                case HPyContextMember.CTX_CAPSULE_NEW -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleNewNodeGen.getUncached();
                case HPyContextMember.CTX_CAPSULE_GET -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleGetNodeGen.getUncached();
                case HPyContextMember.CTX_CAPSULE_SET -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleSetNodeGen.getUncached();
                case HPyContextMember.CTX_CAPSULE_ISVALID -> GraalHPyContextFunctionsFactory.GraalHPyCapsuleIsValidNodeGen.getUncached();
                case HPyContextMember.CTX_CONTEXTVAR_NEW -> GraalHPyContextFunctionsFactory.GraalHPyContextVarNewNodeGen.getUncached();
                case HPyContextMember.CTX_CONTEXTVAR_GET -> GraalHPyContextFunctionsFactory.GraalHPyContextVarGetNodeGen.getUncached();
                case HPyContextMember.CTX_CONTEXTVAR_SET -> GraalHPyContextFunctionsFactory.GraalHPyContextVarSetNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_FROMENCODEDOBJECT -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeFromEncodedObjectNodeGen.getUncached();
                case HPyContextMember.CTX_UNICODE_SUBSTRING -> GraalHPyContextFunctionsFactory.GraalHPyUnicodeSubstringNodeGen.getUncached();
                case HPyContextMember.CTX_SLICE_UNPACK -> GraalHPyContextFunctionsFactory.GraalHPySliceUnpackNodeGen.getUncached();
                case HPyContextMember.CTX_TYPE_GETBUILTINSHAPE -> GraalHPyContextFunctionsFactory.GraalHPyTypeGetBuiltinShapeNodeGen.getUncached();
                case HPyContextMember.CTX_COMPILE_S -> GraalHPyContextFunctionsFactory.GraalHPyCompileNodeGen.getUncached();
                case HPyContextMember.CTX_EVALCODE -> GraalHPyContextFunctionsFactory.GraalHPyEvalCodeNodeGen.getUncached();
                case HPyContextMember.CTX_SETCALLFUNCTION -> GraalHPyContextFunctionsFactory.GraalHPySetCallFunctionNodeGen.getUncached();
                default -> throw CompilerDirectives.shouldNotReachHere();
            };
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Repeatable(value=HPyContextFunctions.class)
    public static @interface HPyContextFunction {
        public String value() default "";
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    public static @interface HPyContextFunctions {
        public HPyContextFunction[] value();
    }
}

