/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.cext.structs;

import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccessFactory;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;

public final class CStructs
extends Enum<CStructs> {
    public static final /* enum */ CStructs PyModuleDef = new CStructs();
    public static final /* enum */ CStructs PyModuleDef_Slot = new CStructs();
    public static final /* enum */ CStructs PyMethodDef = new CStructs();
    public static final /* enum */ CStructs PyObject = new CStructs();
    public static final /* enum */ CStructs GraalPyObject = new CStructs();
    public static final /* enum */ CStructs PyBytesObject = new CStructs();
    public static final /* enum */ CStructs PyByteArrayObject = new CStructs();
    public static final /* enum */ CStructs PyListObject = new CStructs();
    public static final /* enum */ CStructs PyVarObject = new CStructs();
    public static final /* enum */ CStructs GraalPyVarObject = new CStructs();
    public static final /* enum */ CStructs PyMemoryViewObject = new CStructs();
    public static final /* enum */ CStructs Py_buffer = new CStructs();
    public static final /* enum */ CStructs PyDateTime_CAPI = new CStructs();
    public static final /* enum */ CStructs PyNumberMethods = new CStructs();
    public static final /* enum */ CStructs PySequenceMethods = new CStructs();
    public static final /* enum */ CStructs PyMappingMethods = new CStructs();
    public static final /* enum */ CStructs PyAsyncMethods = new CStructs();
    public static final /* enum */ CStructs PyBufferProcs = new CStructs();
    public static final /* enum */ CStructs PyTypeObject = new CStructs();
    public static final /* enum */ CStructs PyHeapTypeObject = new CStructs();
    public static final /* enum */ CStructs PyTupleObject = new CStructs();
    public static final /* enum */ CStructs PyFloatObject = new CStructs();
    public static final /* enum */ CStructs GraalPyFloatObject = new CStructs();
    public static final /* enum */ CStructs PyLongObject = new CStructs();
    public static final /* enum */ CStructs PyModuleDef_Base = new CStructs();
    public static final /* enum */ CStructs Py_complex = new CStructs();
    public static final /* enum */ CStructs PyComplexObject = new CStructs();
    public static final /* enum */ CStructs PyDateTime_Date = new CStructs();
    public static final /* enum */ CStructs PyDateTime_Time = new CStructs();
    public static final /* enum */ CStructs PyDateTime_DateTime = new CStructs();
    public static final /* enum */ CStructs PyDateTime_Delta = new CStructs();
    public static final /* enum */ CStructs PyASCIIObject = new CStructs();
    public static final /* enum */ CStructs PyCompactUnicodeObject = new CStructs();
    public static final /* enum */ CStructs PyBaseExceptionObject = new CStructs();
    public static final /* enum */ CStructs PyUnicodeObject = new CStructs();
    public static final /* enum */ CStructs Py_UNICODE = new CStructs();
    public static final /* enum */ CStructs PyGetSetDef = new CStructs();
    public static final /* enum */ CStructs PyMemberDef = new CStructs();
    public static final /* enum */ CStructs PyThreadState = new CStructs();
    public static final /* enum */ CStructs wchar_t = new CStructs();
    public static final /* enum */ CStructs long__long = new CStructs();
    public static final /* enum */ CStructs Py_ssize_t = new CStructs();
    @CompilerDirectives.CompilationFinal(dimensions=1)
    public static final CStructs[] VALUES;
    @CompilerDirectives.CompilationFinal
    private int size = -1;
    private static final /* synthetic */ CStructs[] $VALUES;

    public static CStructs[] values() {
        return (CStructs[])$VALUES.clone();
    }

    public static CStructs valueOf(String name) {
        return Enum.valueOf(CStructs.class, name);
    }

    public int size() {
        int o = this.size;
        if (o == -1) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            CStructs.resolve();
            return this.size;
        }
        return o;
    }

    private static void resolve() {
        CompilerAsserts.neverPartOfCompilation();
        Object sizesPointer = CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_PYTRUFFLE_STRUCT_SIZES, new Object[0]);
        long[] sizes = CStructAccessFactory.ReadI64NodeGen.getUncached().readLongArray(sizesPointer, VALUES.length);
        for (CStructs struct : VALUES) {
            long size = sizes[struct.ordinal()];
            assert (size > 0L && size < 1024L);
            struct.size = (int)size;
        }
    }

    private static /* synthetic */ CStructs[] $values() {
        return new CStructs[]{PyModuleDef, PyModuleDef_Slot, PyMethodDef, PyObject, GraalPyObject, PyBytesObject, PyByteArrayObject, PyListObject, PyVarObject, GraalPyVarObject, PyMemoryViewObject, Py_buffer, PyDateTime_CAPI, PyNumberMethods, PySequenceMethods, PyMappingMethods, PyAsyncMethods, PyBufferProcs, PyTypeObject, PyHeapTypeObject, PyTupleObject, PyFloatObject, GraalPyFloatObject, PyLongObject, PyModuleDef_Base, Py_complex, PyComplexObject, PyDateTime_Date, PyDateTime_Time, PyDateTime_DateTime, PyDateTime_Delta, PyASCIIObject, PyCompactUnicodeObject, PyBaseExceptionObject, PyUnicodeObject, Py_UNICODE, PyGetSetDef, PyMemberDef, PyThreadState, wchar_t, long__long, Py_ssize_t};
    }

    static {
        $VALUES = CStructs.$values();
        VALUES = CStructs.values();
    }
}

