/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.itertools;

import com.oracle.graal.python.annotations.ArgumentClinic;
import com.oracle.graal.python.annotations.ArgumentsClinic;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.modules.BuiltinFunctions;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.common.SequenceStorageNodes;
import com.oracle.graal.python.builtins.objects.itertools.PTeeDataObject;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltinsClinicProviders;
import com.oracle.graal.python.builtins.objects.itertools.TeeDataObjectBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.list.PList;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.call.special.LookupAndCallUnaryNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.builtins.PythonQuaternaryClinicBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.clinic.ArgumentClinicProvider;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.PTeeDataObject})
public final class TeeDataObjectBuiltins
extends PythonBuiltins {
    static final int LINKCELLS = 128;

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TeeDataObjectBuiltinsFactory.getFactories();
    }

    @Builtin(name="__reduce__", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class ReduceNode
    extends PythonUnaryBuiltinNode {
        abstract Object execute(VirtualFrame var1, PythonObject var2);

        @Specialization
        static Object reduce(PTeeDataObject self, @Bind(value="this") Node inliningTarget, @Cached GetClassNode getClass, @Cached PythonObjectFactory factory) {
            int numread = self.getNumread();
            Object[] values = new Object[numread];
            PythonUtils.arraycopy(self.getValues(), 0, values, 0, numread);
            Object type = getClass.execute(inliningTarget, self);
            PTeeDataObject nextlink = self.getNextlink();
            PTuple tuple = factory.createTuple(new Object[]{self.getIt(), factory.createList(values), nextlink == null ? PNone.NONE : nextlink});
            return factory.createTuple(new Object[]{type, tuple});
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, parameterNames={"$self", "it", "values", "nxt"})
    @ArgumentsClinic(value={@ArgumentClinic(name="values", defaultValue="PNone.NONE", useDefaultForNone=true), @ArgumentClinic(name="nxt", defaultValue="PNone.NONE", useDefaultForNone=true)})
    @GenerateNodeFactory
    public static abstract class InitNode
    extends PythonQuaternaryClinicBuiltinNode {
        @Override
        protected ArgumentClinicProvider getArgumentClinic() {
            return TeeDataObjectBuiltinsClinicProviders.InitNodeClinicProviderGen.INSTANCE;
        }

        abstract Object execute(VirtualFrame var1, PTeeDataObject var2, Object var3, Object var4, Object var5);

        @Specialization(guards={"isNone(values)"})
        static Object init(PTeeDataObject self, Object it, Object values, PNone nxt) {
            InitNode.init(self, it, null);
            return PNone.NONE;
        }

        @Specialization(guards={"isNone(values)"})
        static Object init(PTeeDataObject self, Object it, Object values, PTeeDataObject nxt) {
            InitNode.init(self, it, nxt);
            return PNone.NONE;
        }

        private static void init(PTeeDataObject self, Object it, PTeeDataObject nxt) {
            self.setIt(it);
            self.setValues(new Object[128]);
            self.setNumread(0);
            self.setRunning(false);
            self.setNextlink(nxt);
        }

        @Specialization(guards={"isList(values)"})
        static Object init(VirtualFrame frame, PTeeDataObject self, Object it, PList values, Object nxt, @Bind(value="this") Node inliningTarget, @Cached BuiltinFunctions.LenNode lenNode, @Cached SequenceStorageNodes.GetInternalObjectArrayNode getInternalObjectArrayNode, @Cached InlinedBranchProfile numreadLCProfile, @Cached PRaiseNode.Lazy raiseNode) {
            int numread = (Integer)lenNode.execute(frame, values);
            if (numread == 128) {
                numreadLCProfile.enter(inliningTarget);
                if (!(nxt instanceof PTeeDataObject)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.S_MUST_BE_S, "_tee_dataobject next link", "_tee_dataobject");
                }
            } else {
                if (numread > 128) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.TDATAOBJECT_SHOULD_NOT_HAVE_MORE_LINKS, 128);
                }
                if (!(nxt instanceof PNone)) {
                    throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.TDATAOBJECT_SHOULDNT_HAVE_NEXT);
                }
            }
            self.setIt(it);
            Object[] valuesArray = getInternalObjectArrayNode.execute(inliningTarget, values.getSequenceStorage());
            Object[] obj = new Object[128];
            PythonUtils.arraycopy(valuesArray, 0, obj, 0, numread);
            self.setValues(obj);
            self.setNumread(numread);
            self.setRunning(false);
            self.setNextlink(nxt == PNone.NONE ? null : (PTeeDataObject)nxt);
            return PNone.NONE;
        }

        @Specialization(guards={"!isList(values)", "!isNone(values)"})
        static Object init(VirtualFrame frame, PTeeDataObject self, Object it, Object values, Object nxt, @Cached PRaiseNode raiseNode) {
            throw raiseNode.raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_D_MUST_BE_S_NOT_P, "teedataobject()", 2, "list", values);
        }

        protected LookupAndCallUnaryNode createCopyNode() {
            return LookupAndCallUnaryNode.create(SpecialMethodNames.T___COPY__);
        }
    }
}

