/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.ssl;

import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.exception.BaseExceptionAttrNode;
import com.oracle.graal.python.builtins.objects.exception.ExceptionNodes;
import com.oracle.graal.python.builtins.objects.exception.OsErrorBuiltins;
import com.oracle.graal.python.builtins.objects.exception.PBaseException;
import com.oracle.graal.python.builtins.objects.function.PKeyword;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.ssl.SSLErrorCode;
import com.oracle.graal.python.lib.PyObjectStrAsObjectNode;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.SSLError})
public final class SSLErrorBuiltins
extends PythonBuiltins {
    static final int IDX_REASON = 6;
    static final int IDX_LIB = 7;
    static final int IDX_VERIFY_CODE = 8;
    static final int IDX_VERIFY_MESSAGE = 9;
    static final int SSL_ERR_NUM_ATTRS = 10;
    public static final BaseExceptionAttrNode.StorageFactory SSL_ERROR_ATTR_FACTORY = (args, factory) -> new Object[10];
    public static final TruffleString T_SSL_IN_BRACKETS = PythonUtils.tsLiteral("[SSL]");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return SSLErrorBuiltinsFactory.getFactories();
    }

    public static void setSSLErrorAttributes(PException exception, SSLErrorCode errorCode, TruffleString message) {
        SSLErrorBuiltins.setSSLErrorAttributes((PBaseException)exception.getUnreifiedException(), errorCode, message);
    }

    public static void setSSLErrorAttributes(PBaseException self, SSLErrorCode errorCode, TruffleString message) {
        TruffleString mnemonic;
        Object[] data = new Object[10];
        Object[] attrs = self.getExceptionAttributes();
        if (attrs != null) {
            PythonUtils.arraycopy(attrs, 0, data, 0, attrs.length);
        }
        data[6] = (mnemonic = errorCode.getMnemonic()) != null ? mnemonic : message;
        data[7] = T_SSL_IN_BRACKETS;
        if (errorCode == SSLErrorCode.ERROR_CERT_VERIFICATION) {
            data[8] = 1;
            data[9] = message;
        }
        self.setExceptionAttributes(data);
    }

    @Builtin(name="__str__", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=1)
    @GenerateNodeFactory
    static abstract class StrNode
    extends PythonUnaryBuiltinNode {
        StrNode() {
        }

        @Specialization
        static Object str(VirtualFrame frame, PBaseException self, @Bind(value="this") Node inliningTarget, @Cached PyObjectStrAsObjectNode strNode, @Cached ExceptionNodes.GetArgsNode getArgsNode) {
            Object strerror = self.getExceptionAttribute(1);
            if (PGuards.isString(strerror)) {
                return strerror;
            }
            return strNode.execute((Frame)frame, inliningTarget, getArgsNode.execute(inliningTarget, self));
        }
    }

    @Builtin(name="verify_message", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="exception strerror")
    @GenerateNodeFactory
    public static abstract class SSLErrorVerifyMsgNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 9, SSL_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="verify_code", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="exception strerror")
    @GenerateNodeFactory
    public static abstract class SSLErrorVerifyCodeNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 8, SSL_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="library", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="exception strerror")
    @GenerateNodeFactory
    public static abstract class SSLErrorLibNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 7, SSL_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="reason", minNumOfPositionalArgs=1, maxNumOfPositionalArgs=2, isGetter=true, isSetter=true, doc="exception strerror")
    @GenerateNodeFactory
    public static abstract class SSLErrorReasonNode
    extends PythonBuiltinNode {
        @Specialization
        Object generic(PBaseException self, Object value, @Cached BaseExceptionAttrNode attrNode) {
            return attrNode.execute(self, value, 6, SSL_ERROR_ATTR_FACTORY);
        }
    }

    @Builtin(name="__init__", minNumOfPositionalArgs=1, takesVarArgs=true, takesVarKeywordArgs=true)
    @GenerateNodeFactory
    public static abstract class SSLErrorInitNode
    extends PythonBuiltinNode {
        public abstract Object execute(VirtualFrame var1, PBaseException var2, Object[] var3, PKeyword[] var4);

        @Specialization
        static Object init(VirtualFrame frame, PBaseException self, Object[] args, PKeyword[] kwds, @Cached OsErrorBuiltins.OSErrorInitNode initNode, @Cached PythonObjectFactory factory) {
            initNode.execute(frame, self, args, kwds);
            Object[] sslAttrs = SSL_ERROR_ATTR_FACTORY.create(args, factory);
            PythonUtils.arraycopy(self.getExceptionAttributes(), 0, sslAttrs, 0, self.getExceptionAttributes().length);
            self.setExceptionAttributes(sslAttrs);
            return PNone.NONE;
        }
    }
}

