/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.capi.CExtNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.NativeCAPISymbol;
import com.oracle.graal.python.builtins.objects.cext.capi.PythonClassNativeWrapper;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitionsFactory;
import com.oracle.graal.python.builtins.objects.dict.PDict;
import com.oracle.graal.python.builtins.objects.object.PythonObject;
import com.oracle.graal.python.builtins.objects.tuple.PTuple;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.SpecialAttributeNames;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.graal.python.runtime.object.PythonObjectFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.truffle.api.Assumption;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.object.Shape;
import com.oracle.truffle.api.strings.TruffleString;

public abstract class PythonManagedClass
extends PythonObject
implements PythonAbstractClass {
    @CompilerDirectives.CompilationFinal
    private Object base;
    @CompilerDirectives.CompilationFinal(dimensions=1)
    private PythonAbstractClass[] baseClasses;
    @CompilerDirectives.CompilationFinal
    private MroSequenceStorage methodResolutionOrder;
    private boolean abstractClass;
    private final PDict subClasses;
    @CompilerDirectives.CompilationFinal
    private Shape instanceShape;
    private TruffleString name;
    private TruffleString qualName;
    private int indexedSlotCount;
    Object[] specialMethodSlots;
    private TpSlots tpSlots;
    @CompilerDirectives.CompilationFinal
    protected long methodsFlags = 0L;
    private final boolean needsNativeAllocation;
    @CompilerDirectives.CompilationFinal
    private boolean mroInitialized = false;
    public PTuple mroStore;
    public PTuple basesTuple;

    @CompilerDirectives.TruffleBoundary
    protected PythonManagedClass(PythonLanguage lang, Object typeClass, Shape classShape, Shape instanceShape, TruffleString name, Object base, PythonAbstractClass[] baseClasses, TpSlots slots) {
        this(lang, typeClass, classShape, instanceShape, name, true, true, base, baseClasses, slots);
    }

    @CompilerDirectives.TruffleBoundary
    protected PythonManagedClass(PythonLanguage lang, Object typeClass, Shape classShape, Shape instanceShape, TruffleString name, boolean invokeMro, boolean initDocAttr, Object base, PythonAbstractClass[] baseClasses, TpSlots slots) {
        super(typeClass, classShape);
        this.name = name;
        this.qualName = name;
        this.base = base;
        this.tpSlots = slots;
        this.methodResolutionOrder = new MroSequenceStorage(name, 0);
        if (baseClasses.length == 1 && baseClasses[0] == null) {
            this.baseClasses = new PythonAbstractClass[0];
        } else {
            this.unsafeSetSuperClass(baseClasses);
        }
        this.setMRO(TypeNodes.ComputeMroNode.doSlowPath(this, invokeMro));
        if (invokeMro) {
            this.mroInitialized = true;
        }
        this.needsNativeAllocation = this.computeNeedsNativeAllocation();
        if (initDocAttr) {
            this.setAttribute(SpecialAttributeNames.T___DOC__, PNone.NONE);
        }
        this.instanceShape = instanceShape != null ? instanceShape : lang.getShapeForClass(this);
        this.subClasses = PythonObjectFactory.getUncached().createDict();
    }

    public boolean isMROInitialized() {
        return this.mroInitialized;
    }

    @CompilerDirectives.TruffleBoundary
    public void invokeMro() {
        PythonAbstractClass[] mro = TypeNodes.ComputeMroNode.invokeMro(this);
        if (mro != null) {
            this.setMRO(mro);
        }
        this.mroInitialized = true;
    }

    public Assumption getLookupStableAssumption() {
        return this.methodResolutionOrder.getLookupStableAssumption();
    }

    @Override
    public void lookupChanged() {
        CompilerAsserts.neverPartOfCompilation();
        this.methodResolutionOrder.lookupChanged();
        for (PythonAbstractClass subclass : TypeNodes.GetSubclassesAsArrayNode.executeUncached(this)) {
            if (subclass == null) continue;
            subclass.lookupChanged();
        }
    }

    public int getIndexedSlotCount() {
        return this.indexedSlotCount;
    }

    public void setIndexedSlotCount(int indexedSlotCount) {
        this.indexedSlotCount = indexedSlotCount;
    }

    public final TpSlots getTpSlots() {
        return this.tpSlots;
    }

    public final void setTpSlots(TpSlots tpSlots) {
        this.tpSlots = tpSlots;
    }

    public final Shape getInstanceShape() {
        return this.instanceShape;
    }

    Object getBase() {
        return this.base;
    }

    public void setMRO(PythonAbstractClass[] mro) {
        this.methodResolutionOrder = new MroSequenceStorage(this.name, mro);
    }

    public MroSequenceStorage getMethodResolutionOrder() {
        return this.methodResolutionOrder;
    }

    public TruffleString getQualName() {
        return this.qualName;
    }

    public void setQualName(TruffleString qualName) {
        this.qualName = qualName;
    }

    public TruffleString getName() {
        return this.name;
    }

    public void setName(TruffleString name) {
        this.name = name;
    }

    public boolean isAbstractClass() {
        return this.abstractClass;
    }

    public void setAbstractClass(boolean abstractClass) {
        this.abstractClass = abstractClass;
    }

    private boolean computeNeedsNativeAllocation() {
        for (PythonAbstractClass cls : this.getMethodResolutionOrder().getInternalClassArray()) {
            if (!PGuards.isNativeClass(cls)) continue;
            return true;
        }
        return false;
    }

    @Override
    @CompilerDirectives.TruffleBoundary
    public void setAttribute(TruffleString key, Object value) {
        super.setAttribute(key, value);
        this.onAttributeUpdate(key, value);
    }

    public boolean canSkipOnAttributeUpdate(TruffleString key, Object value, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        return !this.methodResolutionOrder.hasAttributeInMROFinalAssumptions() && !SpecialMethodSlot.canBeSpecial(key, codePointLengthNode, codePointAtIndexNode);
    }

    public final void onAttributeUpdate(Object key, Object value) {
        CompilerAsserts.neverPartOfCompilation();
        if (key instanceof TruffleString) {
            this.onAttributeUpdate((TruffleString)key, value);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void onAttributeUpdate(TruffleString key, Object value) {
        this.methodResolutionOrder.invalidateAttributeInMROFinalAssumptions(key);
        if (TpSlots.canBeSpecialMethod(key, TruffleString.CodePointLengthNode.getUncached(), TruffleString.CodePointAtIndexNode.getUncached())) {
            SpecialMethodSlot slot;
            if (this.tpSlots != null) {
                TpSlots.updateSlot((PythonAbstractClass)this, key);
            }
            if ((slot = SpecialMethodSlot.findSpecialSlotUncached(key)) != null) {
                SpecialMethodSlot.fixupSpecialMethodSlot(this, slot, value);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void setMethodsFlags(long flag) {
        assert (CompilerDirectives.inInterpreter());
        this.methodsFlags |= flag;
    }

    public long getMethodsFlags() {
        return this.methodsFlags;
    }

    private void unsafeSetSuperClass(PythonAbstractClass ... newBaseClasses) {
        CompilerAsserts.neverPartOfCompilation();
        assert (this.getBaseClasses() == null || this.getBaseClasses().length == 0);
        this.baseClasses = newBaseClasses;
        for (PythonAbstractClass base : this.getBaseClasses()) {
            if (!(base instanceof PythonManagedClass) || ((PythonManagedClass)base).mroInitialized) continue;
            throw PRaiseNode.getUncached().raise(PythonBuiltinClassType.TypeError, ErrorMessages.CANNOT_EXTEND_INCOMPLETE_P, base);
        }
        for (PythonAbstractClass base : this.getBaseClasses()) {
            if (base == null) continue;
            if (PGuards.isNativeClass(base)) {
                Object nativeBase = CApiTransitionsFactory.PythonToNativeNodeGen.getUncached().execute(base);
                CExtNodes.PCallCapiFunction.callUncached(NativeCAPISymbol.FUN_TRUFFLE_CHECK_TYPE_READY, nativeBase);
            }
            TypeNodes.GetSubclassesNode.unsafeAddSubclass(base, this);
        }
    }

    @CompilerDirectives.TruffleBoundary
    public final void setBases(Object newBaseClass, PythonAbstractClass[] newBaseClasses) {
        Object oldBase = this.getBase();
        PythonAbstractClass[] oldBaseClasses = this.getBaseClasses();
        PythonAbstractClass[] oldMRO = this.methodResolutionOrder.getInternalClassArray();
        PythonAbstractClass[] subclassesArray = TypeNodes.GetSubclassesAsArrayNode.executeUncached(this);
        PythonAbstractClass[][] oldSubClasssMROs = new PythonAbstractClass[subclassesArray.length][];
        for (int i = 0; i < subclassesArray.length; ++i) {
            PythonAbstractClass scls = subclassesArray[i];
            if (!(scls instanceof PythonManagedClass)) continue;
            oldSubClasssMROs[i] = ((PythonManagedClass)scls).methodResolutionOrder.getInternalClassArray();
        }
        try {
            this.base = newBaseClass;
            this.baseClasses = newBaseClasses;
            this.methodResolutionOrder.lookupChanged();
            this.setMRO(TypeNodes.ComputeMroNode.doSlowPath(this));
            for (PythonAbstractClass scls : subclassesArray) {
                if (!(scls instanceof PythonManagedClass)) continue;
                PythonManagedClass pmc = (PythonManagedClass)scls;
                pmc.methodResolutionOrder.lookupChanged();
                pmc.setMRO(TypeNodes.ComputeMroNode.doSlowPath(scls));
            }
        }
        catch (PException pe) {
            if (this.baseClasses == newBaseClasses) {
                this.base = oldBase;
                this.baseClasses = oldBaseClasses;
            }
            this.methodResolutionOrder.lookupChanged();
            this.setMRO(oldMRO);
            for (int i = 0; i < subclassesArray.length; ++i) {
                PythonAbstractClass scls = subclassesArray[i];
                if (oldSubClasssMROs[i] == null) continue;
                PythonManagedClass pmc = (PythonManagedClass)scls;
                pmc.methodResolutionOrder.lookupChanged();
                pmc.setMRO(oldSubClasssMROs[i]);
            }
            throw pe;
        }
        if (this.baseClasses == newBaseClasses) {
            boolean isCtxInitialized = PythonContext.get(null).isInitialized();
            for (PythonAbstractClass base : oldBaseClasses) {
                if (!(base instanceof PythonManagedClass)) continue;
                if (isCtxInitialized) {
                    TypeNodes.GetSubclassesNode.executeUncached(base).delItem(this);
                    continue;
                }
                TypeNodes.GetSubclassesNode.unsafeRemoveSubclass(base, this);
            }
            for (PythonAbstractClass base : newBaseClasses) {
                if (!(base instanceof PythonManagedClass)) continue;
                if (isCtxInitialized) {
                    TypeNodes.GetSubclassesNode.executeUncached(base).setItem(this, this);
                    continue;
                }
                TypeNodes.GetSubclassesNode.unsafeAddSubclass(base, this);
            }
        }
    }

    final PDict getSubClasses() {
        return this.subClasses;
    }

    @Override
    public String toString() {
        CompilerAsserts.neverPartOfCompilation();
        return String.format("<class '%s'>", this.qualName);
    }

    public final PythonAbstractClass[] getBaseClasses() {
        return this.baseClasses;
    }

    public PythonClassNativeWrapper getClassNativeWrapper() {
        return (PythonClassNativeWrapper)super.getNativeWrapper();
    }

    public boolean needsNativeAllocation() {
        return this.needsNativeAllocation;
    }

    public static boolean isInstance(Object object) {
        return object instanceof PythonClass || object instanceof PythonBuiltinClass;
    }

    public static PythonManagedClass cast(Object object) {
        if (object instanceof PythonClass) {
            return (PythonClass)object;
        }
        return (PythonBuiltinClass)object;
    }

    @CompilerDirectives.TruffleBoundary
    public void setHasSlotsButNoDictFlag() {
        this.instanceShape = PythonLanguage.getShapeForClassWithoutDict(this);
    }
}

