/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.BoundBuiltinCallable;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.cext.PythonAbstractNativeObject;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.PyProcsWrapper;
import com.oracle.graal.python.builtins.objects.cext.common.CExtContext;
import com.oracle.graal.python.builtins.objects.cext.common.NativePointer;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyDef;
import com.oracle.graal.python.builtins.objects.cext.hpy.HPyExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.structs.CFields;
import com.oracle.graal.python.builtins.objects.cext.structs.CStructAccess;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.PythonAbstractClass;
import com.oracle.graal.python.builtins.objects.type.PythonBuiltinClass;
import com.oracle.graal.python.builtins.objects.type.PythonClass;
import com.oracle.graal.python.builtins.objects.type.PythonManagedClass;
import com.oracle.graal.python.builtins.objects.type.TpSlotsFactory;
import com.oracle.graal.python.builtins.objects.type.TypeNodes;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotBinaryFunc;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrGet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotDescrSet;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotGetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotInquiry;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSetAttr;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFun;
import com.oracle.graal.python.nodes.PGuards;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.attributes.LookupAttributeInMRONode;
import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.classes.IsSubtypeNode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.object.GetDictIfExistsNode;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.graal.python.runtime.object.PythonObjectSlowPathFactory;
import com.oracle.graal.python.runtime.sequence.storage.MroSequenceStorage;
import com.oracle.graal.python.util.InlineWeakValueProfile;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerAsserts;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleLogger;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.NeverDefault;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.interop.InteropLibrary;
import com.oracle.truffle.api.interop.UnsupportedMessageException;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

public record TpSlots(TpSlot nb_bool, TpSlot sq_length, TpSlot sq_item, TpSlot mp_length, TpSlot mp_subscript, TpSlot combined_sq_mp_length, TpSlot combined_mp_sq_length, TpSlot tp_descr_get, TpSlot tp_descr_set, TpSlot tp_getattro, TpSlot tp_getattr, TpSlot combined_tp_getattro_getattr, TpSlot tp_setattro, TpSlot tp_setattr, TpSlot combined_tp_setattro_setattr, boolean has_as_number, boolean has_as_sequence, boolean has_as_mapping) {
    private static final TruffleLogger LOGGER = PythonLanguage.getLogger(TpSlot.class);
    private static final LinkedHashMap<TpSlotMeta, TpSlotDef[]> SLOTDEFS;
    private static final Map<TruffleString, List<TpSlotMeta>> SPECIAL2SLOT;
    private static final Map<TruffleString, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>>> SPECIAL2SLOTDEF;

    private static void addSlotDef(LinkedHashMap<TpSlotMeta, TpSlotDef[]> defs, TpSlotMeta slot, TpSlotDef ... slotDefs) {
        defs.put(slot, slotDefs);
    }

    public static TpSlots createEmpty() {
        return TpSlots.newBuilder().build();
    }

    /*
     * Unable to fully structure code
     */
    public static TpSlots fromNative(PythonAbstractNativeObject pythonClass, PythonContext ctx) {
        builder = TpSlots.newBuilder();
        for (TpSlotMeta def : TpSlotMeta.VALUES) {
            if (!def.hasNativeWrapperFactory() || (field = def.readFromNative(pythonClass)) == null) continue;
            interop = InteropLibrary.getUncached((Object)field);
            existingSlotWrapper = null;
            if (interop.isPointer(field)) {
                try {
                    executable = ctx.getCApiContext().getClosureExecutable(interop.asPointer(field));
                    if (executable instanceof PyProcsWrapper.TpSlotWrapper) {
                        existingSlotWrapper = execWrapper = (PyProcsWrapper.TpSlotWrapper)executable;
                    }
                    if (executable == null) ** GOTO lbl19
                    TpSlots.LOGGER.warning((Supplier<String>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$fromNative$2(java.lang.Object ), ()Ljava/lang/String;)((Object)executable));
                }
                catch (UnsupportedMessageException e) {
                    throw new IllegalStateException(e);
                }
            } else if (field instanceof PyProcsWrapper.TpSlotWrapper) {
                existingSlotWrapper = execWrapper = (PyProcsWrapper.TpSlotWrapper)field;
            }
lbl19:
            // 6 sources

            if (existingSlotWrapper != null) {
                newSlot = existingSlot = existingSlotWrapper.getSlot();
                if (existingSlot instanceof TpSlot.TpSlotPython && (newSlot = (newPythonSlot = (pythonSlot = (TpSlot.TpSlotPython)existingSlot).forNewType(pythonClass))) != existingSlot) {
                    newWrapper = existingSlotWrapper.cloneWith(newPythonSlot);
                    TpSlots.toNative(pythonClass, def, newWrapper, (Object)ctx.getNativeNull());
                    field = def.readFromNative(pythonClass);
                }
                if (def.isValidSlotValue(newSlot)) {
                    builder.set(def, newSlot);
                    continue;
                }
            }
            executable = CExtContext.ensureExecutable(field, def.nativeSignature);
            builder.set(def, TpSlot.TpSlotNative.createCExtSlot(executable));
        }
        return builder.build();
    }

    private static void toNative(PythonAbstractNativeObject pythonClass, TpSlotMeta def, TpSlot value, Object nullValue) {
        Object slotNativeValue = def.getNativeValue(value, nullValue);
        TpSlots.toNative(pythonClass, def, slotNativeValue, nullValue);
    }

    private static void toNative(PythonAbstractNativeObject pythonClass, TpSlotMeta def, Object slotNativeValue, Object nullValue) {
        CompilerAsserts.neverPartOfCompilation();
        Object prtToWrite = pythonClass.getPtr();
        CFields fieldToWrite = def.nativeGroupOrField;
        if (def.nativeField != null) {
            prtToWrite = CStructAccess.ReadPointerNode.getUncached().read(prtToWrite, def.nativeGroupOrField);
            if (InteropLibrary.getUncached().isNull(prtToWrite)) {
                if (slotNativeValue == nullValue) {
                    return;
                }
                throw new IllegalStateException("Trying to write a native slot whose group is not allocated. Do we need to update 'updateSlots' to ignore non-allocated groups like CPython?");
            }
            fieldToWrite = def.nativeField;
        }
        CStructAccess.WritePointerNode.getUncached().write(prtToWrite, fieldToWrite, slotNativeValue);
    }

    @CompilerDirectives.TruffleBoundary
    public static void inherit(PythonClass klass, MroSequenceStorage mro) {
        assert (klass.getTpSlots() == null);
        Builder klassSlots = TpSlots.newBuilder();
        for (int i = 0; i < mro.length(); ++i) {
            PythonAbstractClass type = mro.getPythonClassItemNormalized(i);
            TpSlots slots = GetTpSlotsNode.executeUncached(type);
            assert (slots != null || type == klass);
            if (slots == null) continue;
            klassSlots.inherit(slots);
        }
        klass.setTpSlots(klassSlots.build());
    }

    public static boolean canBeSpecialMethod(TruffleString name, TruffleString.CodePointLengthNode codePointLengthNode, TruffleString.CodePointAtIndexNode codePointAtIndexNode) {
        int len = codePointLengthNode.execute((AbstractTruffleString)name, PythonUtils.TS_ENCODING);
        return len > 5 && codePointAtIndexNode.execute((AbstractTruffleString)name, len - 2, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, len - 1, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, 1, PythonUtils.TS_ENCODING) == 95 && codePointAtIndexNode.execute((AbstractTruffleString)name, 0, PythonUtils.TS_ENCODING) == 95;
    }

    public static boolean isSpecialMethod(TruffleString name) {
        CompilerAsserts.neverPartOfCompilation();
        return SPECIAL2SLOT.containsKey(name);
    }

    private static TpSlotMeta resolveSlotdups(Builder slots, TruffleString name) {
        TpSlotMeta found = null;
        for (TpSlotMeta s : SPECIAL2SLOT.get(name)) {
            TpSlot value = slots.get(s);
            if (value == null) continue;
            if (found != null) {
                return null;
            }
            found = s;
        }
        return found;
    }

    @CompilerDirectives.TruffleBoundary
    public static void fixupSlotDispatchers(PythonClass klass) {
        TpSlots.updateSlots((PythonAbstractClass)klass, klass.getTpSlots(), SLOTDEFS.entrySet());
    }

    @CompilerDirectives.TruffleBoundary
    public static void updateAllSlots(PythonAbstractClass klass) {
        TpSlots.updateSlot(klass, SLOTDEFS.entrySet());
    }

    @CompilerDirectives.TruffleBoundary
    public static void updateSlot(PythonAbstractClass klass, TruffleString specialMethodName) {
        Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups = SPECIAL2SLOTDEF.get(specialMethodName);
        if (slotdefGroups == null) {
            return;
        }
        TpSlots.updateSlot(klass, slotdefGroups);
    }

    private static void updateSlot(PythonAbstractClass klass, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups) {
        TpSlots slots = GetTpSlotsNode.executeUncached(klass);
        if (slots == null) {
            return;
        }
        TpSlots.updateSlots(klass, slots, slotdefGroups);
        for (PythonAbstractClass subClass : TypeNodes.GetSubclassesAsArrayNode.executeUncached(klass)) {
            TpSlots.updateSlot(subClass, slotdefGroups);
        }
    }

    private static void updateSlots(PythonAbstractClass klass, TpSlots slots, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups) {
        TpSlots.setSlots(klass, TpSlots.updateSlots(klass, slots.copy(), slotdefGroups).build());
    }

    private static Builder updateSlots(PythonAbstractClass klass, Builder slots, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>> slotdefGroups) {
        LookupAttributeInMRONode.Dynamic lookup = LookupAttributeInMRONode.Dynamic.getUncached();
        IsSubtypeNode isSubType = IsSubtypeNode.getUncached();
        NativePointer nativeNull = null;
        if (klass instanceof PythonAbstractNativeObject) {
            nativeNull = PythonContext.get(null).getNativeNull();
        }
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> slotdefGroup : slotdefGroups) {
            TpSlotMeta slot = slotdefGroup.getKey();
            boolean useGeneric = false;
            PythonFunctionFactory generic = null;
            TpSlot specific = null;
            TpSlotDef[] defs = slotdefGroup.getValue();
            Object[] genericCallables = new Object[defs.length];
            TruffleString[] genericCallablesNames = new TruffleString[defs.length];
            for (int i = 0; i < defs.length; ++i) {
                PBuiltinFunction builtin;
                Object decr;
                TruffleString name = defs[i].name();
                genericCallables[i] = decr = lookup.execute(klass, name);
                genericCallablesNames[i] = name;
                if (decr == PNone.NO_VALUE) continue;
                if (decr instanceof PBuiltinFunction && (builtin = (PBuiltinFunction)decr).getSlot() != null) {
                    boolean canSetSpecific;
                    TpSlotMeta tptr = TpSlots.resolveSlotdups(slots, name);
                    if (tptr == null || tptr == slot) {
                        generic = defs[i].functionFactory;
                    }
                    TpSlot wrappedSlot = builtin.getSlot();
                    boolean bl = canSetSpecific = specific == null || specific == wrappedSlot || TpSlots.areSameNativeCallables(wrappedSlot, specific);
                    if (canSetSpecific && builtin.getSlotWrapper() == defs[i].wrapper() && isSubType.execute(klass, builtin.getEnclosingType())) {
                        specific = wrappedSlot;
                        continue;
                    }
                    useGeneric = true;
                    continue;
                }
                useGeneric = true;
                generic = defs[i].functionFactory;
            }
            if (specific != null && !useGeneric) {
                slots.set(slot, specific);
                continue;
            }
            TpSlot newValue = null;
            if (generic != null) {
                newValue = generic.create(genericCallables, genericCallablesNames, klass);
            }
            slots.set(slot, newValue);
            if (!(klass instanceof PythonAbstractNativeObject)) continue;
            PythonAbstractNativeObject nativeClass = (PythonAbstractNativeObject)klass;
            TpSlots.toNative(nativeClass, slot, newValue, (Object)nativeNull);
        }
        return slots;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean areSameNativeCallables(TpSlot a, TpSlot b) {
        if (!(a instanceof TpSlot.TpSlotNative)) return false;
        TpSlot.TpSlotNative na = (TpSlot.TpSlotNative)a;
        if (!(b instanceof TpSlot.TpSlotNative)) return false;
        TpSlot.TpSlotNative nb = (TpSlot.TpSlotNative)b;
        if (!na.isSameCallable(nb)) return false;
        return true;
    }

    public static void setSlots(PythonAbstractClass klass, TpSlots slots) {
        if (klass instanceof PythonClass) {
            PythonClass pythonClass = (PythonClass)klass;
            pythonClass.setTpSlots(slots);
        } else if (klass instanceof PythonAbstractNativeObject) {
            PythonAbstractNativeObject nativeClass = (PythonAbstractNativeObject)klass;
            nativeClass.setTpSlots(slots);
        } else {
            String name = klass == null ? "null" : klass.getClass().getName();
            throw new AssertionError((Object)("Unexpected type :" + name));
        }
    }

    public static void initializeBuiltinSlots(PythonLanguage language) {
        for (PythonBuiltinClassType klass : PythonBuiltinClassType.VALUES) {
            for (TpSlotMeta slotMeta : TpSlotMeta.VALUES) {
                TpSlot slotValue = slotMeta.getValue(klass.getDeclaredSlots());
                if (slotValue instanceof TpSlot.TpSlotBuiltin) {
                    TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)slotValue;
                    builtinSlot.initialize(language);
                    continue;
                }
                assert (slotValue == null);
            }
        }
    }

    private static boolean checkNoMagicOverrides(Python3Core core, PythonBuiltinClassType type) {
        ReadAttributeFromObjectNode readAttr = ReadAttributeFromObjectNode.getUncachedForceType();
        PythonBuiltinClass typeObj = core.lookupType(type);
        for (TruffleString name : SPECIAL2SLOT.keySet()) {
            assert (readAttr.execute(typeObj, name) == PNone.NO_VALUE) : type.name() + ":" + String.valueOf(name);
        }
        return true;
    }

    public static void addOperatorsToBuiltin(Map<TruffleString, BoundBuiltinCallable<?>> builtins, Python3Core core, PythonBuiltinClassType type) {
        TpSlots slots = type.getDeclaredSlots();
        assert (TpSlots.checkNoMagicOverrides(core, type));
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> slotDefGroup : SLOTDEFS.entrySet()) {
            TpSlotMeta slotMeta = slotDefGroup.getKey();
            TpSlot slotValue = slotMeta.getter.get(slots);
            if (!(slotValue instanceof TpSlot.TpSlotBuiltin)) continue;
            TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)slotValue;
            for (TpSlotDef slotDef : slotDefGroup.getValue()) {
                if (slotDef.wrapper() == null || builtins.containsKey(slotDef.name())) continue;
                PBuiltinFunction value = builtinSlot.createBuiltin(core, (Object)type, slotDef.name(), slotDef.wrapper());
                builtins.put(slotDef.name(), value);
            }
        }
    }

    @CompilerDirectives.TruffleBoundary
    public void addOperators(PythonClass type) {
        assert (GetDictIfExistsNode.getUncached().execute(type) == null);
        PythonContext context = PythonContext.get(null);
        PythonObjectSlowPathFactory factory = context.factory();
        PythonLanguage language = context.getLanguage();
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> slotDefEntry : SLOTDEFS.entrySet()) {
            TpSlotMeta tpSlotMeta = slotDefEntry.getKey();
            for (TpSlotDef tpSlotDef : slotDefEntry.getValue()) {
                Object existingValue;
                TpSlot value;
                if (tpSlotDef.wrapper == null || (value = tpSlotMeta.getValue(this)) == null || !PGuards.isNoValue(existingValue = ReadAttributeFromObjectNode.getUncachedForceType().execute(type, tpSlotDef.name))) continue;
                PBuiltinFunction wrapperDescriptor = null;
                if (value instanceof TpSlot.TpSlotBuiltin) {
                    TpSlot.TpSlotBuiltin builtinSlot = (TpSlot.TpSlotBuiltin)value;
                    wrapperDescriptor = builtinSlot.createBuiltin(context, type, tpSlotDef.name, tpSlotDef.wrapper);
                } else {
                    if (value instanceof TpSlot.TpSlotPython) {
                        throw new IllegalStateException("addOperators: TpSlotPython not implemented yet");
                    }
                    if (value instanceof TpSlot.TpSlotNative) {
                        TpSlot.TpSlotNative nativeSlot = (TpSlot.TpSlotNative)value;
                        if (nativeSlot instanceof TpSlot.TpSlotHPyNative) {
                            TpSlot.TpSlotHPyNative hpySlot = (TpSlot.TpSlotHPyNative)nativeSlot;
                            wrapperDescriptor = HPyExternalFunctionNodes.createWrapperFunction(language, context.getHPyContext(), tpSlotDef.hpyWrapper, hpySlot, tpSlotDef.wrapper, tpSlotDef.name, nativeSlot.getCallable(), type, factory);
                        } else {
                            wrapperDescriptor = ExternalFunctionNodes.PExternalFunctionWrapper.createWrapperFunction(tpSlotDef.name, (TpSlot.TpSlotCExtNative)nativeSlot, type, tpSlotDef.wrapper, language, factory);
                        }
                    }
                }
                assert (wrapperDescriptor != null);
                WriteAttributeToPythonObjectNode.executeUncached(type, tpSlotDef.name, wrapperDescriptor);
            }
        }
    }

    public Builder copy() {
        Builder result = new Builder();
        for (TpSlotMeta def : TpSlotMeta.VALUES) {
            result.set(def, def.getValue(this));
        }
        return result;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static TpSlots merge(TpSlots a, TpSlots b) {
        return a.copy().merge(b).build();
    }

    private static boolean areAssertionsEnabled() {
        boolean enabled = false;
        if (!$assertionsDisabled) {
            enabled = true;
            if (!true) {
                throw new AssertionError();
            }
        }
        return enabled;
    }

    public boolean areEqualTo(TpSlots otherSlots) {
        for (TpSlotMeta def : TpSlotMeta.VALUES) {
            TpSlot otherValue;
            TpSlot thisValue = def.getter.get(this);
            if (thisValue == (otherValue = def.getter.get(otherSlots))) continue;
            return false;
        }
        return true;
    }

    private static /* synthetic */ String lambda$fromNative$2(Object executable) {
        return String.format("Unexpected executable for slot pointer: %s", executable);
    }

    static {
        LinkedHashMap<TpSlotMeta, TpSlotDef[]> s = new LinkedHashMap<TpSlotMeta, TpSlotDef[]>(30);
        TpSlots.addSlotDef(s, TpSlotMeta.TP_GETATTR, TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___GETATTRIBUTE__), TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___GETATTR__));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_SETATTR, TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___SETATTR__), TpSlotDef.withNoFunctionNoWrapper(SpecialMethodNames.T___DELATTR__));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_GETATTRO, TpSlotDef.withoutHPy(SpecialMethodNames.T___GETATTRIBUTE__, TpSlotGetAttr.TpSlotGetAttrPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC), TpSlotDef.withoutHPy(SpecialMethodNames.T___GETATTR__, TpSlotGetAttr.TpSlotGetAttrPython::create, null));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_SETATTRO, TpSlotDef.withoutHPy(SpecialMethodNames.T___SETATTR__, TpSlotSetAttr.TpSlotSetAttrPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.SETATTRO), TpSlotDef.withoutHPy(SpecialMethodNames.T___DELATTR__, TpSlotSetAttr.TpSlotSetAttrPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DELATTRO));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_DESCR_GET, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___GET__, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_GET));
        TpSlots.addSlotDef(s, TpSlotMeta.TP_DESCR_SET, TpSlotDef.withoutHPy(SpecialMethodNames.T___SET__, TpSlotDescrSet.TpSlotDescrSetPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_SET), TpSlotDef.withoutHPy(SpecialMethodNames.T___DELETE__, TpSlotDescrSet.TpSlotDescrSetPython::create, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_DELETE));
        TpSlots.addSlotDef(s, TpSlotMeta.NB_BOOL, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___BOOL__, ExternalFunctionNodes.PExternalFunctionWrapper.INQUIRY));
        TpSlots.addSlotDef(s, TpSlotMeta.MP_LENGTH, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___LEN__, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC, GraalHPyDef.HPySlotWrapper.LENFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.MP_SUBSCRIPT, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___GETITEM__, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, GraalHPyDef.HPySlotWrapper.BINARYFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_LENGTH, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___LEN__, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC, GraalHPyDef.HPySlotWrapper.LENFUNC));
        TpSlots.addSlotDef(s, TpSlotMeta.SQ_ITEM, TpSlotDef.withSimpleFunction(SpecialMethodNames.T___GETITEM__, ExternalFunctionNodes.PExternalFunctionWrapper.GETITEM, GraalHPyDef.HPySlotWrapper.SQ_ITEM));
        SLOTDEFS = s;
        SPECIAL2SLOT = new HashMap<TruffleString, List<TpSlotMeta>>(SLOTDEFS.size() * 2);
        SPECIAL2SLOTDEF = new HashMap<TruffleString, Set<Map.Entry<TpSlotMeta, TpSlotDef[]>>>(SLOTDEFS.size() * 2);
        for (Map.Entry<TpSlotMeta, TpSlotDef[]> e : SLOTDEFS.entrySet()) {
            for (TpSlotDef slotDef : e.getValue()) {
                SPECIAL2SLOT.computeIfAbsent(slotDef.name(), k -> new ArrayList()).add(e.getKey());
                SPECIAL2SLOTDEF.computeIfAbsent(slotDef.name(), k -> new HashSet()).add(e);
            }
        }
    }

    public static final class Builder {
        private final TpSlot[] values = new TpSlot[TpSlotMeta.VALUES.length];

        public Builder set(TpSlotMeta slotMeta, TpSlot value) {
            assert (slotMeta.isValidSlotValue(value)) : String.format("Slot %s is being assigned to type incompatible slot value %s.", slotMeta.name(), value);
            this.values[slotMeta.ordinal()] = value;
            return this;
        }

        public Builder override(TpSlots other) {
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                TpSlot current = this.values[def.ordinal()];
                TpSlot otherValue = def.getter.get(other);
                TpSlot newValue = otherValue != null ? otherValue : current;
                this.set(def, newValue);
            }
            return this;
        }

        private Builder inherit(TpSlots other) {
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                TpSlot current = this.values[def.ordinal()];
                TpSlot otherValue = def.getter.get(other);
                TpSlot newValue = current != null ? current : otherValue;
                this.set(def, newValue);
            }
            return this;
        }

        public Builder merge(TpSlots other) {
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                TpSlot current = this.values[def.ordinal()];
                TpSlot otherValue = def.getter.get(other);
                if (otherValue == null) continue;
                assert (current == null) : def.name();
                this.set(def, otherValue);
            }
            return this;
        }

        private TpSlot fistNonNull(TpSlotMeta a, TpSlotMeta b) {
            return this.values[a.ordinal()] != null ? this.values[a.ordinal()] : this.values[b.ordinal()];
        }

        private TpSlot get(TpSlotMeta s) {
            return this.values[s.ordinal()];
        }

        private boolean hasGroup(TpSlotGroup group) {
            for (TpSlotMeta def : TpSlotMeta.VALUES) {
                if (def.group != group || this.values[def.ordinal()] == null) continue;
                return true;
            }
            return false;
        }

        public TpSlots build() {
            TpSlot sq_mp_length = this.fistNonNull(TpSlotMeta.SQ_LENGTH, TpSlotMeta.MP_LENGTH);
            TpSlot mp_sq_length = this.fistNonNull(TpSlotMeta.MP_LENGTH, TpSlotMeta.SQ_LENGTH);
            TpSlot tp_get_attro_attr = this.fistNonNull(TpSlotMeta.TP_GETATTRO, TpSlotMeta.TP_GETATTR);
            TpSlot tp_set_attro_attr = this.fistNonNull(TpSlotMeta.TP_SETATTRO, TpSlotMeta.TP_SETATTR);
            return new TpSlots(this.get(TpSlotMeta.NB_BOOL), this.get(TpSlotMeta.SQ_LENGTH), this.get(TpSlotMeta.SQ_ITEM), this.get(TpSlotMeta.MP_LENGTH), this.get(TpSlotMeta.MP_SUBSCRIPT), sq_mp_length, mp_sq_length, this.get(TpSlotMeta.TP_DESCR_GET), this.get(TpSlotMeta.TP_DESCR_SET), this.get(TpSlotMeta.TP_GETATTRO), this.get(TpSlotMeta.TP_GETATTR), tp_get_attro_attr, this.get(TpSlotMeta.TP_SETATTRO), this.get(TpSlotMeta.TP_SETATTR), tp_set_attro_attr, this.hasGroup(TpSlotGroup.AS_NUMBER), this.hasGroup(TpSlotGroup.AS_SEQUENCE), this.hasGroup(TpSlotGroup.AS_MAPPING));
        }
    }

    public static final class TpSlotMeta
    extends Enum<TpSlotMeta> {
        public static final /* enum */ TpSlotMeta NB_BOOL = new TpSlotMeta(TpSlots::nb_bool, TpSlot.TpSlotPythonSingle.class, TpSlotInquiry.TpSlotInquiryBuiltin.class, TpSlotGroup.AS_NUMBER, CFields.PyNumberMethods__nb_bool, ExternalFunctionNodes.PExternalFunctionWrapper.INQUIRY, PyProcsWrapper.InquiryWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_LENGTH = new TpSlotMeta(TpSlots::sq_length, TpSlot.TpSlotPythonSingle.class, TpSlotLen.TpSlotLenBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_length, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC, PyProcsWrapper.LenfuncWrapper::new);
        public static final /* enum */ TpSlotMeta SQ_ITEM = new TpSlotMeta(TpSlots::sq_item, TpSlot.TpSlotPythonSingle.class, TpSlotSizeArgFun.TpSlotSizeArgFunBuiltin.class, TpSlotGroup.AS_SEQUENCE, CFields.PySequenceMethods__sq_item, ExternalFunctionNodes.PExternalFunctionWrapper.GETITEM, PyProcsWrapper.SsizeargfuncSlotWrapper::new);
        public static final /* enum */ TpSlotMeta MP_LENGTH = new TpSlotMeta(TpSlots::mp_length, TpSlot.TpSlotPythonSingle.class, TpSlotLen.TpSlotLenBuiltin.class, TpSlotGroup.AS_MAPPING, CFields.PyMappingMethods__mp_length, ExternalFunctionNodes.PExternalFunctionWrapper.LENFUNC, PyProcsWrapper.LenfuncWrapper::new);
        public static final /* enum */ TpSlotMeta MP_SUBSCRIPT = new TpSlotMeta(TpSlots::mp_subscript, TpSlot.TpSlotPythonSingle.class, TpSlotBinaryFunc.TpSlotBinaryFuncBuiltin.class, TpSlotGroup.AS_MAPPING, CFields.PyMappingMethods__mp_subscript, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.BinarySlotFuncWrapper::new);
        public static final /* enum */ TpSlotMeta TP_DESCR_GET = new TpSlotMeta(TpSlots::tp_descr_get, TpSlot.TpSlotPythonSingle.class, TpSlotDescrGet.TpSlotDescrGetBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_descr_get, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_GET, PyProcsWrapper.DescrGetFunctionWrapper::new);
        public static final /* enum */ TpSlotMeta TP_DESCR_SET = new TpSlotMeta(TpSlots::tp_descr_set, TpSlotDescrSet.TpSlotDescrSetPython.class, TpSlotDescrSet.TpSlotDescrSetBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_descr_set, ExternalFunctionNodes.PExternalFunctionWrapper.DESCR_SET, PyProcsWrapper.DescrSetFunctionWrapper::new);
        public static final /* enum */ TpSlotMeta TP_GETATTRO = new TpSlotMeta(TpSlots::tp_getattro, TpSlotGetAttr.TpSlotGetAttrPython.class, TpSlotGetAttr.TpSlotGetAttrBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_getattro, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, PyProcsWrapper.GetAttrWrapper::new);
        public static final /* enum */ TpSlotMeta TP_GETATTR = new TpSlotMeta(TpSlots::tp_getattr, null, null, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_getattr, ExternalFunctionNodes.PExternalFunctionWrapper.GETATTR, new NativeWrapperFactory.ShouldNotReach("tp_getattr"));
        public static final /* enum */ TpSlotMeta TP_SETATTRO = new TpSlotMeta(TpSlots::tp_setattro, TpSlotSetAttr.TpSlotSetAttrPython.class, TpSlotSetAttr.TpSlotSetAttrBuiltin.class, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_setattro, ExternalFunctionNodes.PExternalFunctionWrapper.SETATTRO, PyProcsWrapper.SetattrWrapper::new);
        public static final /* enum */ TpSlotMeta TP_SETATTR = new TpSlotMeta(TpSlots::tp_setattr, null, null, TpSlotGroup.NO_GROUP, CFields.PyTypeObject__tp_setattr, ExternalFunctionNodes.PExternalFunctionWrapper.SETATTR, new NativeWrapperFactory.ShouldNotReach("tp_setattr"));
        public static final TpSlotMeta[] VALUES;
        private final TpSlotGetter getter;
        private final Class<? extends TpSlot.TpSlotPython> permittedPythonSlotClass;
        private final Class<? extends TpSlot.TpSlotBuiltin> permittedBuiltinSlotClass;
        private final TpSlotGroup group;
        private final CFields nativeGroupOrField;
        private final CFields nativeField;
        private final ExternalFunctionNodes.PExternalFunctionWrapper nativeSignature;
        private final NativeWrapperFactory nativeWrapperFactory;
        private static final /* synthetic */ TpSlotMeta[] $VALUES;

        public static TpSlotMeta[] values() {
            return (TpSlotMeta[])$VALUES.clone();
        }

        public static TpSlotMeta valueOf(String name) {
            return Enum.valueOf(TpSlotMeta.class, name);
        }

        private TpSlotMeta(TpSlotGetter getter, Class<? extends TpSlot.TpSlotPython> permittedPythonSlotClass, Class<? extends TpSlot.TpSlotBuiltin> permittedBuiltinSlotClass, TpSlotGroup group, CFields nativeField, ExternalFunctionNodes.PExternalFunctionWrapper nativeSignature, NativeWrapperFactory nativeWrapperFactory) {
            this.permittedPythonSlotClass = permittedPythonSlotClass;
            this.permittedBuiltinSlotClass = permittedBuiltinSlotClass;
            this.nativeWrapperFactory = nativeWrapperFactory;
            this.getter = getter;
            assert (group != null);
            this.group = group;
            if (group == TpSlotGroup.NO_GROUP) {
                this.nativeGroupOrField = nativeField;
                this.nativeField = null;
            } else {
                this.nativeGroupOrField = group.cField;
                this.nativeField = nativeField;
            }
            this.nativeSignature = nativeSignature;
        }

        public boolean isValidSlotValue(Object value) {
            return value == null || value instanceof TpSlot.TpSlotNative || this.permittedBuiltinSlotClass != null && this.permittedBuiltinSlotClass.isAssignableFrom(value.getClass()) || this.permittedPythonSlotClass != null && this.permittedPythonSlotClass.isAssignableFrom(value.getClass());
        }

        public CFields getNativeGroupOrField() {
            return this.nativeGroupOrField;
        }

        public boolean hasGroup() {
            return this.nativeField != null;
        }

        public CFields getNativeField() {
            return this.nativeField;
        }

        public TpSlot getValue(TpSlots slots) {
            return this.getter.get(slots);
        }

        public Object getNativeValue(TpSlots slots, Object defaultValue) {
            return TpSlot.toNative(this, this.getter.get(slots), defaultValue);
        }

        private Object getNativeValue(TpSlot slot, Object defaultValue) {
            return TpSlot.toNative(this, slot, defaultValue);
        }

        public Object readFromNative(PythonAbstractNativeObject pythonClass) {
            Object field = CStructAccess.ReadPointerNode.getUncached().readFromObj(pythonClass, this.nativeGroupOrField);
            InteropLibrary ptrInterop = null;
            if (this.nativeField != null) {
                ptrInterop = InteropLibrary.getUncached((Object)field);
                if (!ptrInterop.isNull(field)) {
                    field = CStructAccess.ReadPointerNode.getUncached().read(field, this.nativeField);
                } else {
                    return null;
                }
            }
            if (PythonUtils.getUncachedInterop(ptrInterop, field).isNull(field)) {
                return null;
            }
            return field;
        }

        public PyProcsWrapper.TpSlotWrapper createNativeWrapper(TpSlot.TpSlotManaged slot) {
            return this.nativeWrapperFactory.create(slot);
        }

        public boolean hasNativeWrapperFactory() {
            return !(this.nativeWrapperFactory instanceof NativeWrapperFactory.Unimplemented);
        }

        public ExternalFunctionNodes.PExternalFunctionWrapper getNativeSignature() {
            return this.nativeSignature;
        }

        public TpSlotGroup getGroup() {
            return this.group;
        }

        private static /* synthetic */ TpSlotMeta[] $values() {
            return new TpSlotMeta[]{NB_BOOL, SQ_LENGTH, SQ_ITEM, MP_LENGTH, MP_SUBSCRIPT, TP_DESCR_GET, TP_DESCR_SET, TP_GETATTRO, TP_GETATTR, TP_SETATTRO, TP_SETATTR};
        }

        static {
            $VALUES = TpSlotMeta.$values();
            VALUES = TpSlotMeta.values();
        }
    }

    @GenerateUncached
    @GenerateInline
    @GenerateCached(value=false)
    public static abstract class GetTpSlotsNode
    extends Node {
        public abstract TpSlots execute(Node var1, Object var2);

        public static TpSlots executeUncached(Object pythonClass) {
            return TpSlotsFactory.GetTpSlotsNodeGen.getUncached().execute(null, pythonClass);
        }

        @Specialization
        static TpSlots doBuiltinType(PythonBuiltinClassType type) {
            return type.getSlots();
        }

        @Specialization
        static TpSlots doManaged(PythonManagedClass klass) {
            return klass.getTpSlots();
        }

        @Specialization
        static TpSlots doNative(Node inliningTarget, PythonAbstractNativeObject nativeKlass, @Cached InlinedBranchProfile slotsNotInitializedProfile) {
            TpSlots tpSlots = nativeKlass.getTpSlots();
            if (CompilerDirectives.injectBranchProbability((double)1.0E-4, (tpSlots == null ? 1 : 0) != 0)) {
                slotsNotInitializedProfile.enter(inliningTarget);
                tpSlots = GetTpSlotsNode.initializeNativeSlots(nativeKlass);
            }
            return tpSlots;
        }

        @CompilerDirectives.TruffleBoundary
        private static TpSlots initializeNativeSlots(PythonAbstractNativeObject nativeKlass) {
            TpSlots tpSlots = TpSlots.fromNative(nativeKlass, PythonContext.get(null));
            nativeKlass.setTpSlots(tpSlots);
            return tpSlots;
        }
    }

    public record TpSlotDef(TruffleString name, PythonFunctionFactory functionFactory, ExternalFunctionNodes.PExternalFunctionWrapper wrapper, GraalHPyDef.HPySlotWrapper hpyWrapper) {
        public static TpSlotDef withoutHPy(TruffleString name, PythonFunctionFactory functionFactory, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return new TpSlotDef(name, functionFactory, wrapper, null);
        }

        public static TpSlotDef withSimpleFunction(TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            return new TpSlotDef(name, SimplePythonWrapper.INSTANCE, wrapper, null);
        }

        public static TpSlotDef withSimpleFunction(TruffleString name, ExternalFunctionNodes.PExternalFunctionWrapper wrapper, GraalHPyDef.HPySlotWrapper hpyWrapper) {
            return new TpSlotDef(name, SimplePythonWrapper.INSTANCE, wrapper, hpyWrapper);
        }

        public static TpSlotDef withNoFunctionNoWrapper(TruffleString name) {
            return new TpSlotDef(name, null, null, null);
        }
    }

    @FunctionalInterface
    public static interface PythonFunctionFactory {
        public TpSlot create(Object[] var1, TruffleString[] var2, Object var3);
    }

    @FunctionalInterface
    private static interface TpSlotGetter {
        public TpSlot get(TpSlots var1);
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @GenerateUncached
    public static abstract class GetObjectSlotsNode
    extends Node {
        public abstract TpSlots execute(Node var1, Object var2);

        public final TpSlots executeCached(Object pythonObject) {
            return this.execute(this, pythonObject);
        }

        @NeverDefault
        public static GetObjectSlotsNode create() {
            return TpSlotsFactory.GetObjectSlotsNodeGen.create();
        }

        @Specialization
        static TpSlots doIt(Node inliningTarget, Object pythonObject, @Cached GetClassNode getClassNode, @Cached GetCachedTpSlotsNode getSlotsNode) {
            return getSlotsNode.execute(inliningTarget, getClassNode.execute(inliningTarget, pythonObject));
        }
    }

    @GenerateInline(inlineByDefault=true)
    @GenerateCached
    @ImportStatic(value={PGuards.class})
    public static abstract class GetCachedTpSlotsNode
    extends Node {
        public abstract TpSlots execute(Node var1, Object var2);

        @Specialization
        static TpSlots doBuiltin(PythonBuiltinClassType klass) {
            return klass.getSlots();
        }

        @Specialization(replaces={"doBuiltin"})
        static TpSlots doOtherCached(Node inliningTarget, Object klass, @Cached InlineWeakValueProfile weakValueProfile, @Cached GetTpSlotsNode getSlots) {
            return weakValueProfile.execute(inliningTarget, getSlots.execute(inliningTarget, klass));
        }

        public static GetCachedTpSlotsNode getUncached() {
            return Uncached.INSTANCE;
        }

        @GenerateCached(value=false)
        private static final class Uncached
        extends GetCachedTpSlotsNode {
            private static final Uncached INSTANCE = new Uncached();

            private Uncached() {
            }

            @Override
            public TpSlots execute(Node inliningTarget, Object pythonClass) {
                return GetTpSlotsNode.executeUncached(pythonClass);
            }
        }
    }

    public static enum TpSlotGroup {
        NO_GROUP(null),
        AS_NUMBER(CFields.PyTypeObject__tp_as_number),
        AS_SEQUENCE(CFields.PyTypeObject__tp_as_sequence),
        AS_MAPPING(CFields.PyTypeObject__tp_as_mapping);

        private final CFields cField;

        private TpSlotGroup(CFields cField) {
            this.cField = cField;
        }
    }

    public static final class SimplePythonWrapper
    implements PythonFunctionFactory {
        private static final SimplePythonWrapper INSTANCE = new SimplePythonWrapper();

        @Override
        public TpSlot create(Object[] callables, TruffleString[] names, Object klass) {
            assert (callables.length == 1);
            assert (callables[0] != PNone.NO_VALUE);
            return new TpSlot.TpSlotPythonSingle(callables[0], klass, names[0]);
        }
    }

    @FunctionalInterface
    private static interface NativeWrapperFactory {
        public PyProcsWrapper.TpSlotWrapper create(TpSlot.TpSlotManaged var1);

        public record ShouldNotReach(String slotName) implements NativeWrapperFactory
        {
            @Override
            public PyProcsWrapper.TpSlotWrapper create(TpSlot.TpSlotManaged slot) {
                throw new IllegalStateException(String.format("Slot %s should never be assigned a managed slot value.", this.slotName));
            }
        }

        public static final class Unimplemented
        implements NativeWrapperFactory {
            @Override
            public PyProcsWrapper.TpSlotWrapper create(TpSlot.TpSlotManaged slot) {
                throw new IllegalStateException("TODO: " + String.valueOf(slot));
            }
        }
    }
}

