/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;

public class TpSlotBinaryFunc {
    private TpSlotBinaryFunc() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotBinaryFuncNode
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "binaryfunc");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, Object var5);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotBinaryFuncBuiltin<?> slot, Object self, Object arg, @Cached(value="slot") TpSlotBinaryFuncBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") PythonBinaryBuiltinNode slotNode) {
            return slotNode.execute(frame, self, arg);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, Object arg, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode dispatcherNode) {
            return dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self, arg);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, Object arg, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode selfToNativeNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode argToNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState state = getThreadStateNode.execute(inliningTarget, ctx);
            TruffleString name = SpecialMethodNames.T___GETITEM__;
            Object result = externalInvokeNode.call(frame, inliningTarget, state, C_API_TIMING, name, slot.callable, selfToNativeNode.execute(self), argToNativeNode.execute(arg));
            return checkResultNode.execute(state, name, toPythonNode.execute(result));
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callHPy(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotHPyNative slot, Object self, Object index, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) GraalHPyNodes.HPyAsHandleNode selfToNativeNode, @Cached(inline=false) GraalHPyNodes.HPyAsHandleNode indexToNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) GraalHPyNodes.HPyAsPythonObjectNode toPythonNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___GETITEM__, slot.callable, ctx.getHPyContext().getBackend(), selfToNativeNode.execute(self), indexToNativeNode.execute(index));
            return checkResultNode.execute(threadState, SpecialMethodNames.T___GETITEM__, toPythonNode.execute(result));
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericComplexBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotBinaryFuncBuiltin<?> slot, Object self, Object arg, @Cached(inline=false) ExecutionContext.CallContext callContext, @Cached InlinedConditionProfile isNullFrameProfile, @Cached(inline=false) IndirectCallNode indirectCallNode) {
            Object[] arguments = PArguments.create(2);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, arg);
            return BuiltinDispatchers.callGenericBuiltin(frame, inliningTarget, slot.callTargetIndex, arguments, callContext, isNullFrameProfile, indirectCallNode);
        }
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class MpSubscriptBuiltinNode
    extends PythonBinaryBuiltinNode {
    }

    public static abstract class TpSlotMpSubscript<T extends PythonBinaryBuiltinNode>
    extends TpSlotBinaryFuncBuiltin<T> {
        protected TpSlotMpSubscript(NodeFactory<T> nodeFactory) {
            super(nodeFactory, ExternalFunctionNodes.PExternalFunctionWrapper.BINARYFUNC, "__getitem__");
        }
    }

    public static abstract class TpSlotBinaryFuncBuiltin<T extends PythonBinaryBuiltinNode>
    extends TpSlot.TpSlotBuiltinBase<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();
        private final String builtinName;

        protected TpSlotBinaryFuncBuiltin(NodeFactory<T> nodeFactory, ExternalFunctionNodes.PExternalFunctionWrapper wrapper, String builtinName) {
            super(nodeFactory, BuiltinSlotWrapperSignature.BINARY, wrapper);
            this.builtinName = builtinName;
        }

        final PythonBinaryBuiltinNode createSlotNode() {
            return (PythonBinaryBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotBinaryFuncBuiltin.createBuiltinCallTarget(language, BuiltinSlotWrapperSignature.BINARY, this.getNodeFactory(), this.builtinName);
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }
    }
}

