/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.type.slots;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.cext.capi.ExternalFunctionNodes;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTiming;
import com.oracle.graal.python.builtins.objects.cext.capi.transitions.CApiTransitions;
import com.oracle.graal.python.builtins.objects.cext.hpy.GraalHPyNodes;
import com.oracle.graal.python.builtins.objects.function.PArguments;
import com.oracle.graal.python.builtins.objects.function.PBuiltinFunction;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.BuiltinSlotWrapperSignature;
import com.oracle.graal.python.builtins.objects.type.slots.NodeFactoryUtils;
import com.oracle.graal.python.builtins.objects.type.slots.PythonDispatchers;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlot;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotLen;
import com.oracle.graal.python.builtins.objects.type.slots.TpSlotSizeArgFunFactory;
import com.oracle.graal.python.lib.PyNumberAsSizeNode;
import com.oracle.graal.python.nodes.SpecialMethodNames;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.runtime.ExecutionContext;
import com.oracle.graal.python.runtime.PythonContext;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.HostCompilerDirectives;
import com.oracle.truffle.api.RootCallTarget;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.nodes.IndirectCallNode;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.Objects;

public class TpSlotSizeArgFun {
    private TpSlotSizeArgFun() {
    }

    @GenerateInline
    @GenerateCached(value=false)
    @GenerateUncached
    public static abstract class CallSlotSizeArgFun
    extends Node {
        private static final CApiTiming C_API_TIMING = CApiTiming.create(true, "ssizeargfun");

        public abstract Object execute(VirtualFrame var1, Node var2, TpSlot var3, Object var4, int var5);

        @Specialization(guards={"cachedSlot == slot"}, limit="3")
        static Object callCachedBuiltin(VirtualFrame frame, TpSlotSizeArgFunBuiltin<?> slot, Object self, int index, @Cached(value="slot") TpSlotSizeArgFunBuiltin<?> cachedSlot, @Cached(value="cachedSlot.createSlotNode()") SizeArgFunBuiltinNode slotNode) {
            return slotNode.execute(frame, self, index);
        }

        @Specialization
        static Object callPython(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotPythonSingle slot, Object self, int index, @Cached PythonDispatchers.BinaryPythonSlotDispatcherNode dispatcherNode) {
            return dispatcherNode.execute(frame, inliningTarget, slot.getCallable(), slot.getType(), self, index);
        }

        @Specialization
        static Object callNative(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotCExtNative slot, Object self, int index, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) CApiTransitions.PythonToNativeNode toNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) CApiTransitions.NativeToPythonTransferNode toPythonNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___GETITEM__, slot.callable, toNativeNode.execute(self), index);
            return checkResultNode.execute(threadState, SpecialMethodNames.T___GETITEM__, toPythonNode.execute(result));
        }

        @Specialization
        @HostCompilerDirectives.InliningCutoff
        static Object callHPy(VirtualFrame frame, Node inliningTarget, TpSlot.TpSlotHPyNative slot, Object self, int index, @Cached.Exclusive @Cached PythonContext.GetThreadStateNode getThreadStateNode, @Cached(inline=false) GraalHPyNodes.HPyAsHandleNode toNativeNode, @Cached.Exclusive @Cached ExternalFunctionNodes.ExternalFunctionInvokeNode externalInvokeNode, @Cached(inline=false) GraalHPyNodes.HPyAsPythonObjectNode toPythonNode, @Cached.Exclusive @Cached(inline=false) ExternalFunctionNodes.PyObjectCheckFunctionResultNode checkResultNode) {
            PythonContext ctx = PythonContext.get(inliningTarget);
            PythonContext.PythonThreadState threadState = getThreadStateNode.execute(inliningTarget, ctx);
            Object result = externalInvokeNode.call(frame, inliningTarget, threadState, C_API_TIMING, SpecialMethodNames.T___GETITEM__, slot.callable, ctx.getHPyContext().getBackend(), toNativeNode.execute(self), index);
            return checkResultNode.execute(threadState, SpecialMethodNames.T___GETITEM__, toPythonNode.execute(result));
        }

        @Specialization(replaces={"callCachedBuiltin"})
        @HostCompilerDirectives.InliningCutoff
        static Object callGenericBuiltin(VirtualFrame frame, Node inliningTarget, TpSlotSizeArgFunBuiltin<?> slot, Object self, int index, @Cached(inline=false) ExecutionContext.CallContext callContext, @Cached InlinedConditionProfile isNullFrameProfile, @Cached(inline=false) IndirectCallNode indirectCallNode) {
            Object[] arguments = PArguments.create(2);
            PArguments.setArgument(arguments, 0, self);
            PArguments.setArgument(arguments, 1, index);
            return BuiltinDispatchers.callGenericBuiltin(frame, inliningTarget, slot.callTargetIndex, arguments, callContext, isNullFrameProfile, indirectCallNode);
        }
    }

    @GenerateInline(value=false)
    public static abstract class FixNegativeIndex
    extends Node {
        public abstract int execute(VirtualFrame var1, int var2, Object var3);

        @Specialization
        static int doIt(VirtualFrame frame, int indexAsSize, Object indexObj, @Bind(value="this") Node inliningTarget, @Cached TpSlots.GetObjectSlotsNode getIndexSlots, @Cached TpSlotLen.CallSlotLenNode callSlotLen) {
            assert (indexAsSize < 0);
            TpSlots indexSlots = getIndexSlots.execute(inliningTarget, indexObj);
            if (indexSlots.sq_length() != null) {
                int len = callSlotLen.execute(frame, inliningTarget, indexSlots.sq_length(), indexObj);
                return indexAsSize + len;
            }
            return indexAsSize;
        }
    }

    public static abstract class WrapSqItemBuiltinNode
    extends PythonBinaryBuiltinNode {
        @Node.Child
        private SizeArgFunBuiltinNode slotNode;
        @Node.Child
        private FixNegativeIndex fixNegativeIndex;

        protected WrapSqItemBuiltinNode(SizeArgFunBuiltinNode slotNode) {
            this.slotNode = slotNode;
        }

        @Specialization(guards={"index >= 0"})
        Object doIntIndex(VirtualFrame frame, Object self, int index) {
            return this.slotNode.execute(frame, self, index);
        }

        @Specialization(replaces={"doIntIndex"})
        Object doGeneric(VirtualFrame frame, Object self, Object index, @Bind(value="this") Node inliningTarget, @Cached PyNumberAsSizeNode asSizeNode) {
            int size = asSizeNode.executeExact((Frame)frame, inliningTarget, index, PythonBuiltinClassType.OverflowError);
            if (size < 0) {
                if (this.fixNegativeIndex == null) {
                    CompilerDirectives.transferToInterpreterAndInvalidate();
                    this.fixNegativeIndex = (FixNegativeIndex)this.insert(TpSlotSizeArgFunFactory.FixNegativeIndexNodeGen.create());
                }
                size = this.fixNegativeIndex.execute(frame, size, index);
            }
            return this.slotNode.execute(frame, self, size);
        }
    }

    public static abstract class SqItemBuiltinNode
    extends SizeArgFunBuiltinNode {
    }

    @GenerateInline(value=false, inherit=true)
    public static abstract class SizeArgFunBuiltinNode
    extends PythonBinaryBuiltinNode {
        @Override
        public final Object execute(VirtualFrame frame, Object arg, Object arg2) {
            return this.execute(frame, arg, (Integer)arg2);
        }

        public abstract Object execute(VirtualFrame var1, Object var2, int var3);
    }

    public static abstract class TpSlotSizeArgFunBuiltin<T extends SizeArgFunBuiltinNode>
    extends TpSlot.TpSlotBuiltin<T> {
        private final int callTargetIndex = TpSlot.TpSlotBuiltinCallTargetRegistry.getNextCallTargetIndex();

        protected TpSlotSizeArgFunBuiltin(NodeFactory<T> nodeFactory) {
            super(nodeFactory);
        }

        final SizeArgFunBuiltinNode createSlotNode() {
            return (SizeArgFunBuiltinNode)((Object)this.createNode());
        }

        @Override
        public void initialize(PythonLanguage language) {
            RootCallTarget target = TpSlotSizeArgFunBuiltin.createBuiltinCallTarget(language, BuiltinSlotWrapperSignature.BINARY, this.getNodeFactory(), "__getitem__");
            language.setBuiltinSlotCallTarget(this.callTargetIndex, target);
        }

        @Override
        public PBuiltinFunction createBuiltin(Python3Core core, Object type, TruffleString tsName, ExternalFunctionNodes.PExternalFunctionWrapper wrapper) {
            switch (wrapper) {
                case GETITEM: {
                    break;
                }
                default: {
                    throw new IllegalStateException(Objects.toString(wrapper));
                }
            }
            return this.createBuiltin(core, type, tsName, BuiltinSlotWrapperSignature.BINARY, wrapper, NodeFactoryUtils.WrapperNodeFactory.wrap(this.getNodeFactory(), WrapSqItemBuiltinNode.class, TpSlotSizeArgFunFactory.WrapSqItemBuiltinNodeGen::create));
        }
    }
}

