/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAccessLibrary;
import com.oracle.graal.python.builtins.objects.buffer.PythonBufferAcquireLibrary;
import com.oracle.graal.python.builtins.objects.floats.FloatUtils;
import com.oracle.graal.python.lib.PyObjectReprAsTruffleStringNode;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.util.CannotCastException;
import com.oracle.graal.python.nodes.util.CastToJavaStringNode;
import com.oracle.graal.python.runtime.IndirectCallData;
import com.oracle.graal.python.runtime.exception.PException;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.frame.Frame;
import com.oracle.truffle.api.frame.VirtualFrame;
import com.oracle.truffle.api.library.CachedLibrary;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.AbstractTruffleString;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
public abstract class PyFloatFromString
extends PNodeWithContext {
    public abstract double execute(Frame var1, Node var2, Object var3);

    public abstract double execute(Frame var1, Node var2, TruffleString var3);

    @Specialization
    static double doString(VirtualFrame frame, Node inliningTarget, TruffleString object, @Cached(inline=false) TruffleString.ToJavaStringNode toJavaStringNode, @Cached.Shared @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
        return PyFloatFromString.convertStringToDouble(frame, inliningTarget, toJavaStringNode.execute((AbstractTruffleString)object), object, reprNode, raiseNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Specialization(limit="3")
    static double doGeneric(VirtualFrame frame, Node inliningTarget, Object object, @Cached(value="createFor(this)") IndirectCallData indirectCallData, @CachedLibrary(value="object") PythonBufferAcquireLibrary acquireLib, @CachedLibrary(limit="3") PythonBufferAccessLibrary accessLib, @Cached(inline=false) CastToJavaStringNode cast, @Cached.Shared @Cached PyObjectReprAsTruffleStringNode reprNode, @Cached.Shared @Cached PRaiseNode.Lazy raiseNode) {
        String string;
        block8: {
            string = null;
            try {
                string = cast.execute(object);
            }
            catch (CannotCastException e) {
                Object buffer = null;
                try {
                    buffer = acquireLib.acquireReadonly(object, frame, indirectCallData);
                }
                catch (PException pException) {
                    // empty catch block
                }
                if (buffer == null) break block8;
                try {
                    byte[] bytes = accessLib.getInternalOrCopiedByteArray(buffer);
                    int len = accessLib.getBufferLength(buffer);
                    string = PyFloatFromString.newString(bytes, 0, len);
                }
                finally {
                    accessLib.release(buffer, frame, indirectCallData);
                }
            }
        }
        if (string != null) {
            return PyFloatFromString.convertStringToDouble(frame, inliningTarget, string, object, reprNode, raiseNode);
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.TypeError, ErrorMessages.ARG_MUST_BE_STRING_OR_NUMBER, "float()", object);
    }

    @CompilerDirectives.TruffleBoundary(allowInlining=true)
    private static String newString(byte[] bytes, int offset, int length) {
        return new String(bytes, offset, length);
    }

    private static double convertStringToDouble(VirtualFrame frame, Node inliningTarget, String src, Object origObj, PyObjectReprAsTruffleStringNode reprNode, PRaiseNode.Lazy raiseNode) {
        TruffleString repr;
        int end;
        int len;
        int offset;
        FloatUtils.StringToDoubleResult res;
        String str = FloatUtils.removeUnicodeAndUnderscores(src);
        if (str != null && (res = FloatUtils.stringToDouble(str, offset = FloatUtils.skipAsciiWhitespace(str, 0, len = str.length()), len)) != null && (end = FloatUtils.skipAsciiWhitespace(str, res.position, len)) == len) {
            return res.value;
        }
        try {
            repr = reprNode.execute((Frame)frame, inliningTarget, origObj);
        }
        catch (PException e) {
            throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError);
        }
        throw raiseNode.get(inliningTarget).raise(PythonBuiltinClassType.ValueError, ErrorMessages.COULD_NOT_CONVERT_STRING_TO_FLOAT, repr);
    }
}

