/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.lib;

import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.objects.PNone;
import com.oracle.graal.python.builtins.objects.type.SpecialMethodSlot;
import com.oracle.graal.python.lib.PyComplexCheckNode;
import com.oracle.graal.python.nodes.PNodeWithContext;
import com.oracle.graal.python.nodes.attributes.LookupCallableSlotInMRONode;
import com.oracle.graal.python.nodes.object.GetClassNode;
import com.oracle.graal.python.nodes.util.LazyInteropLibrary;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Fallback;
import com.oracle.truffle.api.dsl.GenerateCached;
import com.oracle.truffle.api.dsl.GenerateInline;
import com.oracle.truffle.api.dsl.GenerateUncached;
import com.oracle.truffle.api.dsl.ImportStatic;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;

@GenerateUncached
@GenerateInline
@GenerateCached(value=false)
@ImportStatic(value={SpecialMethodSlot.class})
public abstract class PyNumberCheckNode
extends PNodeWithContext {
    public abstract boolean execute(Node var1, Object var2);

    @Specialization
    static boolean doString(TruffleString object) {
        return false;
    }

    @Specialization
    static boolean doDouble(Double object) {
        return true;
    }

    @Specialization
    static boolean doInt(Integer object) {
        return true;
    }

    @Specialization
    static boolean doLong(Long object) {
        return true;
    }

    @Specialization
    static boolean doBoolean(Boolean object) {
        return true;
    }

    @Specialization
    static boolean doNone(PNone object) {
        return false;
    }

    @Fallback
    static boolean doOthers(Node inliningTarget, Object object, @Cached LazyInteropLibrary interopLibrary, @Cached GetClassNode getClassNode, @Cached(parameters={"Index"}, inline=false) LookupCallableSlotInMRONode lookupIndex, @Cached(parameters={"Float"}, inline=false) LookupCallableSlotInMRONode lookupFloat, @Cached(parameters={"Int"}, inline=false) LookupCallableSlotInMRONode lookupInt, @Cached PyComplexCheckNode checkComplex) {
        Object type = getClassNode.execute(inliningTarget, object);
        if (type == PythonBuiltinClassType.ForeignObject) {
            return interopLibrary.get(inliningTarget).isNumber(object);
        }
        return lookupIndex.execute(type) != PNone.NO_VALUE || lookupInt.execute(type) != PNone.NO_VALUE || lookupFloat.execute(type) != PNone.NO_VALUE || checkComplex.execute(inliningTarget, object);
    }
}

