/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.runtime;

import com.oracle.graal.python.nodes.attributes.ReadAttributeFromObjectNode;
import com.oracle.graal.python.nodes.object.IsNode;
import com.oracle.graal.python.runtime.EmulatedPosixSupport;
import com.oracle.graal.python.runtime.EmulatedPosixSupportFactory;
import com.oracle.graal.python.runtime.PosixSupportLibrary;
import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.DSLSupport;
import com.oracle.truffle.api.dsl.GeneratedBy;
import com.oracle.truffle.api.dsl.InlineSupport;
import com.oracle.truffle.api.library.DynamicDispatchLibrary;
import com.oracle.truffle.api.library.LibraryExport;
import com.oracle.truffle.api.library.LibraryFactory;
import com.oracle.truffle.api.nodes.DenyReplace;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.nodes.UnadoptableNode;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Objects;

@GeneratedBy(value=EmulatedPosixSupport.class)
final class EmulatedPosixSupportGen {
    private static final LibraryFactory<DynamicDispatchLibrary> DYNAMIC_DISPATCH_LIBRARY_ = LibraryFactory.resolve(DynamicDispatchLibrary.class);

    private EmulatedPosixSupportGen() {
    }

    static {
        LibraryExport.register(EmulatedPosixSupport.class, (LibraryExport[])new LibraryExport[]{new PosixSupportLibraryExports()});
    }

    @GeneratedBy(value=EmulatedPosixSupport.class)
    private static final class PosixSupportLibraryExports
    extends LibraryExport<PosixSupportLibrary> {
        private PosixSupportLibraryExports() {
            super(PosixSupportLibrary.class, EmulatedPosixSupport.class, false, false, 0);
        }

        protected PosixSupportLibrary createUncached(Object receiver) {
            assert (receiver instanceof EmulatedPosixSupport);
            Uncached uncached = new Uncached();
            return uncached;
        }

        protected PosixSupportLibrary createCached(Object receiver) {
            assert (receiver instanceof EmulatedPosixSupport);
            return new Cached();
        }

        @GeneratedBy(value=EmulatedPosixSupport.class)
        @DenyReplace
        private static final class Uncached
        extends PosixSupportLibrary
        implements UnadoptableNode {
            protected Uncached() {
            }

            @CompilerDirectives.TruffleBoundary
            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof EmulatedPosixSupport) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof EmulatedPosixSupport;
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpid(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return EmulatedPosixSupport.Getpid.getPidFallback(arg0Value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getBackend(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getBackend();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int umask(Object receiver, int mask) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).umask(mask);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString strerror(Object arg0Value_, int arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.strerror(arg1Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int close(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).closeMessage(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int openat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.openat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long write(Object arg0Value_, int arg1Value, PosixSupportLibrary.Buffer arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.write(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.Buffer read(Object arg0Value_, int arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.read(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dup(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).dup(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dup2(Object arg0Value_, int arg1Value, int arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.dup2(arg1Value, arg2Value, arg3Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean getInheritable(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getInheritable(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setInheritable(Object receiver, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).setInheritable(fd, inheritable);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int[] pipe(Object arg0Value_) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.pipeMessage(TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.SelectResult select(Object receiver, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).select(readfds, writefds, errorfds, timeout);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long lseek(Object arg0Value_, int arg1Value, long arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.lseek(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void ftruncate(Object arg0Value_, int arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.ftruncateMessage(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void truncate(Object arg0Value_, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.truncate(arg1Value, arg2Value, (Node)this, TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fsync(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).fsyncMessage(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void flock(Object arg0Value_, int arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.flock(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fcntlLock(Object arg0Value_, int arg1Value, boolean arg2Value, int arg3Value, int arg4Value, long arg5Value, long arg6Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.fcntlLock(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (Node)this, InlinedBranchProfile.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean getBlocking(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getBlocking(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setBlocking(Object arg0Value_, int arg1Value, boolean arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.setBlocking(arg1Value, arg2Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int[] getTerminalSize(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getTerminalSize(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstatat(Object arg0Value_, int arg1Value, Object arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.fstatat(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstat(Object arg0Value_, int arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.fstat(arg1Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] statvfs(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).statvfs(path);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] fstatvfs(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).fstatvfs(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] uname(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.uname(TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unlinkat(Object arg0Value_, int arg1Value, Object arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.unlinkat(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void linkat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.linkat(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void symlinkat(Object arg0Value_, Object arg1Value, int arg2Value, Object arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.symlinkat(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mkdirat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.mkdirat(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object getcwd(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getcwd();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void chdir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.chdir(arg1Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchdir(Object arg0Value_, int arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.fchdir(arg1Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isatty(Object receiver, int fd) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).isatty(fd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object opendir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.opendir(arg1Value, TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object fdopendir(Object arg0Value_, int arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.fdopendir(arg1Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void closedir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.closedir(arg1Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readdir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.readdir(arg1Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void rewinddir(Object receiver, Object dirStream) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).rewinddir(dirStream);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object dirEntryGetName(Object receiver, Object dirEntry) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).dirEntryGetName(dirEntry);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object dirEntryGetPath(Object arg0Value_, Object arg1Value, Object arg2Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.dirEntryGetPath(arg1Value, arg2Value, TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long dirEntryGetInode(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.dirEntryGetInode(arg1Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dirEntryGetType(Object receiver, Object dirEntry) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).dirEntryGetType(dirEntry);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void utimensat(Object arg0Value_, int arg1Value, Object arg2Value, long[] arg3Value, boolean arg4Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.utimensat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, EmulatedPosixSupportFactory.SetUTimeNodeGen.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void futimens(Object arg0Value_, int arg1Value, long[] arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.futimens(arg1Value, arg2Value, (Node)this, EmulatedPosixSupportFactory.SetUTimeNodeGen.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void futimes(Object arg0Value_, int arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.futimes(arg1Value, arg2Value, (Node)this, EmulatedPosixSupportFactory.SetUTimeNodeGen.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void lutimes(Object arg0Value_, Object arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.lutimes(arg1Value, arg2Value, (Node)this, EmulatedPosixSupportFactory.SetUTimeNodeGen.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void utimes(Object arg0Value_, Object arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.utimes(arg1Value, arg2Value, (Node)this, EmulatedPosixSupportFactory.SetUTimeNodeGen.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void renameat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, Object arg4Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.renameat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean faccessat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, boolean arg4Value, boolean arg5Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.faccessat(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)this, InlinedBranchProfile.getUncached(), InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchmodat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, boolean arg4Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.fchmodat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchmod(Object arg0Value_, int arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.fchmod(arg1Value, arg2Value, TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchownat(Object receiver, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).fchownat(dirFd, pathname, owner, group, followSymlinks);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void fchown(Object receiver, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).fchown(fd, owner, group);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object readlinkat(Object arg0Value_, int arg1Value, Object arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.readlinkat(arg1Value, arg2Value, (Node)this, InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached(), TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void kill(Object arg0Value_, long arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.kill(arg1Value, arg2Value, ReadAttributeFromObjectNode.getUncached(), IsNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void killpg(Object receiver, long pid, int signal) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).killpg(pid, signal);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] waitpid(Object arg0Value_, long arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.waitpid(arg1Value, arg2Value, this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void abort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.abort(this);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wcoredump(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wcoredump(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifcontinued(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wifcontinued(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifstopped(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wifstopped(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifsignaled(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wifsignaled(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean wifexited(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wifexited(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wexitstatus(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wexitstatus(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wtermsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wtermsig(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int wstopsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).wstopsig(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getuid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long geteuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).geteuid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getgid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getgid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getegid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getegid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getppid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getppid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpgid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getpgid(pid);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setpgid(Object receiver, long pid, long pgid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).setpgid(pid, pgid);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getpgrp(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getpgrp();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getsid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getsid(pid);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long setsid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).setsid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] getgroups(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getgroups();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RusageResult getrusage(Object receiver, int who) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getrusage(who);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.OpenPtyResult openpty(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).openpty();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString ctermid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).ctermid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setenv(Object receiver, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).setenv(name, value, overwrite);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unsetenv(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).unsetenv(name);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int forkExec(Object arg0Value_, Object[] arg1Value, Object[] arg2Value, Object arg3Value, Object[] arg4Value, int arg5Value, int arg6Value, int arg7Value, int arg8Value, int arg9Value, int arg10Value, int arg11Value, int arg12Value, boolean arg13Value, boolean arg14Value, boolean arg15Value, int[] arg16Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.forkExec(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, arg13Value, arg14Value, arg15Value, arg16Value, TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void execv(Object arg0Value_, Object arg1Value, Object[] arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.execv(arg1Value, arg2Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int system(Object receiver, Object command) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).system(command);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object mmap(Object arg0Value_, long arg1Value, int arg2Value, int arg3Value, int arg4Value, long arg5Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.mmap(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)this, InlinedConditionProfile.getUncached(), TruffleString.EqualNode.getUncached(), TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte mmapReadByte(Object arg0Value_, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.mmapReadByte(arg1Value, arg2Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapWriteByte(Object arg0Value_, Object arg1Value, long arg2Value, byte arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.mmapWriteByte(arg1Value, arg2Value, arg3Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int mmapReadBytes(Object arg0Value_, Object arg1Value, long arg2Value, byte[] arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.mmapReadBytes(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapWriteBytes(Object arg0Value_, Object arg1Value, long arg2Value, byte[] arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.mmapWriteBytes(arg1Value, arg2Value, arg3Value, arg4Value, (Node)this, InlinedBranchProfile.getUncached(), TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapFlush(Object receiver, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).mmapFlush(mmap, offset, length);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void mmapUnmap(Object arg0Value_, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                arg0Value.mmapUnmap(arg1Value, arg2Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long mmapGetPointer(Object receiver, Object mmap) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).mmapGetPointer(mmap);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString crypt(Object receiver, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).crypt(word, salt);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long semOpen(Object receiver, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).semOpen(name, openFlags, mode, value);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semClose(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).semClose(handle);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semUnlink(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).semUnlink(name);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int semGetValue(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).semGetValue(handle);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semPost(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).semPost(handle);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void semWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).semWait(handle);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean semTryWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).semTryWait(handle);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean semTimedWait(Object receiver, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).semTimedWait(handle, deadlineNs);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwuid(Object receiver, long uid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getpwuid(uid);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwnam(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getpwnam(name);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean hasGetpwentries(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).hasGetpwentries();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getpwentries();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int ioctlBytes(Object receiver, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).ioctlBytes(fd, request, arg);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int ioctlInt(Object receiver, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).ioctlInt(fd, request, arg);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int socket(Object arg0Value_, int arg1Value, int arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.socket(arg1Value, arg2Value, arg3Value, TruffleString.EqualNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AcceptResult accept(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).accept(sockfd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void bind(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).bind(sockfd, addr);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void connect(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).connect(sockfd, addr);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void listen(Object receiver, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).listen(sockfd, backlog);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getpeername(sockfd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getsockname(sockfd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int send(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).send(sockfd, buf, offset, len, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int sendto(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).sendto(sockfd, buf, offset, len, flags, destAddr);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int recv(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).recv(sockfd, buf, offset, len, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).recvfrom(sockfd, buf, offset, len, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void shutdown(Object receiver, int sockfd, int how) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).shutdown(sockfd, how);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getsockopt(sockfd, level, optname, optval, optlen);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                ((EmulatedPosixSupport)receiver).setsockopt(sockfd, level, optname, optval, optlen);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_addr(Object receiver, Object src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).inet_addr(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_aton(Object receiver, Object src) throws PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).inet_aton(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntoa(Object receiver, int address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).inet_ntoa(address);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte[] inet_pton(Object receiver, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).inet_pton(family, src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntop(Object receiver, int family, byte[] src) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).inet_ntop(family, src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object gethostname(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).gethostname();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] getnameinfo(Object receiver, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getnameinfo(addr, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getaddrinfo(node, service, family, sockType, protocol, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver, PosixSupportLibrary.Inet4SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).createUniversalSockAddrInet4(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver, PosixSupportLibrary.Inet6SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).createUniversalSockAddrInet6(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).createUniversalSockAddrUnix(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createPathFromString(Object arg0Value_, TruffleString arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.createPathFromString(arg1Value, TruffleString.ToJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object createPathFromBytes(Object receiver, byte[] path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).createPathFromBytes(path);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public TruffleString getPathAsString(Object arg0Value_, Object arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                return arg0Value.getPathAsString(arg1Value, TruffleString.FromJavaStringNode.getUncached());
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver, Object path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                return ((EmulatedPosixSupport)receiver).getPathAsBytes(path);
            }
        }

        @GeneratedBy(value=EmulatedPosixSupport.class)
        private static final class Cached
        extends PosixSupportLibrary {
            private static final InlineSupport.StateField STATE_1_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlineSupport.StateField STATE_2_UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_2_");
            private static final InlineSupport.StateField STATE_1_LseekNode__UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlineSupport.StateField STATE_1_FstatatNode__UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlineSupport.StateField STATE_1_FstatNode__UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_1_");
            private static final InlineSupport.StateField STATE_2_FstatNode__UPDATER = InlineSupport.StateField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"state_2_");
            private static final InlinedBranchProfile INLINED_ERROR_BRANCH = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_UPDATER.subUpdater(17, 1)}));
            private static final InlinedConditionProfile INLINED_DEFAULT_DIR_PROFILE = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_UPDATER.subUpdater(18, 2)}));
            private static final EmulatedPosixSupport.SetUTimeNode INLINED_SET_U_TIME = EmulatedPosixSupportFactory.SetUTimeNodeGen.inline(InlineSupport.InlineTarget.create(EmulatedPosixSupport.SetUTimeNode.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_2_UPDATER.subUpdater(2, 3), InlineSupport.ReferenceField.create((MethodHandles.Lookup)MethodHandles.lookup(), (String)"setUTime_field1_", Node.class)}));
            private static final InlinedBranchProfile INLINED_LSEEK_NODE__LSEEK_ERROR_BRANCH_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_LseekNode__UPDATER.subUpdater(20, 1)}));
            private static final InlinedConditionProfile INLINED_LSEEK_NODE__LSEEK_NOT_SUPPORTED_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_LseekNode__UPDATER.subUpdater(21, 2)}));
            private static final InlinedConditionProfile INLINED_LSEEK_NODE__LSEEK_NO_FILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_LseekNode__UPDATER.subUpdater(23, 2)}));
            private static final InlinedConditionProfile INLINED_LSEEK_NODE__LSEEK_NOT_SEEKABLE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_LseekNode__UPDATER.subUpdater(25, 2)}));
            private static final InlinedBranchProfile INLINED_FSTATAT_NODE__FSTATAT_ERROR_BRANCH_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_FstatatNode__UPDATER.subUpdater(27, 1)}));
            private static final InlinedConditionProfile INLINED_FSTATAT_NODE__FSTATAT_DEFAULT_DIR_FD_POFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_FstatatNode__UPDATER.subUpdater(28, 2)}));
            private static final InlinedBranchProfile INLINED_FSTAT_NODE__FSTAT_NULL_PATH_PROFILE_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_FstatNode__UPDATER.subUpdater(30, 1)}));
            private static final InlinedBranchProfile INLINED_FSTAT_NODE__FSTAT_ERROR_BRANCH_ = InlinedBranchProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedBranchProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_1_FstatNode__UPDATER.subUpdater(31, 1)}));
            private static final InlinedConditionProfile INLINED_FSTAT_NODE__FSTAT_DEFAULT_DIR_FD_POFILE_ = InlinedConditionProfile.inline((InlineSupport.InlineTarget)InlineSupport.InlineTarget.create(InlinedConditionProfile.class, (InlineSupport.InlinableField[])new InlineSupport.InlinableField[]{STATE_2_FstatNode__UPDATER.subUpdater(0, 2)}));
            @CompilerDirectives.CompilationFinal
            private int state_0_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_1_;
            @CompilerDirectives.CompilationFinal
            @InlineSupport.UnsafeAccessedField
            private int state_2_;
            @Node.Child
            private TruffleString.EqualNode eq;
            @Node.Child
            private TruffleString.FromJavaStringNode js2ts;
            @Node.Child
            private TruffleString.ToJavaStringNode ts2js;
            @Node.Child
            @InlineSupport.UnsafeAccessedField
            private Node setUTime_field1_;
            @Node.Child
            private KillNode_KillData killNode__kill_cache;

            protected Cached() {
            }

            public boolean accepts(Object receiver) {
                assert (!(receiver instanceof EmulatedPosixSupport) || ((DynamicDispatchLibrary)DYNAMIC_DISPATCH_LIBRARY_.getUncached()).dispatch(receiver) == null) : "Invalid library export. Exported receiver with dynamic dispatch found but not expected.";
                return receiver instanceof EmulatedPosixSupport;
            }

            @Override
            public long getpid(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 5) != 0) {
                    if ((state_0 & 1) != 0) {
                        try {
                            return EmulatedPosixSupport.Getpid.getPid(arg0Value);
                        }
                        catch (Exception ex) {
                            CompilerDirectives.transferToInterpreterAndInvalidate();
                            state_0 = this.state_0_;
                            state_0 &= 0xFFFFFFFE;
                            this.state_0_ = state_0 |= 2;
                            return this.getpidAndSpecialize(arg0Value);
                        }
                    }
                    if ((state_0 & 4) != 0) {
                        return EmulatedPosixSupport.Getpid.getPidFallback(arg0Value);
                    }
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getpidAndSpecialize(arg0Value);
            }

            private long getpidAndSpecialize(EmulatedPosixSupport arg0Value) {
                int state_0 = this.state_0_;
                if ((state_0 & 4) == 0 && (state_0 & 2) == 0) {
                    this.state_0_ = state_0 |= 1;
                    try {
                        return EmulatedPosixSupport.Getpid.getPid(arg0Value);
                    }
                    catch (Exception ex) {
                        CompilerDirectives.transferToInterpreterAndInvalidate();
                        state_0 = this.state_0_;
                        state_0 &= 0xFFFFFFFE;
                        this.state_0_ = state_0 |= 2;
                        return this.getpidAndSpecialize(arg0Value);
                    }
                }
                state_0 &= 0xFFFFFFFE;
                this.state_0_ = state_0 |= 4;
                return EmulatedPosixSupport.Getpid.getPidFallback(arg0Value);
            }

            @Override
            public TruffleString getBackend(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getBackend();
            }

            @Override
            public int umask(Object receiver, int mask) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).umask(mask);
            }

            @Override
            public TruffleString strerror(Object arg0Value_, int arg1Value) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                Cached inliningTarget__ = this;
                return arg0Value.strerror(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH);
            }

            @Override
            public int close(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).closeMessage(fd);
            }

            @Override
            public int openat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 8) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.openat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.openatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private int openatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, int arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 8;
                return arg0Value.openat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public long write(Object arg0Value_, int arg1Value, PosixSupportLibrary.Buffer arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.write(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.writeNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private long writeNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, PosixSupportLibrary.Buffer arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x10;
                return arg0Value.write(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public PosixSupportLibrary.Buffer read(Object arg0Value_, int arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.read(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private PosixSupportLibrary.Buffer readNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x20;
                return arg0Value.read(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public int dup(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).dup(fd);
            }

            @Override
            public int dup2(Object arg0Value_, int arg1Value, int arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40) != 0 && (eq_ = this.eq) != null) {
                    return arg0Value.dup2(arg1Value, arg2Value, arg3Value, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.dup2Node_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int dup2Node_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, int arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x40;
                return arg0Value.dup2(arg1Value, arg2Value, arg3Value, eq_);
            }

            @Override
            public boolean getInheritable(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getInheritable(fd);
            }

            @Override
            public void setInheritable(Object receiver, int fd, boolean inheritable) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).setInheritable(fd, inheritable);
            }

            @Override
            public int[] pipe(Object arg0Value_) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80) != 0 && (eq_ = this.eq) != null) {
                    return arg0Value.pipeMessage(eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.pipeMessageNode_AndSpecialize(arg0Value);
            }

            private int[] pipeMessageNode_AndSpecialize(EmulatedPosixSupport arg0Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x80;
                return arg0Value.pipeMessage(eq_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.SelectResult select(Object receiver, int[] readfds, int[] writefds, int[] errorfds, PosixSupportLibrary.Timeval timeout) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).select(readfds, writefds, errorfds, timeout);
            }

            @Override
            public long lseek(Object arg0Value_, int arg1Value, long arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.lseek(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_LSEEK_NODE__LSEEK_ERROR_BRANCH_, INLINED_LSEEK_NODE__LSEEK_NOT_SUPPORTED_, INLINED_LSEEK_NODE__LSEEK_NO_FILE_, INLINED_LSEEK_NODE__LSEEK_NOT_SEEKABLE_, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.lseekNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private long lseekNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, long arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x100;
                return arg0Value.lseek(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_LSEEK_NODE__LSEEK_ERROR_BRANCH_, INLINED_LSEEK_NODE__LSEEK_NOT_SUPPORTED_, INLINED_LSEEK_NODE__LSEEK_NO_FILE_, INLINED_LSEEK_NODE__LSEEK_NOT_SEEKABLE_, eq_);
            }

            @Override
            public void ftruncate(Object arg0Value_, int arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.ftruncateMessage(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.ftruncateMessageNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void ftruncateMessageNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x200;
                arg0Value.ftruncateMessage(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public void truncate(Object arg0Value_, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.truncate(arg1Value, arg2Value, (Node)inliningTarget__, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.truncateNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void truncateNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x400;
                arg0Value.truncate(arg1Value, arg2Value, (Node)inliningTarget__, eq_, js2ts_);
            }

            @Override
            public void fsync(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).fsyncMessage(fd);
            }

            @Override
            public void flock(Object arg0Value_, int arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                Cached inliningTarget__ = this;
                arg0Value.flock(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH);
            }

            @Override
            public void fcntlLock(Object arg0Value_, int arg1Value, boolean arg2Value, int arg3Value, int arg4Value, long arg5Value, long arg6Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                Cached inliningTarget__ = this;
                arg0Value.fcntlLock(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH);
            }

            @Override
            public boolean getBlocking(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getBlocking(fd);
            }

            @Override
            public void setBlocking(Object arg0Value_, int arg1Value, boolean arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800) != 0 && (eq_ = this.eq) != null) {
                    arg0Value.setBlocking(arg1Value, arg2Value, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.setBlockingNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void setBlockingNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, boolean arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x800;
                arg0Value.setBlocking(arg1Value, arg2Value, eq_);
            }

            @Override
            public int[] getTerminalSize(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getTerminalSize(fd);
            }

            @Override
            public long[] fstatat(Object arg0Value_, int arg1Value, Object arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.fstatat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_FSTATAT_NODE__FSTATAT_ERROR_BRANCH_, INLINED_FSTATAT_NODE__FSTATAT_DEFAULT_DIR_FD_POFILE_, eq_, js2ts_, ts2js_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fstatatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private long[] fstatatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 0x1000;
                return arg0Value.fstatat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_FSTATAT_NODE__FSTATAT_ERROR_BRANCH_, INLINED_FSTATAT_NODE__FSTATAT_DEFAULT_DIR_FD_POFILE_, eq_, js2ts_, ts2js_);
            }

            @Override
            public long[] fstat(Object arg0Value_, int arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.fstat(arg1Value, (Node)inliningTarget__, INLINED_FSTAT_NODE__FSTAT_NULL_PATH_PROFILE_, INLINED_FSTAT_NODE__FSTAT_ERROR_BRANCH_, INLINED_FSTAT_NODE__FSTAT_DEFAULT_DIR_FD_POFILE_, eq_, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fstatNode_AndSpecialize(arg0Value, arg1Value);
            }

            private long[] fstatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x2000;
                return arg0Value.fstat(arg1Value, (Node)inliningTarget__, INLINED_FSTAT_NODE__FSTAT_NULL_PATH_PROFILE_, INLINED_FSTAT_NODE__FSTAT_ERROR_BRANCH_, INLINED_FSTAT_NODE__FSTAT_DEFAULT_DIR_FD_POFILE_, eq_, js2ts_);
            }

            @Override
            public long[] statvfs(Object receiver, Object path) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).statvfs(path);
            }

            @Override
            public long[] fstatvfs(Object receiver, int fd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).fstatvfs(fd);
            }

            @Override
            public Object[] uname(Object arg0Value_) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000) != 0 && (js2ts_ = this.js2ts) != null) {
                    return arg0Value.uname(js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.unameNode_AndSpecialize(arg0Value);
            }

            private Object[] unameNode_AndSpecialize(EmulatedPosixSupport arg0Value) {
                TruffleString.FromJavaStringNode js2ts_;
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode js2ts__shared = this.js2ts;
                if (js2ts__shared != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x4000;
                return arg0Value.uname(js2ts_);
            }

            @Override
            public void unlinkat(Object arg0Value_, int arg1Value, Object arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.unlinkat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.unlinkatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void unlinkatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, boolean arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 0x8000;
                arg0Value.unlinkat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void linkat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.linkat(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.linkatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private void linkatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, int arg3Value, Object arg4Value, int arg5Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 0x10000;
                arg0Value.linkat(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void symlinkat(Object arg0Value_, Object arg1Value, int arg2Value, Object arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.symlinkat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.symlinkatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void symlinkatNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, int arg2Value, Object arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 0x20000;
                arg0Value.symlinkat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void mkdirat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.mkdirat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.mkdiratNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void mkdiratNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 0x40000;
                arg0Value.mkdirat(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public Object getcwd(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getcwd();
            }

            @Override
            public void chdir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x80000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.chdir(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.chdirNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void chdirNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x80000;
                arg0Value.chdir(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_, js2ts_);
            }

            @Override
            public void fchdir(Object arg0Value_, int arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x100000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.fchdir(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fchdirNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void fchdirNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x100000;
                arg0Value.fchdir(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_, js2ts_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public boolean isatty(Object receiver, int fd) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).isatty(fd);
            }

            @Override
            public Object opendir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x200000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    return arg0Value.opendir(arg1Value, eq_, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.opendirNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object opendirNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x200000;
                return arg0Value.opendir(arg1Value, eq_, js2ts_);
            }

            @Override
            public Object fdopendir(Object arg0Value_, int arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x400000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.fdopendir(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.fdopendirNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object fdopendirNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x400000;
                return arg0Value.fdopendir(arg1Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_, js2ts_);
            }

            @Override
            public void closedir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x800000) != 0 && (eq_ = this.eq) != null) {
                    arg0Value.closedir(arg1Value, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.closedirNode_AndSpecialize(arg0Value, arg1Value);
            }

            private void closedirNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x800000;
                arg0Value.closedir(arg1Value, eq_);
            }

            @Override
            public Object readdir(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x1000000) != 0 && (eq_ = this.eq) != null) {
                    return arg0Value.readdir(arg1Value, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readdirNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object readdirNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x1000000;
                return arg0Value.readdir(arg1Value, eq_);
            }

            @Override
            public void rewinddir(Object receiver, Object dirStream) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).rewinddir(dirStream);
            }

            @Override
            public Object dirEntryGetName(Object receiver, Object dirEntry) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).dirEntryGetName(dirEntry);
            }

            @Override
            public Object dirEntryGetPath(Object arg0Value_, Object arg1Value, Object arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x2000000) != 0 && (js2ts_ = this.js2ts) != null) {
                    return arg0Value.dirEntryGetPath(arg1Value, arg2Value, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.dirEntryGetPathNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object dirEntryGetPathNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, Object arg2Value) {
                TruffleString.FromJavaStringNode js2ts_;
                int state_0 = this.state_0_;
                TruffleString.FromJavaStringNode js2ts__shared = this.js2ts;
                if (js2ts__shared != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x2000000;
                return arg0Value.dirEntryGetPath(arg1Value, arg2Value, js2ts_);
            }

            @Override
            public long dirEntryGetInode(Object arg0Value_, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x4000000) != 0 && (eq_ = this.eq) != null) {
                    return arg0Value.dirEntryGetInode(arg1Value, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.dirEntryGetInodeNode_AndSpecialize(arg0Value, arg1Value);
            }

            private long dirEntryGetInodeNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_0_ = state_0 |= 0x4000000;
                return arg0Value.dirEntryGetInode(arg1Value, eq_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int dirEntryGetType(Object receiver, Object dirEntry) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).dirEntryGetType(dirEntry);
            }

            @Override
            public void utimensat(Object arg0Value_, int arg1Value, Object arg2Value, long[] arg3Value, boolean arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x8000000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.utimensat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_SET_U_TIME, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.utimensatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void utimensatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, long[] arg3Value, boolean arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_0_ = state_0 |= 0x8000000;
                arg0Value.utimensat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_SET_U_TIME, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void futimens(Object arg0Value_, int arg1Value, long[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x10000000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.futimens(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.futimensNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void futimensNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, long[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x10000000;
                arg0Value.futimens(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
            }

            @Override
            public void futimes(Object arg0Value_, int arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x20000000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.futimes(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.futimesNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void futimesNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x20000000;
                arg0Value.futimes(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
            }

            @Override
            public void lutimes(Object arg0Value_, Object arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & 0x40000000) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.lutimes(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.lutimesNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void lutimesNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= 0x40000000;
                arg0Value.lutimes(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
            }

            @Override
            public void utimes(Object arg0Value_, Object arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_0 = this.state_0_;
                if ((state_0 & Integer.MIN_VALUE) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.utimes(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.utimesNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void utimesNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, PosixSupportLibrary.Timeval[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_0 = this.state_0_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_0_ = state_0 |= Integer.MIN_VALUE;
                arg0Value.utimes(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_SET_U_TIME, eq_, js2ts_);
            }

            @Override
            public void renameat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, Object arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 1) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.renameat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.renameatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void renameatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, int arg3Value, Object arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_1_ = state_1 |= 1;
                arg0Value.renameat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public boolean faccessat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, boolean arg4Value, boolean arg5Value) {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 2) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.faccessat(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.faccessatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private boolean faccessatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, int arg3Value, boolean arg4Value, boolean arg5Value) {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_1_ = state_1 |= 2;
                return arg0Value.faccessat(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void fchmodat(Object arg0Value_, int arg1Value, Object arg2Value, int arg3Value, boolean arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 4) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.fchmodat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fchmodatNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void fchmodatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value, int arg3Value, boolean arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_1_ = state_1 |= 4;
                arg0Value.fchmodat(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void fchmod(Object arg0Value_, int arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 8) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    arg0Value.fchmod(arg1Value, arg2Value, eq_, js2ts_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.fchmodNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void fchmodNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_1_ = state_1 |= 8;
                arg0Value.fchmod(arg1Value, arg2Value, eq_, js2ts_);
            }

            @Override
            public void fchownat(Object receiver, int dirFd, Object pathname, long owner, long group, boolean followSymlinks) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).fchownat(dirFd, pathname, owner, group, followSymlinks);
            }

            @Override
            public void fchown(Object receiver, int fd, long owner, long group) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).fchown(fd, owner, group);
            }

            @Override
            public Object readlinkat(Object arg0Value_, int arg1Value, Object arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x10) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null && (ts2js_ = this.ts2js) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.readlinkat(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.readlinkatNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private Object readlinkatNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, Object arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.ToJavaStringNode ts2js_;
                TruffleString.ToJavaStringNode ts2js__shared;
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                if ((ts2js__shared = this.ts2js) != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_1_ = state_1 |= 0x10;
                return arg0Value.readlinkat(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_, ts2js_);
            }

            @Override
            public void kill(Object arg0Value_, long arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                KillNode_KillData s0_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x20) != 0 && (s0_ = this.killNode__kill_cache) != null) {
                    arg0Value.kill(arg1Value, arg2Value, s0_.readSignalNode_, s0_.isNode_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.killNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void killNode_AndSpecialize(EmulatedPosixSupport arg0Value, long arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                int state_1 = this.state_1_;
                KillNode_KillData s0_ = (KillNode_KillData)this.insert(new KillNode_KillData());
                ReadAttributeFromObjectNode readSignalNode__ = (ReadAttributeFromObjectNode)s0_.insert(ReadAttributeFromObjectNode.create());
                Objects.requireNonNull(readSignalNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.readSignalNode_ = readSignalNode__;
                IsNode isNode__ = (IsNode)s0_.insert(IsNode.create());
                Objects.requireNonNull(isNode__, "A specialization cache returned a default value. The cache initializer must never return a default value for this cache. Use @Cached(neverDefault=false) to allow default values for this cached value or make sure the cache initializer never returns the default value.");
                s0_.isNode_ = isNode__;
                VarHandle.storeStoreFence();
                this.killNode__kill_cache = s0_;
                this.state_1_ = state_1 |= 0x20;
                arg0Value.kill(arg1Value, arg2Value, readSignalNode__, isNode__);
            }

            @Override
            public void killpg(Object receiver, long pid, int signal) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).killpg(pid, signal);
            }

            @Override
            public long[] waitpid(Object arg0Value_, long arg1Value, int arg2Value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                Cached posixLib__ = this;
                return arg0Value.waitpid(arg1Value, arg2Value, posixLib__);
            }

            @Override
            public void abort(Object arg0Value_) {
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                Cached thisLib__ = this;
                arg0Value.abort(thisLib__);
            }

            @Override
            public boolean wcoredump(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wcoredump(status);
            }

            @Override
            public boolean wifcontinued(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wifcontinued(status);
            }

            @Override
            public boolean wifstopped(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wifstopped(status);
            }

            @Override
            public boolean wifsignaled(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wifsignaled(status);
            }

            @Override
            public boolean wifexited(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wifexited(status);
            }

            @Override
            public int wexitstatus(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wexitstatus(status);
            }

            @Override
            public int wtermsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wtermsig(status);
            }

            @Override
            public int wstopsig(Object receiver, int status) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).wstopsig(status);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getuid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long geteuid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).geteuid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getgid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getgid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long getegid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getegid();
            }

            @Override
            public long getppid(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getppid();
            }

            @Override
            public long getpgid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getpgid(pid);
            }

            @Override
            public void setpgid(Object receiver, long pid, long pgid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).setpgid(pid, pgid);
            }

            @Override
            public long getpgrp(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getpgrp();
            }

            @Override
            public long getsid(Object receiver, long pid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getsid(pid);
            }

            @Override
            public long setsid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).setsid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public long[] getgroups(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getgroups();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RusageResult getrusage(Object receiver, int who) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getrusage(who);
            }

            @Override
            public PosixSupportLibrary.OpenPtyResult openpty(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).openpty();
            }

            @Override
            public TruffleString ctermid(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).ctermid();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setenv(Object receiver, Object name, Object value, boolean overwrite) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).setenv(name, value, overwrite);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void unsetenv(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).unsetenv(name);
            }

            @Override
            public int forkExec(Object arg0Value_, Object[] arg1Value, Object[] arg2Value, Object arg3Value, Object[] arg4Value, int arg5Value, int arg6Value, int arg7Value, int arg8Value, int arg9Value, int arg10Value, int arg11Value, int arg12Value, boolean arg13Value, boolean arg14Value, boolean arg15Value, int[] arg16Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x40) != 0 && (js2ts_ = this.js2ts) != null) {
                    return arg0Value.forkExec(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, arg13Value, arg14Value, arg15Value, arg16Value, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.forkExecNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, arg13Value, arg14Value, arg15Value, arg16Value);
            }

            private int forkExecNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object[] arg1Value, Object[] arg2Value, Object arg3Value, Object[] arg4Value, int arg5Value, int arg6Value, int arg7Value, int arg8Value, int arg9Value, int arg10Value, int arg11Value, int arg12Value, boolean arg13Value, boolean arg14Value, boolean arg15Value, int[] arg16Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                int state_1 = this.state_1_;
                TruffleString.FromJavaStringNode js2ts__shared = this.js2ts;
                if (js2ts__shared != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_1_ = state_1 |= 0x40;
                return arg0Value.forkExec(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, arg6Value, arg7Value, arg8Value, arg9Value, arg10Value, arg11Value, arg12Value, arg13Value, arg14Value, arg15Value, arg16Value, js2ts_);
            }

            @Override
            public void execv(Object arg0Value_, Object arg1Value, Object[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x80) != 0 && (eq_ = this.eq) != null) {
                    arg0Value.execv(arg1Value, arg2Value, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.execvNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void execvNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, Object[] arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x80;
                arg0Value.execv(arg1Value, arg2Value, eq_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int system(Object receiver, Object command) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).system(command);
            }

            @Override
            public Object mmap(Object arg0Value_, long arg1Value, int arg2Value, int arg3Value, int arg4Value, long arg5Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x100) != 0 && (eq_ = this.eq) != null && (js2ts_ = this.js2ts) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.mmap(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.mmapNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value, arg5Value);
            }

            private EmulatedPosixSupport.MMapHandle mmapNode_AndSpecialize(EmulatedPosixSupport arg0Value, long arg1Value, int arg2Value, int arg3Value, int arg4Value, long arg5Value) throws PosixSupportLibrary.PosixException {
                TruffleString.FromJavaStringNode js2ts_;
                TruffleString.FromJavaStringNode js2ts__shared;
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                if ((js2ts__shared = this.js2ts) != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_1_ = state_1 |= 0x100;
                return arg0Value.mmap(arg1Value, arg2Value, arg3Value, arg4Value, arg5Value, (Node)inliningTarget__, INLINED_DEFAULT_DIR_PROFILE, eq_, js2ts_);
            }

            @Override
            public byte mmapReadByte(Object arg0Value_, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x200) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.mmapReadByte(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.mmapReadByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private byte mmapReadByteNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x200;
                return arg0Value.mmapReadByte(arg1Value, arg2Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public void mmapWriteByte(Object arg0Value_, Object arg1Value, long arg2Value, byte arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x400) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.mmapWriteByte(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.mmapWriteByteNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private void mmapWriteByteNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, long arg2Value, byte arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x400;
                arg0Value.mmapWriteByte(arg1Value, arg2Value, arg3Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public int mmapReadBytes(Object arg0Value_, Object arg1Value, long arg2Value, byte[] arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x800) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    return arg0Value.mmapReadBytes(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.mmapReadBytesNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private int mmapReadBytesNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, long arg2Value, byte[] arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x800;
                return arg0Value.mmapReadBytes(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public void mmapWriteBytes(Object arg0Value_, Object arg1Value, long arg2Value, byte[] arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x1000) != 0 && (eq_ = this.eq) != null) {
                    Cached inliningTarget__ = this;
                    arg0Value.mmapWriteBytes(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.mmapWriteBytesNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value, arg4Value);
            }

            private void mmapWriteBytesNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, long arg2Value, byte[] arg3Value, int arg4Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                Cached inliningTarget__ = null;
                inliningTarget__ = this;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x1000;
                arg0Value.mmapWriteBytes(arg1Value, arg2Value, arg3Value, arg4Value, (Node)inliningTarget__, INLINED_ERROR_BRANCH, eq_);
            }

            @Override
            public void mmapFlush(Object receiver, Object mmap, long offset, long length) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).mmapFlush(mmap, offset, length);
            }

            @Override
            public void mmapUnmap(Object arg0Value_, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x2000) != 0 && (eq_ = this.eq) != null) {
                    arg0Value.mmapUnmap(arg1Value, arg2Value, eq_);
                    return;
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.mmapUnmapNode_AndSpecialize(arg0Value, arg1Value, arg2Value);
            }

            private void mmapUnmapNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value, long arg2Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x2000;
                arg0Value.mmapUnmap(arg1Value, arg2Value, eq_);
            }

            @Override
            public long mmapGetPointer(Object receiver, Object mmap) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).mmapGetPointer(mmap);
            }

            @Override
            public TruffleString crypt(Object receiver, TruffleString word, TruffleString salt) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).crypt(word, salt);
            }

            @Override
            public long semOpen(Object receiver, Object name, int openFlags, int mode, int value) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).semOpen(name, openFlags, mode, value);
            }

            @Override
            public void semClose(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).semClose(handle);
            }

            @Override
            public void semUnlink(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).semUnlink(name);
            }

            @Override
            public int semGetValue(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).semGetValue(handle);
            }

            @Override
            public void semPost(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).semPost(handle);
            }

            @Override
            public void semWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).semWait(handle);
            }

            @Override
            public boolean semTryWait(Object receiver, long handle) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).semTryWait(handle);
            }

            @Override
            public boolean semTimedWait(Object receiver, long handle, long deadlineNs) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).semTimedWait(handle, deadlineNs);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwuid(Object receiver, long uid) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getpwuid(uid);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.PwdResult getpwnam(Object receiver, Object name) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getpwnam(name);
            }

            @Override
            public boolean hasGetpwentries(Object receiver) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).hasGetpwentries();
            }

            @Override
            public PosixSupportLibrary.PwdResult[] getpwentries(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getpwentries();
            }

            @Override
            public int ioctlBytes(Object receiver, int fd, long request, byte[] arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).ioctlBytes(fd, request, arg);
            }

            @Override
            public int ioctlInt(Object receiver, int fd, long request, int arg) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).ioctlInt(fd, request, arg);
            }

            @Override
            public int socket(Object arg0Value_, int arg1Value, int arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x4000) != 0 && (eq_ = this.eq) != null) {
                    return arg0Value.socket(arg1Value, arg2Value, arg3Value, eq_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.socketNode_AndSpecialize(arg0Value, arg1Value, arg2Value, arg3Value);
            }

            private int socketNode_AndSpecialize(EmulatedPosixSupport arg0Value, int arg1Value, int arg2Value, int arg3Value) throws PosixSupportLibrary.PosixException {
                TruffleString.EqualNode eq_;
                int state_1 = this.state_1_;
                TruffleString.EqualNode eq__shared = this.eq;
                if (eq__shared != null) {
                    eq_ = eq__shared;
                } else {
                    eq_ = (TruffleString.EqualNode)this.insert((Node)TruffleString.EqualNode.create());
                    if (eq_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.eq == null) {
                    VarHandle.storeStoreFence();
                    this.eq = eq_;
                }
                this.state_1_ = state_1 |= 0x4000;
                return arg0Value.socket(arg1Value, arg2Value, arg3Value, eq_);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AcceptResult accept(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).accept(sockfd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void bind(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).bind(sockfd, addr);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void connect(Object receiver, int sockfd, PosixSupportLibrary.UniversalSockAddr addr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).connect(sockfd, addr);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void listen(Object receiver, int sockfd, int backlog) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).listen(sockfd, backlog);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getpeername(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getpeername(sockfd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.UniversalSockAddr getsockname(Object receiver, int sockfd) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getsockname(sockfd);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int send(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).send(sockfd, buf, offset, len, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int sendto(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags, PosixSupportLibrary.UniversalSockAddr destAddr) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).sendto(sockfd, buf, offset, len, flags, destAddr);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int recv(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).recv(sockfd, buf, offset, len, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.RecvfromResult recvfrom(Object receiver, int sockfd, byte[] buf, int offset, int len, int flags) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).recvfrom(sockfd, buf, offset, len, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void shutdown(Object receiver, int sockfd, int how) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).shutdown(sockfd, how);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int getsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getsockopt(sockfd, level, optname, optval, optlen);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public void setsockopt(Object receiver, int sockfd, int level, int optname, byte[] optval, int optlen) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                ((EmulatedPosixSupport)receiver).setsockopt(sockfd, level, optname, optval, optlen);
            }

            @Override
            public int inet_addr(Object receiver, Object src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).inet_addr(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public int inet_aton(Object receiver, Object src) throws PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).inet_aton(src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntoa(Object receiver, int address) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).inet_ntoa(address);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public byte[] inet_pton(Object receiver, int family, Object src) throws PosixSupportLibrary.PosixException, PosixSupportLibrary.InvalidAddressException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).inet_pton(family, src);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object inet_ntop(Object receiver, int family, byte[] src) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).inet_ntop(family, src);
            }

            @Override
            public Object gethostname(Object receiver) throws PosixSupportLibrary.PosixException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).gethostname();
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public Object[] getnameinfo(Object receiver, PosixSupportLibrary.UniversalSockAddr addr, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getnameinfo(addr, flags);
            }

            @Override
            @CompilerDirectives.TruffleBoundary
            public PosixSupportLibrary.AddrInfoCursor getaddrinfo(Object receiver, Object node, Object service, int family, int sockType, int protocol, int flags) throws PosixSupportLibrary.GetAddrInfoException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getaddrinfo(node, service, family, sockType, protocol, flags);
            }

            @Override
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet4(Object receiver, PosixSupportLibrary.Inet4SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).createUniversalSockAddrInet4(src);
            }

            @Override
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrInet6(Object receiver, PosixSupportLibrary.Inet6SockAddr src) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).createUniversalSockAddrInet6(src);
            }

            @Override
            public PosixSupportLibrary.UniversalSockAddr createUniversalSockAddrUnix(Object receiver, PosixSupportLibrary.UnixSockAddr src) throws PosixSupportLibrary.InvalidUnixSocketPathException {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).createUniversalSockAddrUnix(src);
            }

            @Override
            public Object createPathFromString(Object arg0Value_, TruffleString arg1Value) {
                TruffleString.ToJavaStringNode ts2js_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x8000) != 0 && (ts2js_ = this.ts2js) != null) {
                    return arg0Value.createPathFromString(arg1Value, ts2js_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.createPathFromStringNode_AndSpecialize(arg0Value, arg1Value);
            }

            private Object createPathFromStringNode_AndSpecialize(EmulatedPosixSupport arg0Value, TruffleString arg1Value) {
                TruffleString.ToJavaStringNode ts2js_;
                int state_1 = this.state_1_;
                TruffleString.ToJavaStringNode ts2js__shared = this.ts2js;
                if (ts2js__shared != null) {
                    ts2js_ = ts2js__shared;
                } else {
                    ts2js_ = (TruffleString.ToJavaStringNode)this.insert((Node)TruffleString.ToJavaStringNode.create());
                    if (ts2js_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.ts2js == null) {
                    VarHandle.storeStoreFence();
                    this.ts2js = ts2js_;
                }
                this.state_1_ = state_1 |= 0x8000;
                return arg0Value.createPathFromString(arg1Value, ts2js_);
            }

            @Override
            public Object createPathFromBytes(Object receiver, byte[] path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).createPathFromBytes(path);
            }

            @Override
            public TruffleString getPathAsString(Object arg0Value_, Object arg1Value) {
                TruffleString.FromJavaStringNode js2ts_;
                assert (this.accepts(arg0Value_)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                EmulatedPosixSupport arg0Value = (EmulatedPosixSupport)arg0Value_;
                int state_1 = this.state_1_;
                if ((state_1 & 0x10000) != 0 && (js2ts_ = this.js2ts) != null) {
                    return arg0Value.getPathAsString(arg1Value, js2ts_);
                }
                CompilerDirectives.transferToInterpreterAndInvalidate();
                return this.getPathAsStringNode_AndSpecialize(arg0Value, arg1Value);
            }

            private TruffleString getPathAsStringNode_AndSpecialize(EmulatedPosixSupport arg0Value, Object arg1Value) {
                TruffleString.FromJavaStringNode js2ts_;
                int state_1 = this.state_1_;
                TruffleString.FromJavaStringNode js2ts__shared = this.js2ts;
                if (js2ts__shared != null) {
                    js2ts_ = js2ts__shared;
                } else {
                    js2ts_ = (TruffleString.FromJavaStringNode)this.insert((Node)TruffleString.FromJavaStringNode.create());
                    if (js2ts_ == null) {
                        throw new IllegalStateException("A specialization returned a default value for a cached initializer. Default values are not supported for shared cached initializers because the default value is reserved for the uninitialized state.");
                    }
                }
                if (this.js2ts == null) {
                    VarHandle.storeStoreFence();
                    this.js2ts = js2ts_;
                }
                this.state_1_ = state_1 |= 0x10000;
                return arg0Value.getPathAsString(arg1Value, js2ts_);
            }

            @Override
            public PosixSupportLibrary.Buffer getPathAsBytes(Object receiver, Object path) {
                assert (this.accepts(receiver)) : "Invalid library usage. Library does not accept given receiver.";
                assert (PosixSupportLibraryExports.assertAdopted((Node)((Node)this)));
                return ((EmulatedPosixSupport)receiver).getPathAsBytes(path);
            }

            @GeneratedBy(value=EmulatedPosixSupport.class)
            @DenyReplace
            private static final class KillNode_KillData
            extends Node
            implements DSLSupport.SpecializationDataNode {
                @Node.Child
                ReadAttributeFromObjectNode readSignalNode_;
                @Node.Child
                IsNode isNode_;

                KillNode_KillData() {
                }
            }
        }
    }
}

