/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.util;

import com.oracle.graal.python.util.OverflowException;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.CompilerDirectives;
import java.util.Arrays;

public final class ArrayBuilder<T> {
    private Object[] data;
    private int size;

    public ArrayBuilder() {
        this(8);
    }

    public ArrayBuilder(int capacity) {
        this.data = new Object[capacity];
    }

    public void add(Object item) {
        if (this.size == this.data.length) {
            try {
                this.data = PythonUtils.arrayCopyOf(this.data, PythonUtils.multiplyExact(this.size, 2));
            }
            catch (OverflowException e) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                throw new OutOfMemoryError();
            }
        }
        this.data[this.size++] = item;
    }

    public T get(int index) {
        assert (index >= 0 && index < this.size);
        return (T)this.data[index];
    }

    public T[] toArray(T[] newArray) {
        return ArrayBuilder.arrayCopyOf(this.data, this.size, newArray.getClass());
    }

    public Object[] toObjectArray(Object[] newArray) {
        return ArrayBuilder.arrayCopyOf(this.data, this.size, newArray.getClass());
    }

    public int size() {
        return this.size;
    }

    private static <T> T[] arrayCopyOf(T[] original, int newLength, Class<? extends T[]> newType) {
        try {
            return Arrays.copyOf(original, newLength, newType);
        }
        catch (Throwable t) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            throw t;
        }
    }
}

